/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.Set;

public class AttributeGenerator {
    static void getter(Tree.AttributeGetterDefinition that, GenerateJsVisitor gen, boolean block) {
        if (block) {
            gen.beginBlock();
        }
        gen.initSelf(that);
        gen.visitStatements(that.getBlock().getStatements());
        if (block) {
            gen.endBlock();
        }
    }

    static void setter(Tree.AttributeSetterDefinition that, GenerateJsVisitor gen) {
        if (that.getSpecifierExpression() == null) {
            gen.beginBlock();
            gen.initSelf(that);
            gen.visitStatements(that.getBlock().getStatements());
            gen.endBlock();
        } else {
            gen.out("{", new String[0]);
            gen.initSelf(that);
            gen.out("return ", new String[0]);
            if (!gen.isNaturalLiteral(that.getSpecifierExpression().getExpression().getTerm())) {
                that.getSpecifierExpression().visit(gen);
            }
            gen.out(";}", new String[0]);
        }
    }

    static void generateAttributeGetter(Tree.AnyAttribute attributeNode, FunctionOrValue decl, Tree.SpecifierOrInitializerExpression expr, String param, GenerateJsVisitor gen, Set<Declaration> directAccess, boolean verboseStitcher) {
        boolean asProp = AttributeGenerator.defineAsProperty(decl) && (gen.isCaptured(decl) || decl.isToplevel());
        String varName = asProp ? gen.getNames().valueName(decl) : gen.getNames().name(decl);
        boolean initVal = decl.isToplevel() && !TypeUtils.isNativeExternal(decl);
        boolean stitch = TypeUtils.isNativeExternal(decl);
        gen.out("var ", varName);
        if (expr != null) {
            if (initVal) {
                gen.out(";function $valinit$", varName, "(){");
                gen.out("if(", varName, "===", gen.getClAlias(), "INIT$)");
                gen.generateThrow(gen.getClAlias() + "InitializationError", "Cyclic initialization trying to read the value of '" + decl.getName() + "' before it was set", attributeNode == null ? expr : attributeNode);
                gen.endLine(true);
                gen.out("if(", varName, "===undefined){", varName, "=", gen.getClAlias(), "INIT$;", varName, "=");
            } else {
                gen.out("=", new String[0]);
            }
            boolean genatr = true;
            if (stitch) {
                boolean bl = genatr = !gen.stitchNative(decl, attributeNode);
                if (!genatr && verboseStitcher) {
                    gen.spitOut("Stitching in native attribute " + decl.getQualifiedNameString() + ", ignoring Ceylon declaration");
                }
                stitch = false;
            }
            if (genatr) {
                int boxType = gen.boxStart(expr.getExpression().getTerm());
                if (gen.isInDynamicBlock() && ModelUtil.isTypeUnknown(expr.getExpression().getTypeModel()) && !ModelUtil.isTypeUnknown(decl.getType())) {
                    TypeUtils.generateDynamicCheck(expr.getExpression(), decl.getType(), gen, false, expr.getExpression().getTypeModel().getTypeArguments());
                } else {
                    expr.visit(gen);
                }
                if (boxType == 4) {
                    gen.out(",", new String[0]);
                    if (decl instanceof Function) {
                        TypeUtils.encodeParameterListForRuntime(true, attributeNode, ((Function)decl).getFirstParameterList(), gen);
                    } else {
                        TypeUtils.encodeCallableArgumentsAsParameterListForRuntime(attributeNode, expr.getExpression().getTypeModel(), gen);
                    }
                    gen.out(",", new String[0]);
                    TypeUtils.printTypeArguments(expr, expr.getExpression().getTypeModel().getTypeArguments(), gen, false, expr.getExpression().getTypeModel().getVarianceOverrides());
                }
                gen.boxUnboxEnd(boxType);
            }
            if (initVal) {
                gen.out("};return ", varName, ";}");
            }
        } else if (param != null) {
            gen.out("=", param);
        } else if (stitch) {
            gen.out("=", new String[0]);
            gen.stitchNative(decl, attributeNode);
            stitch = false;
        }
        gen.endLine(true);
        if (decl instanceof Function) {
            if (decl.isClassOrInterfaceMember() && gen.isCaptured(decl)) {
                gen.beginNewLine();
                gen.outerSelf(decl);
                gen.out(".", varName, "=", varName);
                gen.endLine(true);
            }
        } else if (gen.isCaptured(decl) || decl.isToplevel()) {
            boolean isLate = decl.isLate();
            if (asProp) {
                gen.out(gen.getClAlias(), "atr$(");
                gen.outerSelf(decl);
                gen.out(",'", gen.getNames().name(decl), "',function(){");
                if (isLate) {
                    gen.generateUnitializedAttributeReadCheck(varName, gen.getNames().name(decl), null);
                }
                if (initVal && !isLate) {
                    gen.out("return $valinit$", varName, "();}");
                } else {
                    gen.out("return ", varName, ";}");
                }
                if (decl.isVariable() || isLate) {
                    String par = gen.getNames().createTempVariable();
                    gen.out(",function(", par, "){");
                    gen.generateImmutableAttributeReassignmentCheck(decl, varName, gen.getNames().name(decl));
                    gen.out("return ", varName, "=", par, ";}");
                } else {
                    gen.out(",undefined", new String[0]);
                }
                gen.out(",", new String[0]);
                if (attributeNode == null) {
                    TypeUtils.encodeForRuntime(expr, decl, gen);
                } else {
                    TypeUtils.encodeForRuntime((Node)attributeNode, (Declaration)decl, attributeNode.getAnnotationList(), gen);
                }
                gen.out(")", new String[0]);
                gen.endLine(true);
            } else {
                gen.out("function ", gen.getNames().getter(decl, false), "(){");
                if (initVal) {
                    if (isLate) {
                        gen.generateUnitializedAttributeReadCheck(varName, decl.getName(), expr);
                        gen.out("return ", varName, ";}");
                    } else {
                        gen.out("return $valinit$", varName, "();}");
                    }
                } else if (stitch) {
                    gen.out("return ", new String[0]);
                    gen.stitchNative(decl, attributeNode);
                    gen.out(";}", new String[0]);
                    if (verboseStitcher) {
                        gen.spitOut("Stitching in native attribute " + decl.getQualifiedNameString() + ", ignoring Ceylon declaration");
                    }
                } else {
                    gen.out("return ", varName, ";}");
                }
                gen.endLine();
                gen.shareGetter(decl);
            }
        } else {
            if (decl.isMember() && gen.qualify(expr, decl)) {
                gen.out(varName, "=", varName, ";");
            }
            directAccess.add(decl);
        }
    }

    static boolean generateAttributeSetter(Tree.AnyAttribute that, Value d, GenerateJsVisitor gen) {
        if (!d.isToplevel()) {
            return false;
        }
        String varName = gen.getNames().name(d);
        String paramVarName = gen.getNames().createTempVariable();
        gen.out("function ", gen.getNames().setter(d), "(", paramVarName, "){");
        gen.generateImmutableAttributeReassignmentCheck(d, varName, gen.getNames().name(d));
        if (d.isLate()) {
            gen.generateImmutableAttributeReassignmentCheck(d, varName, d.getName());
        } else {
            gen.out("if(", varName, "===undefined||", varName, "===", gen.getClAlias(), "INIT$)$valinit$", varName, "();");
        }
        gen.out("return ", varName, "=", paramVarName, ";}");
        gen.endLine(true);
        gen.shareSetter(d);
        return true;
    }

    static void addGetterAndSetterToPrototype(TypeDeclaration outer, Tree.AttributeDeclaration that, GenerateJsVisitor gen, boolean verboseStitcher) {
        String outerName;
        Value d = that.getDeclarationModel();
        if (!gen.opts.isOptimize() || d.isToplevel()) {
            return;
        }
        gen.comment(that);
        String atname = gen.getNames().valueName(d);
        String string = outerName = d.isStatic() ? gen.getNames().name(outer) + ".$st$" : gen.getNames().self(outer);
        if (d.isFormal()) {
            AttributeGenerator.generateAttributeMetamodel(that, false, false, gen);
        } else if (that.getSpecifierOrInitializerExpression() == null) {
            gen.defineAttribute(outerName, gen.getNames().name(d));
            gen.out("{", new String[0]);
            if (TypeUtils.isNativeExternal(d)) {
                gen.stitchNative(d, that);
            } else if (d.isStatic()) {
                if (d.isLate()) {
                    gen.generateUnitializedAttributeReadCheck(outerName + "." + atname, gen.getNames().name(d), that.getSpecifierOrInitializerExpression());
                    gen.out("return ", outerName, ".", atname, ";");
                } else {
                    gen.out("return ", new String[0]);
                    that.getSpecifierOrInitializerExpression().visit(gen);
                    gen.out(";", new String[0]);
                }
            } else {
                if (d.isLate()) {
                    gen.generateUnitializedAttributeReadCheck("this." + atname, gen.getNames().name(d), that.getSpecifierOrInitializerExpression());
                }
                gen.out("return this.", atname, ";");
            }
            gen.out("},", new String[0]);
            Tree.AttributeSetterDefinition setterDef = null;
            boolean setterDefined = false;
            if (d.isVariable() || d.isLate()) {
                setterDef = gen.associatedSetterDefinition(d);
                if (setterDef == null) {
                    setterDefined = true;
                    String par = gen.getNames().createTempVariable();
                    gen.out("function(", par, "){");
                    gen.generateImmutableAttributeReassignmentCheck(d, "this." + atname, gen.getNames().name(d));
                    gen.out("return this.", atname, "=", par, ";}");
                } else if (!gen.stitchNative(setterDef.getDeclarationModel(), that)) {
                    gen.out("function(", gen.getNames().name(setterDef.getDeclarationModel().getParameter()), ")");
                    AttributeGenerator.setter(setterDef, gen);
                    setterDefined = true;
                }
            }
            if (!setterDefined) {
                gen.out("undefined", new String[0]);
            }
            gen.out(",", new String[0]);
            TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), gen);
            if (setterDef != null) {
                gen.out(",", new String[0]);
                TypeUtils.encodeForRuntime((Node)setterDef, (Declaration)setterDef.getDeclarationModel(), that.getAnnotationList(), gen);
            }
            gen.out(")", new String[0]);
            gen.endLine(true);
        } else {
            Parameter param = null;
            if (d.isParameter()) {
                param = ((Functional)((Object)d.getContainer())).getParameter(d.getName());
            }
            if (that.getSpecifierOrInitializerExpression() != null || d.isVariable() || param != null || d.isLate() || TypeUtils.isNativeExternal(d)) {
                if (that.getSpecifierOrInitializerExpression() instanceof Tree.LazySpecifierExpression) {
                    gen.defineAttribute(outerName, gen.getNames().name(d));
                    gen.beginBlock();
                    gen.initSelf(that);
                    boolean stitch = TypeUtils.isNativeExternal(d);
                    if (stitch && (stitch = gen.stitchNative(d, that)) && verboseStitcher) {
                        gen.spitOut("Stitching in native getter " + d.getQualifiedNameString() + ", ignoring Ceylon declaration");
                    }
                    if (!stitch) {
                        Tree.Expression expr = that.getSpecifierOrInitializerExpression().getExpression();
                        gen.out("return ", new String[0]);
                        if (!gen.isNaturalLiteral(expr.getTerm())) {
                            gen.visitSingleExpression(expr);
                        }
                    }
                    gen.endBlock();
                    Tree.AttributeSetterDefinition setterDef = null;
                    if (d.isVariable() && (setterDef = gen.associatedSetterDefinition(d)) != null) {
                        gen.out(",function(", gen.getNames().name(setterDef.getDeclarationModel().getParameter()), ")");
                        AttributeGenerator.setter(setterDef, gen);
                    }
                    if (setterDef == null) {
                        gen.out(",undefined", new String[0]);
                    }
                    gen.out(",", new String[0]);
                    TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), gen);
                    if (setterDef != null) {
                        gen.out(",", new String[0]);
                        TypeUtils.encodeForRuntime((Node)setterDef, (Declaration)setterDef.getDeclarationModel(), that.getAnnotationList(), gen);
                    }
                    gen.out(")", new String[0]);
                    gen.endLine(true);
                } else {
                    String privname = param == null ? gen.getNames().privateName(d) : gen.getNames().name(param) + "_";
                    gen.defineAttribute(outerName, gen.getNames().name(d));
                    gen.out("{", new String[0]);
                    if (d.isLate()) {
                        gen.generateUnitializedAttributeReadCheck("this." + privname, gen.getNames().name(d), that.getSpecifierOrInitializerExpression());
                    }
                    if (TypeUtils.isNativeExternal(d)) {
                        if (gen.stitchNative(d, that)) {
                            if (verboseStitcher) {
                                gen.spitOut("Stitching in native getter " + d.getQualifiedNameString() + ", ignoring Ceylon declaration");
                            }
                        } else {
                            gen.out("return ", new String[0]);
                            gen.visitSingleExpression(that.getSpecifierOrInitializerExpression().getExpression());
                        }
                        gen.out("}", new String[0]);
                    } else if (d.isStatic()) {
                        gen.out("return ", new String[0]);
                        gen.visitSingleExpression(that.getSpecifierOrInitializerExpression().getExpression());
                        gen.out("}", new String[0]);
                    } else {
                        gen.out("return this.", privname, ";}");
                    }
                    if (d.isVariable() || d.isLate()) {
                        String pname = gen.getNames().createTempVariable();
                        gen.out(",function(", pname, "){");
                        gen.generateImmutableAttributeReassignmentCheck(d, "this." + privname, gen.getNames().name(d));
                        gen.out("return this.", privname, "=", pname, ";}");
                    } else {
                        gen.out(",undefined", new String[0]);
                    }
                    gen.out(",", new String[0]);
                    TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), gen);
                    gen.out(")", new String[0]);
                    gen.endLine(true);
                }
            }
        }
    }

    public static boolean defineAsProperty(Declaration d) {
        return d.isMember() && d instanceof FunctionOrValue && !(d instanceof Function);
    }

    static void generateAttributeMetamodel(Tree.TypedDeclaration that, boolean addGetter, boolean addSetter, GenerateJsVisitor gen) {
        TypedDeclaration d;
        for (Scope _scope = that.getScope(); _scope != null; _scope = _scope.getContainer()) {
            if (!(_scope instanceof Declaration)) continue;
            if (!(_scope instanceof Function)) break;
            return;
        }
        if ((d = that.getDeclarationModel()) instanceof Setter) {
            d = ((Setter)d).getGetter();
        }
        String pname = gen.getNames().getter(d, false);
        String pnameMeta = gen.getNames().getter(d, true);
        if (!gen.isGeneratedAttribute(d)) {
            if (d.isToplevel()) {
                gen.out("var ", new String[0]);
            } else if (gen.outerSelf(d)) {
                gen.out(".", new String[0]);
            }
            gen.out(pnameMeta, "={$crtmm$:");
            TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), gen);
            gen.out("}", new String[0]);
            gen.endLine(true);
            if (d.isToplevel()) {
                gen.out("ex$.", pnameMeta, "=", pnameMeta);
                gen.endLine(true);
            }
            gen.addGeneratedAttribute(d);
        }
        if (addGetter) {
            if (!d.isToplevel() && gen.outerSelf(d)) {
                gen.out(".", new String[0]);
            }
            gen.out(pnameMeta, ".get=");
            if (gen.isCaptured(d) && !AttributeGenerator.defineAsProperty(d)) {
                gen.out(pname, new String[0]);
                gen.endLine(true);
                gen.out(pname, ".$crtmm$=", pnameMeta, ".$crtmm$");
            } else if (d.isToplevel()) {
                gen.out(pname, new String[0]);
            } else {
                gen.out("function(){return ", gen.getNames().name(d), "}");
            }
            gen.endLine(true);
        }
        if (addSetter) {
            String pset = gen.getNames().setter(d instanceof Setter ? ((Setter)d).getGetter() : d);
            if (!d.isToplevel() && gen.outerSelf(d)) {
                gen.out(".", new String[0]);
            }
            gen.out(pnameMeta, ".set=", pset);
            gen.endLine(true);
            gen.out("if(", pset, ".$crtmm$===undefined)", pset, ".$crtmm$=", pnameMeta, ".$crtmm$");
            gen.endLine(true);
        }
    }
}

