/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.EnumUtil;
import com.redhat.ceylon.common.tool.NonFatalToolMessage;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleWildcardsHelper;
import com.redhat.ceylon.common.tools.OutputRepoUsingTool;
import com.redhat.ceylon.common.tools.SourceArgumentsResolver;
import com.redhat.ceylon.common.tools.SourceDependencyResolver;
import com.redhat.ceylon.compiler.js.CeylonCompileJsMessages;
import com.redhat.ceylon.compiler.js.CompilerErrorException;
import com.redhat.ceylon.compiler.js.DiagnosticListener;
import com.redhat.ceylon.compiler.js.JsCompiler;
import com.redhat.ceylon.compiler.js.loader.JsModuleManagerFactory;
import com.redhat.ceylon.compiler.js.util.Options;
import com.redhat.ceylon.compiler.typechecker.TypeChecker;
import com.redhat.ceylon.compiler.typechecker.TypeCheckerBuilder;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.model.typechecker.context.TypeCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

@Summary(value="Compiles Ceylon source code to JavaScript and directly produces module and source archives in a module repository")
@RemainingSections(value="## Compiling dependencies\n\nThe `--include-dependencies` option can take the following flags: \n\n - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n\n\n## Configuration file\n\nThe compile tool accepts the following options from the Ceylon configuration file: `defaults.offline`, `defaults.encoding`, `compiler.source`, `compiler.resource` and `repositories` (the equivalent options on the command line always have precedence).\n\n## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see https://ceylon-lang.org/documentation/1.3/reference/repository/tools")
public class CeylonCompileJsTool
extends OutputRepoUsingTool {
    private boolean profile = false;
    private boolean optimize = true;
    private boolean modulify = true;
    private boolean comments = false;
    private boolean skipSrc = false;
    private String encoding = DefaultToolOptions.getDefaultEncoding();
    private String includeDependencies;
    private List<File> roots = DefaultToolOptions.getCompilerSourceDirs();
    private List<File> resources = DefaultToolOptions.getCompilerResourceDirs();
    private String resourceRootName = DefaultToolOptions.getCompilerResourceRootName();
    private List<String> files = DefaultToolOptions.getCompilerModules(Backend.JavaScript);
    private DiagnosticListener diagnosticListener;
    private boolean throwOnError;
    private EnumSet<Warning> suppwarns = EnumUtil.enumsFromPossiblyInvalidStrings(Warning.class, DefaultToolOptions.getCompilerSuppressWarnings());

    public CeylonCompileJsTool() {
        super(CeylonCompileJsMessages.RESOURCE_BUNDLE);
    }

    @Override
    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`, `ast`, `code`, `stitcher`.")
    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    @Override
    protected Set<String> getVerboseCategories(String ... morecats) {
        return super.getVerboseCategories("ast", "code", "stitcher");
    }

    @OptionArgument(shortName=69, argumentName="encoding")
    @Description(value="Sets the encoding used for reading source files (default: platform-specific)")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Option
    @OptionArgument(argumentName="flags")
    @Description(value="Determines if and how compilation of dependencies should be handled. Allowed flags include: `never`, `once`, `force`, `check`.")
    public void setIncludeDependencies(String includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    @Option
    @Description(value="Time the compilation phases (results are printed to standard error)")
    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    @Option
    @Description(value="Create lexical scope-style JS code")
    public void setLexicalScopeStyle(boolean flag) {
        this.optimize = !flag;
    }

    @Option(longName="no-module")
    @Description(value="Do **not** wrap generated code as CommonJS module")
    public void setNoModulify(boolean nomodulify) {
        this.modulify = !nomodulify;
    }

    @Option
    @Description(value="Do **not** indent code (deprecated)")
    public void setNoIndent(boolean noindent) {
    }

    @Option
    @Description(value="Equivalent to `--no-indent` `--no-comments`")
    public void setCompact(boolean compact) {
        this.setNoComments(compact);
    }

    @Option
    @Description(value="Do **not** generate any comments")
    public void setNoComments(boolean nocomments) {
        this.comments = !nocomments;
    }

    public List<String> getFilesAsStrings(List<File> files) {
        if (files != null) {
            ArrayList<String> result = new ArrayList<String>(files.size());
            for (File f : files) {
                result.add(f.getPath());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @OptionArgument(shortName=115, longName="src", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="Path to source files. Can be specified multiple times; you can also specify several paths separated by your operating system's `PATH` separator. (default: `./source`)")
    public void setSrc(List<File> src) {
        this.roots = src;
    }

    @OptionArgument(longName="source", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="An alias for `--src` (default: `./source`)")
    public void setSource(List<File> source) {
        this.setSrc(source);
    }

    @OptionArgument(shortName=114, longName="resource", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="Path to directory containing resource files. Can be specified multiple times; you can also specify several paths separated by your operating system's `PATH` separator. (default: `./resource`)")
    public void setResource(List<File> resource) {
        this.resources = resource;
    }

    @OptionArgument(shortName=82, argumentName="folder-name")
    @Description(value="Sets the special resource folder name whose files will end up in the root of the resulting module CAR file (default: ROOT).")
    public void setResourceRoot(String resourceRootName) {
        this.resourceRootName = resourceRootName;
    }

    public String getOut() {
        return this.out != null ? this.out : DefaultToolOptions.getCompilerOutputRepo();
    }

    @Option
    @Description(value="Do **not** generate .src archive - useful when doing joint compilation")
    public void setSkipSrcArchive(boolean skip) {
        this.skipSrc = skip;
    }

    public boolean isSkipSrcArchive() {
        return this.skipSrc;
    }

    @Argument(argumentName="moduleOrFile", multiplicity="*")
    public void setModule(List<String> moduleOrFile) {
        this.files = moduleOrFile;
    }

    @Override
    protected List<File> getSourceDirs() {
        return this.roots;
    }

    @Override
    protected List<File> getResourceDirs() {
        return this.resources;
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        super.initialize(mainTool);
        this.includeDependencies = this.processCompileFlags(this.includeDependencies, DefaultToolOptions.getCompilerIncludeDependencies());
    }

    @Override
    public void run() throws Exception {
        TypeCheckerBuilder tcb;
        long t0;
        AppendableWriter writer = new AppendableWriter(this.getOutAppendable());
        Options opts = new Options().cwd(this.cwd).repos(this.getRepositoryAsStrings()).sourceDirs(this.roots).resourceDirs(this.resources).resourceRootName(this.resourceRootName).systemRepo(this.systemRepo).outRepo(this.getOut()).user(this.user).pass(this.pass).optimize(this.optimize).modulify(this.modulify).comment(this.comments).verbose(this.getVerbose()).profile(this.profile).stdin(false).generateSourceArchive(!this.skipSrc).encoding(this.encoding).includeDependencies(this.includeDependencies).diagnosticListener(this.diagnosticListener).outWriter(writer).suppressWarnings(this.suppwarns);
        if (opts.hasVerboseFlag("cmr")) {
            this.append("Using repositories: " + this.getRepositoryAsStrings());
            this.newline();
        }
        RepositoryManager repoman = this.getRepositoryManager();
        List<File> onlySources = null;
        List<File> onlyResources = null;
        if (opts.isStdin()) {
            VirtualFile src = new VirtualFile(){

                @Override
                public boolean exists() {
                    return true;
                }

                @Override
                public boolean isFolder() {
                    return false;
                }

                @Override
                public String getName() {
                    return "SCRIPT.ceylon";
                }

                @Override
                public String getPath() {
                    return this.getName();
                }

                @Override
                public String getRelativePath(VirtualFile file) {
                    return "";
                }

                @Override
                public InputStream getInputStream() {
                    return System.in;
                }

                public List<VirtualFile> getChildren() {
                    return Collections.emptyList();
                }

                public int hashCode() {
                    return this.getPath().hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj instanceof VirtualFile) {
                        return ((VirtualFile)obj).getPath().equals(this.getPath());
                    }
                    return super.equals(obj);
                }

                @Override
                public int compareTo(VirtualFile o) {
                    return this.getPath().compareTo(o.getPath());
                }
            };
            t0 = System.nanoTime();
            tcb = new TypeCheckerBuilder().addSrcDirectory(src);
        } else {
            SourceDependencyResolver sdr;
            t0 = System.nanoTime();
            tcb = new TypeCheckerBuilder();
            SourceArgumentsResolver resolver = new SourceArgumentsResolver(this.roots, this.resources, ".ceylon", ".js");
            resolver.cwd(this.cwd).expandAndParse(this.files, Backend.JavaScript);
            if (this.includeDependencies != null && !"never".equals(this.includeDependencies) && (sdr = new SourceDependencyResolver(this.getModuleVersionReader(), this.roots, Backends.JS)).traverseDependencies(resolver.getSourceFiles())) {
                for (ModuleVersionDetails mvd : sdr.getAdditionalModules()) {
                    if (!"force".equals(this.includeDependencies) && (!"check".equals(this.includeDependencies) || !this.shouldRecompile(this.getOfflineRepositoryManager(), mvd.getModule(), mvd.getVersion(), ModuleQuery.Type.JS, true)) && (!"once".equals(this.includeDependencies) || !this.shouldRecompile(this.getOfflineRepositoryManager(), mvd.getModule(), mvd.getVersion(), ModuleQuery.Type.JS, false))) continue;
                    this.files.add(mvd.getModule());
                    resolver.expandAndParse(this.files, Backend.JavaScript);
                }
            }
            onlySources = resolver.getSourceFiles();
            onlyResources = resolver.getResourceFiles();
            if (onlySources.isEmpty()) {
                String msg = CeylonCompileJsMessages.msg("error.no.sources", new Object[0]);
                if (ModuleWildcardsHelper.onlyGlobArgs(this.files)) {
                    throw new NonFatalToolMessage(msg);
                }
                throw new ToolUsageError(msg);
            }
            if (opts.isVerbose()) {
                this.append("Adding source directories to typechecker:" + this.roots).newline();
            }
            for (File root : this.roots) {
                File cwdRoot = this.applyCwd(root);
                if (!cwdRoot.exists() || !cwdRoot.isDirectory()) continue;
                tcb.addSrcDirectory(cwdRoot);
            }
            tcb.setSourceFiles(onlySources);
            if (!resolver.getSourceModules().isEmpty()) {
                tcb.setModuleFilters(resolver.getSourceModules());
            }
            tcb.statistics(opts.isProfile());
            JsModuleManagerFactory.setVerbose(opts.hasVerboseFlag("loader"));
            tcb.moduleManagerFactory(new JsModuleManagerFactory(this.encoding));
        }
        tcb.verbose(opts.hasVerboseFlag("ast")).setRepositoryManager(repoman);
        tcb.usageWarnings(false).encoding(this.encoding);
        final TypeChecker typeChecker = tcb.getTypeChecker();
        long t1 = System.nanoTime();
        TypeCache.doWithoutCaching(new Runnable(){

            @Override
            public void run() {
                typeChecker.process(true);
            }
        });
        long t2 = System.nanoTime();
        JsCompiler jsc = new JsCompiler(typeChecker, opts);
        if (onlySources != null) {
            if (opts.isVerbose()) {
                this.append("Only these files will be compiled: " + onlySources).newline();
            }
            jsc.setSourceFiles(onlySources);
        }
        if (onlyResources != null) {
            jsc.setResourceFiles(onlyResources);
        }
        long t3 = System.nanoTime();
        if (!jsc.generate()) {
            int count;
            if (jsc.getExitCode() != 0) {
                if (this.throwOnError) {
                    throw new RuntimeException("Compiler exited with non-zero exit code: " + jsc.getExitCode());
                }
                jsc.printErrorsAndCount(writer);
                System.exit(jsc.getExitCode());
            }
            String msg = (count = jsc.printErrorsAndCount(writer)) > 1 ? "There were %d errors." : "There was %d error.";
            this.flush();
            throw new CompilerErrorException(String.format(msg, count));
        }
        jsc.printErrorsAndCount(writer);
        long t4 = System.nanoTime();
        if (opts.isProfile() || opts.hasVerboseFlag("benchmark")) {
            System.err.println("PROFILING INFORMATION");
            System.err.printf("TypeChecker creation:   %6d nanos%n", t1 - t0);
            System.err.printf("TypeChecker processing: %6d nanos%n", t2 - t1);
            System.err.printf("JS compiler creation:   %6d nanos%n", t3 - t2);
            System.err.printf("JS compilation:         %6d nanos%n", t4 - t3);
            System.out.println("Compilation finished.");
        }
    }

    public void setDiagnosticListener(DiagnosticListener diagnosticListener) {
        this.diagnosticListener = diagnosticListener;
    }

    public void setThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
    }

    public boolean isThrowOnError() {
        return this.throwOnError;
    }

    @Option(shortName=87)
    @OptionArgument(argumentName="warnings")
    @Description(value="Suppress the reporting of the given warnings. If no `warnings` are given then suppresss the reporting of all warnings, otherwise just suppresss those which are present. Allowed flags include: `filenameNonAscii`, `filenameClaselessCollision`, `deprecation`, `compilerAnnotation`, `doclink`, `expressionTypeNothing`, `unusedDeclaration`, `unusedImport`, `ceylonNamespace`, `javaNamespace`, `suppressedAlready`, `suppressesNothing`.")
    public void setSuppressWarning(EnumSet<Warning> warnings) {
        this.suppwarns = warnings;
    }

    public static class AppendableWriter
    extends Writer {
        private Appendable out;

        public AppendableWriter(Appendable out) {
            this.out = out;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.out.append(new String(cbuf, off, len));
        }

        @Override
        public void write(String str) throws IOException {
            this.out.append(str);
        }
    }
}

