/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.AttributeGenerator;
import com.redhat.ceylon.compiler.js.BlockWithCaptureVisitor;
import com.redhat.ceylon.compiler.js.BmeGenerator;
import com.redhat.ceylon.compiler.js.ClassGenerator;
import com.redhat.ceylon.compiler.js.CompilerErrorException;
import com.redhat.ceylon.compiler.js.ComprehensionGenerator;
import com.redhat.ceylon.compiler.js.ConditionGenerator;
import com.redhat.ceylon.compiler.js.Destructurer;
import com.redhat.ceylon.compiler.js.ErrorVisitor;
import com.redhat.ceylon.compiler.js.ForGenerator;
import com.redhat.ceylon.compiler.js.FunctionHelper;
import com.redhat.ceylon.compiler.js.InvocationGenerator;
import com.redhat.ceylon.compiler.js.JsCompiler;
import com.redhat.ceylon.compiler.js.MetamodelHelper;
import com.redhat.ceylon.compiler.js.Operators;
import com.redhat.ceylon.compiler.js.ReturnConstructorVisitor;
import com.redhat.ceylon.compiler.js.SequenceGenerator;
import com.redhat.ceylon.compiler.js.SerializationHelper;
import com.redhat.ceylon.compiler.js.Singletons;
import com.redhat.ceylon.compiler.js.TryCatchGenerator;
import com.redhat.ceylon.compiler.js.TypeGenerator;
import com.redhat.ceylon.compiler.js.loader.JsonModule;
import com.redhat.ceylon.compiler.js.util.ContinueBreakVisitor;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.js.util.JsOutput;
import com.redhat.ceylon.compiler.js.util.JsUtils;
import com.redhat.ceylon.compiler.js.util.JsWriter;
import com.redhat.ceylon.compiler.js.util.Options;
import com.redhat.ceylon.compiler.js.util.RetainedVars;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.CommonToken;

public class GenerateJsVisitor
extends Visitor {
    private final Stack<ContinueBreakVisitor> continues = new Stack();
    private final JsIdentifierNames names;
    private final Set<Declaration> directAccess = new HashSet<Declaration>();
    private final Set<Declaration> generatedAttributes = new HashSet<Declaration>();
    private final RetainedVars retainedVars = new RetainedVars();
    final ConditionGenerator conds;
    private final InvocationGenerator invoker;
    private final List<CommonToken> tokens;
    private final ErrorVisitor errVisitor = new ErrorVisitor();
    private int dynblock;
    private int exitCode = 0;
    private final Map<String, Tree.Declaration> headers = new HashMap<String, Tree.Declaration>();
    protected static final BigInteger minLong = new BigInteger(Long.toString(Long.MIN_VALUE));
    protected static final BigInteger maxLong = new BigInteger(Long.toString(Long.MAX_VALUE));
    protected static final BigInteger maxUnsignedLong = new BigInteger("ffffffffffffffff", 16);
    private List<? extends Tree.Statement> currentStatements = null;
    private final JsCompiler compiler;
    public final JsWriter out;
    private final PrintWriter verboseOut;
    private final boolean verboseStitcher;
    public final Options opts;
    private Tree.CompilationUnit root;
    static final String function = "function ";
    private final JsOutput jsout;
    private ClassOrInterface prototypeOwner;

    public Package getCurrentPackage() {
        return this.root.getUnit().getPackage();
    }

    public String getClAlias() {
        return this.jsout.getLanguageModuleAlias();
    }

    @Override
    public void handleException(Exception e, Node that) {
        that.addUnexpectedError(that.getMessage(e, this), Backend.JavaScript);
    }

    public GenerateJsVisitor(JsCompiler compiler, JsOutput out, Options options, JsIdentifierNames names, List<CommonToken> tokens) throws IOException {
        Writer vw;
        this.compiler = compiler;
        this.jsout = out;
        this.opts = options;
        this.verboseOut = options.hasVerboseFlag("code") ? ((vw = options.getOutWriter()) instanceof PrintWriter ? (PrintWriter)vw : new PrintWriter(vw == null ? new OutputStreamWriter(System.out) : vw)) : null;
        this.verboseStitcher = options.hasVerboseFlag("stitcher");
        this.names = names;
        this.conds = new ConditionGenerator(this, names, this.directAccess);
        this.tokens = tokens;
        this.invoker = new InvocationGenerator(this, names, this.retainedVars);
        this.out = new JsWriter(out.getWriter(), this.verboseOut, this.opts.isMinify());
        out.setJsWriter(this.out);
    }

    public InvocationGenerator getInvoker() {
        return this.invoker;
    }

    public JsIdentifierNames getNames() {
        return this.names;
    }

    public void out(String code, String ... codez) {
        this.out.write(code, codez);
    }

    void endLine() {
        this.out.endLine(false);
    }

    public void endLine(boolean semicolon) {
        this.out.endLine(semicolon);
    }

    void beginNewLine() {
        this.out.endLine(false);
    }

    void beginBlock() {
        this.out.beginBlock();
    }

    void endBlockNewLine() {
        this.out.endBlock(false, true);
    }

    void endBlockNewLine(boolean semicolon) {
        this.out.endBlock(semicolon, true);
    }

    void endBlock() {
        this.out.endBlock(false, false);
    }

    void endBlock(boolean semicolon, boolean newline) {
        this.out.endBlock(semicolon, newline);
    }

    void spitOut(String s) {
        this.out.spitOut(s);
    }

    public void location(Node node) {
        this.out(" at ", node.getUnit().getFilename(), " (", node.getLocation(), ")");
    }

    private String generateToString(GenerateCallback callback) {
        return this.out.generateToString(callback);
    }

    @Override
    public void visit(final Tree.CompilationUnit that) {
        this.root = that;
        if (!that.getModuleDescriptors().isEmpty()) {
            final Tree.ModuleDescriptor md = that.getModuleDescriptors().get(0);
            if (md.getNamespace() != null && "npm".equals(md.getNamespace().getText()) && md.getGroupQuotedLiteral() != null) {
                String npmName = md.getGroupQuotedLiteral().getText();
                if (npmName.charAt(0) == '\"' && npmName.charAt(npmName.length() - 1) == '\"') {
                    npmName = npmName.substring(1, npmName.length() - 1);
                }
                ((JsonModule)that.getUnit().getPackage().getModule()).setNpmPath(npmName);
            }
            this.out("ex$.$mod$ans$=", new String[0]);
            TypeUtils.outputAnnotationsFunction(md.getAnnotationList(), new TypeUtils.AnnotationFunctionHelper(){

                @Override
                public String getPathToModelDoc() {
                    return "''";
                }

                @Override
                public String getPackedAnnotationsKey() {
                    return null;
                }

                @Override
                public String getAnnotationsKey() {
                    return null;
                }

                @Override
                public List<Annotation> getAnnotations() {
                    return md.getUnit().getPackage().getModule().getAnnotations();
                }

                @Override
                public Object getAnnotationSource() {
                    return md.getUnit().getPackage().getModule();
                }

                @Override
                public String getAnPath() {
                    return "'$mod-anns'";
                }
            }, this);
            this.endLine(true);
            if (md.getImportModuleList() != null && !md.getImportModuleList().getImportModules().isEmpty()) {
                this.out("ex$.$mod$imps=function(){return{", new String[0]);
                if (!this.opts.isMinify()) {
                    this.endLine();
                }
                boolean first = true;
                for (final Tree.ImportModule im : md.getImportModuleList().getImportModules()) {
                    StringBuilder path = new StringBuilder("'");
                    if (im.getName() == null) {
                        throw new CompilerErrorException("Invalid imported module");
                    }
                    path.append(im.getName());
                    String qv = im.getVersion().getText();
                    path.append('/').append(qv.substring(1, qv.length() - 1)).append("'");
                    if (first) {
                        first = false;
                    } else {
                        this.out(",", new String[0]);
                        this.endLine();
                    }
                    this.out(path.toString(), ":");
                    TypeUtils.outputAnnotationsFunction(im.getAnnotationList(), new TypeUtils.AnnotationFunctionHelper(){

                        @Override
                        public String getPathToModelDoc() {
                            return null;
                        }

                        @Override
                        public String getPackedAnnotationsKey() {
                            return null;
                        }

                        @Override
                        public String getAnnotationsKey() {
                            return null;
                        }

                        @Override
                        public List<Annotation> getAnnotations() {
                            if (im.getImportPath().getModel() instanceof Module) {
                                return ((Module)im.getImportPath().getModel()).getAnnotations();
                            }
                            return null;
                        }

                        @Override
                        public Object getAnnotationSource() {
                            return im;
                        }

                        @Override
                        public String getAnPath() {
                            return null;
                        }
                    }, this);
                }
                if (!this.opts.isMinify()) {
                    this.endLine();
                }
                this.out("};};", new String[0]);
                if (!this.opts.isMinify()) {
                    this.endLine();
                }
            }
        }
        if (!that.getPackageDescriptors().isEmpty()) {
            String pknm = that.getUnit().getPackage().getNameAsString().replaceAll("\\.", "\\$");
            this.out("ex$.$pkg$ans$", pknm, "=");
            TypeUtils.outputAnnotationsFunction(that.getPackageDescriptors().get(0).getAnnotationList(), new TypeUtils.AnnotationFunctionHelper(){

                @Override
                public String getPathToModelDoc() {
                    return "'" + that.getUnit().getPackage().getQualifiedNameString() + "'";
                }

                @Override
                public String getPackedAnnotationsKey() {
                    return null;
                }

                @Override
                public String getAnnotationsKey() {
                    return null;
                }

                @Override
                public List<Annotation> getAnnotations() {
                    return that.getUnit().getPackage().getAnnotations();
                }

                @Override
                public Object getAnnotationSource() {
                    return that.getUnit().getPackage();
                }

                @Override
                public String getAnPath() {
                    return "'$pkg-anns'";
                }
            }, this);
            this.endLine(true);
        }
        for (Tree.CompilerAnnotation ca : that.getCompilerAnnotations()) {
            ca.visit(this);
        }
        if (that.getImportList() != null) {
            that.getImportList().visit(this);
        }
        this.visitStatements(that.getDeclarations());
    }

    @Override
    public void visit(Tree.Import that) {
    }

    @Override
    public void visit(Tree.Parameter that) {
        this.out(this.names.name(that.getParameterModel()), new String[0]);
    }

    @Override
    public void visit(Tree.ParameterList that) {
        this.out("(", new String[0]);
        boolean first = true;
        String ptypes = null;
        if (that.getScope() instanceof Function && that.getModel().isFirst() && ((Function)that.getScope()).getTypeParameters() != null && !((Function)that.getScope()).getTypeParameters().isEmpty()) {
            ptypes = this.names.typeArgsParamName((Function)that.getScope());
        }
        for (Tree.Parameter param : that.getParameters()) {
            if (!first) {
                this.out(",", new String[0]);
            }
            this.out(this.names.name(param.getParameterModel()), new String[0]);
            first = false;
        }
        if (ptypes != null) {
            if (!first) {
                this.out(",", new String[0]);
            }
            this.out(ptypes, new String[0]);
        }
        this.out(")", new String[0]);
    }

    void generateConstructorStatements(Tree.Declaration cnstr, List<? extends Tree.Statement> stmts) {
        List<String> oldRetainedVars = this.retainedVars.reset(null);
        List<? extends Tree.Statement> prevStatements = this.currentStatements;
        this.currentStatements = stmts;
        ReturnConstructorVisitor rcv = new ReturnConstructorVisitor(cnstr);
        if (rcv.isReturns()) {
            this.out("(function(){", new String[0]);
        }
        for (Tree.Statement statement : stmts) {
            if (statement instanceof Tree.SpecifierStatement) {
                if (cnstr instanceof Tree.Constructor) {
                    this.specifierStatement(((Tree.Constructor)cnstr).getConstructor(), (Tree.SpecifierStatement)statement);
                } else if (cnstr instanceof Tree.Enumerated) {
                    this.specifierStatement(((Tree.Enumerated)cnstr).getEnumerated(), (Tree.SpecifierStatement)statement);
                }
            } else {
                statement.visit(this);
            }
            if (!this.opts.isMinify()) {
                this.beginNewLine();
            }
            this.retainedVars.emitRetainedVars(this);
            if (this.opts.isOptimize() || cnstr == null || !(statement instanceof Tree.AttributeDeclaration)) continue;
            this.generatedAttributes.remove(((Tree.AttributeDeclaration)statement).getDeclarationModel());
        }
        if (rcv.isReturns()) {
            this.out("}());", new String[0]);
        }
        this.retainedVars.reset(oldRetainedVars);
        this.currentStatements = prevStatements;
    }

    void visitStatements(List<? extends Tree.Statement> statements) {
        List<String> oldRetainedVars = this.retainedVars.reset(null);
        List<? extends Tree.Statement> prevStatements = this.currentStatements;
        this.currentStatements = statements;
        for (int i = 0; i < statements.size(); ++i) {
            Tree.Statement s = statements.get(i);
            s.visit(this);
            if (!this.opts.isMinify()) {
                this.beginNewLine();
            }
            this.retainedVars.emitRetainedVars(this);
        }
        this.retainedVars.reset(oldRetainedVars);
        this.currentStatements = prevStatements;
    }

    public void visitSingleExpression(Tree.Expression that) {
        List<String> oldRetainedVars = this.retainedVars.reset(null);
        int boxType = this.boxStart(that.getTerm());
        that.visit(this);
        if (boxType == 4) {
            this.out("/*TODO: callable targs 3*/", new String[0]);
        }
        this.boxUnboxEnd(boxType);
        this.endLine(true);
        this.retainedVars.emitRetainedVars(this);
        this.retainedVars.reset(oldRetainedVars);
    }

    @Override
    public void visit(Tree.Body that) {
        this.visitStatements(that.getStatements());
    }

    @Override
    public void visit(Tree.Block that) {
        List<Tree.Statement> stmnts = that.getStatements();
        if (stmnts.isEmpty()) {
            this.out("{}", new String[0]);
        } else {
            this.beginBlock();
            this.visitStatements(stmnts);
            this.endBlock();
        }
    }

    void initSelf(Node node) {
        NeedsThisVisitor ntv = new NeedsThisVisitor(node);
        if (ntv.needsThisReference()) {
            Declaration od;
            String me = this.names.self(this.prototypeOwner);
            this.out("var ", me, "=this");
            if (ntv.needsOuterReference() && (od = ModelUtil.getContainingDeclaration(this.prototypeOwner)) instanceof TypeDeclaration) {
                this.out(",", this.names.self((TypeDeclaration)od), "=", me, ".outer$");
            }
            this.endLine(true);
        }
    }

    void comment(Tree.Declaration that) {
        if (!this.opts.isComment() || this.opts.isMinify()) {
            return;
        }
        this.endLine();
        String dname = that.getNodeType();
        if (dname.endsWith("Declaration") || dname.endsWith("Definition")) {
            dname = dname.substring(0, dname.length() - 7);
        }
        if (that instanceof Tree.Constructor) {
            String cname = ((Class)((Tree.Constructor)that).getDeclarationModel().getContainer()).getName();
            this.out("//Constructor ", cname, ".", that.getDeclarationModel().getName() == null ? "<default>" : that.getDeclarationModel().getName());
        } else {
            this.out("//", dname, " ", that.getDeclarationModel().getName());
        }
        this.location(that);
        this.endLine();
    }

    boolean share(Declaration d) {
        return this.share(d, true);
    }

    private boolean share(Declaration d, boolean excludeProtoMembers) {
        boolean shared = this.sharePrefix(d, excludeProtoMembers);
        if (shared) {
            String dname = this.names.name(d);
            if (dname.endsWith("()")) {
                dname = dname.substring(0, dname.length() - 2);
            }
            if (this.names.isJsGlobal(d)) {
                this.out(dname.substring(2), "=", dname);
            } else {
                this.out(dname, "=", dname);
            }
            this.endLine(true);
        }
        return shared;
    }

    private boolean sharePrefix(Declaration d, boolean excludeProtoMembers) {
        boolean shared = false;
        if (!(excludeProtoMembers && this.opts.isOptimize() && d.isClassOrInterfaceMember() || !(d instanceof ClassOrInterface) && !this.isCaptured(d))) {
            this.beginNewLine();
            if (d.isStatic()) {
                this.out(this.names.name(ModelUtil.getContainingClassOrInterface((Scope)((Object)d))), ".$st$.");
                shared = true;
            } else if (this.outerSelf(d)) {
                this.out(".", new String[0]);
                shared = true;
            }
        }
        return shared;
    }

    @Override
    public void visit(Tree.ClassDeclaration that) {
        if (this.opts.isOptimize() && that.getDeclarationModel().isClassOrInterfaceMember()) {
            return;
        }
        this.classDeclaration(that);
    }

    private void addClassDeclarationToPrototype(TypeDeclaration outer, Tree.ClassDeclaration that) {
        this.classDeclaration(that);
        String tname = this.names.name(that.getDeclarationModel());
        if (that.getDeclarationModel().isStatic()) {
            this.out(this.names.name(outer), ".$st$.", tname, "=", tname);
        } else {
            this.out(this.names.self(outer), ".", tname, "=", tname);
        }
        this.endLine(true);
    }

    private void addAliasDeclarationToPrototype(TypeDeclaration outer, Tree.TypeAliasDeclaration that) {
        this.comment(that);
        TypeAlias d = that.getDeclarationModel();
        String path = this.qualifiedPath(that, d, true);
        if (path.length() > 0) {
            path = path + '.';
        }
        String tname = this.names.name(d);
        tname = tname.substring(0, tname.length() - 2);
        String _tmp = this.names.createTempVariable();
        this.out(this.names.self(outer), ".", tname, "=function(){var ");
        Type pt = that.getTypeSpecifier().getType().getTypeModel();
        boolean skip = true;
        if (pt.involvesTypeParameters() && this.outerSelf(d)) {
            this.out("=this,", new String[0]);
            skip = false;
        }
        this.out(_tmp, "=");
        TypeUtils.typeNameOrList(that, pt, this, skip);
        this.out(";", _tmp, ".$crtmm$=");
        TypeUtils.encodeForRuntime(that, d, this);
        this.out(";return ", _tmp, ";}");
        this.endLine(true);
    }

    @Override
    public void visit(Tree.InterfaceDeclaration that) {
        if (!this.opts.isOptimize() || !that.getDeclarationModel().isClassOrInterfaceMember()) {
            this.interfaceDeclaration(that);
        }
    }

    private void addInterfaceDeclarationToPrototype(TypeDeclaration outer, Tree.InterfaceDeclaration that) {
        this.interfaceDeclaration(that);
        String tname = this.names.name(that.getDeclarationModel());
        if (that.getDeclarationModel().isStatic()) {
            this.out(this.names.name(outer), ".$st$.", tname, "=", tname);
        } else {
            this.out(this.names.self(outer), ".", tname, "=", tname);
        }
        this.endLine(true);
    }

    private void addInterfaceToPrototype(ClassOrInterface type, Tree.InterfaceDefinition interfaceDef, InitDeferrer initDeferrer) {
        if (type.isDynamic()) {
            return;
        }
        TypeGenerator.interfaceDefinition(interfaceDef, this, initDeferrer);
        Interface d = interfaceDef.getDeclarationModel();
        if (d.isStatic()) {
            this.out(this.names.name(type), ".$st$.", this.names.name(d), "=", this.names.name(d));
        } else {
            this.out(this.names.self(type), ".", this.names.name(d), "=", this.names.name(d));
        }
        this.endLine(true);
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        if (!this.opts.isOptimize() || !that.getDeclarationModel().isClassOrInterfaceMember()) {
            TypeGenerator.interfaceDefinition(that, this, null);
        }
    }

    private void addClassToPrototype(ClassOrInterface type, Tree.ClassDefinition classDef, InitDeferrer initDeferrer) {
        if (type.isDynamic()) {
            return;
        }
        ClassGenerator.classDefinition(classDef, this, initDeferrer);
        String tname = this.names.name(classDef.getDeclarationModel());
        if (classDef.getDeclarationModel().isStatic()) {
            this.out(this.names.name(type), ".$st$.", tname, "=", tname);
        } else {
            this.out(this.names.self(type), ".", tname, "=", tname);
        }
        this.endLine(true);
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        if (this.opts.isOptimize() && that.getDeclarationModel().isClassOrInterfaceMember()) {
            return;
        }
        ClassGenerator.classDefinition(that, this, null);
    }

    private void interfaceDeclaration(Tree.InterfaceDeclaration that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        this.comment(that);
        Interface d = that.getDeclarationModel();
        String aname = this.names.name(d);
        Tree.StaticType ext = that.getTypeSpecifier().getType();
        this.out(function, aname, "(");
        if (d.getTypeParameters() != null && !d.getTypeParameters().isEmpty()) {
            this.out("$$targs$$,", new String[0]);
        }
        this.out(this.names.self(d), "){");
        Type pt = ext.getTypeModel();
        TypeDeclaration aliased = pt.getDeclaration();
        this.qualify(that, aliased);
        this.out(this.names.name(aliased), "(");
        if (!pt.getTypeArguments().isEmpty()) {
            TypeUtils.printTypeArguments(that, pt.getTypeArguments(), this, true, pt.getVarianceOverrides());
            this.out(",", new String[0]);
        }
        this.out(this.names.self(d), ");}");
        this.endLine();
        this.out(aname, ".$crtmm$=");
        TypeUtils.encodeForRuntime(that, d, this);
        this.endLine(true);
        this.share(d);
    }

    private void classDeclaration(Tree.ClassDeclaration that) {
        Map<TypeParameter, Type> invargs;
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        this.comment(that);
        Class d = that.getDeclarationModel();
        String aname = this.names.name(d);
        Tree.ClassSpecifier ext = that.getClassSpecifier();
        this.out(function, aname, "(");
        for (Tree.Parameter p : that.getParameterList().getParameters()) {
            p.visit(this);
            this.out(", ", new String[0]);
        }
        if (d.getTypeParameters() != null && !d.getTypeParameters().isEmpty()) {
            this.out("$$targs$$,", new String[0]);
        }
        this.out(this.names.self(d), "){");
        this.initSelf(that);
        this.initParameters(that.getParameterList(), d, null);
        this.out("return ", new String[0]);
        TypeDeclaration aliased = ext.getType().getDeclarationModel();
        String aliasedName = this.names.name(aliased);
        this.qualify(that, aliased);
        Scope superscope = this.getSuperMemberScope(ext.getType());
        if (superscope != null) {
            this.out("getT$all()['", new String[0]);
            this.out(superscope.getQualifiedNameString(), new String[0]);
            this.out("'].$$.prototype.", aliasedName, ".call(", this.names.self(this.prototypeOwner), ",");
        } else {
            this.out(aliasedName, "(");
        }
        if (ext.getInvocationExpression().getPositionalArgumentList() != null) {
            ext.getInvocationExpression().getPositionalArgumentList().visit(this);
            if (!ext.getInvocationExpression().getPositionalArgumentList().getPositionalArguments().isEmpty()) {
                this.out(",", new String[0]);
            }
        } else {
            this.out("/*PENDIENTE NAMED ARG CLASS DECL */", new String[0]);
        }
        if ((invargs = ext.getType().getTypeModel().getTypeArguments()) != null && !invargs.isEmpty()) {
            TypeUtils.printTypeArguments(that, invargs, this, true, ext.getType().getTypeModel().getVarianceOverrides());
            this.out(",", new String[0]);
        }
        this.out(this.names.self(d), ");}");
        this.endLine();
        this.out(aname, ".$$=");
        this.qualify(that, aliased);
        this.out(aliasedName, ".$$");
        this.endLine(true);
        this.out(aname, ".$crtmm$=");
        TypeUtils.encodeForRuntime(that, d, this);
        this.endLine(true);
        this.share(d);
        if (aliased instanceof Class && ((Class)aliased).hasConstructors() || aliased instanceof Constructor) {
            Class ac = aliased instanceof Constructor ? (Class)((Constructor)aliased).getContainer() : (Class)aliased;
            for (Declaration cm : ac.getMembers()) {
                if (!(cm instanceof Constructor) || cm == ac.getDefaultConstructor() || !cm.isShared()) continue;
                Constructor cons = (Constructor)cm;
                String constructorName = aname + this.names.constructorSeparator(cons) + this.names.name(cons);
                this.out(function, constructorName, "(");
                ArrayList<String> pnames = new ArrayList<String>(cons.getFirstParameterList().getParameters().size() + 1);
                boolean first = true;
                for (int i = 0; i < cons.getFirstParameterList().getParameters().size(); ++i) {
                    String pname = this.names.createTempVariable();
                    pnames.add(pname);
                    if (first) {
                        first = false;
                    } else {
                        this.out(",", new String[0]);
                    }
                    this.out(pname, new String[0]);
                }
                this.out("){return ", new String[0]);
                this.qualify(that, cons);
                this.out(this.names.name(cons), "(");
                first = true;
                for (String pname : pnames) {
                    if (first) {
                        first = false;
                    } else {
                        this.out(",", new String[0]);
                    }
                    this.out(pname, new String[0]);
                }
                this.out(");}", new String[0]);
                if (!ac.isShared()) continue;
                this.sharePrefix(ac, true);
                this.out(constructorName, "=", constructorName, ";");
                this.endLine();
            }
        }
    }

    @Override
    public void visit(final Tree.TypeAliasDeclaration that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        final TypeAlias d = that.getDeclarationModel();
        if (this.opts.isOptimize() && d.isClassOrInterfaceMember()) {
            return;
        }
        this.comment(that);
        String tname = this.names.createTempVariable();
        this.out(function, this.names.name(d), "{var ", tname, "=");
        TypeUtils.typeNameOrList(that, that.getTypeSpecifier().getType().getTypeModel(), this, false);
        this.out(";", tname, ".$crtmm$=");
        TypeUtils.encodeForRuntime((Node)that, (Declaration)d, this, new TypeUtils.RuntimeMetamodelAnnotationGenerator(){

            @Override
            public void generateAnnotations() {
                TypeUtils.outputAnnotationsFunction(that.getAnnotationList(), d, GenerateJsVisitor.this);
            }
        });
        this.out(";return ", tname, ";}");
        this.endLine();
        this.share(d);
    }

    void referenceOuter(TypeDeclaration d) {
        ClassOrInterface coi;
        if (!d.isToplevel() && !d.isStatic() && (coi = ModelUtil.getContainingClassOrInterface(d.getContainer())) != null) {
            this.out(this.names.self(d), ".outer$");
            if (d.isClassOrInterfaceMember()) {
                if (d.isStatic()) {
                    this.out("=", this.names.name(coi));
                } else {
                    this.out("=this", new String[0]);
                }
            } else {
                this.out("=", this.names.self(coi));
            }
            this.endLine(true);
        }
    }

    void addToPrototype(Node node, ClassOrInterface d, List<Tree.Statement> statements) {
        boolean overrideToString;
        boolean isSerial = d instanceof Class && ((Class)d).isSerializable();
        boolean enter = this.opts.isOptimize();
        ArrayList<Parameter> plist = null;
        boolean isAbstractNative = TypeUtils.makeAbstractNative(d);
        String typename = this.names.name(d);
        boolean bl = overrideToString = d.getDirectMember("toString", null, true) == null;
        if (enter) {
            ParameterList _pl;
            enter = !statements.isEmpty() | overrideToString;
            if (d instanceof Class && (_pl = ((Class)d).getParameterList()) != null) {
                plist = new ArrayList<Parameter>(_pl.getParameters().size());
                plist.addAll(_pl.getParameters());
                enter |= !plist.isEmpty();
            }
        }
        if (enter || isSerial) {
            List<? extends Tree.Statement> prevStatements = this.currentStatements;
            this.currentStatements = statements;
            this.out("(function(", this.names.self(d), ")");
            this.beginBlock();
            if (enter) {
                ClassOrInterface coi;
                for (Tree.Statement statement : statements) {
                }
                if (plist != null) {
                    for (Parameter p : plist) {
                        this.generateAttributeForParameter(node, (Class)d, p);
                    }
                }
                boolean statics = false;
                InitDeferrer initDeferrer = new InitDeferrer();
                for (Tree.Statement s : statements) {
                    Declaration sd;
                    if (!statics && s instanceof Tree.Declaration && (sd = ((Tree.Declaration)s).getDeclarationModel()).isStatic()) {
                        statics = true;
                        this.out(this.names.name(d), ".$st$={};");
                    }
                    if (s instanceof Tree.ClassOrInterface || s instanceof Tree.AttributeDeclaration && ((Tree.AttributeDeclaration)s).getDeclarationModel().isParameter()) continue;
                    this.addToPrototype(d, s, plist, initDeferrer);
                }
                for (Tree.Statement s : statements) {
                    if (s instanceof Tree.ClassOrInterface) {
                        this.addToPrototype(d, s, plist, initDeferrer);
                        continue;
                    }
                    if (!(s instanceof Tree.Enumerated)) continue;
                    Tree.Enumerated vc = (Tree.Enumerated)s;
                    this.defineAttribute(this.names.self(d), this.names.name(vc.getDeclarationModel()));
                    this.out("{return ", typename, this.names.constructorSeparator(vc.getDeclarationModel()), this.names.name(vc.getDeclarationModel()), "();},undefined,");
                    TypeUtils.encodeForRuntime((Node)vc, (Declaration)vc.getDeclarationModel(), vc.getAnnotationList(), this);
                    this.out(");", new String[0]);
                }
                for (String stmt : initDeferrer.deferred) {
                    this.out(stmt, new String[0]);
                    this.endLine();
                }
                if (d.isMember() && (coi = ModelUtil.getContainingClassOrInterface(d.getContainer())) != null && d.inherits(coi)) {
                    this.out(this.names.self(d), ".", typename, "=", typename, ";");
                }
            }
            if (isSerial && !isAbstractNative) {
                SerializationHelper.addSerializer(node, (Class)d, this);
            }
            if (overrideToString) {
                this.out(this.names.self(d), ".", "toString=function(){return this.string.valueOf();};");
            }
            this.endBlock();
            this.out(")(", typename, ".$$.prototype)");
            this.endLine(true);
            this.currentStatements = prevStatements;
        }
    }

    void generateAttributeForParameter(Node node, Class d, Parameter p) {
        if (p.getDeclaration() instanceof Function && ((Function)p.getDeclaration()).getTypeDeclaration() instanceof Constructor) {
            return;
        }
        FunctionOrValue pdec = p.getModel();
        String privname = this.names.valueName(pdec);
        this.defineAttribute(this.names.self(d), this.names.name(pdec));
        this.out("{", new String[0]);
        if (pdec.isLate()) {
            this.generateUnitializedAttributeReadCheck("this." + privname, this.names.name(p), null);
        }
        this.out("return this.", privname, ";}");
        if (pdec.isVariable() || pdec.isLate()) {
            String param = this.names.createTempVariable();
            this.out(",function(", param, "){");
            this.generateImmutableAttributeReassignmentCheck(pdec, "this." + privname, this.names.name(p));
            this.out("return this.", privname, "=", param, ";}");
        } else {
            this.out(",undefined", new String[0]);
        }
        this.out(",", new String[0]);
        TypeUtils.encodeForRuntime(node, pdec, this);
        this.out(")", new String[0]);
        this.endLine(true);
    }

    private void addToPrototype(ClassOrInterface d, Tree.Statement s, List<Parameter> params, InitDeferrer initDeferrer) {
        ClassOrInterface oldPrototypeOwner = this.prototypeOwner;
        this.prototypeOwner = d;
        if (s instanceof Tree.MethodDefinition) {
            this.addMethodToPrototype(d, (Tree.MethodDefinition)s);
        } else if (s instanceof Tree.MethodDeclaration) {
            if (this.errVisitor.hasErrors(s)) {
                return;
            }
            FunctionHelper.methodDeclaration(d, (Tree.MethodDeclaration)s, this, this.verboseStitcher);
        } else if (s instanceof Tree.AttributeGetterDefinition) {
            this.addGetterToPrototype(d, (Tree.AttributeGetterDefinition)s);
        } else if (s instanceof Tree.AttributeDeclaration) {
            AttributeGenerator.addGetterAndSetterToPrototype(d, (Tree.AttributeDeclaration)s, this, this.verboseStitcher);
        } else if (s instanceof Tree.ClassDefinition) {
            this.addClassToPrototype(d, (Tree.ClassDefinition)s, initDeferrer);
        } else if (s instanceof Tree.InterfaceDefinition) {
            this.addInterfaceToPrototype(d, (Tree.InterfaceDefinition)s, initDeferrer);
        } else if (s instanceof Tree.ObjectDefinition) {
            this.addObjectToPrototype(d, (Tree.ObjectDefinition)s, initDeferrer);
        } else if (s instanceof Tree.ClassDeclaration) {
            this.addClassDeclarationToPrototype(d, (Tree.ClassDeclaration)s);
        } else if (s instanceof Tree.InterfaceDeclaration) {
            this.addInterfaceDeclarationToPrototype(d, (Tree.InterfaceDeclaration)s);
        } else if (s instanceof Tree.SpecifierStatement) {
            this.addSpecifierToPrototype(d, (Tree.SpecifierStatement)s);
        } else if (s instanceof Tree.TypeAliasDeclaration) {
            this.addAliasDeclarationToPrototype(d, (Tree.TypeAliasDeclaration)s);
        }
        if (params != null && s instanceof Tree.Declaration) {
            Declaration m = ((Tree.Declaration)s).getDeclarationModel();
            Iterator<Parameter> iter = params.iterator();
            while (iter.hasNext()) {
                Parameter _p = iter.next();
                if (m.getName() == null || !m.getName().equals(_p.getName())) continue;
                iter.remove();
                break;
            }
        }
        this.prototypeOwner = oldPrototypeOwner;
    }

    void declareSelf(ClassOrInterface d) {
        this.out("if(", this.names.self(d), "===undefined)");
        if (d instanceof Class && d.isAbstract()) {
            this.out(this.getClAlias(), "throwexc(", this.getClAlias(), "InvocationException$meta$model(");
            this.out("\"Cannot instantiate abstract class ", d.getQualifiedNameString(), "\"),'?','?')");
        } else {
            this.out(this.names.self(d), "=new ");
            if (this.opts.isOptimize() && d.isClassOrInterfaceMember() && !d.isStatic()) {
                this.out("this.", new String[0]);
            }
            this.out(this.names.name(d), ".$$;");
        }
        this.endLine();
    }

    void instantiateSelf(ClassOrInterface d) {
        this.out("var ", this.names.self(d), "=new ");
        if (this.opts.isOptimize() && d.isClassOrInterfaceMember()) {
            if (d.isStatic()) {
                this.out(this.names.name(ModelUtil.getContainingClassOrInterface(d.getContainer())), ".$st$.");
            } else {
                this.out("this.", new String[0]);
            }
        }
        this.out(this.names.name(d), ".$$;");
    }

    private void addObjectToPrototype(ClassOrInterface type, Tree.ObjectDefinition objDef, InitDeferrer initDeferrer) {
        if (this.errVisitor.hasErrors(objDef)) {
            return;
        }
        this.comment(objDef);
        Singletons.objectDefinition(objDef, this, initDeferrer);
        Value d = objDef.getDeclarationModel();
        Class c = (Class)d.getTypeDeclaration();
        if (d.isStatic()) {
            this.out(this.names.name(type), ".$st$.", this.names.name(d), "=function(){if(", this.names.name(type), ".$st$.$INIT$", this.names.name(d), "===undefined)", this.names.name(type), ".$st$.$INIT$", this.names.name(d), "=$init$", this.names.name(d), "()();return ", this.names.name(type), ".$st$.$INIT$", this.names.name(d), "};");
            this.out(this.names.name(type), ".$st$.", this.names.name(c), "=", this.names.name(c), ";");
        } else {
            this.out(this.names.self(type), ".", this.names.name(c), "=", this.names.name(c), ";");
        }
        if (d.isStatic()) {
            this.out(this.names.name(type), ".$st$.", this.names.name(d));
        } else {
            this.out(this.names.self(type), ".", this.names.name(c));
        }
        this.out(".$crtmm$=", new String[0]);
        TypeUtils.encodeForRuntime(objDef, d, this);
        this.endLine(true);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        if (NativeUtil.isNativeHeader(that) && ModelUtil.getNativeDeclaration((Declaration)that.getDeclarationModel(), Backend.JavaScript) != null) {
            this.headers.put(that.getDeclarationModel().getQualifiedNameString(), that);
            return;
        }
        if (!NativeUtil.isForBackend(that, Backend.JavaScript) && !NativeUtil.isHeaderWithoutBackend(that, Backend.JavaScript)) {
            return;
        }
        Value d = that.getDeclarationModel();
        if (!this.opts.isOptimize() || !d.isClassOrInterfaceMember()) {
            this.comment(that);
            Singletons.objectDefinition(that, this, null);
        } else {
            if (this.errVisitor.hasErrors(that)) {
                return;
            }
            Class c = (Class)d.getTypeDeclaration();
            if (d.isStatic()) {
                return;
            }
            this.comment(that);
            this.outerSelf(d);
            this.out(".", this.names.privateName(d), "=");
            this.outerSelf(d);
            this.out(".", this.names.name(c), "()");
            this.endLine(true);
        }
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        this.out("function(){", new String[0]);
        try {
            Tree.SatisfiedTypes sts = that.getSatisfiedTypes();
            Tree.ExtendedType et = that.getExtendedType();
            Singletons.defineObject(that, null, sts == null ? null : TypeUtils.getTypes(sts.getTypes()), et == null ? null : et.getType(), et == null ? null : et.getInvocationExpression(), that.getClassBody(), null, this, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.out("}()", new String[0]);
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        if (this.errVisitor.hasErrors(that) || !TypeUtils.acceptNative(that)) {
            return;
        }
        FunctionHelper.methodDeclaration(null, that, this, this.verboseStitcher);
    }

    boolean stitchNative(Declaration d, Tree.Declaration n) {
        VirtualFile f = this.compiler.getStitchedFile(d, ".js");
        if (f != null && f.exists()) {
            if (this.compiler.isCompilingLanguageModule()) {
                this.jsout.outputFile(f);
            }
            if (d.isClassOrInterfaceMember()) {
                if (d instanceof Value || n instanceof Tree.Constructor) {
                    return true;
                }
                this.out(this.names.self((TypeDeclaration)d.getContainer()), ".");
            } else if (n instanceof Tree.AttributeDeclaration || n instanceof Tree.AttributeGetterDefinition) {
                return true;
            }
            this.out(this.names.name(d), ".$crtmm$=");
            TypeUtils.encodeForRuntime((Node)n, d, n.getAnnotationList(), this);
            this.endLine(true);
            return true;
        }
        if (!(d instanceof ClassOrInterface || n instanceof Tree.MethodDefinition || n instanceof Tree.MethodDeclaration && ((Tree.MethodDeclaration)n).getSpecifierExpression() != null || n instanceof Tree.AttributeGetterDefinition || n instanceof Tree.AttributeDeclaration && ((Tree.AttributeDeclaration)n).getSpecifierOrInitializerExpression() != null)) {
            String missingDeclarationName = d.getName();
            missingDeclarationName = missingDeclarationName == null && d instanceof Constructor ? "default constructor" : "'" + missingDeclarationName + "'";
            String err = "no native implementation for backend: native " + missingDeclarationName + " is not implemented for the 'js' backend";
            n.addError(err, Backend.JavaScript);
            this.out("/*", err, "*/");
        }
        return false;
    }

    boolean stitchInitializer(TypeDeclaration d) {
        VirtualFile f = this.compiler.getStitchedFile(d, "$init.js");
        if (f != null && f.exists()) {
            this.jsout.outputFile(f);
            return true;
        }
        return false;
    }

    boolean stitchConstructorHelper(Tree.ClassOrInterface coi, String partName) {
        VirtualFile f = this.compiler.getStitchedConstructorFile(coi.getDeclarationModel(), partName);
        if (f != null && f.exists() && !f.isFolder()) {
            if (this.verboseStitcher) {
                this.spitOut("Stitching in " + f + ". It must contain an anonymous function " + "which will be invoked with the same arguments as the " + this.names.name(coi.getDeclarationModel()) + " constructor.");
            }
            this.out("(", new String[0]);
            this.jsout.outputFile(f);
            this.out(")", new String[0]);
            TypeGenerator.generateParameters(coi.getTypeParameterList(), coi instanceof Tree.ClassDefinition ? ((Tree.ClassDefinition)coi).getParameterList() : null, coi.getDeclarationModel(), this);
            this.endLine(true);
        }
        return false;
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        if (this.errVisitor.hasErrors(that) || !TypeUtils.acceptNative(that)) {
            return;
        }
        Function d = that.getDeclarationModel();
        if (!(this.opts.isOptimize() && d.isClassOrInterfaceMember() || TypeUtils.isNativeExternal(d) && this.compiler.isCompilingLanguageModule())) {
            this.comment(that);
            this.initDefaultedParameters(that.getParameterLists().get(0), that);
            FunctionHelper.methodDefinition(that, this, true, this.verboseStitcher);
            this.out(this.names.name(d), ".$crtmm$=");
            TypeUtils.encodeMethodForRuntime(that, this);
            this.endLine(true);
        }
    }

    Tree.SpecifierOrInitializerExpression getDefaultExpression(Tree.Parameter param) {
        Tree.SpecifierOrInitializerExpression expr;
        if (param instanceof Tree.ParameterDeclaration || param instanceof Tree.InitializerParameter) {
            Tree.MethodDeclaration md = null;
            if (param instanceof Tree.ParameterDeclaration) {
                Tree.TypedDeclaration td = ((Tree.ParameterDeclaration)param).getTypedDeclaration();
                if (td instanceof Tree.AttributeDeclaration) {
                    expr = ((Tree.AttributeDeclaration)td).getSpecifierOrInitializerExpression();
                } else if (td instanceof Tree.MethodDeclaration) {
                    md = (Tree.MethodDeclaration)td;
                    expr = md.getSpecifierExpression();
                } else {
                    param.addUnexpectedError("Don't know what to do with TypedDeclaration " + td.getClass().getName(), Backend.JavaScript);
                    expr = null;
                }
            } else {
                expr = ((Tree.InitializerParameter)param).getSpecifierExpression();
            }
        } else {
            param.addUnexpectedError("Don't know what to do with defaulted/sequenced param " + param, Backend.JavaScript);
            expr = null;
        }
        return expr;
    }

    void initDefaultedParameters(Tree.ParameterList params, Tree.AnyMethod container) {
        if (!(container instanceof Tree.MethodDeclaration) && !container.getDeclarationModel().isMember()) {
            return;
        }
        boolean isMember = container.getDeclarationModel().isMember();
        for (Tree.Parameter param : params.getParameters()) {
            Tree.SpecifierOrInitializerExpression expr;
            Parameter pd = param.getParameterModel();
            if (!pd.isDefaulted() || (expr = this.getDefaultExpression(param)) == null) continue;
            if (isMember) {
                this.qualify(params, container.getDeclarationModel());
                this.out(this.names.name(container.getDeclarationModel()), "$defs$", pd.getName(), "=function");
            } else {
                this.out(function, this.names.name(container.getDeclarationModel()), "$defs$", pd.getName());
            }
            params.visit(this);
            this.out("{", new String[0]);
            this.initSelf(expr);
            this.out("return ", new String[0]);
            if (param instanceof Tree.ParameterDeclaration && ((Tree.ParameterDeclaration)param).getTypedDeclaration() instanceof Tree.MethodDeclaration) {
                FunctionHelper.singleExprFunction(((Tree.MethodDeclaration)((Tree.ParameterDeclaration)param).getTypedDeclaration()).getParameterLists(), expr.getExpression(), null, true, true, this);
            } else if (!this.isNaturalLiteral(expr.getExpression().getTerm())) {
                expr.visit(this);
            }
            this.out(";}", new String[0]);
            this.endLine(true);
        }
    }

    List<Tree.Parameter> initParameters(Tree.ParameterList params, TypeDeclaration typeDecl, Functional m) {
        ArrayList<Tree.Parameter> rparams = null;
        for (Tree.Parameter param : params.getParameters()) {
            Parameter pd = param.getParameterModel();
            String paramName = this.names.name(pd);
            if (pd.isDefaulted() || pd.isSequenced()) {
                this.out("if(", paramName, "===undefined){", paramName, "=");
                if (pd.isDefaulted()) {
                    boolean done = false;
                    if (m instanceof Function) {
                        Function mf = (Function)m;
                        if (mf.getRefinedDeclaration() != mf && ((mf = (Function)mf.getRefinedDeclaration()).isMember() || !mf.isImplemented())) {
                            this.qualify(params, mf);
                            this.out(this.names.name(mf), "$defs$", pd.getName(), "(");
                            boolean firstParam = true;
                            for (Parameter p : m.getFirstParameterList().getParameters()) {
                                if (firstParam) {
                                    firstParam = false;
                                } else {
                                    this.out(",", new String[0]);
                                }
                                this.out(this.names.name(p), new String[0]);
                            }
                            this.out(")", new String[0]);
                            done = true;
                        }
                    } else if (pd.getDeclaration() instanceof Class) {
                        Class cdec = (Class)pd.getDeclaration().getRefinedDeclaration();
                        this.out(TypeGenerator.pathToType(params, cdec, this), ".$defs$", pd.getName(), "(", this.names.self(cdec));
                        for (Parameter p : ((Class)pd.getDeclaration()).getParameterList().getParameters()) {
                            if (p.equals(pd)) continue;
                            this.out(",", this.names.name(p));
                        }
                        this.out(")", new String[0]);
                        if (rparams == null) {
                            rparams = new ArrayList<Tree.Parameter>(3);
                        }
                        rparams.add(param);
                        done = true;
                    }
                    if (!done) {
                        Tree.SpecifierOrInitializerExpression expr = this.getDefaultExpression(param);
                        if (expr == null) {
                            param.addUnexpectedError("Default expression missing for " + pd.getName(), Backend.JavaScript);
                            this.out("undefined", new String[0]);
                        } else {
                            this.generateParameterExpression(param, expr, pd.getDeclaration() instanceof Scope ? (Scope)((Object)pd.getDeclaration()) : null);
                        }
                    }
                } else {
                    this.out(this.getClAlias(), "empty()");
                }
                this.out(";}", new String[0]);
                this.endLine();
            }
            if (typeDecl == null || typeDecl instanceof ClassAlias || !pd.getModel().isCaptured() && !(pd.getDeclaration() instanceof Class)) continue;
            this.out(this.names.self(typeDecl), ".", this.names.valueName(pd.getModel()), "=", paramName);
            if (!this.opts.isOptimize() && pd.isHidden()) {
                this.out(";", this.names.self(typeDecl), ".", paramName, "=", paramName);
            }
            this.endLine(true);
        }
        return rparams;
    }

    void generateParameterExpression(Tree.Parameter param, Tree.SpecifierOrInitializerExpression expr, Scope m) {
        if (param instanceof Tree.ParameterDeclaration && ((Tree.ParameterDeclaration)param).getTypedDeclaration() instanceof Tree.MethodDeclaration) {
            FunctionHelper.singleExprFunction(((Tree.MethodDeclaration)((Tree.ParameterDeclaration)param).getTypedDeclaration()).getParameterLists(), expr.getExpression(), m, false, true, this);
        } else {
            expr.visit(this);
        }
    }

    private void addMethodToPrototype(TypeDeclaration outer, Tree.MethodDefinition that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        Function d = that.getDeclarationModel();
        if (!this.opts.isOptimize() || !d.isClassOrInterfaceMember()) {
            return;
        }
        this.comment(that);
        this.initDefaultedParameters(that.getParameterLists().get(0), that);
        if (d.isStatic()) {
            this.out(this.names.name(outer), ".$st$.", this.names.name(d), "=");
        } else {
            this.out(this.names.self(outer), ".", this.names.name(d), "=");
        }
        FunctionHelper.methodDefinition(that, this, false, this.verboseStitcher);
        if (d.isStatic()) {
            this.out(this.names.name(outer), ".$st$.", this.names.name(d), ".$crtmm$=");
        } else {
            this.out(this.names.self(outer), ".", this.names.name(d), ".$crtmm$=");
        }
        TypeUtils.encodeMethodForRuntime(that, this);
        this.endLine(true);
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        if (this.errVisitor.hasErrors(that) || !TypeUtils.acceptNative(that)) {
            return;
        }
        Value d = that.getDeclarationModel();
        if (this.opts.isOptimize() && d.isClassOrInterfaceMember()) {
            return;
        }
        this.comment(that);
        if (AttributeGenerator.defineAsProperty(d)) {
            this.defineAttribute(this.names.self((TypeDeclaration)d.getContainer()), this.names.name(d));
            AttributeGenerator.getter(that, this, true);
            Tree.AttributeSetterDefinition setterDef = this.associatedSetterDefinition(d);
            if (setterDef == null) {
                this.out(",undefined", new String[0]);
            } else {
                this.out(",function(", this.names.name(setterDef.getDeclarationModel().getParameter()), ")");
                AttributeGenerator.setter(setterDef, this);
            }
            this.out(",", new String[0]);
            TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), this);
            if (setterDef != null) {
                this.out(",", new String[0]);
                TypeUtils.encodeForRuntime((Node)setterDef, (Declaration)setterDef.getDeclarationModel(), setterDef.getAnnotationList(), this);
            }
            this.out(");", new String[0]);
        } else {
            this.out(function, this.names.getter(d, false), "()");
            if (TypeUtils.isNativeExternal(d)) {
                this.out("{", new String[0]);
                if (this.stitchNative(d, that)) {
                    if (this.verboseStitcher) {
                        this.spitOut("Stitching in native attribute " + d.getQualifiedNameString() + ", ignoring Ceylon declaration");
                    }
                } else {
                    AttributeGenerator.getter(that, this, false);
                }
                this.out("}", new String[0]);
            } else {
                AttributeGenerator.getter(that, this, true);
            }
            this.endLine();
            this.out(this.names.getter(d, false), ".$crtmm$=");
            TypeUtils.encodeForRuntime(that, d, this);
            if (!this.shareGetter(d)) {
                this.out(";", new String[0]);
            }
            AttributeGenerator.generateAttributeMetamodel(that, true, false, this);
        }
    }

    private void addGetterToPrototype(TypeDeclaration outer, Tree.AttributeGetterDefinition that) {
        Value d = that.getDeclarationModel();
        if (!this.opts.isOptimize() || !d.isClassOrInterfaceMember()) {
            return;
        }
        this.comment(that);
        this.defineAttribute(d.isStatic() ? this.names.name(outer) + ".$st$" : this.names.self(outer), this.names.name(d));
        if (TypeUtils.isNativeExternal(d)) {
            this.out("{", new String[0]);
            if (this.stitchNative(d, that)) {
                if (this.verboseStitcher) {
                    this.spitOut("Stitching in native getter " + d.getQualifiedNameString() + ", ignoring Ceylon declaration");
                }
            } else {
                AttributeGenerator.getter(that, this, false);
            }
            this.out("}", new String[0]);
        } else {
            AttributeGenerator.getter(that, this, true);
        }
        Tree.AttributeSetterDefinition setterDef = this.associatedSetterDefinition(d);
        if (setterDef == null) {
            this.out(",undefined", new String[0]);
        } else {
            this.out(",function(", this.names.name(setterDef.getDeclarationModel().getParameter()), ")");
            AttributeGenerator.setter(setterDef, this);
        }
        this.out(",", new String[0]);
        TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), this);
        if (setterDef != null) {
            this.out(",", new String[0]);
            TypeUtils.encodeForRuntime((Node)setterDef, (Declaration)setterDef.getDeclarationModel(), setterDef.getAnnotationList(), this);
        }
        this.out(");", new String[0]);
    }

    Tree.AttributeSetterDefinition associatedSetterDefinition(Value valueDecl) {
        Setter setter = valueDecl.getSetter();
        if (setter != null && this.currentStatements != null) {
            for (Tree.Statement statement : this.currentStatements) {
                Tree.AttributeSetterDefinition setterDef;
                if (!(statement instanceof Tree.AttributeSetterDefinition) || (setterDef = (Tree.AttributeSetterDefinition)statement).getDeclarationModel() != setter) continue;
                return setterDef;
            }
        }
        return null;
    }

    boolean shareGetter(FunctionOrValue d) {
        boolean shared = false;
        if (this.isCaptured(d)) {
            this.beginNewLine();
            this.outerSelf(d);
            this.out(".", this.names.getter(d, false), "=", this.names.getter(d, false));
            this.endLine(true);
            shared = true;
        }
        return shared;
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        if (this.errVisitor.hasErrors(that) || !TypeUtils.acceptNative(that)) {
            return;
        }
        Setter d = that.getDeclarationModel();
        if (this.opts.isOptimize() && d.isClassOrInterfaceMember() || AttributeGenerator.defineAsProperty(d)) {
            return;
        }
        this.comment(that);
        this.out(function, this.names.setter(d.getGetter()), "(", this.names.name(d.getParameter()), ")");
        AttributeGenerator.setter(that, this);
        if (!this.shareSetter(d)) {
            this.out(";", new String[0]);
        }
        if (!d.isToplevel()) {
            this.outerSelf(d);
        }
        this.out(this.names.setter(d.getGetter()), ".$crtmm$=");
        TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), this);
        this.endLine(true);
        AttributeGenerator.generateAttributeMetamodel(that, false, true, this);
    }

    boolean isCaptured(Declaration d) {
        if (d.isToplevel() || d.isClassOrInterfaceMember()) {
            if (d.isShared() || d.isCaptured()) {
                return true;
            }
            OuterVisitor ov = new OuterVisitor(d);
            ov.visit(this.root);
            return ov.found;
        }
        return false;
    }

    boolean shareSetter(FunctionOrValue d) {
        boolean shared = false;
        if (this.isCaptured(d)) {
            this.beginNewLine();
            this.outerSelf(d);
            this.out(".", this.names.setter(d), "=", this.names.setter(d));
            this.endLine(true);
            shared = true;
        }
        return shared;
    }

    void addGeneratedAttribute(Declaration d) {
        this.generatedAttributes.add(d);
    }

    boolean isGeneratedAttribute(Declaration d) {
        return this.generatedAttributes.contains(d);
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (this.errVisitor.hasErrors(that) || !TypeUtils.acceptNative(that)) {
            return;
        }
        Value d = that.getDeclarationModel();
        Parameter param = d.isParameter() ? ((Functional)((Object)d.getContainer())).getParameter(d.getName()) : null;
        boolean asprop = AttributeGenerator.defineAsProperty(d);
        if (d.isFormal()) {
            if (!this.opts.isOptimize()) {
                this.comment(that);
                AttributeGenerator.generateAttributeMetamodel(that, false, false, this);
            }
        } else if (!d.isStatic()) {
            boolean addMeta;
            Tree.SpecifierOrInitializerExpression specInitExpr = that.getSpecifierOrInitializerExpression();
            boolean addGetter = specInitExpr != null || param != null || !d.isMember() || d.isVariable() || d.isLate();
            boolean setterGend = false;
            if (this.opts.isOptimize() && d.isClassOrInterfaceMember()) {
                boolean eagerExpr;
                boolean bl = eagerExpr = specInitExpr != null && !(specInitExpr instanceof Tree.LazySpecifierExpression);
                if (eagerExpr && !TypeUtils.isNativeExternal(d)) {
                    this.comment(that);
                    this.outerSelf(d);
                    this.out(".", this.names.privateName(d), "=");
                    if (d.isLate()) {
                        this.out("undefined", new String[0]);
                    } else {
                        super.visit(specInitExpr);
                    }
                    this.endLine(true);
                }
            } else if (specInitExpr instanceof Tree.LazySpecifierExpression) {
                this.comment(that);
                if (asprop) {
                    this.defineAttribute(this.names.self((TypeDeclaration)d.getContainer()), this.names.name(d));
                    this.out("{", new String[0]);
                } else {
                    this.out(function, this.names.getter(d, false), "(){");
                }
                this.initSelf(that);
                boolean genatr = true;
                if (TypeUtils.isNativeExternal(d) && this.stitchNative(d, that)) {
                    if (this.verboseStitcher) {
                        this.spitOut("Stitching in native attribute " + d.getQualifiedNameString() + ", ignoring Ceylon declaration");
                    }
                    genatr = false;
                    this.out(";};", new String[0]);
                }
                if (genatr) {
                    this.out("return ", new String[0]);
                    if (!this.isNaturalLiteral(specInitExpr.getExpression().getTerm())) {
                        this.visitSingleExpression(specInitExpr.getExpression());
                    }
                    this.out("}", new String[0]);
                    if (asprop) {
                        Tree.AttributeSetterDefinition setterDef = null;
                        if (d.isVariable() && (setterDef = this.associatedSetterDefinition(d)) != null) {
                            this.out(",function(", this.names.name(setterDef.getDeclarationModel().getParameter()), ")");
                            AttributeGenerator.setter(setterDef, this);
                        }
                        if (setterDef == null) {
                            this.out(",undefined", new String[0]);
                        }
                        this.out(",", new String[0]);
                        TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), this);
                        if (setterDef != null) {
                            this.out(",", new String[0]);
                            TypeUtils.encodeForRuntime((Node)setterDef, (Declaration)setterDef.getDeclarationModel(), setterDef.getAnnotationList(), this);
                        }
                        this.out(")", new String[0]);
                        this.endLine(true);
                    } else {
                        this.endLine(true);
                        this.shareGetter(d);
                    }
                }
            } else if (!d.isParameter() || !(d.getContainer() instanceof Function)) {
                if (addGetter) {
                    AttributeGenerator.generateAttributeGetter(that, d, specInitExpr, this.names.name(param), this, this.directAccess, this.verboseStitcher);
                }
                if ((d.isVariable() || d.isLate()) && !asprop) {
                    setterGend = AttributeGenerator.generateAttributeSetter(that, d, this);
                }
            }
            boolean bl = addMeta = !this.opts.isOptimize() || d.isToplevel();
            if (!d.isToplevel()) {
                addMeta |= ModelUtil.getContainingDeclaration(d).isAnonymous();
            }
            if (addMeta) {
                AttributeGenerator.generateAttributeMetamodel(that, addGetter, setterGend, this);
            }
        }
    }

    void generateUnitializedAttributeReadCheck(String privname, String pubname, Tree.SpecifierOrInitializerExpression expr) {
        this.out("if(", privname, "===undefined)");
        if (expr == null) {
            this.out("throw ", this.getClAlias(), "InitializationError('Attempt to read uninitialized attribute \\u00ab", pubname, "\\u00bb');");
        } else {
            if (new NeedsThisVisitor(expr).needsThisReference()) {
                this.out("{", new String[0]);
                this.initSelf(expr);
                this.out(privname, "=");
            } else {
                this.out("{", privname, "=");
            }
            expr.visit(this);
            this.out(";}", new String[0]);
        }
    }

    void generateImmutableAttributeReassignmentCheck(FunctionOrValue decl, String privname, String pubname) {
        if (decl.isLate() && !decl.isVariable()) {
            this.out("if(", privname, "!==undefined)throw ", this.getClAlias(), "InitializationError('Attempt to reassign immutable attribute \\u00ab", pubname, "\\u00bb');");
        }
    }

    @Override
    public void visit(Tree.CharLiteral that) {
        this.out(this.getClAlias(), "Character(");
        this.out(String.valueOf(that.getText().codePointAt(1)), new String[0]);
        this.out(",true)", new String[0]);
    }

    @Override
    public void visit(Tree.StringLiteral that) {
        this.out("\"", JsUtils.escapeStringLiteral(that.getText()), "\"");
    }

    @Override
    public void visit(Tree.StringTemplate that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        List<Tree.StringLiteral> literals = that.getStringLiterals();
        List<Tree.Expression> exprs = that.getExpressions();
        for (int i = 0; i < literals.size(); ++i) {
            boolean skip;
            Tree.StringLiteral literal = literals.get(i);
            boolean bl = skip = (i == 0 || i == literals.size() - 1) && literal.getText().isEmpty();
            if (i > 0 && !skip) {
                this.out("+", new String[0]);
            }
            if (!skip) {
                literal.visit(this);
            }
            if (i >= exprs.size()) continue;
            if (!skip) {
                this.out("+(", new String[0]);
            }
            Tree.Expression expr = exprs.get(i);
            Type t = expr.getTypeModel();
            expr.visit(this);
            if (t == null || t.isUnknown()) {
                this.out(".toString()", new String[0]);
            } else if (!t.isString()) {
                this.out(".string", new String[0]);
            }
            if (skip) continue;
            this.out(")", new String[0]);
        }
    }

    @Override
    public void visit(Tree.FloatLiteral that) {
        String f = that.getText();
        int dot = f.indexOf(46);
        boolean wrap = true;
        double parsed = Double.parseDouble(f);
        if (parsed == 0.0 && !f.equals("0.0")) {
            that.addUsageWarning(Warning.zeroFloatLiteral, "literal so small it is indistinguishable from zero: '" + f + "' (use 0.0)");
        }
        if (f.indexOf(69, dot) < 0 && f.indexOf(101, dot) < 0) {
            for (int i = dot + 1; i < f.length(); ++i) {
                if (f.charAt(i) == '0') continue;
                wrap = false;
                break;
            }
        }
        if (wrap) {
            this.out(this.getClAlias(), "Float");
        }
        this.out("(", f, ")");
    }

    long parseNaturalLiteral(Tree.NaturalLiteral that, boolean neg) throws NumberFormatException {
        String nt = that.getText();
        char prefix = nt.charAt(0);
        int radix = 10;
        if (prefix == '$' || prefix == '#') {
            radix = prefix == '$' ? 2 : 16;
            nt = nt.substring(1);
        }
        BigInteger lit = new BigInteger(nt, radix);
        if (neg) {
            lit = lit.negate();
        }
        if (radix == 10) {
            if (lit.compareTo(maxLong) > 0 || lit.compareTo(minLong) < 0) {
                that.addError("literal outside representable range: " + lit + " is too large to be represented as an Integer", Backend.JavaScript);
                return 0L;
            }
        } else {
            if ((neg ? lit.negate() : lit).compareTo(maxUnsignedLong) == 0) {
                return neg ? 1L : -1L;
            }
            if ((neg ? lit.negate() : lit).compareTo(maxUnsignedLong) > 0) {
                that.addError("invalid hexadecimal literal: '" + (radix == 2 ? "$" : "#") + nt + "' has more than 64 bits", Backend.JavaScript);
                return 0L;
            }
        }
        return lit.longValue();
    }

    @Override
    public void visit(Tree.NaturalLiteral that) {
        try {
            this.out("(", Long.toString(this.parseNaturalLiteral(that, false)), ")");
        }
        catch (NumberFormatException ex) {
            that.addError("Invalid numeric literal " + that.getText(), Backend.JavaScript);
        }
    }

    @Override
    public void visit(Tree.This that) {
        this.out(this.names.self(ModelUtil.getContainingClassOrInterface(that.getScope())), new String[0]);
    }

    @Override
    public void visit(Tree.Super that) {
        this.out(this.names.self(ModelUtil.getContainingClassOrInterface(that.getScope())), new String[0]);
    }

    @Override
    public void visit(Tree.Outer that) {
        boolean outer = false;
        if (this.opts.isOptimize()) {
            Scope scope;
            for (scope = that.getScope(); scope != null && !(scope instanceof TypeDeclaration); scope = scope.getContainer()) {
            }
            if (scope != null && ((TypeDeclaration)scope).isClassOrInterfaceMember()) {
                this.out(this.names.self((TypeDeclaration)scope), ".");
                outer = true;
            }
        }
        if (outer) {
            this.out("outer$", new String[0]);
        } else {
            this.out(this.names.self(that.getTypeModel().getDeclaration()), new String[0]);
        }
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        BmeGenerator.generateBme(that, this);
    }

    boolean accessDirectly(Declaration d) {
        return this.directAccess.contains(d) || !this.accessThroughGetter(d) || d.isParameter();
    }

    private boolean accessThroughGetter(Declaration d) {
        return d instanceof FunctionOrValue && !(d instanceof Function) && !AttributeGenerator.defineAsProperty(d) && !d.isDynamic();
    }

    void supervisit(Tree.QualifiedMemberOrTypeExpression that) {
        super.visit(that);
    }

    @Override
    public void visit(final Tree.QualifiedMemberExpression that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        Declaration d = that.getDeclaration();
        if (that.getMemberOperator() instanceof Tree.SafeMemberOp) {
            Operators.generateSafeOp(that, this);
        } else if (that.getMemberOperator() instanceof Tree.SpreadOp) {
            SequenceGenerator.generateSpread(that, this);
        } else if (d instanceof Function && that.getSignature() == null) {
            FunctionHelper.generateCallable(that, null, this);
        } else if (that.getStaticMethodReference() && d != null) {
            if (d instanceof Value && ((Value)d).getTypeDeclaration() instanceof Constructor) {
                Constructor cnst = (Constructor)((Value)d).getTypeDeclaration();
                if (cnst.getTypescriptEnum() != null && cnst.getTypescriptEnum().matches("[0-9.-]+")) {
                    this.out(cnst.getTypescriptEnum(), new String[0]);
                } else {
                    boolean wrap = false;
                    if (that.getPrimary() instanceof Tree.QualifiedMemberOrTypeExpression) {
                        Tree.QualifiedMemberOrTypeExpression prim = (Tree.QualifiedMemberOrTypeExpression)that.getPrimary();
                        if (prim.getStaticMethodReference()) {
                            wrap = true;
                            this.out("function(_$){return _$", new String[0]);
                        } else {
                            prim.getPrimary().visit(this);
                        }
                        this.out(".", new String[0]);
                    } else if (d.getContainer() instanceof Declaration) {
                        this.qualify(that.getPrimary(), (Declaration)((Object)d.getContainer()));
                    } else if (d.getContainer() instanceof Package) {
                        this.out(this.names.moduleAlias(((Package)d.getContainer()).getModule()), new String[0]);
                    }
                    if (cnst.getTypescriptEnum() != null) {
                        this.out(this.names.name((TypeDeclaration)d.getContainer()), ".", cnst.getTypescriptEnum());
                    } else {
                        this.out(this.names.name((TypeDeclaration)d.getContainer()), this.names.constructorSeparator(d), this.names.name(d), "()");
                    }
                    if (wrap) {
                        this.out(";}", new String[0]);
                    }
                }
            } else if (d instanceof Function) {
                Function fd = (Function)d;
                if (fd.getTypeDeclaration() instanceof Constructor) {
                    that.getPrimary().visit(this);
                    this.out(this.names.constructorSeparator(fd), this.names.name(fd));
                } else if (fd.isStatic()) {
                    BmeGenerator.generateStaticReference(that, fd, this);
                } else {
                    this.out("function($O$){return ", new String[0]);
                    if (BmeGenerator.hasTypeParameters(that)) {
                        BmeGenerator.printGenericMethodReference(this, that, "$O$", "$O$." + this.names.name(d));
                    } else {
                        this.out(this.getClAlias(), "jsc$3($O$,$O$.", this.names.name(d), ")");
                    }
                    this.out(";}", new String[0]);
                }
            } else if (d.isStatic()) {
                BmeGenerator.generateStaticReference(that, d, this);
            } else {
                this.out("function($O$){return $O$.", this.names.name(d), ";}");
            }
        } else {
            final boolean isDynamic = that.getPrimary() instanceof Tree.Dynamic;
            String lhs = this.generateToString(new GenerateCallback(){

                @Override
                public void generateValue() {
                    if (isDynamic) {
                        GenerateJsVisitor.this.out("(", new String[0]);
                    }
                    GenerateJsVisitor.super.visit(that);
                    if (isDynamic) {
                        GenerateJsVisitor.this.out(")", new String[0]);
                    }
                }
            });
            if (d != null && d.isStatic()) {
                BmeGenerator.generateStaticReference(that, d, this);
            } else {
                this.out(this.memberAccess(that, lhs), new String[0]);
            }
        }
    }

    Scope getSuperMemberScope(Node node) {
        Tree.QualifiedType qtype;
        Scope scope = null;
        if (node instanceof Tree.QualifiedMemberOrTypeExpression) {
            Tree.QualifiedMemberOrTypeExpression qmte = (Tree.QualifiedMemberOrTypeExpression)node;
            Tree.Term primary = TreeUtil.eliminateParensAndWidening(qmte.getPrimary());
            if (primary instanceof Tree.Super) {
                scope = qmte.getDeclaration().getContainer();
            }
        } else if (node instanceof Tree.QualifiedType && (qtype = (Tree.QualifiedType)node).getOuterType() instanceof Tree.SuperType) {
            scope = qtype.getDeclarationModel().getContainer();
        }
        return scope;
    }

    String getMember(Node node, String lhs) {
        StringBuilder sb = new StringBuilder();
        if (lhs != null) {
            if (lhs.length() > 0) {
                sb.append(lhs);
            }
        } else if (node instanceof Tree.BaseMemberOrTypeExpression) {
            Tree.BaseMemberOrTypeExpression bmte = (Tree.BaseMemberOrTypeExpression)node;
            Declaration bmd = bmte.getDeclaration();
            if (bmd.isParameter() && bmd.getContainer() instanceof ClassAlias) {
                return this.names.name(bmd);
            }
            String path = this.qualifiedPath(node, bmd);
            if (path.length() > 0) {
                sb.append(path);
            }
        }
        return sb.toString();
    }

    String memberAccessBase(Node node, Declaration decl, boolean setter, String lhs) {
        String member;
        StringBuilder sb = new StringBuilder(this.getMember(node, lhs));
        boolean isConstructor = decl instanceof Constructor;
        if (sb.length() > 0) {
            Declaration bmd;
            if (node instanceof Tree.BaseMemberOrTypeExpression && (bmd = ((Tree.BaseMemberOrTypeExpression)node).getDeclaration()).isParameter() && bmd.getContainer() instanceof ClassAlias) {
                return sb.toString();
            }
            sb.append(isConstructor ? this.names.constructorSeparator(decl) : ".");
        }
        boolean metaGetter = false;
        Scope scope = this.getSuperMemberScope(node);
        if (this.opts.isOptimize() && scope != null && !isConstructor) {
            sb.append("getT$all()['").append(scope.getQualifiedNameString()).append("']");
            if (AttributeGenerator.defineAsProperty(decl)) {
                return this.getClAlias() + (setter ? "attrSetter(" : "attrGetter(") + sb.toString() + ",'" + this.names.name(decl) + "')";
            }
            sb.append(".$$.prototype.");
            metaGetter = true;
        }
        String string = this.accessThroughGetter(decl) && !this.accessDirectly(decl) ? (setter ? this.names.setter(decl) : this.names.getter(decl, metaGetter)) : (member = this.names.name(decl));
        if (!isConstructor && TypeUtils.isConstructor(decl)) {
            sb.append(this.names.name((Declaration)((Object)decl.getContainer()))).append(this.names.constructorSeparator(decl));
        }
        sb.append(member);
        if (!this.opts.isOptimize() && scope != null) {
            sb.append(this.names.scopeSuffix(scope));
        }
        return sb.toString();
    }

    String memberAccess(Tree.StaticMemberOrTypeExpression expr, String lhs) {
        boolean protoCall;
        Declaration decl = expr.getDeclaration();
        String plainName = null;
        if (decl == null && this.isInDynamicBlock()) {
            plainName = expr.getIdentifier().getText();
        } else if (TypeUtils.isNativeJs(decl)) {
            if (decl == null) {
                expr.addUnexpectedError("Expression with no declaration outside of dynamic block");
                return "(throw new TypeError('<NULL>'))";
            }
            plainName = decl.getName();
        }
        if (plainName != null) {
            return lhs != null && lhs.length() > 0 ? lhs + "." + plainName : plainName;
        }
        boolean bl = protoCall = this.opts.isOptimize() && this.getSuperMemberScope(expr) != null;
        if (!(!this.accessDirectly(decl) || protoCall && AttributeGenerator.defineAsProperty(decl))) {
            return this.memberAccessBase(expr, decl, false, lhs);
        }
        return this.memberAccessBase(expr, decl, false, lhs) + (protoCall ? ".call(this)" : "()");
    }

    @Override
    public void visit(Tree.BaseTypeExpression that) {
        BmeGenerator.generateBte(that, this, false);
    }

    @Override
    public void visit(Tree.QualifiedTypeExpression that) {
        BmeGenerator.generateQte(that, this);
    }

    @Override
    public void visit(Tree.Dynamic that) {
        if (that.getNamedArgumentList() == null) {
            this.out("[]", new String[0]);
        } else if (that.getNamedArgumentList().getSequencedArgument() == null && that.getNamedArgumentList().getNamedArguments().isEmpty()) {
            this.out("{}", new String[0]);
        } else {
            this.invoker.nativeObject(that.getNamedArgumentList());
        }
    }

    @Override
    public void visit(Tree.InvocationExpression that) {
        this.invoker.generateInvocation(that);
    }

    @Override
    public void visit(Tree.PositionalArgumentList that) {
        this.invoker.generatePositionalArguments(null, that, that.getPositionalArguments(), false, false);
    }

    void box(Tree.Term term) {
        int t = this.boxStart(term);
        term.visit(this);
        if (t == 4) {
            Type ct = term.getTypeModel();
            this.out(",", new String[0]);
            TypeUtils.encodeCallableArgumentsAsParameterListForRuntime(term, ct, this);
            this.out(",", new String[0]);
            TypeUtils.printTypeArguments(term, ct.getTypeArguments(), this, true, null);
        }
        this.boxUnboxEnd(t);
    }

    int boxStart(Tree.Term fromTerm) {
        return this.boxUnboxStart(fromTerm, false);
    }

    int boxUnboxStart(Tree.Term fromTerm, Tree.Term toTerm) {
        return this.boxUnboxStart(fromTerm, TypeUtils.isNativeJs(toTerm));
    }

    int boxUnboxStart(Tree.Term fromTerm, TypedDeclaration toDecl) {
        return this.boxUnboxStart(fromTerm, TypeUtils.isNativeJs(toDecl));
    }

    int boxUnboxStart(Tree.Term fromTerm, boolean toNative) {
        boolean fromNative = TypeUtils.isNativeJs(fromTerm);
        Type fromType = fromTerm.getTypeModel();
        if (fromNative != toNative || fromType != null && fromType.isCallable()) {
            if (fromNative) {
                if (fromType.isInteger() || fromType.isFloat()) {
                    this.out("(", new String[0]);
                } else if (fromType.isBoolean()) {
                    this.out("(", new String[0]);
                } else if (fromType.isCharacter()) {
                    this.out(this.getClAlias(), "Character(");
                } else {
                    if (fromType.isCallable()) {
                        this.out(this.getClAlias(), "jsc$2(");
                        return 4;
                    }
                    return 0;
                }
                return 1;
            }
            if (fromType.isFloat()) {
                return toNative ? 2 : 1;
            }
            if (fromType.isCallable()) {
                Declaration d;
                Tree.Term _t = fromTerm;
                if (_t instanceof Tree.InvocationExpression) {
                    _t = ((Tree.InvocationExpression)_t).getPrimary();
                }
                if (_t instanceof Tree.MemberOrTypeExpression && (d = ((Tree.MemberOrTypeExpression)_t).getDeclaration()) != null && !d.isClassOrInterfaceMember() && !d.isAnonymous()) {
                    return 0;
                }
                this.out(this.getClAlias(), "jsc$2(");
                return 4;
            }
            return 3;
        }
        return 0;
    }

    void boxUnboxEnd(int boxType) {
        switch (boxType) {
            case 1: {
                this.out(")", new String[0]);
                break;
            }
            case 2: {
                this.out(".valueOf(/*UNFLOAT*/)", new String[0]);
                break;
            }
            case 4: {
                this.out(")", new String[0]);
                break;
            }
        }
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        FunctionHelper.objectArgument(that, this);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        FunctionHelper.attributeArgument(that, this);
    }

    @Override
    public void visit(Tree.SequencedArgument that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        SequenceGenerator.sequencedArgument(that, this);
    }

    @Override
    public void visit(Tree.SequenceEnumeration that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        SequenceGenerator.sequenceEnumeration(that, this);
    }

    @Override
    public void visit(Tree.Comprehension that) {
        new ComprehensionGenerator(this, this.names, this.directAccess).generateComprehension(that);
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        if (!(this.opts.isOptimize() && that.getSpecifierExpression() instanceof Tree.LazySpecifierExpression && that.getScope().getContainer() instanceof TypeDeclaration)) {
            this.specifierStatement(null, that);
        }
    }

    private void assignment(TypeDeclaration outer, Declaration d, Tree.Expression expr) {
        FunctionOrValue vdec = (FunctionOrValue)d;
        String atname = this.names.valueName(vdec);
        if (outer instanceof Constructor) {
            if (d.isClassOrInterfaceMember()) {
                this.out(this.names.self(outer), ".", atname, "=");
            } else {
                this.out(this.names.name(d), "=");
            }
            expr.visit(this);
            this.endLine(true);
        }
        if (d.isClassOrInterfaceMember()) {
            this.defineAttribute(this.names.self(outer), this.names.name(d));
            this.out("{", new String[0]);
            if (vdec.isLate()) {
                this.generateUnitializedAttributeReadCheck("this." + atname, this.names.name(d), null);
            }
            this.out("return this.", atname, ";}");
            if (vdec.isVariable() || vdec.isLate()) {
                String par = this.getNames().createTempVariable();
                this.out(",function(", par, "){");
                this.generateImmutableAttributeReassignmentCheck(vdec, "this." + atname, this.names.name(d));
                this.out("return this.", atname, "=", par, ";}");
            } else {
                this.out(",undefined", new String[0]);
            }
            this.out(",", new String[0]);
            TypeUtils.encodeForRuntime(expr, d, this);
            this.out(")", new String[0]);
            this.endLine(true);
        }
    }

    private void specifierStatement(TypeDeclaration outer, final Tree.SpecifierStatement specStmt) {
        Tree.ParameterizedExpression paramExpr;
        Tree.StaticMemberOrTypeExpression smte;
        final Tree.Expression expr = specStmt.getSpecifierExpression().getExpression();
        Tree.Term term = specStmt.getBaseMemberExpression();
        Tree.StaticMemberOrTypeExpression staticMemberOrTypeExpression = smte = term instanceof Tree.StaticMemberOrTypeExpression ? (Tree.StaticMemberOrTypeExpression)term : null;
        if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(term.getTypeModel())) {
            if (smte != null && smte.getDeclaration() == null) {
                this.out(smte.getIdentifier().getText(), new String[0]);
            } else {
                Value v;
                term.visit(this);
                if (term instanceof Tree.BaseMemberExpression && ((Tree.BaseMemberExpression)term).getDeclaration() instanceof Value && (v = (Value)((Tree.BaseMemberExpression)term).getDeclaration()).isMember()) {
                    this.out("_", new String[0]);
                }
            }
            this.out("=", new String[0]);
            int box = this.boxUnboxStart((Tree.Term)expr, term);
            expr.visit(this);
            if (box == 4) {
                this.out("/*TODO: callable targs 6.1*/", new String[0]);
            }
            this.boxUnboxEnd(box);
            this.out(";", new String[0]);
            return;
        }
        if (smte != null) {
            Declaration bmeDecl = smte.getDeclaration();
            if (specStmt.getSpecifierExpression() instanceof Tree.LazySpecifierExpression) {
                boolean property = AttributeGenerator.defineAsProperty(bmeDecl);
                if (property) {
                    this.defineAttribute(this.qualifiedPath(specStmt, bmeDecl), this.names.name(bmeDecl));
                } else {
                    if (bmeDecl.isMember()) {
                        this.qualify(specStmt, bmeDecl);
                    } else {
                        this.out("var ", new String[0]);
                    }
                    this.out(this.names.getter(bmeDecl, false), "=function()");
                }
                this.beginBlock();
                if (outer != null) {
                    this.initSelf(specStmt);
                }
                this.out("return ", new String[0]);
                if (!this.isNaturalLiteral(specStmt.getSpecifierExpression().getExpression().getTerm())) {
                    specStmt.getSpecifierExpression().visit(this);
                }
                this.out(";", new String[0]);
                this.endBlock();
                if (property) {
                    this.out(",undefined,", new String[0]);
                    TypeUtils.encodeForRuntime(specStmt, bmeDecl, this);
                    this.out(")", new String[0]);
                }
                this.endLine(true);
                this.directAccess.remove(bmeDecl);
            } else if (outer != null) {
                if (outer instanceof Constructor || bmeDecl.isMember() && bmeDecl instanceof Value && bmeDecl.isActual()) {
                    this.assignment(outer, bmeDecl, expr);
                }
            } else if (bmeDecl instanceof FunctionOrValue) {
                final FunctionOrValue moval = (FunctionOrValue)bmeDecl;
                if (moval.isVariable() || moval.isLate()) {
                    BmeGenerator.generateMemberAccess(smte, new GenerateCallback(){

                        @Override
                        public void generateValue() {
                            int boxType = GenerateJsVisitor.this.boxUnboxStart(expr.getTerm(), moval);
                            if (GenerateJsVisitor.this.isInDynamicBlock() && !ModelUtil.isTypeUnknown(moval.getType()) && ModelUtil.isTypeUnknown(expr.getTypeModel())) {
                                TypeUtils.generateDynamicCheck(expr, moval.getType(), GenerateJsVisitor.this, false, expr.getTypeModel().getTypeArguments());
                            } else {
                                expr.visit(GenerateJsVisitor.this);
                            }
                            if (boxType == 4) {
                                GenerateJsVisitor.this.out(",", new String[0]);
                                if (moval instanceof Function) {
                                    TypeUtils.encodeParameterListForRuntime(true, specStmt, ((Function)moval).getFirstParameterList(), GenerateJsVisitor.this);
                                    GenerateJsVisitor.this.out(",", new String[0]);
                                } else {
                                    Type ps = moval.getUnit().getCallableTuple(moval.getType());
                                    if (ps == null || ps.isSubtypeOf(moval.getUnit().getEmptyType())) {
                                        GenerateJsVisitor.this.out("[],", new String[0]);
                                    } else {
                                        GenerateJsVisitor.this.out("[/*VALUE Callable params ", ps.asString() + "*/],");
                                    }
                                }
                                TypeUtils.printTypeArguments(expr, expr.getTypeModel().getTypeArguments(), GenerateJsVisitor.this, false, expr.getTypeModel().getVarianceOverrides());
                            }
                            GenerateJsVisitor.this.boxUnboxEnd(boxType);
                        }
                    }, this.qualifiedPath(smte, moval), this);
                    this.out(";", new String[0]);
                } else if (moval.isMember()) {
                    if (moval instanceof Function) {
                        this.qualify(specStmt, bmeDecl);
                        if (expr.getTerm() instanceof Tree.FunctionArgument) {
                            ((Tree.FunctionArgument)expr.getTerm()).getDeclarationModel().setRefinedDeclaration(moval);
                            this.out(this.names.name(moval), "=");
                            specStmt.getSpecifierExpression().visit(this);
                            this.out(";", new String[0]);
                        } else {
                            this.out(this.names.name(moval), "=function ", this.names.name(moval), "(");
                            StringBuilder paramNames = new StringBuilder();
                            List<Parameter> params = ((Function)moval).getFirstParameterList().getParameters();
                            for (Parameter p : params) {
                                if (paramNames.length() > 0) {
                                    paramNames.append(",");
                                }
                                paramNames.append(this.names.name(p));
                            }
                            this.out(paramNames.toString(), new String[0]);
                            this.out("){", new String[0]);
                            for (Parameter p : params) {
                                if (!p.isDefaulted()) continue;
                                this.out("if(", this.names.name(p), "===undefined)", this.names.name(p), "=");
                                this.qualify(specStmt, moval);
                                this.out(this.names.name(moval), "$defs$", p.getName(), "(", paramNames.toString(), ")");
                                this.endLine(true);
                            }
                            this.out("return ", new String[0]);
                            if (!this.isNaturalLiteral(specStmt.getSpecifierExpression().getExpression().getTerm())) {
                                specStmt.getSpecifierExpression().visit(this);
                            }
                            this.out("(", paramNames.toString(), ");}");
                            this.endLine(true);
                        }
                    } else if (this.opts.isOptimize()) {
                        this.out(this.names.self(ModelUtil.getContainingClassOrInterface(moval.getScope())), ".", this.names.valueName(moval), "=");
                        specStmt.getSpecifierExpression().visit(this);
                        this.endLine(true);
                    } else {
                        AttributeGenerator.generateAttributeGetter(null, moval, specStmt.getSpecifierExpression(), null, this, this.directAccess, this.verboseStitcher);
                    }
                } else {
                    if (this.opts.isOptimize() || bmeDecl.isMember() && bmeDecl instanceof Function) {
                        this.qualify(specStmt, bmeDecl);
                    }
                    this.out(this.names.name(bmeDecl), "=");
                    if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(expr.getTypeModel()) && !ModelUtil.isTypeUnknown(((FunctionOrValue)bmeDecl).getType())) {
                        TypeUtils.generateDynamicCheck(expr, ((FunctionOrValue)bmeDecl).getType(), this, false, expr.getTypeModel().getTypeArguments());
                    } else {
                        if (expr.getTerm() instanceof Tree.FunctionArgument && ((Tree.FunctionArgument)expr.getTerm()).getDeclarationModel().isAnonymous()) {
                            ((Tree.FunctionArgument)expr.getTerm()).getDeclarationModel().setRefinedDeclaration(moval);
                        }
                        specStmt.getSpecifierExpression().visit(this);
                    }
                    this.out(";", new String[0]);
                }
            }
        } else if (term instanceof Tree.ParameterizedExpression && specStmt.getSpecifierExpression() != null && (paramExpr = (Tree.ParameterizedExpression)term).getPrimary() instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme2 = (Tree.BaseMemberExpression)paramExpr.getPrimary();
            Declaration bmeDecl = bme2.getDeclaration();
            if (bmeDecl.isMember()) {
                this.qualify(specStmt, bmeDecl);
            } else {
                this.out("var ", new String[0]);
            }
            this.out(this.names.name(bmeDecl), "=");
            FunctionHelper.singleExprFunction(paramExpr.getParameterLists(), expr, bmeDecl instanceof Scope ? (Scope)((Object)bmeDecl) : null, true, true, this);
            this.out(";", new String[0]);
        }
    }

    private void addSpecifierToPrototype(TypeDeclaration outer, Tree.SpecifierStatement specStmt) {
        this.specifierStatement(outer, specStmt);
    }

    @Override
    public void visit(final Tree.AssignOp that) {
        boolean leftDynamic;
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        String returnValue = null;
        Tree.StaticMemberOrTypeExpression lhsExpr = null;
        boolean bl = leftDynamic = this.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel());
        if (that.getLeftTerm() instanceof Tree.IndexExpression) {
            Tree.IndexExpression iex = (Tree.IndexExpression)that.getLeftTerm();
            if (leftDynamic) {
                iex.getPrimary().visit(this);
                this.out("[", new String[0]);
                ((Tree.Element)iex.getElementOrRange()).getExpression().visit(this);
                this.out("]=", new String[0]);
                that.getRightTerm().visit(this);
            } else {
                String tv = this.createRetainedTempVar();
                this.out("(", tv, "=");
                that.getRightTerm().visit(this);
                this.out(",", new String[0]);
                iex.getPrimary().visit(this);
                TypeDeclaration td = iex.getPrimary().getTypeModel().getDeclaration();
                if (td != null && td.inherits(iex.getUnit().getKeyedCorrespondenceMutatorDeclaration())) {
                    this.out(".put(", new String[0]);
                } else {
                    this.out(".set(", new String[0]);
                }
                ((Tree.Element)iex.getElementOrRange()).getExpression().visit(this);
                this.out(",", tv, "), ", tv, ")");
            }
            return;
        }
        if (leftDynamic) {
            that.getLeftTerm().visit(this);
            this.out("=", new String[0]);
            int box = this.boxUnboxStart(that.getRightTerm(), that.getLeftTerm());
            that.getRightTerm().visit(this);
            if (box == 4) {
                this.out("/*TODO: callable targs 6.2*/", new String[0]);
            }
            this.boxUnboxEnd(box);
            return;
        }
        this.out("(", new String[0]);
        if (that.getLeftTerm() instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme;
            lhsExpr = bme = (Tree.BaseMemberExpression)that.getLeftTerm();
            Declaration bmeDecl = bme.getDeclaration();
            boolean simpleSetter = this.hasSimpleGetterSetter(bmeDecl);
            if (!simpleSetter) {
                returnValue = this.memberAccess(bme, null);
            }
        } else if (that.getLeftTerm() instanceof Tree.QualifiedMemberExpression) {
            Tree.QualifiedMemberExpression qme = (Tree.QualifiedMemberExpression)that.getLeftTerm();
            lhsExpr = qme;
            boolean simpleSetter = this.hasSimpleGetterSetter(qme.getDeclaration());
            String lhsVar = null;
            if (!simpleSetter) {
                lhsVar = this.createRetainedTempVar();
                this.out(lhsVar, "=");
                super.visit(qme);
                this.out(",", lhsVar, ".");
                returnValue = this.memberAccess(qme, lhsVar);
            } else if (!(qme.getPrimary() instanceof Tree.Package)) {
                super.visit(qme);
                this.out(".", new String[0]);
                if (qme.getDeclaration() != null && qme.getDeclaration().isStatic()) {
                    this.out("$st$.", new String[0]);
                }
            }
        }
        BmeGenerator.generateMemberAccess(lhsExpr, new GenerateCallback(){

            @Override
            public void generateValue() {
                if (!GenerateJsVisitor.this.isNaturalLiteral(that.getRightTerm())) {
                    int boxType = GenerateJsVisitor.this.boxUnboxStart(that.getRightTerm(), that.getLeftTerm());
                    that.getRightTerm().visit(GenerateJsVisitor.this);
                    if (boxType == 4) {
                        GenerateJsVisitor.this.out("/*TODO: callable targs 7*/", new String[0]);
                    }
                    GenerateJsVisitor.this.boxUnboxEnd(boxType);
                }
            }
        }, null, this);
        if (returnValue != null) {
            this.out(",", returnValue);
        }
        this.out(")", new String[0]);
    }

    public boolean qualify(Node that, Declaration d) {
        String path = this.qualifiedPath(that, d);
        if (path.length() > 0) {
            this.out(path, d instanceof Constructor ? this.names.constructorSeparator(d) : ".");
        }
        return path.length() > 0;
    }

    String qualifiedPath(Node that, Declaration d) {
        return this.qualifiedPath(that, d, false);
    }

    public String qualifiedPath(Node that, Declaration d, boolean inProto) {
        if (d instanceof Constructor) {
            Class c = (Class)d.getContainer();
            String rval = this.qualifiedPath(that, c, inProto);
            return rval.isEmpty() ? this.names.name(c) : rval + "." + this.names.name(c);
        }
        boolean isMember = d.isClassOrInterfaceMember();
        boolean imported = this.isImported(that == null ? null : that.getUnit().getPackage(), d);
        if (!isMember && imported) {
            return this.names.moduleAlias(d.getUnit().getPackage().getModule());
        }
        if (this.opts.isOptimize() && !inProto) {
            if (isMember && (!d.isParameter() || d.isCaptured())) {
                Scope scope;
                TypeDeclaration id = that.getScope().getInheritingDeclaration(d);
                TypeDeclaration nd = null;
                if (id == null && (id = (TypeDeclaration)d.getContainer()).isNativeHeader()) {
                    nd = (TypeDeclaration)ModelUtil.getNativeDeclaration((Declaration)id, Backend.JavaScript);
                }
                if ((scope = ModelUtil.getRealScope(that.getScope())) instanceof Value && !(ModelUtil.getRealScope(scope) instanceof ClassOrInterface)) {
                    scope = ModelUtil.getRealScope(scope.getContainer());
                }
                if (scope != null && (that instanceof Tree.ClassDeclaration || that instanceof Tree.InterfaceDeclaration || that instanceof Tree.Constructor)) {
                    scope = scope.getContainer();
                }
                StringBuilder path = new StringBuilder();
                Declaration innermostDeclaration = ModelUtil.getContainingDeclarationOfScope(scope);
                while (scope != null) {
                    if (scope instanceof Constructor && scope == innermostDeclaration) {
                        TypeDeclaration consCont = (TypeDeclaration)scope.getContainer();
                        if (that instanceof Tree.BaseTypeExpression) {
                            path.append(this.names.name(consCont));
                        } else if (d.isStatic()) {
                            path.append(this.names.name(consCont)).append(".$st$");
                        } else {
                            path.append(this.names.self(consCont));
                        }
                        if (scope == id || nd != null && scope == nd) break;
                        scope = consCont;
                    } else if (scope instanceof TypeDeclaration) {
                        if (path.length() > 0) {
                            if (!(scope instanceof Constructor)) {
                                Constructor constr;
                                Constructor constructor = constr = scope instanceof Class ? ((Class)scope).getDefaultConstructor() : null;
                                if (!(constr != null && ModelUtil.contains(constr, (Scope)((Object)innermostDeclaration)) || d.isStatic())) {
                                    path.append(".outer$");
                                }
                            }
                        } else if (d instanceof Constructor && ModelUtil.getContainingDeclaration(d) == scope) {
                            if (!d.getName().equals(((TypeDeclaration)scope).getName())) {
                                if (path.length() > 0) {
                                    path.append('.');
                                }
                                path.append(this.names.name((TypeDeclaration)scope));
                            }
                        } else {
                            if (path.length() > 0) {
                                path.append('.');
                            }
                            if (d.isStatic()) {
                                if (d instanceof TypedDeclaration) {
                                    TypedDeclaration orig = ((TypedDeclaration)d).getOriginalDeclaration();
                                    path.append(this.names.name((ClassOrInterface)(orig == null ? d : orig).getContainer())).append(".$st$");
                                } else if (d instanceof TypeDeclaration) {
                                    path.append(this.names.name((ClassOrInterface)d.getContainer())).append(".$st$");
                                }
                            } else {
                                path.append(this.names.self((TypeDeclaration)scope));
                            }
                        }
                    } else {
                        path.setLength(0);
                    }
                    if (scope == id || nd != null && scope == nd) break;
                    scope = scope.getContainer();
                }
                if (id != null && path.length() == 0 && !ModelUtil.contains(id, that.getScope())) {
                    if (imported) {
                        path.append(this.names.moduleAlias(id.getUnit().getPackage().getModule())).append('.');
                    }
                    path.append(id.isAnonymous() ? this.names.objectName(id) : this.names.name(id));
                }
                return path.toString();
            }
        } else if (d != null && isMember && (d.isShared() || inProto || !d.isParameter() && AttributeGenerator.defineAsProperty(d))) {
            TypeDeclaration id;
            TypeDeclaration typeDeclaration = id = d instanceof TypeAlias ? (TypeDeclaration)d : that.getScope().getInheritingDeclaration(d);
            if (id == null) {
                id = (TypeDeclaration)d.getContainer();
                if (id.isToplevel() && !ModelUtil.contains(id, that.getScope())) {
                    StringBuilder sb = new StringBuilder();
                    if (imported) {
                        sb.append(this.names.moduleAlias(id.getUnit().getPackage().getModule())).append('.');
                    }
                    sb.append(id.isAnonymous() ? this.names.objectName(id) : this.names.name(id));
                    return sb.toString();
                }
                if (d instanceof Constructor) {
                    return this.names.name(id);
                }
                return this.names.self(id);
            }
            return this.names.self(id);
        }
        return "";
    }

    public boolean isImported(Package p2, Declaration d) {
        if (d == null) {
            return false;
        }
        Package p1 = d.getUnit().getPackage();
        if (p2 == null) {
            return p1 != null;
        }
        if (p1.getModule() == null) {
            return p2.getModule() != null && (!p2.getModule().isNative() || p2.getModule().getNativeBackends().supports(Backend.JavaScript));
        }
        return !p1.getModule().equals(p2.getModule());
    }

    @Override
    public void visit(Tree.ExecutableStatement that) {
        super.visit(that);
        this.endLine(true);
    }

    String createRetainedTempVar() {
        String varName = this.names.createTempVariable();
        this.retainedVars.add(varName);
        return varName;
    }

    @Override
    public void visit(Tree.Return that) {
        if (that.getExpression() == null) {
            Declaration contDecl = ModelUtil.getContainingDeclarationOfScope(that.getScope());
            if (contDecl instanceof Class) {
                this.out("return ", this.names.self((Class)contDecl), ";");
            } else {
                this.out("return;", new String[0]);
            }
            this.endLine();
            return;
        }
        this.out("return ", new String[0]);
        Type returnType = that.getExpression().getTypeModel();
        if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(returnType)) {
            Declaration cont = ModelUtil.getContainingDeclarationOfScope(that.getScope());
            Type dectype = cont.getReference().getType();
            if (dectype != null && dectype.isTypeParameter() && !dectype.getSatisfiedTypes().isEmpty()) {
                ArrayList<Type> dyntypes = null;
                for (Type tp : dectype.getSatisfiedTypes()) {
                    if (tp.getDeclaration() == null || !tp.getDeclaration().isDynamic()) continue;
                    if (dyntypes == null) {
                        dyntypes = new ArrayList<Type>(dectype.getSatisfiedTypes().size());
                    }
                    dyntypes.add(tp);
                }
                if (dyntypes != null) {
                    if (dyntypes.size() == 1) {
                        dectype = (Type)dyntypes.get(0);
                    } else {
                        IntersectionType itype = new IntersectionType(that.getUnit());
                        itype.setSatisfiedTypes((List<Type>)dyntypes);
                        dectype = itype.getType();
                    }
                }
            }
            if (!ModelUtil.isTypeUnknown(dectype)) {
                TypeUtils.generateDynamicCheck(that.getExpression(), dectype, this, false, returnType.getTypeArguments());
                this.endLine(true);
                return;
            }
        }
        if (this.isNaturalLiteral(that.getExpression().getTerm())) {
            this.out(";", new String[0]);
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AnnotationList that) {
    }

    boolean outerSelf(Declaration d) {
        ClassOrInterface coi;
        if (d.isToplevel()) {
            this.out("ex$", new String[0]);
            return true;
        }
        if (d.isClassOrInterfaceMember()) {
            this.out(this.names.self((TypeDeclaration)d.getContainer()), new String[0]);
            return true;
        }
        if (d instanceof ClassOrInterface && (coi = ModelUtil.getContainingClassOrInterface(d.getContainer())) != null) {
            this.out(this.names.self(coi), new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public void visit(Tree.SumOp that) {
        if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "plus", "+", null, this);
        } else {
            Type rt;
            Type lt = that.getLeftTerm().getTypeModel();
            if (TypeUtils.intsOrFloats(lt, rt = that.getRightTerm().getTypeModel())) {
                if (lt.isFloat() || rt.isFloat()) {
                    this.out(this.getClAlias(), "Float");
                }
                this.out("(", new String[0]);
                Operators.simpleBinaryOp(that, null, "+", ")", this);
            } else {
                Operators.simpleBinaryOp(that, null, ".plus(", ")", this);
            }
        }
    }

    @Override
    public void visit(Tree.ScaleOp that) {
        String lhs = this.names.createTempVariable();
        Operators.simpleBinaryOp(that, "function(){var " + lhs + "=", ";return ", ".scale(" + lhs + ");}()", this);
    }

    @Override
    public void visit(Tree.DifferenceOp that) {
        if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "minus", "-", null, this);
        } else {
            Type rt;
            Type lt = that.getLeftTerm().getTypeModel();
            if (TypeUtils.intsOrFloats(lt, rt = that.getRightTerm().getTypeModel())) {
                if (lt.isFloat() || rt.isFloat()) {
                    this.out(this.getClAlias(), "Float");
                }
                this.out("(", new String[0]);
                Operators.simpleBinaryOp(that, null, "-", ")", this);
            } else {
                Operators.simpleBinaryOp(that, null, ".minus(", ")", this);
            }
        }
    }

    @Override
    public void visit(Tree.ProductOp that) {
        if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "times", "*", null, this);
        } else {
            Type rt;
            Type lt = that.getLeftTerm().getTypeModel();
            if (TypeUtils.intsOrFloats(lt, rt = that.getRightTerm().getTypeModel())) {
                if (lt.isFloat() || rt.isFloat()) {
                    this.out(this.getClAlias(), "Float");
                }
                this.out("(", new String[0]);
                Operators.simpleBinaryOp(that, null, "*", ")", this);
            } else {
                Operators.simpleBinaryOp(that, null, ".times(", ")", this);
            }
        }
    }

    @Override
    public void visit(Tree.QuotientOp that) {
        Type ltype = that.getLeftTerm().getTypeModel();
        Type rtype = that.getRightTerm().getTypeModel();
        if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(ltype)) {
            Operators.nativeBinaryOp(that, "divided", "/", null, this);
        } else if (TypeUtils.bothInts(ltype, rtype) || TypeUtils.bothFloats(ltype, rtype)) {
            this.out(this.getClAlias(), TypeUtils.bothInts(ltype, rtype) ? "i$div(" : "f$div(");
            Operators.unwrappedNumberOrTerm(that.getLeftTerm(), false, this);
            this.out(",", new String[0]);
            Operators.unwrappedNumberOrTerm(that.getRightTerm(), false, this);
            this.out(")", new String[0]);
        } else {
            Operators.simpleBinaryOp(that, null, ".divided(", ")", this);
        }
    }

    @Override
    public void visit(Tree.RemainderOp that) {
        if (this.isInDynamicBlock() && ModelUtil.isTypeUnknown(that.getLeftTerm().getTypeModel())) {
            Operators.nativeBinaryOp(that, "remainder", "%", null, this);
        } else {
            Operators.simpleBinaryOp(that, null, ".remainder(", ")", this);
        }
    }

    @Override
    public void visit(Tree.PowerOp that) {
        Type left = that.getLeftTerm().getTypeModel();
        Operators.simpleBinaryOp(that, null, left.isFloat() ? ".$fpower(" : ".power(", ")", this);
    }

    @Override
    public void visit(Tree.AddAssignOp that) {
        if (!this.arithmeticAssignOp(that, "+")) {
            this.assignOp(that, "plus", null);
        }
    }

    @Override
    public void visit(Tree.SubtractAssignOp that) {
        if (!this.arithmeticAssignOp(that, "-")) {
            this.assignOp(that, "minus", null);
        }
    }

    @Override
    public void visit(Tree.MultiplyAssignOp that) {
        if (!this.arithmeticAssignOp(that, "*")) {
            this.assignOp(that, "times", null);
        }
    }

    @Override
    public void visit(Tree.DivideAssignOp that) {
        this.assignOp(that, "divided", null);
    }

    @Override
    public void visit(Tree.RemainderAssignOp that) {
        if (!this.arithmeticAssignOp(that, "%")) {
            this.assignOp(that, "remainder", null);
        }
    }

    @Override
    public void visit(Tree.ComplementAssignOp that) {
        this.assignOp(that, "complement", TypeUtils.mapTypeArgument(that, "complement", "Element", "Other"));
    }

    @Override
    public void visit(Tree.UnionAssignOp that) {
        this.assignOp(that, "union", TypeUtils.mapTypeArgument(that, "union", "Element", "Other"));
    }

    @Override
    public void visit(Tree.IntersectAssignOp that) {
        this.assignOp(that, "intersection", TypeUtils.mapTypeArgument(that, "intersection", "Element", "Other"));
    }

    @Override
    public void visit(Tree.AndAssignOp that) {
        this.assignOp(that, "&&", null);
    }

    @Override
    public void visit(Tree.OrAssignOp that) {
        this.assignOp(that, "||", null);
    }

    private boolean arithmeticAssignOp(final Tree.AssignmentOp that, final String operand) {
        boolean oneFloat;
        Tree.Term lhs = that.getLeftTerm();
        Type ltype = lhs.getTypeModel();
        Type rtype = that.getRightTerm().getTypeModel();
        boolean bl = oneFloat = ltype.isFloat() || rtype.isFloat();
        if (TypeUtils.intsOrFloats(ltype, rtype)) {
            if (lhs instanceof Tree.BaseMemberExpression) {
                Tree.BaseMemberExpression lhsBME = (Tree.BaseMemberExpression)lhs;
                Declaration lhsDecl = lhsBME.getDeclaration();
                final String getLHS = this.memberAccess(lhsBME, null);
                this.out("(", new String[0]);
                BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)lhsBME, new GenerateCallback(){

                    @Override
                    public void generateValue() {
                        if (oneFloat) {
                            GenerateJsVisitor.this.out(GenerateJsVisitor.this.getClAlias(), "Float(");
                        }
                        GenerateJsVisitor.this.out(getLHS, operand);
                        if (!GenerateJsVisitor.this.isNaturalLiteral(that.getRightTerm())) {
                            that.getRightTerm().visit(GenerateJsVisitor.this);
                        }
                        if (oneFloat) {
                            GenerateJsVisitor.this.out(")", new String[0]);
                        }
                    }
                }, null, this);
                if (!this.hasSimpleGetterSetter(lhsDecl)) {
                    this.out(",", getLHS);
                }
                this.out(")", new String[0]);
            } else if (lhs instanceof Tree.QualifiedMemberExpression) {
                Tree.QualifiedMemberExpression lhsQME = (Tree.QualifiedMemberExpression)lhs;
                if (TypeUtils.isNativeJs(lhsQME)) {
                    String tmp = this.names.createTempVariable();
                    String dec = this.isInDynamicBlock() && lhsQME.getDeclaration() == null ? lhsQME.getIdentifier().getText() : lhsQME.getDeclaration().getName();
                    this.out("(", tmp, "=");
                    lhsQME.getPrimary().visit(this);
                    this.out(",", tmp, ".", dec, "=");
                    int boxType = this.boxStart(lhsQME);
                    this.out(tmp, ".", dec);
                    if (boxType == 4) {
                        this.out("/*TODO: callable targs 8*/", new String[0]);
                    }
                    this.boxUnboxEnd(boxType);
                    this.out(operand, new String[0]);
                    if (!this.isNaturalLiteral(that.getRightTerm())) {
                        that.getRightTerm().visit(this);
                    }
                    this.out(")", new String[0]);
                } else {
                    String lhsPrimaryVar = this.createRetainedTempVar();
                    final String getLHS = this.memberAccess(lhsQME, lhsPrimaryVar);
                    this.out("(", lhsPrimaryVar, "=");
                    lhsQME.getPrimary().visit(this);
                    this.out(",", new String[0]);
                    BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)lhsQME, new GenerateCallback(){

                        @Override
                        public void generateValue() {
                            GenerateJsVisitor.this.out(getLHS, operand);
                            if (!GenerateJsVisitor.this.isNaturalLiteral(that.getRightTerm())) {
                                that.getRightTerm().visit(GenerateJsVisitor.this);
                            }
                        }
                    }, lhsPrimaryVar, this);
                    if (!this.hasSimpleGetterSetter(lhsQME.getDeclaration())) {
                        this.out(",", getLHS);
                    }
                    this.out(")", new String[0]);
                }
            } else if (lhs instanceof Tree.IndexExpression) {
                lhs.addUnsupportedError("Index expressions are not supported in this kind of assignment.");
            }
            return true;
        }
        return false;
    }

    private void assignOp(final Tree.AssignmentOp that, final String functionName, final Map<TypeParameter, Type> targs) {
        boolean isNative;
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        Tree.Term lhs = that.getLeftTerm();
        boolean bl = isNative = "||".equals(functionName) || "&&".equals(functionName);
        if (lhs instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression lhsBME = (Tree.BaseMemberExpression)lhs;
            Declaration lhsDecl = lhsBME.getDeclaration();
            final String getLHS = this.memberAccess(lhsBME, null);
            this.out("(", new String[0]);
            BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)lhsBME, new GenerateCallback(){

                @Override
                public void generateValue() {
                    if (isNative) {
                        GenerateJsVisitor.this.out(getLHS, functionName);
                    } else {
                        GenerateJsVisitor.this.out(getLHS, ".", functionName, "(");
                    }
                    if (!GenerateJsVisitor.this.isNaturalLiteral(that.getRightTerm())) {
                        that.getRightTerm().visit(GenerateJsVisitor.this);
                    }
                    if (!isNative) {
                        if (targs != null) {
                            GenerateJsVisitor.this.out(",", new String[0]);
                            TypeUtils.printTypeArguments(that, targs, GenerateJsVisitor.this, false, null);
                        }
                        GenerateJsVisitor.this.out(")", new String[0]);
                    }
                }
            }, null, this);
            if (!this.hasSimpleGetterSetter(lhsDecl)) {
                this.out(",", getLHS);
            }
            this.out(")", new String[0]);
        } else if (lhs instanceof Tree.QualifiedMemberExpression) {
            Tree.QualifiedMemberExpression lhsQME = (Tree.QualifiedMemberExpression)lhs;
            if (TypeUtils.isNativeJs(lhsQME)) {
                String tmp = this.names.createTempVariable();
                String dec = this.isInDynamicBlock() && lhsQME.getDeclaration() == null ? lhsQME.getIdentifier().getText() : lhsQME.getDeclaration().getName();
                this.out("(", tmp, "=");
                lhsQME.getPrimary().visit(this);
                this.out(",", tmp, ".", dec, "=");
                int boxType = this.boxStart(lhsQME);
                this.out(tmp, ".", dec);
                if (boxType == 4) {
                    this.out("/*TODO: callable targs 8*/", new String[0]);
                }
                this.boxUnboxEnd(boxType);
                this.out(".", functionName, "(");
                if (!this.isNaturalLiteral(that.getRightTerm())) {
                    that.getRightTerm().visit(this);
                }
                this.out("))", new String[0]);
            } else {
                String lhsPrimaryVar = this.createRetainedTempVar();
                final String getLHS = this.memberAccess(lhsQME, lhsPrimaryVar);
                this.out("(", lhsPrimaryVar, "=");
                lhsQME.getPrimary().visit(this);
                this.out(",", new String[0]);
                BmeGenerator.generateMemberAccess((Tree.StaticMemberOrTypeExpression)lhsQME, new GenerateCallback(){

                    @Override
                    public void generateValue() {
                        GenerateJsVisitor.this.out(getLHS, ".", functionName, "(");
                        if (!GenerateJsVisitor.this.isNaturalLiteral(that.getRightTerm())) {
                            that.getRightTerm().visit(GenerateJsVisitor.this);
                        }
                        GenerateJsVisitor.this.out(")", new String[0]);
                    }
                }, lhsPrimaryVar, this);
                if (!this.hasSimpleGetterSetter(lhsQME.getDeclaration())) {
                    this.out(",", getLHS);
                }
                this.out(")", new String[0]);
            }
        } else if (lhs instanceof Tree.IndexExpression) {
            lhs.addUnsupportedError("Index expressions are not supported in this kind of assignment.");
        }
    }

    @Override
    public void visit(Tree.NegativeOp that) {
        Operators.neg(that, this);
    }

    @Override
    public void visit(Tree.PositiveOp that) {
        Type d = that.getTerm().getTypeModel();
        boolean nat = d.isSubtypeOf(that.getUnit().getIntegerType());
        Operators.unaryOp(that, nat ? "(+" : null, nat ? ")" : null, this);
    }

    @Override
    public void visit(Tree.EqualOp that) {
        Operators.equal(that, this);
    }

    @Override
    public void visit(Tree.NotEqualOp that) {
        Operators.notEqual(that, this);
    }

    @Override
    public void visit(Tree.NotOp that) {
        boolean omitParens;
        Tree.Term t = that.getTerm();
        boolean bl = omitParens = t instanceof Tree.BaseMemberExpression || t instanceof Tree.QualifiedMemberExpression || t instanceof Tree.IsOp || t instanceof Tree.Exists || t instanceof Tree.IdenticalOp || t instanceof Tree.InOp || t instanceof Tree.Nonempty || t instanceof Tree.InvocationExpression && ((Tree.InvocationExpression)t).getNamedArgumentList() == null;
        if (omitParens) {
            Operators.unaryOp(that, "!", null, this);
        } else {
            Operators.unaryOp(that, "(!", ")", this);
        }
    }

    @Override
    public void visit(Tree.IdenticalOp that) {
        Operators.simpleBinaryOp(that, "(", "===", ")", this);
    }

    @Override
    public void visit(Tree.CompareOp that) {
        Operators.simpleBinaryOp(that, null, ".compare(", ")", this);
    }

    boolean canUseNativeComparator(Tree.Term left, Tree.Term right) {
        Type rt;
        if (left == null || right == null || left.getTypeModel() == null || right.getTypeModel() == null) {
            return false;
        }
        Type lt = left.getTypeModel();
        return TypeUtils.bothInts(lt, rt = right.getTypeModel()) || lt.isBoolean() && rt.isBoolean();
    }

    @Override
    public void visit(Tree.SmallerOp that) {
        Operators.smaller(that, this);
    }

    @Override
    public void visit(Tree.LargerOp that) {
        Operators.larger(that, this);
    }

    @Override
    public void visit(Tree.SmallAsOp that) {
        Operators.smallAs(that, this);
    }

    @Override
    public void visit(Tree.LargeAsOp that) {
        Operators.largeAs(that, this);
    }

    @Override
    public void visit(Tree.WithinOp that) {
        Operators.withinOp(that, this);
    }

    @Override
    public void visit(Tree.AndOp that) {
        Operators.simpleBinaryOp(that, "(", "&&", ")", this);
    }

    @Override
    public void visit(Tree.OrOp that) {
        Operators.simpleBinaryOp(that, "(", "||", ")", this);
    }

    @Override
    public void visit(Tree.EntryOp that) {
        this.out(this.getClAlias(), "Entry(");
        Operators.genericBinaryOp(that, ",", that.getTypeModel().getTypeArguments(), that.getTypeModel().getVarianceOverrides(), this);
    }

    @Override
    public void visit(Tree.RangeOp that) {
        Operators.segmentOrRange(that, "span", "Element", this);
    }

    @Override
    public void visit(Tree.SegmentOp that) {
        Operators.segmentOrRange(that, "measure", "Element", this);
    }

    @Override
    public void visit(Tree.ThenOp that) {
        Operators.simpleBinaryOp(that, "(", "?", ":null)", this);
    }

    @Override
    public void visit(Tree.Element that) {
        this.out(".$_get(", new String[0]);
        if (!this.isNaturalLiteral(that.getExpression().getTerm())) {
            that.getExpression().visit(this);
        }
        this.out(")", new String[0]);
    }

    @Override
    public void visit(Tree.DefaultOp that) {
        String lhsVar = this.createRetainedTempVar();
        this.out("(", lhsVar, "=");
        this.box(that.getLeftTerm());
        this.out(",", this.getClAlias(), "nn$(", lhsVar, ")?", lhsVar, ":");
        this.box(that.getRightTerm());
        this.out(")", new String[0]);
    }

    @Override
    public void visit(Tree.IncrementOp that) {
        Operators.prefixIncrementOrDecrement(that.getTerm(), "successor", this);
    }

    @Override
    public void visit(Tree.DecrementOp that) {
        Operators.prefixIncrementOrDecrement(that.getTerm(), "predecessor", this);
    }

    boolean hasSimpleGetterSetter(Declaration decl) {
        return this.isInDynamicBlock() && TypeUtils.isUnknown(decl) || (!(decl instanceof Value) || !((Value)decl).isTransient()) && !(decl instanceof Setter) && !decl.isFormal();
    }

    @Override
    public void visit(Tree.PostfixIncrementOp that) {
        Operators.postfixIncrementOrDecrement(that.getTerm(), "successor", this);
    }

    @Override
    public void visit(Tree.PostfixDecrementOp that) {
        Operators.postfixIncrementOrDecrement(that.getTerm(), "predecessor", this);
    }

    @Override
    public void visit(Tree.UnionOp that) {
        Operators.genericBinaryOp(that, ".union(", TypeUtils.mapTypeArgument(that, "union", "Element", "Other"), that.getTypeModel().getVarianceOverrides(), this);
    }

    @Override
    public void visit(Tree.IntersectionOp that) {
        Operators.genericBinaryOp(that, ".intersection(", TypeUtils.mapTypeArgument(that, "intersection", "Element", "Other"), that.getTypeModel().getVarianceOverrides(), this);
    }

    @Override
    public void visit(Tree.ComplementOp that) {
        Operators.genericBinaryOp(that, ".complement(", TypeUtils.mapTypeArgument(that, "complement", "Element", "Other"), that.getTypeModel().getVarianceOverrides(), this);
    }

    @Override
    public void visit(Tree.Exists that) {
        Operators.unaryOp(that, this.getClAlias() + "nn$(", ")", this);
    }

    @Override
    public void visit(Tree.Nonempty that) {
        Operators.unaryOp(that, this.getClAlias() + "ne$(", ")", this);
    }

    @Override
    public void visit(Tree.ConditionList that) {
        this.spitOut("ZOMG condition list in the wild! " + that.getLocation() + " of " + that.getUnit().getFilename());
        super.visit(that);
    }

    @Override
    public void visit(Tree.BooleanCondition that) {
        int boxType = this.boxStart(that.getExpression().getTerm());
        super.visit(that);
        if (boxType == 4) {
            this.out("/*TODO: callable targs 10*/", new String[0]);
        }
        this.boxUnboxEnd(boxType);
    }

    @Override
    public void visit(Tree.IfStatement that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        this.conds.generateIf(that);
    }

    @Override
    public void visit(Tree.IfExpression that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        this.conds.generateIfExpression(that, false);
    }

    @Override
    public void visit(Tree.WhileStatement that) {
        this.conds.generateWhile(that);
    }

    @Override
    public void visit(Tree.Variable that) {
        boolean guarded = that instanceof CustomTree.GuardedVariable;
        if (guarded) {
            this.out(function, this.names.name(that.getDeclarationModel()), "(){return ");
        }
        super.visit(that);
        if (guarded) {
            this.out(";}", new String[0]);
            this.endLine();
        }
    }

    void generateIsOfType(Node term, String termString, Type type, String tmpvar, boolean negate, boolean coerceDynamic) {
        Declaration d;
        if (negate) {
            this.out("!", new String[0]);
        }
        this.out(this.getClAlias(), "is$(");
        if (this.isInDynamicBlock() && coerceDynamic) {
            this.out(this.getClAlias(), "dre$$(");
        }
        if (term instanceof Tree.Term) {
            this.conds.specialConditionRHS((Tree.Term)term, tmpvar);
        } else {
            this.conds.specialConditionRHS(termString, tmpvar);
        }
        if (this.isInDynamicBlock() && coerceDynamic) {
            this.out(",", new String[0]);
            TypeUtils.typeNameOrList(term, type, this, false);
            this.out(",false)", new String[0]);
        }
        this.out(",", new String[0]);
        TypeUtils.typeNameOrList(term, type, this, false);
        if (type.getQualifyingType() != null) {
            boolean first = true;
            for (Type outer = type.getQualifyingType(); outer != null; outer = outer.getQualifyingType()) {
                if (first) {
                    this.out(",[", new String[0]);
                    first = false;
                } else {
                    this.out(",", new String[0]);
                }
                TypeUtils.typeNameOrList(term, outer, this, false);
            }
            if (!first) {
                this.out("]", new String[0]);
            }
        } else if (type.getDeclaration() != null && type.getDeclaration().getContainer() != null && (d = ModelUtil.getContainingDeclarationOfScope(type.getDeclaration().getContainer())) != null && d instanceof Function && !((Function)d).getTypeParameters().isEmpty()) {
            this.out(",", this.names.typeArgsParamName((Function)d));
        }
        this.out(")", new String[0]);
    }

    @Override
    public void visit(Tree.IsOp that) {
        this.generateIsOfType(that.getTerm(), null, that.getType().getTypeModel(), null, false, false);
    }

    @Override
    public void visit(Tree.Break that) {
        if (this.continues.isEmpty()) {
            this.out("break;", new String[0]);
        } else {
            ContinueBreakVisitor top = this.continues.peek();
            if (top.belongs(that)) {
                this.out(top.getBreakName(), "=true;return;");
            } else {
                this.out("break;", new String[0]);
            }
        }
    }

    @Override
    public void visit(Tree.Continue that) {
        if (this.continues.isEmpty()) {
            this.out("continue;", new String[0]);
        } else {
            ContinueBreakVisitor top = this.continues.peek();
            if (top.belongs(that)) {
                this.out(top.getContinueName(), "=true;return;");
            } else {
                this.out("continue;", new String[0]);
            }
        }
    }

    @Override
    public void visit(Tree.ForStatement that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        new ForGenerator(this, this.directAccess).generate(that);
    }

    @Override
    public void visit(Tree.InOp that) {
        this.out(this.getClAlias(), "$cnt$(");
        this.box(that.getRightTerm());
        this.out(",", new String[0]);
        if (!this.isNaturalLiteral(that.getLeftTerm())) {
            this.box(that.getLeftTerm());
        }
        this.out(")", new String[0]);
    }

    @Override
    public void visit(Tree.TryCatchStatement that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        new TryCatchGenerator(this, this.directAccess).generate(that);
    }

    @Override
    public void visit(Tree.Throw that) {
        this.out("throw ", this.getClAlias(), "wrapexc(");
        if (that.getExpression() == null) {
            this.out(this.getClAlias(), "Exception()");
        } else {
            that.getExpression().visit(this);
        }
        that.getUnit().getFullPath();
        this.out(",'", that.getLocation(), "','", that.getUnit().getRelativePath(), "');");
    }

    private void visitIndex(Tree.IndexExpression that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        Operators.indexOp(that, this);
    }

    @Override
    public void visit(Tree.IndexExpression that) {
        this.visitIndex(that);
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        if (this.opts.isComment() && !this.opts.isMinify()) {
            this.out("//Switch statement at ", that.getUnit().getFilename(), " (", that.getLocation(), ")");
            this.endLine();
        }
        this.conds.switchStatement(that);
        if (this.opts.isComment() && !this.opts.isMinify()) {
            this.out("//End switch statement at ", that.getUnit().getFilename(), " (", that.getLocation(), ")");
            this.endLine();
        }
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        this.conds.switchExpression(that);
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        FunctionHelper.functionArgument(that, this);
    }

    @Override
    public void visit(Tree.SpecifiedArgument that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        int _box = 0;
        Tree.SpecifierExpression expr = that.getSpecifierExpression();
        if (that.getParameter() != null && expr != null) {
            _box = this.boxUnboxStart(expr.getExpression().getTerm(), that.getParameter().getModel());
        }
        expr.visit(this);
        if (_box == 4) {
            this.out(",", new String[0]);
            this.invoker.describeMethodParameters(expr.getExpression().getTerm());
            this.out(",", new String[0]);
            TypeUtils.printTypeArguments(that, expr.getExpression().getTypeModel().getTypeArguments(), this, false, expr.getExpression().getTypeModel().getVarianceOverrides());
        }
        this.boxUnboxEnd(_box);
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        FunctionHelper.methodArgument(that, this);
    }

    void outputCapturedValues(Set<Value> caps) {
        if (caps == null || caps.isEmpty()) {
            return;
        }
        boolean first = true;
        for (Value v : caps) {
            if (first) {
                this.out("var ", new String[0]);
            } else {
                this.out(",", new String[0]);
            }
            first = false;
            String cn = this.names.createTempVariable();
            this.out(cn, "=", this.names.name(v));
            this.names.forceName(v, cn);
        }
        this.out(";", new String[0]);
    }

    void forgetCapturedValues(Set<Value> caps) {
        if (caps == null) {
            return;
        }
        for (Value v : caps) {
            this.directAccess.remove(v);
            this.names.forceName(v, null);
        }
    }

    void encloseBlockInFunction(Tree.Block block, boolean markBlock, Set<Value> capturedValues) {
        ContinueBreakVisitor cbv;
        boolean wrap;
        boolean bl = wrap = capturedValues != null && !capturedValues.isEmpty() || new BlockWithCaptureVisitor(block).hasCapture();
        if (markBlock) {
            this.beginBlock();
        }
        if (wrap) {
            cbv = new ContinueBreakVisitor(block, this.names);
            this.continues.push(cbv);
            boolean vars = false;
            if (cbv.isContinues()) {
                this.out("var ", cbv.getContinueName(), "=false");
                vars = true;
            }
            if (cbv.isBreaks()) {
                this.out(vars ? "," : "var ", cbv.getBreakName(), "=false");
                vars = true;
            }
            this.out(vars ? "," : "var ", cbv.getReturnName(), "=(function(){");
            this.outputCapturedValues(capturedValues);
        }
        this.visitStatements(block.getStatements());
        if (wrap) {
            cbv = this.continues.pop();
            ContinueBreakVisitor prev = this.continues.isEmpty() ? null : this.continues.peek();
            this.out("}());if(", cbv.getReturnName(), "!==undefined){return ", cbv.getReturnName(), ";}");
            if (cbv.isContinues()) {
                this.out("else if(", cbv.getContinueName());
                if (prev != null && prev.isContinues()) {
                    this.out("){", prev.getContinueName(), "=true;return ", cbv.getReturnName(), ";}");
                } else {
                    this.out("){continue;}", new String[0]);
                }
            }
            if (cbv.isBreaks()) {
                this.out("else if(", cbv.getBreakName());
                if (prev != null && prev.isBreaks()) {
                    this.out("){", prev.getBreakName(), "=true;return ", cbv.getReturnName(), ";}");
                } else {
                    this.out("){break;}", new String[0]);
                }
            }
            this.forgetCapturedValues(capturedValues);
        }
        if (markBlock) {
            this.endBlockNewLine();
        }
    }

    @Override
    public void visit(Tree.Tuple that) {
        SequenceGenerator.tuple(that, this);
    }

    @Override
    public void visit(Tree.Assertion that) {
        if (this.opts.isComment() && !this.opts.isMinify()) {
            this.out("//assert", new String[0]);
            this.location(that);
            this.endLine();
        }
        Tree.AnnotationList annotationList = that.getAnnotationList();
        Tree.ConditionList conditionList = that.getConditionList();
        if (conditionList != null) {
            this.conds.specialConditionsAndBlock(conditionList, null, this.getClAlias() + "asrt$(", true);
            this.out(",", new String[0]);
            this.out("\"Assertion failed: \"+", new String[0]);
            String custom = this.docText(annotationList);
            if (custom == null) {
                this.out("(", new String[0]);
                this.visit(annotationList.getAnonymousAnnotation().getStringTemplate());
                this.out(")+", new String[0]);
            }
            StringBuilder sb = new StringBuilder();
            if (custom != null) {
                sb.append(JsUtils.escapeStringLiteral(custom));
            }
            sb.append("\\n\\tviolated ");
            for (int i = conditionList.getToken().getTokenIndex() + 1; i < conditionList.getEndToken().getTokenIndex(); ++i) {
                sb.append(JsUtils.escapeStringLiteral(this.tokens.get(i).getText()));
            }
            sb.append("\\n\\tat ").append(that.getUnit().getFilename()).append(" (").append(conditionList.getLocation()).append(")");
            this.out("\"", sb.toString(), "\",'", that.getLocation(), "','", that.getUnit().getFilename(), "');");
        }
        this.endLine();
    }

    private String docText(Tree.AnnotationList annotationList) {
        if (annotationList != null) {
            if (annotationList.getAnonymousAnnotation() != null) {
                Tree.StringLiteral lit = annotationList.getAnonymousAnnotation().getStringLiteral();
                if (lit == null) {
                    return null;
                }
                return lit.getText();
            }
            for (Tree.Annotation ann : annotationList.getAnnotations()) {
                Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)ann.getPrimary();
                if (!"doc".equals(bme.getDeclaration().getName())) continue;
                Tree.ListedArgument arg = (Tree.ListedArgument)ann.getPositionalArgumentList().getPositionalArguments().get(0);
                return arg.getExpression().getTerm().getText();
            }
        }
        return "";
    }

    @Override
    public void visit(Tree.DynamicStatement that) {
        ++this.dynblock;
        if (this.dynblock == 1 && !this.opts.isMinify()) {
            if (this.opts.isComment()) {
                this.out("/*BEG dynblock*/", new String[0]);
            }
            this.endLine();
        }
        for (Tree.Statement stmt : that.getDynamicClause().getBlock().getStatements()) {
            stmt.visit(this);
        }
        if (this.dynblock == 1 && !this.opts.isMinify()) {
            if (this.opts.isComment()) {
                this.out("/*END dynblock*/", new String[0]);
            }
            this.endLine();
        }
        --this.dynblock;
    }

    public boolean isInDynamicBlock() {
        return this.dynblock > 0;
    }

    @Override
    public void visit(Tree.TypeLiteral that) {
        if (that.getWantsDeclaration()) {
            MetamodelHelper.generateOpenType(that, that.getDeclaration(), this, this.compiler.isCompilingLanguageModule());
        } else {
            MetamodelHelper.generateClosedTypeLiteral(that, this);
        }
    }

    @Override
    public void visit(Tree.MemberLiteral that) {
        if (that.getWantsDeclaration()) {
            MetamodelHelper.generateOpenType(that, that.getDeclaration(), this, this.compiler.isCompilingLanguageModule());
        } else {
            MetamodelHelper.generateMemberLiteral(that, this);
        }
    }

    @Override
    public void visit(Tree.PackageLiteral that) {
        Package pkg = (Package)that.getImportPath().getModel();
        MetamodelHelper.findModule(pkg.getModule(), this);
        this.out(".findPackage('", pkg.getNameAsString(), "')");
    }

    @Override
    public void visit(Tree.ModuleLiteral that) {
        Module m = (Module)that.getImportPath().getModel();
        MetamodelHelper.findModule(m, this);
    }

    void generateThrow(String exceptionClass, String msg, Node node) {
        this.out(this.getClAlias(), "throwexc(", exceptionClass == null ? this.getClAlias() + "Exception" : exceptionClass, "(");
        this.out("\"", JsUtils.escapeStringLiteral(msg), "\"),'", node.getLocation(), "','", node.getUnit().getFilename(), "')");
    }

    @Override
    public void visit(Tree.CompilerAnnotation that) {
    }

    void defineAttribute(String owner, String name) {
        this.out(this.getClAlias(), "atr$(", owner, ",'", name, "',function()");
    }

    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void visit(Tree.ListedArgument that) {
        if (!this.isNaturalLiteral(that.getExpression().getTerm())) {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.LetExpression that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        FunctionHelper.generateLet(that, this.directAccess, this);
    }

    @Override
    public void visit(Tree.Destructure that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        String expvar = this.names.createTempVariable();
        this.out("var ", expvar, "=");
        that.getSpecifierExpression().visit(this);
        new Destructurer(that.getPattern(), this, this.directAccess, expvar, false, false);
        this.endLine(true);
    }

    @Override
    public void visit(Tree.Enumerated that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        if (this.opts.isOptimize()) {
            return;
        }
        this.comment(that);
        TypeDeclaration klass = (TypeDeclaration)that.getEnumerated().getContainer();
        this.defineAttribute(this.names.self(klass), this.names.name(that.getDeclarationModel()));
        this.out("{return ", this.names.name(klass), this.names.constructorSeparator(that.getDeclarationModel()), this.names.name(that.getDeclarationModel()), "();},undefined,");
        TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), that.getAnnotationList(), this);
        this.out(");", new String[0]);
    }

    @Override
    public void visit(Tree.ExtendedTypeExpression that) {
        if (this.errVisitor.hasErrors(that)) {
            return;
        }
        Declaration d = that.getDeclaration();
        if (d instanceof Constructor) {
            this.qualify(that, (Declaration)((Object)d.getContainer()));
            this.out(this.names.name((Declaration)((Object)d.getContainer())), this.names.constructorSeparator(d));
        } else {
            this.qualify(that, d);
        }
        this.out(this.names.name(d), new String[0]);
    }

    boolean isNaturalLiteral(Tree.Term that) {
        if (that instanceof Tree.NaturalLiteral) {
            this.out(Long.toString(this.parseNaturalLiteral((Tree.NaturalLiteral)that, false)), new String[0]);
            return true;
        }
        if (that instanceof Tree.NegativeOp) {
            that.visit(this);
            return true;
        }
        return false;
    }

    public void saveNativeHeader(Tree.Declaration that) {
        this.headers.put(that.getDeclarationModel().getQualifiedNameString(), that);
    }

    public Tree.Declaration getNativeHeader(Declaration that) {
        return this.headers.get(that.getQualifiedNameString());
    }

    @Override
    public void visit(Tree.SequenceType that) {
    }

    static interface PrototypeInitCallback {
        public void addToPrototypeCallback();
    }

    static class InitDeferrer {
        List<String> deferred = new LinkedList<String>();

        InitDeferrer() {
        }
    }

    class NeedsThisVisitor
    extends Visitor {
        private boolean refs = false;
        private boolean outerRefs = false;

        NeedsThisVisitor(Node n) {
            if (GenerateJsVisitor.this.prototypeOwner != null) {
                boolean isMember;
                Scope scope = ModelUtil.getRealScope(n.getScope());
                if (scope instanceof Specification) {
                    scope = ModelUtil.getRealScope(scope.getContainer());
                }
                boolean bl = isMember = scope instanceof ClassOrInterface || scope instanceof Declaration && (((Declaration)((Object)scope)).isClassOrInterfaceMember() || ((Declaration)((Object)scope)).isParameter());
                if (isMember) {
                    n.visit(this);
                }
            }
        }

        @Override
        public void visit(Tree.This that) {
            this.refs = true;
        }

        @Override
        public void visit(Tree.Outer that) {
            this.refs = true;
        }

        @Override
        public void visit(Tree.Super that) {
            this.refs = true;
        }

        private boolean check(Scope origScope) {
            Scope s;
            for (s = origScope; s != null; s = s.getContainer()) {
                if (s != GenerateJsVisitor.this.prototypeOwner && (!(s instanceof TypeDeclaration) || !GenerateJsVisitor.this.prototypeOwner.inherits((TypeDeclaration)s))) continue;
                this.refs = true;
                if (GenerateJsVisitor.this.prototypeOwner.isAnonymous() && GenerateJsVisitor.this.prototypeOwner.isMember()) {
                    this.outerRefs = true;
                }
                return true;
            }
            s = GenerateJsVisitor.this.prototypeOwner;
            Scope endScope = origScope;
            if (endScope instanceof TypeParameter) {
                endScope = endScope.getContainer();
            }
            while (s != null) {
                if (s == endScope || s instanceof TypeDeclaration && endScope instanceof TypeDeclaration && ((TypeDeclaration)s).inherits((TypeDeclaration)endScope)) {
                    this.refs = true;
                    return true;
                }
                s = s.getContainer();
            }
            return false;
        }

        @Override
        public void visit(Tree.MemberOrTypeExpression that) {
            if (this.refs) {
                return;
            }
            if (that.getDeclaration() == null) {
                super.visit(that);
                return;
            }
            if (!this.check(that.getDeclaration().getContainer())) {
                super.visit(that);
            }
        }

        @Override
        public void visit(Tree.Type that) {
            if (!this.check(that.getTypeModel().getDeclaration())) {
                super.visit(that);
            }
        }

        @Override
        public void visit(Tree.ParameterList plist) {
            for (Tree.Parameter param : plist.getParameters()) {
                if (!param.getParameterModel().isDefaulted()) continue;
                this.refs = true;
                return;
            }
            super.visit(plist);
        }

        boolean needsThisReference() {
            return this.refs;
        }

        boolean needsOuterReference() {
            return this.outerRefs;
        }
    }

    public static interface GenerateCallback {
        public void generateValue();
    }

    private final class OuterVisitor
    extends Visitor {
        boolean found = false;
        private Declaration dec;

        private OuterVisitor(Declaration dec) {
            this.dec = dec;
        }

        @Override
        public void visit(Tree.QualifiedMemberOrTypeExpression qe) {
            if ((qe.getPrimary() instanceof Tree.Outer || qe.getPrimary() instanceof Tree.This) && qe.getDeclaration().equals(this.dec)) {
                this.found = true;
            }
            super.visit(qe);
        }
    }

    static final class SuperVisitor
    extends Visitor {
        private final List<Declaration> decs;

        SuperVisitor(List<Declaration> decs) {
            this.decs = decs;
        }

        @Override
        public void visit(Tree.QualifiedMemberOrTypeExpression qe) {
            Tree.Term primary = TreeUtil.eliminateParensAndWidening(qe.getPrimary());
            if (primary instanceof Tree.Super) {
                this.decs.add(qe.getDeclaration());
            }
            super.visit(qe);
        }

        @Override
        public void visit(Tree.QualifiedType that) {
            if (that.getOuterType() instanceof Tree.SuperType) {
                this.decs.add(that.getDeclarationModel());
            }
            super.visit(that);
        }

        @Override
        public void visit(Tree.ClassOrInterface qe) {
            Tree.ExtendedType extType;
            if (qe instanceof Tree.ClassDefinition && (extType = ((Tree.ClassDefinition)qe).getExtendedType()) != null) {
                super.visit(extType);
            }
        }
    }
}

