/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactCreator;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.Versions;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.js.DiagnosticListener;
import com.redhat.ceylon.compiler.js.ErrorCollectingVisitor;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.Stitcher;
import com.redhat.ceylon.compiler.js.ValueVisitor;
import com.redhat.ceylon.compiler.js.loader.JsModuleSourceMapper;
import com.redhat.ceylon.compiler.js.loader.NpmAware;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.js.util.JsLogger;
import com.redhat.ceylon.compiler.js.util.JsOutput;
import com.redhat.ceylon.compiler.js.util.NpmDescriptorGenerator;
import com.redhat.ceylon.compiler.js.util.Options;
import com.redhat.ceylon.compiler.typechecker.TypeChecker;
import com.redhat.ceylon.compiler.typechecker.analyzer.MissingNativeVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.WarningSuppressionVisitor;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ImportableScope;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class JsCompiler {
    protected final TypeChecker tc;
    protected final Options opts;
    protected final RepositoryManager outRepo;
    private final ErrorCollectingVisitor errorVisitor;
    private boolean stopOnErrors = true;
    private int errCount = 0;
    protected final List<VirtualFile> srcDirectories;
    protected List<File> srcFiles;
    protected List<File> resFiles;
    private final Map<Module, JsOutput> output = new HashMap<Module, JsOutput>();
    private boolean compilingLanguageModule;
    private int exitCode = 0;
    private Logger logger;
    private JsIdentifierNames names;

    public int getExitCode() {
        return this.exitCode;
    }

    public JsCompiler(TypeChecker tc, Options options) {
        this(tc, options, false);
    }

    public JsCompiler(TypeChecker tc, Options options, boolean compilingLanguageModule) {
        this.tc = tc;
        this.opts = options;
        this.compilingLanguageModule = compilingLanguageModule;
        this.outRepo = CeylonUtils.repoManager().cwd(options.getCwd()).outRepo(options.getOutRepo()).user(options.getUser()).password(options.getPass()).buildOutputManager();
        this.logger = this.opts.getLogger();
        if (this.logger == null) {
            this.logger = new JsLogger(this.opts);
        }
        this.errorVisitor = new ErrorCollectingVisitor(tc);
        this.srcDirectories = this.initSourceDirectories(this.opts);
    }

    protected List<VirtualFile> initSourceDirectories(Options opts) {
        ArrayList<VirtualFile> srcdirs = new ArrayList<VirtualFile>(opts.getSrcDirs().size());
        for (File srcdir : opts.getSrcDirs()) {
            srcdirs.add(this.sourceDirVirtual(srcdir));
        }
        return srcdirs;
    }

    protected VirtualFile sourceDirVirtual(File f) {
        return this.tc.getContext().getVfs().getFromFile(f);
    }

    private boolean isURL(String path) {
        try {
            new URL(path);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public JsCompiler stopOnErrors(boolean flag) {
        this.stopOnErrors = flag;
        return this;
    }

    public JsCompiler setSourceFiles(List<File> files) {
        if (files != null && !files.isEmpty()) {
            this.srcFiles = files;
        }
        return this;
    }

    public JsCompiler setResourceFiles(List<File> files) {
        this.resFiles = files;
        return this;
    }

    private int compileUnit(PhasedUnit pu, JsIdentifierNames names) throws IOException {
        if (this.opts.isVerbose()) {
            this.logger.debug("Compiling " + pu.getUnitFile().getPath() + " to JS");
        }
        JsOutput jsout = this.getOutput(pu);
        JsMissingNativeVisitor mnv = new JsMissingNativeVisitor(this.opts.getCwd());
        pu.getCompilationUnit().visit(mnv);
        GenerateJsVisitor jsv = new GenerateJsVisitor(this, jsout, this.opts, names, pu.getTokens());
        pu.getCompilationUnit().visit(jsv);
        pu.getCompilationUnit().visit(this.errorVisitor);
        return jsv.getExitCode();
    }

    protected boolean stopOnError() {
        this.errCount += this.errorVisitor.getErrorCount();
        return this.stopOnErrors && this.errCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate() throws IOException {
        this.errorVisitor.clear();
        this.errCount = 0;
        this.output.clear();
        try {
            if (this.opts.isVerbose()) {
                this.logger.debug("Generating metamodel...");
            }
            List typecheckerPhasedUnits = this.tc.getPhasedUnits().getPhasedUnits();
            ArrayList<PhasedUnit> phasedUnits = new ArrayList<PhasedUnit>(typecheckerPhasedUnits.size());
            for (PhasedUnit pu : typecheckerPhasedUnits) {
                if (this.srcFiles == null) {
                    phasedUnits.add(pu);
                    continue;
                }
                File path = this.getFullPath(pu);
                if (!this.srcFiles.contains(path)) continue;
                phasedUnits.add(pu);
            }
            boolean generatedCode = false;
            Module defmod = this.tc.getContext().getModules().getDefaultModule();
            for (PhasedUnit phasedUnit : phasedUnits) {
                EnumSet<Warning> suppressedWarnings;
                Module mod = phasedUnit.getPackage().getModule();
                if (mod.getVersion() == null && !mod.isDefaultModule()) {
                    for (Package pkg : mod.getPackages()) {
                        defmod.getPackages().add(pkg);
                        pkg.setModule(defmod);
                    }
                }
                if ((suppressedWarnings = this.opts.getSuppressWarnings()) == null) {
                    suppressedWarnings = EnumSet.noneOf(Warning.class);
                }
                phasedUnit.getCompilationUnit().visit(new WarningSuppressionVisitor<Warning>(Warning.class, suppressedWarnings));
                for (Declaration d : phasedUnit.getDeclarations()) {
                    if (!(d instanceof TypedDeclaration) || d instanceof Setter) continue;
                    phasedUnit.getCompilationUnit().visit(new ValueVisitor((TypedDeclaration)d));
                }
                phasedUnit.getCompilationUnit().visit(this.getOutput((PhasedUnit)phasedUnit).mmg);
                if (!this.opts.hasVerboseFlag("ast")) continue;
                if (this.opts.getOutWriter() == null) {
                    this.logger.debug(phasedUnit.getCompilationUnit().toString());
                    continue;
                }
                this.opts.getOutWriter().write(phasedUnit.getCompilationUnit().toString());
                this.opts.getOutWriter().write(10);
            }
            this.names = new JsIdentifierNames(this);
            if (!this.compilingLanguageModule) {
                for (Map.Entry entry : this.output.entrySet()) {
                    ((JsOutput)entry.getValue()).encodeModel(this.names);
                }
            }
            Visitor importVisitor = new Visitor(){

                @Override
                public void visit(Tree.Import that) {
                    Package pkg;
                    Module om;
                    ImportableScope scope = that.getImportMemberOrTypeList().getImportList().getImportedScope();
                    Module _m = that.getUnit().getPackage().getModule();
                    if (scope instanceof Package && !(om = (pkg = (Package)scope).getModule()).equals(_m) && (!om.isNative() || om.getNativeBackends().supports(Backend.JavaScript))) {
                        Module impmod = ((Package)scope).getModule();
                        if (impmod instanceof NpmAware && ((NpmAware)((Object)impmod)).getNpmPath() != null) {
                            ((JsOutput)JsCompiler.this.output.get(_m)).requireFromNpm(impmod, JsCompiler.this.names);
                        } else {
                            ((JsOutput)JsCompiler.this.output.get(_m)).require(impmod, JsCompiler.this.names);
                        }
                    }
                }

                @Override
                public void visit(Tree.ImportModule that) {
                    if (that.getImportPath() != null && that.getImportPath().getModel() instanceof Module) {
                        Module m = (Module)that.getImportPath().getModel();
                        int binMajorVersion = m.getJsMajor();
                        int binMinorVersion = m.getJsMinor();
                        if (m.getJsMajor() == 0) {
                            for (PhasedUnit pu : JsCompiler.this.tc.getPhasedUnits().getPhasedUnits()) {
                                if (pu.getPackage() == null || pu.getPackage().getModule() != m) continue;
                                m.setJsMajor(10);
                                m.setJsMinor(0);
                                binMajorVersion = 10;
                                binMinorVersion = 0;
                                break;
                            }
                            if (m.getJsMajor() == 0) {
                                ArtifactContext ac = new ArtifactContext(null, m.getNameAsString(), m.getVersion(), "-model.js");
                                ac.setIgnoreDependencies(true);
                                ac.setThrowErrorIfMissing(false);
                                ArtifactResult ar = JsCompiler.this.tc.getContext().getRepositoryManager().getArtifactResult(ac);
                                if (ar == null) {
                                    return;
                                }
                                File js = ar.artifact();
                                if (js != null) {
                                    Map<String, Object> json = JsModuleSourceMapper.loadJsonModel(js);
                                    String binVersion = json.get("$mod-bin").toString();
                                    int p = binVersion.indexOf(46);
                                    binMajorVersion = Integer.valueOf(binVersion.substring(0, p));
                                    binMinorVersion = Integer.valueOf(binVersion.substring(p + 1));
                                }
                            }
                        }
                        if (!Versions.isJsBinaryVersionSupported(binMajorVersion, binMinorVersion)) {
                            that.addError("version '" + m.getVersion() + "' of module '" + m.getNameAsString() + "' was compiled by an incompatible version of the compiler (binary version " + binMajorVersion + "." + binMinorVersion + " of module is not compatible with binary version " + 10 + "." + 0 + " of this compiler)");
                        }
                    }
                }
            };
            for (PhasedUnit pu : phasedUnits) {
                pu.getCompilationUnit().visit(importVisitor);
            }
            ArrayList<PhasedUnit> arrayList = new ArrayList<PhasedUnit>(4);
            if (this.srcFiles == null && !phasedUnits.isEmpty()) {
                for (PhasedUnit pu : phasedUnits) {
                    if (!"module.ceylon".equals(pu.getUnitFile().getName())) continue;
                    int t = this.compileUnit(pu);
                    generatedCode = true;
                    if (t == 0) continue;
                    boolean d = false;
                    return d;
                }
                for (PhasedUnit pu : phasedUnits) {
                    if ("package.ceylon".equals(pu.getUnitFile().getName())) {
                        arrayList.add(pu);
                        continue;
                    }
                    if ("module.ceylon".equals(pu.getUnitFile().getName())) continue;
                    int t = this.compileUnit(pu);
                    generatedCode = true;
                    if (t == 1) {
                        boolean d = false;
                        return d;
                    }
                    if (t != 2) continue;
                    break;
                }
            } else if (this.srcFiles != null && !this.srcFiles.isEmpty() && !typecheckerPhasedUnits.isEmpty()) {
                for (PhasedUnit pu : phasedUnits) {
                    if (!"module.ceylon".equals(pu.getUnitFile().getName())) continue;
                    int t = this.compileUnit(pu);
                    generatedCode = true;
                    if (t == 0) continue;
                    boolean d = false;
                    return d;
                }
                block29: for (File path : this.srcFiles) {
                    if (path.getPath().endsWith(".js")) {
                        File dir = path.getParentFile();
                        PhasedUnit lastUnit = phasedUnits.isEmpty() ? (PhasedUnit)typecheckerPhasedUnits.get(0) : (PhasedUnit)phasedUnits.get(0);
                        for (PhasedUnit pu : phasedUnits) {
                            if (!pu.getUnitFile().getPath().startsWith(dir.getPath())) continue;
                            lastUnit = pu;
                            break;
                        }
                        JsOutput lastOut = this.getOutput(lastUnit);
                        VirtualFile vpath = this.findFile(path);
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(vpath.getInputStream(), this.opts.getEncoding()));){
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                if (this.opts.isMinify()) {
                                    line = line.trim();
                                    if (!this.opts.isComment() && line.startsWith("//") && !line.contains("*/")) continue;
                                }
                                if (line.length() == 0) continue;
                                lastOut.getWriter().write(line);
                                lastOut.getWriter().write(10);
                            }
                        }
                        finally {
                            lastOut.addSource(path);
                        }
                        generatedCode = true;
                        continue;
                    }
                    for (PhasedUnit pu : phasedUnits) {
                        File unitFile = this.getFullPath(pu);
                        if (!path.equals(unitFile)) continue;
                        if (path.getName().equals("package.ceylon")) {
                            arrayList.add(pu);
                            continue;
                        }
                        if (path.getName().equals("module.ceylon")) continue;
                        int t = this.compileUnit(pu);
                        generatedCode = true;
                        if (t == 1) {
                            boolean bl = false;
                            return bl;
                        }
                        if (t != 2) continue;
                        continue block29;
                    }
                }
            }
            for (PhasedUnit pu : arrayList) {
                int t = this.compileUnit(pu);
                generatedCode = true;
                if (t == 1) {
                    boolean bl = false;
                    return bl;
                }
                if (t != 2) continue;
                break;
            }
            if (!generatedCode) {
                this.logger.error("No source units found to compile");
                this.exitCode = 2;
            }
        }
        finally {
            if (this.exitCode == 0) {
                this.exitCode = this.finish();
            }
        }
        return this.errCount == 0 && this.exitCode == 0;
    }

    private int compileUnit(PhasedUnit pu) throws IOException {
        this.exitCode = this.compileUnit(pu, this.names);
        if (this.exitCode != 0) {
            return 1;
        }
        if (this.stopOnError()) {
            this.logger.error("Errors found. Compilation stopped.");
            return 2;
        }
        this.getOutput(pu).addSource(this.getFullPath(pu));
        return 0;
    }

    VirtualFile findFile(File path) {
        for (VirtualFile root : this.srcDirectories) {
            File relPath;
            VirtualFile f;
            String r;
            String p = path.getPath().replace(File.separator, "/");
            if (!p.startsWith(r = root.getPath()) || (f = this.findFile(root, relPath = new File(p.substring(r.length() + 1)))) == null) continue;
            return f;
        }
        return null;
    }

    private VirtualFile findFile(VirtualFile root, File path) {
        String[] parts;
        VirtualFile result = root;
        block0: for (String p : parts = path.getPath().split(Pattern.quote(File.separator))) {
            if (p.equals(".")) continue;
            for (VirtualFile virtualFile : result.getChildren()) {
                if (!virtualFile.getName().equals(p)) continue;
                result = virtualFile;
                continue block0;
            }
            return null;
        }
        return result;
    }

    public File getFullPath(PhasedUnit pu) {
        return new File(pu.getUnit().getFullPath());
    }

    private JsOutput getOutput(PhasedUnit pu) throws IOException {
        Module mod = pu.getPackage().getModule();
        JsOutput jsout = this.output.get(mod);
        if (jsout == null) {
            jsout = this.newJsOutput(mod);
            this.output.put(mod, jsout);
            if (this.opts.isModulify()) {
                jsout.openWrapper();
            }
        }
        return jsout;
    }

    protected JsOutput newJsOutput(Module m) throws IOException {
        return new JsOutput(m, this.isCompilingLanguageModule());
    }

    JsOutput getOutputForModule(Module m) {
        return this.output.get(m);
    }

    JsIdentifierNames getNames() {
        return this.names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int finish() throws IOException {
        int result = 0;
        String outDir = CeylonUtils.resolveRepoUrl(this.opts.getOutRepo());
        if (!this.isURL(outDir)) {
            File root = new File(outDir);
            if (root.exists()) {
                if (!root.isDirectory() || !root.canWrite()) {
                    this.logger.error("Cannot write to " + root + ". Stop.");
                    result = 1;
                }
            } else if (!FileUtil.mkdirs(root)) {
                this.logger.error("Cannot create " + root + ". Stop.");
                result = 1;
            }
        }
        for (Map.Entry<Module, JsOutput> entry : this.output.entrySet()) {
            ArtifactContext artifact;
            JsOutput jsout = entry.getValue();
            if (!this.compilingLanguageModule) {
                jsout.publishUnsharedDeclarations(this.names);
            }
            if (this.opts.isModulify()) {
                jsout.closeWrapper();
            }
            String moduleName = entry.getKey().getNameAsString();
            String moduleVersion = entry.getKey().getVersion();
            if (this.opts.getDiagnosticListener() != null) {
                this.opts.getDiagnosticListener().moduleCompiled(moduleName, moduleVersion);
            }
            File jsart = jsout.close();
            File modart = jsout.getModelFile();
            if (entry.getKey().isDefaultModule()) {
                this.logger.info("Created module " + moduleName);
            } else if (!this.compilingLanguageModule) {
                this.logger.info("Created module " + moduleName + "/" + moduleVersion);
            }
            if (this.compilingLanguageModule) {
                artifact = new ArtifactContext(null, "delete", "me", ".js");
                artifact.setForceOperation(true);
                this.outRepo.putArtifact(artifact, jsart);
            } else {
                ArtifactCreator sac;
                artifact = new ArtifactContext(null, moduleName, moduleVersion, ".js");
                artifact.setForceOperation(true);
                this.outRepo.putArtifact(artifact, jsart);
                ArtifactContext martifact = new ArtifactContext(null, moduleName, moduleVersion, "-model.js");
                martifact.setForceOperation(true);
                this.outRepo.putArtifact(martifact, modart);
                ShaSigner.signArtifact(this.outRepo, artifact, jsart, this.logger);
                ShaSigner.signArtifact(this.outRepo, martifact, modart, this.logger);
                if (this.opts.isGenerateSourceArchive()) {
                    sac = CeylonUtils.makeSourceArtifactCreator(this.outRepo, this.opts.getSrcDirs(), moduleName, moduleVersion, this.opts.hasVerboseFlag("cmr"), this.logger);
                    sac.copy(FileUtil.filesToPathList(jsout.getSources()));
                }
                if (this.resFiles != null && !this.resFiles.isEmpty()) {
                    sac = CeylonUtils.makeResourceArtifactCreator(this.outRepo, this.opts.getSrcDirs(), this.opts.getResourceDirs(), this.opts.getResourceRootName(), moduleName, moduleVersion, this.opts.hasVerboseFlag("cmr"), this.logger);
                    sac.copy(FileUtil.filesToPathList(this.filterForModule(this.resFiles, this.opts.getResourceDirs(), moduleName)));
                }
                if (!entry.getKey().isDefaultModule()) {
                    String npmdesc = new NpmDescriptorGenerator(entry.getKey(), this.opts.isGenerateSourceArchive(), this.resFiles != null && !this.resFiles.isEmpty()).generateDescriptor();
                    File npmfile = File.createTempFile("npm", "json");
                    try {
                        try (FileWriter fw = new FileWriter(npmfile);){
                            fw.write(npmdesc);
                        }
                        ArtifactContext npmArtifact = new ArtifactContext(null, moduleName, moduleVersion, "package.json");
                        npmArtifact.setForceOperation(true);
                        this.outRepo.putArtifact(npmArtifact, npmfile);
                    }
                    finally {
                        npmfile.delete();
                    }
                }
            }
            FileUtil.deleteQuietly(jsart);
            if (modart == null) continue;
            FileUtil.deleteQuietly(modart);
        }
        return result;
    }

    private Collection<File> filterForModule(List<File> files, List<File> roots, String moduleName) {
        ArrayList<File> result = new ArrayList<File>(files.size());
        for (File f : files) {
            String rel = FileUtil.relativeFile(roots, f.getPath());
            if (!rel.startsWith(moduleName + "/") && !rel.startsWith(moduleName + "\\") && (!"default".equals(moduleName) || rel.contains("/") || rel.contains("\\"))) continue;
            result.add(f);
        }
        return result;
    }

    public int printErrorsAndCount(Writer out) throws IOException {
        DiagnosticListener diagnosticListener = this.opts.getDiagnosticListener();
        return this.errorVisitor.printErrors(out, diagnosticListener, true, true);
    }

    public int printErrors(Writer out) throws IOException {
        DiagnosticListener diagnosticListener = this.opts.getDiagnosticListener();
        return this.errorVisitor.printErrors(out, diagnosticListener, true, false);
    }

    public Set<Message> getErrors() {
        return this.errorVisitor.getErrors();
    }

    public static void beginWrapper(Writer writer) throws IOException {
        writer.write("(function(define) { define(function(require, ex$, module) {\n");
    }

    public static void requireWrapper(Writer writer, Module mod) throws IOException {
        writer.write("var $$req$ = require; require = (typeof $$ceylon$require == 'undefined') ? $$req$ : function() { return $$ceylon$require('" + JsCompiler.scriptPath(mod) + "', $$req$, Array.prototype.slice.call(arguments)); }\n");
    }

    public static void endWrapper(Writer writer) throws IOException {
        writer.write("});\n");
        writer.write("}(typeof define==='function' && define.amd ? define : function (factory) {\n");
        writer.write("if (typeof exports!=='undefined') { factory(require, exports, module);\n");
        writer.write("} else { throw 'no module loader'; }\n");
        writer.write("}));\n");
    }

    protected boolean nonCeylonUnit(Unit u) {
        return u.getFilename() != null && !u.getFilename().isEmpty() && !u.getFilename().endsWith(".ceylon") || u.getPackage() != null && u.getPackage().getModule() != null && u.getPackage().getModule().isJava();
    }

    public boolean isCompilingLanguageModule() {
        return this.compilingLanguageModule;
    }

    public static String scriptPath(Module mod) {
        StringBuilder path = new StringBuilder(mod.getNameAsString().replace('.', '/')).append('/');
        if (!mod.isDefaultModule()) {
            path.append(mod.getVersion()).append('/');
        }
        path.append(mod.getNameAsString());
        if (!mod.isDefaultModule()) {
            path.append('-').append(mod.getVersion());
        }
        return path.toString();
    }

    VirtualFile getStitchedFile(Declaration d, String suffix) {
        File path;
        String fqn = d.getQualifiedNameString();
        String name = d.getName();
        if (name == null && d instanceof Constructor) {
            name = "default$constructor";
            if (fqn.endsWith(".null")) {
                fqn = fqn.substring(0, fqn.length() - 4);
            }
            fqn = fqn + name;
        }
        if (fqn.startsWith("ceylon.language")) {
            fqn = fqn.substring(15);
        }
        if (fqn.startsWith("::")) {
            fqn = fqn.substring(2);
        }
        fqn = fqn.replace('.', '/').replace("::", "/");
        if (this.isCompilingLanguageModule()) {
            path = new File(Stitcher.LANGMOD_JS_SRC, fqn + suffix);
        } else {
            PhasedUnit pu = this.tc.getPhasedUnitFromRelativePath(d.getUnit().getRelativePath());
            path = new File(this.getFullPath(pu).getParentFile(), name + suffix);
        }
        return this.findFile(path);
    }

    VirtualFile getStitchedConstructorFile(Declaration d, String suffix) {
        VirtualFile f = this.isCompilingLanguageModule() ? this.getStitchedFile(d, suffix + ".js") : this.findFile(new File(new File(d.getUnit().getFullPath()).getParentFile(), String.format("%s%s.js", this.names.name(d), suffix)));
        return f;
    }

    boolean canStitchNative(Declaration d) {
        VirtualFile f;
        if (this.isCompilingLanguageModule()) {
            switch (d.getName()) {
                case "Integer": 
                case "Float": 
                case "true": 
                case "false": 
                case "modules": 
                case "Tuple": 
                case "Callable": 
                case "Throwable": 
                case "Exception": 
                case "reach": {
                    return true;
                }
            }
        }
        if ((f = this.getStitchedFile(d, ".js")) != null) {
            return true;
        }
        return this.isCompilingLanguageModule() && (f = this.getStitchedFile(d, "")) != null && f.isFolder();
    }

    private class JsMissingNativeVisitor
    extends MissingNativeVisitor {
        public JsMissingNativeVisitor(File cwd) {
            super(Backend.JavaScript);
        }

        @Override
        protected boolean checkNative(Node node, Declaration model) {
            if (model.getUnit() != node.getUnit() && ModelUtil.isForBackend(model.getUnit().getPackage().getModule().getNativeBackends(), Backend.JavaScript)) {
                return true;
            }
            return JsCompiler.this.canStitchNative(model);
        }
    }
}

