/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.List;
import java.util.Map;

public class SequenceGenerator {
    static void lazyEnumeration(List<Tree.PositionalArgument> args, Node node, Type seqType, boolean spread, GenerateJsVisitor gen) {
        Tree.PositionalArgument seqarg;
        Tree.PositionalArgument positionalArgument = seqarg = spread ? args.get(args.size() - 1) : null;
        if (args.size() == 1 && seqarg instanceof Tree.Comprehension) {
            seqarg.visit(gen);
            return;
        }
        String idxvar = gen.getNames().createTempVariable();
        gen.out(gen.getClAlias(), "sarg$(function(", idxvar, "){switch(", idxvar, "){");
        int count = 0;
        for (Tree.PositionalArgument expr : args) {
            if (expr == seqarg) {
                gen.out("}return ", gen.getClAlias(), "finished();},function(){return ");
                if (gen.isInDynamicBlock() && expr instanceof Tree.SpreadArgument && ModelUtil.isTypeUnknown(expr.getTypeModel())) {
                    TypeUtils.spreadArrayCheck(((Tree.SpreadArgument)expr).getExpression(), gen);
                } else {
                    expr.visit(gen);
                }
                gen.out(";},", new String[0]);
            } else {
                gen.out("case ", Integer.toString(count), ":return ");
                expr.visit(gen);
                gen.out(";", new String[0]);
            }
            ++count;
        }
        if (seqarg == null) {
            gen.out("}return ", gen.getClAlias(), "finished();},undefined,");
        }
        TypeUtils.printTypeArguments(node, seqType.getTypeArguments(), gen, false, seqType.getVarianceOverrides());
        gen.out(")", new String[0]);
    }

    static void sequenceEnumeration(Tree.SequenceEnumeration that, GenerateJsVisitor gen) {
        Tree.SequencedArgument sarg = that.getSequencedArgument();
        if (sarg == null) {
            gen.out(gen.getClAlias(), "empty()");
        } else {
            List<Tree.PositionalArgument> positionalArguments = sarg.getPositionalArguments();
            boolean spread = SequenceGenerator.isSpread(positionalArguments);
            boolean canBeEager = SequenceGenerator.allLiterals(positionalArguments);
            boolean wantsIter = false;
            if (spread || !canBeEager) {
                SequenceGenerator.lazyEnumeration(positionalArguments, that, that.getTypeModel(), spread, gen);
                return;
            }
            if (that.getTypeModel().isSequential()) {
                gen.out(gen.getClAlias(), "$arr$sa$([");
            } else {
                gen.out(gen.getClAlias(), "sarg$(", gen.getClAlias(), "$lai$([");
                wantsIter = true;
            }
            int count = 0;
            for (Tree.PositionalArgument expr : positionalArguments) {
                if (count > 0) {
                    gen.out(",", new String[0]);
                }
                if (gen.isInDynamicBlock() && expr instanceof Tree.ListedArgument && ModelUtil.isTypeUnknown(expr.getTypeModel()) && expr.getParameter() != null && !ModelUtil.isTypeUnknown(expr.getParameter().getType())) {
                    TypeUtils.generateDynamicCheck(((Tree.ListedArgument)expr).getExpression(), expr.getParameter().getType(), gen, false, that.getTypeModel().getTypeArguments());
                } else {
                    expr.visit(gen);
                }
                ++count;
            }
            SequenceGenerator.closeSequenceWithReifiedType(that, that.getTypeModel().getTypeArguments(), gen, wantsIter);
        }
    }

    static void sequencedArgument(Tree.SequencedArgument that, GenerateJsVisitor gen) {
        List<Tree.PositionalArgument> positionalArguments = that.getPositionalArguments();
        boolean spread = SequenceGenerator.isSpread(positionalArguments);
        if (!spread) {
            gen.out("[", new String[0]);
        }
        boolean first = true;
        for (Tree.PositionalArgument arg : positionalArguments) {
            if (!first) {
                gen.out(",", new String[0]);
            }
            if (arg instanceof Tree.ListedArgument) {
                ((Tree.ListedArgument)arg).getExpression().visit(gen);
            } else if (arg instanceof Tree.SpreadArgument) {
                ((Tree.SpreadArgument)arg).getExpression().visit(gen);
            } else {
                arg.visit(gen);
            }
            first = false;
        }
        if (!spread) {
            gen.out("]", new String[0]);
        }
    }

    static void generateSpread(Tree.QualifiedMemberOrTypeExpression that, GenerateJsVisitor gen) {
        boolean isMethod = that.getDeclaration() instanceof Functional;
        if (isMethod) {
            gen.out(gen.getClAlias(), "JsCallableList(");
            gen.supervisit(that);
            gen.out(",function(e,a){return ", gen.memberAccess(that, "e"), ".apply(e,a);},");
            if (that.getTypeArguments() != null && that.getTypeArguments().getTypeModels() != null && !that.getTypeArguments().getTypeModels().isEmpty()) {
                TypeUtils.printTypeArguments(that, TypeUtils.matchTypeParametersWithArguments(((Generic)((Object)that.getDeclaration())).getTypeParameters(), that.getTypeArguments().getTypeModels()), gen, true, null);
            } else {
                gen.out("undefined", new String[0]);
            }
            gen.out(",", new String[0]);
            if (that.getTypeModel() != null && that.getTypeModel().isCallable()) {
                TypeUtils.typeNameOrList(that, that.getTypeModel().getTypeArgumentList().get(0).getTypeArgumentList().get(0), gen, false);
            } else {
                TypeUtils.typeNameOrList(that, that.getTypeModel(), gen, false);
            }
            gen.out(")", new String[0]);
        } else {
            gen.supervisit(that);
            gen.out(".collect(function(e){return ", gen.memberAccess(that, "e"), ";},{Result$collect:");
            TypeUtils.typeNameOrList(that, that.getTypeModel().getTypeArgumentList().get(0), gen, false);
            gen.out("})", new String[0]);
        }
    }

    static boolean isSpread(List<Tree.PositionalArgument> args) {
        return !args.isEmpty() && !(args.get(args.size() - 1) instanceof Tree.ListedArgument);
    }

    static boolean allLiterals(List<Tree.PositionalArgument> args) {
        for (Tree.PositionalArgument a : args) {
            if (a instanceof Tree.ListedArgument) {
                if (((Tree.ListedArgument)a).getExpression().getTerm() instanceof Tree.Literal) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    static void closeSequenceWithReifiedType(Node that, Map<TypeParameter, Type> types, GenerateJsVisitor gen, boolean wantsIterable) {
        if (wantsIterable) {
            gen.out("]),undefined,{Element$Iterable:", new String[0]);
        } else {
            gen.out("],", new String[0]);
        }
        boolean nonempty = false;
        Type elem = null;
        for (Map.Entry<TypeParameter, Type> e : types.entrySet()) {
            if (e.getKey().getName().equals("Element")) {
                elem = e.getValue();
                continue;
            }
            if (!e.getKey().equals(that.getUnit().getIterableDeclaration().getTypeParameters().get(1))) continue;
            nonempty = e.getValue().isNothing();
        }
        if (elem == null) {
            gen.out("/*WARNING no Element found* /", new String[0]);
            elem = that.getUnit().getAnythingType();
        }
        TypeUtils.typeNameOrList(that, elem, gen, false);
        if (wantsIterable) {
            gen.out(",Absent$Iterable:{t:", gen.getClAlias(), nonempty ? "Nothing}}" : "Null}}");
        }
        if (nonempty) {
            gen.out(",1", new String[0]);
        }
        gen.out(")", new String[0]);
    }

    static void tuple(Tree.Tuple that, GenerateJsVisitor gen) {
        Tree.SequencedArgument sarg = that.getSequencedArgument();
        if (sarg == null) {
            gen.out(gen.getClAlias(), "empty()");
        } else {
            List<Tree.PositionalArgument> positionalArguments = sarg.getPositionalArguments();
            boolean spread = SequenceGenerator.isSpread(positionalArguments);
            int lim = positionalArguments.size() - 1;
            gen.out(gen.getClAlias(), "tpl$([");
            int count = 0;
            for (Tree.PositionalArgument expr : positionalArguments) {
                if (count != lim || !spread) {
                    if (count > 0) {
                        gen.out(",", new String[0]);
                    }
                    expr.visit(gen);
                }
                ++count;
            }
            gen.out("]", new String[0]);
            if (spread) {
                gen.out(",", new String[0]);
                positionalArguments.get(lim).visit(gen);
            }
            gen.out(")", new String[0]);
        }
    }
}

