/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.CompilerErrorException;
import com.redhat.ceylon.compiler.js.JsCompiler;
import com.redhat.ceylon.compiler.js.loader.MetamodelVisitor;
import com.redhat.ceylon.compiler.js.loader.ModelEncoder;
import com.redhat.ceylon.compiler.js.loader.NpmAware;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.js.util.JsWriter;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JsOutput {
    private File outfile;
    private File modfile;
    private Writer writer;
    protected String clalias = "";
    protected final Module module;
    protected boolean modelDone;
    private final Set<File> s = new HashSet<File>();
    final Map<String, String> requires = new HashMap<String, String>();
    public final MetamodelVisitor mmg;
    private static final String encoding = "UTF-8";
    private JsWriter jsw;
    private final boolean compilingLanguageModule;

    public JsOutput(Module m, boolean compilingLanguageModule) throws IOException {
        this.module = m;
        this.compilingLanguageModule = compilingLanguageModule;
        this.mmg = m == null ? null : new MetamodelVisitor(m);
    }

    public void setJsWriter(JsWriter value) {
        this.jsw = value;
    }

    public Writer getWriter() throws IOException {
        if (this.writer == null) {
            this.outfile = File.createTempFile("ceylon-jsout-", ".tmp");
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outfile), encoding);
        }
        return this.writer;
    }

    public File close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        return this.outfile;
    }

    public File getModelFile() {
        return this.modfile;
    }

    public void addSource(File src) {
        this.s.add(src);
    }

    public Set<File> getSources() {
        return this.s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeModelFile() throws IOException {
        this.modfile = File.createTempFile("ceylon-jsmod-", ".tmp");
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.modfile), encoding);){
            JsCompiler.beginWrapper(fw);
            fw.write("ex$.$CCMM$=");
            ModelEncoder.encodeModel(this.mmg.getModel(), fw);
            fw.write(";\n");
            JsCompiler.endWrapper(fw);
        }
    }

    protected void writeModelRetriever() throws IOException {
        this.out("require('", JsCompiler.scriptPath(this.module), "-model').$CCMM$");
    }

    public void encodeModel(JsIdentifierNames names) throws IOException {
        if (!this.modelDone) {
            this.modelDone = true;
            this.writeModelFile();
            this.out("\nvar _CTM$;function $CCMM$(){if (_CTM$===undefined)_CTM$=", new String[0]);
            this.writeModelRetriever();
            this.out(";return _CTM$;}\n", new String[0]);
            this.out("ex$.$CCMM$=$CCMM$;\n", new String[0]);
            if (!this.compilingLanguageModule) {
                Module clm = this.module.getLanguageModule();
                this.clalias = names.moduleAlias(clm) + ".";
                this.require(clm, names);
                this.out(this.clalias, "$addmod$(ex$,'", this.module.getNameAsString(), "/", this.module.getVersion(), "');\n");
            }
        }
    }

    public void outputFile(File f) {
        try (FileReader in = new FileReader(f);){
            this.outputFile(in);
        }
        catch (IOException ex) {
            throw new CompilerErrorException("Reading from " + f);
        }
    }

    public void outputFile(VirtualFile f) {
        try {
            this.outputFile(new InputStreamReader(f.getInputStream()));
        }
        catch (IOException ex) {
            throw new CompilerErrorException("Reading from " + f);
        }
    }

    public void outputFile(Reader in) throws IOException {
        try (BufferedReader r = new BufferedReader(in);){
            String line = null;
            while ((line = r.readLine()) != null) {
                String c = line.trim();
                if (c.isEmpty()) continue;
                this.out(c, "\n");
            }
        }
    }

    public String getLanguageModuleAlias() {
        return this.clalias;
    }

    public void requireFromNpm(Module mod, JsIdentifierNames names) {
        String modAlias = names.moduleAlias(mod);
        String path = ((NpmAware)((Object)mod)).getNpmPath();
        if (this.requires.put(path, modAlias) == null) {
            String singleFunctionName = mod.getNameAsString();
            int dashIdx = singleFunctionName.indexOf(45);
            while (dashIdx > 0) {
                singleFunctionName = singleFunctionName.substring(0, dashIdx) + Character.toUpperCase(singleFunctionName.charAt(dashIdx + 1)) + singleFunctionName.substring(dashIdx + 2);
                dashIdx = singleFunctionName.indexOf(45, dashIdx);
            }
            this.out("var ", modAlias, "=", "(", this.getLanguageModuleAlias(), "run$isNode())?", this.getLanguageModuleAlias(), "npm$req('", singleFunctionName, "','", path, "',require):require('", JsCompiler.scriptPath(mod), "');\n");
            if (modAlias != null && !modAlias.isEmpty()) {
                this.out(this.clalias, "$addmod$(", modAlias, ",'", mod.getNameAsString(), "/", mod.getVersion(), "');\n");
            }
        }
    }

    public void require(Module mod, JsIdentifierNames names) {
        String modAlias;
        String path = JsCompiler.scriptPath(mod);
        if (this.requires.put(path, modAlias = names.moduleAlias(mod)) == null) {
            this.out("var ", modAlias, "=require('", path, "');\n");
            if (modAlias != null && !modAlias.isEmpty()) {
                this.out(this.clalias, "$addmod$(", modAlias, ",'", mod.getNameAsString(), "/", mod.getVersion(), "');\n");
            }
        }
    }

    public void out(String code, String ... codez) {
        if (this.jsw != null) {
            this.jsw.write(code, codez);
            return;
        }
        try {
            this.getWriter().write(code);
            for (String s : codez) {
                this.getWriter().write(s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Generating JS code", ioe);
        }
    }

    public void publishUnsharedDeclarations(JsIdentifierNames names) {
        for (Package pkg : this.module.getPackages()) {
            ArrayList<Declaration> unsharedDecls = new ArrayList<Declaration>(pkg.getMembers().size());
            for (Declaration d : pkg.getMembers()) {
                if (d.isShared() || d.isAnonymous() && d.getName() != null && d.getName().startsWith("anonymous#") || d.isNative() && !d.getNativeBackends().supports(Backend.JavaScript)) continue;
                unsharedDecls.add(d);
            }
            if (unsharedDecls.isEmpty()) continue;
            this.out("ex$.$pkgunsh$", pkg.getNameAsString().replace('.', '$'), "={");
            boolean first = true;
            for (Declaration d : unsharedDecls) {
                if (d.getName() == null || d.isAnonymous()) continue;
                if (d instanceof Setter) {
                    if (((Setter)d).getGetter() != null) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.out(",", new String[0]);
                    }
                    this.out("'", d.getName(), "':", names.setter(d));
                    continue;
                }
                if (d instanceof Value) {
                    if (first) {
                        first = false;
                    } else {
                        this.out(",", new String[0]);
                    }
                    this.out("'", d.getName(), "':", names.getter(d, true));
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    this.out(",", new String[0]);
                }
                this.out("'", d.getName(), "':", names.name(d));
            }
            this.out("};\n", new String[0]);
        }
    }

    public void openWrapper() throws IOException {
        JsCompiler.beginWrapper(this.getWriter());
        JsCompiler.requireWrapper(this.getWriter(), this.module);
    }

    public void closeWrapper() throws IOException {
        JsCompiler.endWrapper(this.writer);
    }
}

