/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.loader.NpmAware;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minidev.json.JSONObject;

public class NpmDescriptorGenerator {
    private final Module mod;
    private final boolean src;
    private final boolean resources;

    public NpmDescriptorGenerator(Module module, boolean withSources, boolean withResources) {
        this.mod = module;
        this.src = withSources;
        this.resources = withResources;
    }

    public String generateDescriptor() throws IOException {
        HashMap<String, Object> desc = new HashMap<String, Object>();
        if (this.mod instanceof NpmAware && ((NpmAware)((Object)this.mod)).getNpmPath() != null) {
            desc.put("name", ((NpmAware)((Object)this.mod)).getNpmPath());
        } else {
            desc.put("name", this.mod.getNameAsString());
        }
        desc.put("version", this.mod.getVersion());
        for (Annotation ann : this.mod.getAnnotations()) {
            List<String> args = ann.getPositionalArguments();
            if ("doc".equals(ann.getName())) {
                desc.put("description", args.get(0));
                continue;
            }
            if ("license".equals(ann.getName())) {
                desc.put("license", args.get(0));
                continue;
            }
            if (!"by".equals(ann.getName()) || args.isEmpty()) continue;
            desc.put("author", args.get(0));
            desc.put("contributors", args);
        }
        if (!this.mod.getImports().isEmpty()) {
            HashMap<String, String> deps = new HashMap<String, String>(this.mod.getImports().size());
            HashMap<String, String> opts = new HashMap<String, String>(this.mod.getImports().size());
            for (ModuleImport imp : this.mod.getImports()) {
                if (imp.isOptional()) {
                    opts.put(imp.getModule().getNameAsString(), imp.getModule().getVersion());
                    continue;
                }
                if (imp.isNative() && !imp.getNativeBackends().supports(Backend.JavaScript)) continue;
                deps.put(imp.getModule().getNameAsString(), imp.getModule().getVersion());
            }
            if (!deps.isEmpty()) {
                desc.put("dependencies", deps);
            }
            if (!opts.isEmpty()) {
                desc.put("optionalDependencies", opts);
            }
        }
        ArrayList<String> files = new ArrayList<String>((this.src ? 6 : 4) + (this.resources ? 1 : 0));
        String modName = this.mod.getNameAsString() + "-" + this.mod.getVersion();
        files.add(modName + ".js");
        files.add(modName + ".js" + ".sha1");
        files.add(modName + "-model.js");
        files.add(modName + "-model.js" + ".sha1");
        if (this.src) {
            files.add(modName + ".src");
            files.add(modName + ".src" + ".sha1");
        }
        if (this.resources) {
            files.add("module-resources");
        }
        desc.put("files", files);
        StringWriter sw = new StringWriter();
        JSONObject.writeJSON(desc, sw);
        return sw.toString();
    }
}

