/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.js.DiagnosticListener;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class Options {
    private File cwd;
    private List<String> repos = new ArrayList<String>();
    private String systemRepo;
    private String user;
    private String pass;
    private List<File> srcDirs = new ArrayList<File>();
    private List<File> resourceDirs = new ArrayList<File>();
    private String resourceRoot = DefaultToolOptions.getCompilerResourceRootName();
    private String outRepo = DefaultToolOptions.getCompilerOutputRepo();
    private boolean optimize = true;
    private boolean modulify = true;
    private boolean comment = true;
    private String verbose;
    private boolean profile;
    private boolean help;
    private boolean version;
    private boolean stdin;
    private boolean gensrc = true;
    private boolean offline;
    private boolean srcmap;
    private boolean minify;
    private String encoding = System.getProperty("file.encoding");
    private String includeDependencies;
    private Logger logger;
    private Writer outWriter;
    private DiagnosticListener diagnosticListener;
    private EnumSet<Warning> suppwarns;

    public static List<String> findRepos(List<String> args, boolean remove) {
        ArrayList<String> repos = new ArrayList<String>(args.size() / 2);
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (!"-rep".equals(s)) continue;
            if (remove) {
                iter.remove();
            }
            if (!iter.hasNext()) continue;
            s = iter.next();
            repos.add(s);
            if (!remove) continue;
            iter.remove();
        }
        return repos;
    }

    public static String findOptionValue(String optionName, List<String> args, boolean remove) {
        int idx = args.indexOf(optionName);
        if (idx >= 0 && idx < args.size() - 2 && !args.get(idx + 1).startsWith("-")) {
            if (remove) {
                args.remove(idx);
                return args.remove(idx);
            }
            return args.get(idx + 1);
        }
        return null;
    }

    public static boolean findOption(String name, List<String> args, boolean remove) {
        int idx = args.indexOf(name);
        if (idx >= 0) {
            if (remove) {
                args.remove(idx);
            }
            return true;
        }
        return false;
    }

    public File getCwd() {
        return this.cwd;
    }

    public Options cwd(File cwd) {
        this.cwd = cwd;
        return this;
    }

    public List<String> getRepos() {
        return this.repos;
    }

    public Options addRepo(String repo) {
        this.repos.add(repo);
        return this;
    }

    public Options repos(List<String> repos) {
        this.repos.addAll(repos);
        return this;
    }

    public String getSystemRepo() {
        return this.systemRepo;
    }

    public Options systemRepo(String systemRepo) {
        this.systemRepo = systemRepo;
        return this;
    }

    public boolean getOffline() {
        return this.offline;
    }

    public Options offline(boolean flag) {
        this.offline = flag;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public Options user(String user) {
        this.user = user;
        return this;
    }

    public String getPass() {
        return this.pass;
    }

    public Options pass(String pass) {
        this.pass = pass;
        return this;
    }

    public List<File> getSrcDirs() {
        return this.srcDirs;
    }

    public Options addSrcDir(String src) {
        this.srcDirs.add(new File(src));
        return this;
    }

    public Options addSrcDir(File src) {
        this.srcDirs.add(src);
        return this;
    }

    public Options sourceDirs(List<File> srcs) {
        this.srcDirs.addAll(srcs);
        return this;
    }

    public String getOutRepo() {
        return this.outRepo;
    }

    public Options outRepo(String outRepo) {
        this.outRepo = outRepo;
        return this;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public Options optimize(boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    public boolean isModulify() {
        return this.modulify;
    }

    public Options modulify(boolean modulify) {
        this.modulify = modulify;
        return this;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public Options minify(boolean flag) {
        this.minify = flag;
        return this;
    }

    public boolean isSourceMaps() {
        return this.srcmap;
    }

    public Options sourceMaps(boolean flag) {
        this.srcmap = flag;
        return this;
    }

    @Deprecated
    public boolean isIndent() {
        return false;
    }

    @Deprecated
    public Options indent(boolean indent) {
        return this;
    }

    public boolean isComment() {
        return this.comment;
    }

    public Options comment(boolean comment) {
        this.comment = comment;
        return this;
    }

    public String getVerbose() {
        return this.verbose;
    }

    public Options verbose(String verbose) {
        this.verbose = verbose;
        return this;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public Options profile(boolean profile) {
        this.profile = profile;
        return this;
    }

    public boolean isVersion() {
        return this.version;
    }

    public Options version(boolean version2) {
        this.version = version2;
        return this;
    }

    public boolean isStdin() {
        return this.stdin;
    }

    public Options stdin(boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    public boolean isHelp() {
        return this.help;
    }

    public Options help(boolean help) {
        this.help = help;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Options encoding(String encoding) {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        this.encoding = encoding;
        return this;
    }

    public String getIncludeDependencies() {
        return this.includeDependencies;
    }

    public Options includeDependencies(String includeDependencies) {
        this.includeDependencies = includeDependencies;
        return this;
    }

    public Options generateSourceArchive(boolean flag) {
        this.gensrc = flag;
        return this;
    }

    public boolean isGenerateSourceArchive() {
        return this.gensrc;
    }

    public boolean isVerbose() {
        return this.hasVerboseFlag("");
    }

    public boolean hasVerboseFlag(String flag) {
        if (this.verbose == null) {
            return false;
        }
        if (this.verbose.isEmpty()) {
            return true;
        }
        List<String> lst = Arrays.asList(this.verbose.split(","));
        if (lst.contains("all")) {
            return true;
        }
        return lst.contains(flag);
    }

    public Options resourceRootName(String resourceRootName) {
        this.resourceRoot = resourceRootName;
        return this;
    }

    public String getResourceRootName() {
        return this.resourceRoot;
    }

    public Options resourceDirs(List<File> value) {
        this.resourceDirs.clear();
        this.resourceDirs.addAll(value);
        return this;
    }

    public List<File> getResourceDirs() {
        return this.resourceDirs;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Options logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Writer getOutWriter() {
        return this.outWriter;
    }

    public Options outWriter(Writer outWriter) {
        this.outWriter = outWriter;
        return this;
    }

    public DiagnosticListener getDiagnosticListener() {
        return this.diagnosticListener;
    }

    public Options diagnosticListener(DiagnosticListener diagnosticListener) {
        this.diagnosticListener = diagnosticListener;
        return this;
    }

    public Options suppressWarnings(EnumSet<Warning> value) {
        this.suppwarns = value;
        return this;
    }

    public EnumSet<Warning> getSuppressWarnings() {
        return this.suppwarns;
    }
}

