/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker;

import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleValidator;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.io.VFS;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.util.AssertionVisitor;
import com.redhat.ceylon.compiler.typechecker.util.ModuleManagerFactory;
import com.redhat.ceylon.compiler.typechecker.util.StatisticsVisitor;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.util.List;

public class TypeChecker {
    public static final String LANGUAGE_MODULE_VERSION = "1.3.2";
    private final boolean verbose;
    private final boolean statistics;
    private final Context context;
    private final PhasedUnits phasedUnits;
    private List<PhasedUnits> phasedUnitsOfDependencies;
    private final boolean verifyDependencies;
    private final AssertionVisitor assertionVisitor;
    private final StatisticsVisitor statsVisitor;

    TypeChecker(VFS vfs, List<VirtualFile> srcDirectories, RepositoryManager repositoryManager, boolean verifyDependencies, AssertionVisitor assertionVisitor, ModuleManagerFactory moduleManagerFactory, boolean verbose, boolean statistics, List<String> moduleFilters, List<VirtualFile> srcFiles, String encoding) {
        long start = System.nanoTime();
        this.verbose = verbose;
        this.statistics = statistics;
        this.context = new Context(repositoryManager, vfs);
        this.phasedUnits = new PhasedUnits(this.context, moduleManagerFactory);
        this.verifyDependencies = verifyDependencies;
        this.assertionVisitor = assertionVisitor;
        this.statsVisitor = new StatisticsVisitor();
        this.phasedUnits.setSourceFiles(srcFiles);
        this.phasedUnits.setModuleFilters(moduleFilters);
        this.phasedUnits.setEncoding(encoding);
        this.phasedUnits.parseUnits(srcDirectories);
        long time = System.nanoTime() - start;
        if (statistics) {
            System.out.println("Parsed in " + time / 1000000L + " ms");
        }
    }

    public PhasedUnits getPhasedUnits() {
        return this.phasedUnits;
    }

    public List<PhasedUnits> getPhasedUnitsOfDependencies() {
        return this.phasedUnitsOfDependencies;
    }

    public void setPhasedUnitsOfDependencies(List<PhasedUnits> phasedUnitsOfDependencies) {
        this.phasedUnitsOfDependencies = phasedUnitsOfDependencies;
    }

    public Context getContext() {
        return this.context;
    }

    public PhasedUnit getPhasedUnitFromRelativePath(String relativePath) {
        Object phasedUnit = this.phasedUnits.getPhasedUnitFromRelativePath(relativePath);
        if (phasedUnit == null) {
            for (PhasedUnits units : this.phasedUnitsOfDependencies) {
                phasedUnit = units.getPhasedUnitFromRelativePath(relativePath);
                if (phasedUnit == null) continue;
                return phasedUnit;
            }
            return null;
        }
        return phasedUnit;
    }

    public PhasedUnit getPhasedUnit(VirtualFile file) {
        Object phasedUnit = this.phasedUnits.getPhasedUnit(file);
        if (phasedUnit == null) {
            for (PhasedUnits units : this.phasedUnitsOfDependencies) {
                phasedUnit = units.getPhasedUnit(file);
                if (phasedUnit == null) continue;
                return phasedUnit;
            }
            return null;
        }
        return phasedUnit;
    }

    public void process() throws RuntimeException {
        this.process(false);
    }

    public void process(boolean forceSilence) throws RuntimeException {
        long start = System.nanoTime();
        this.executePhases(this.phasedUnits, forceSilence);
        long time = System.nanoTime() - start;
        if (this.statistics) {
            System.out.println("Type checked in " + time / 1000000L + " ms");
        }
    }

    private void executePhases(PhasedUnits phasedUnits, boolean forceSilence) {
        List<PhasedUnit> listOfUnits = phasedUnits.getPhasedUnits();
        phasedUnits.getModuleManager().prepareForTypeChecking();
        phasedUnits.visitModules();
        phasedUnits.getModuleManager().modulesVisited();
        Module languageModule = this.context.getModules().getLanguageModule();
        if (languageModule.getVersion() == null) {
            languageModule.setVersion(LANGUAGE_MODULE_VERSION);
        }
        ModuleValidator moduleValidator = new ModuleValidator(this.context, phasedUnits);
        if (this.verifyDependencies) {
            moduleValidator.verifyModuleDependencyTree();
        }
        this.phasedUnitsOfDependencies = moduleValidator.getPhasedUnitsOfDependencies();
        this.executePhases(listOfUnits);
        if (!forceSilence) {
            for (PhasedUnit pu : listOfUnits) {
                if (this.verbose) {
                    pu.display();
                }
                pu.generateStatistics(this.statsVisitor);
                pu.runAssertions(this.assertionVisitor);
            }
            if (this.verbose || this.statistics) {
                this.statsVisitor.print();
            }
            this.assertionVisitor.print(this.verbose);
        }
    }

    protected void executePhases(List<PhasedUnit> listOfUnits) {
        for (PhasedUnit pu : listOfUnits) {
            pu.validateTree();
            pu.scanDeclarations();
        }
        for (PhasedUnit pu : listOfUnits) {
            pu.scanTypeDeclarations();
        }
        for (PhasedUnit pu : listOfUnits) {
            pu.validateRefinement();
        }
        for (PhasedUnit pu : listOfUnits) {
            pu.analyseTypes();
        }
        for (PhasedUnit pu : listOfUnits) {
            pu.analyseFlow();
        }
        for (PhasedUnit pu : listOfUnits) {
            pu.analyseUsage();
        }
    }

    public int getErrors() {
        return this.assertionVisitor.getErrors();
    }

    public int getWarnings() {
        return this.assertionVisitor.getWarnings();
    }

    public List<Message> getMessages() {
        return this.assertionVisitor.getFoundErrors();
    }
}

