/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class InheritanceVisitor
extends Visitor {
    @Override
    public void visit(Tree.TypeDeclaration that) {
        this.validateSupertypes(that, that.getDeclarationModel());
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        this.validateSupertypes(that, that.getDeclarationModel().getType().getDeclaration());
        super.visit(that);
        this.validateEnumeratedSupertypes(that, that.getAnonymousClass());
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        this.validateSupertypes(that, that.getAnonymousClass());
        super.visit(that);
        this.validateEnumeratedSupertypes(that, that.getAnonymousClass());
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        this.validateSupertypes(that, that.getAnonymousClass());
        super.visit(that);
        this.validateEnumeratedSupertypes(that, that.getAnonymousClass());
    }

    @Override
    public void visit(Tree.TypeConstraint that) {
        super.visit(that);
        this.validateUpperBounds(that, that.getDeclarationModel());
    }

    @Override
    public void visit(Tree.ClassOrInterface that) {
        super.visit(that);
        this.validateEnumeratedSupertypeArguments(that, that.getDeclarationModel());
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        super.visit(that);
        this.validateEnumeratedSupertypes(that, that.getDeclarationModel());
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        super.visit(that);
        this.validateEnumeratedSupertypes(that, that.getDeclarationModel());
    }

    private void validateSupertypes(Node that, TypeDeclaration td) {
        if (!(td instanceof TypeAlias)) {
            List<Type> supertypes = td.getType().getSupertypes();
            for (int i = 0; i < supertypes.size(); ++i) {
                Type st1 = supertypes.get(i);
                for (int j = i + 1; j < supertypes.size(); ++j) {
                    Type st2 = supertypes.get(j);
                    this.checkSupertypeIntersection(that, td, st1, st2);
                }
            }
        }
    }

    private void checkSupertypeIntersection(Node that, TypeDeclaration td, Type st1, Type st2) {
        Unit unit;
        TypeDeclaration st2d;
        TypeDeclaration st1d = st1.getDeclaration();
        if (st1d.equals(st2d = st2.getDeclaration()) && !ModelUtil.areConsistentSupertypes(st1, st2, unit = that.getUnit())) {
            that.addError(AnalyzerUtil.typeDescription(td, unit) + " has the same parameterized supertype twice with incompatible type arguments: '" + st1.asString(unit) + " & " + st2.asString(unit) + "'");
            td.setInconsistentType(true);
        }
    }

    private void validateUpperBounds(Tree.TypeConstraint that, TypeDeclaration td) {
        if (!td.isInconsistentType()) {
            Unit unit = that.getUnit();
            List<Type> upperBounds = td.getSatisfiedTypes();
            ArrayList<Type> list = new ArrayList<Type>(upperBounds.size());
            for (Type st : upperBounds) {
                ModelUtil.addToIntersection(list, st, unit);
            }
            if (ModelUtil.canonicalIntersection(list, unit).isNothing()) {
                that.addError(AnalyzerUtil.typeDescription(td, unit) + " has unsatisfiable upper bound constraints: the constraints '" + AnalyzerUtil.typeNamesAsIntersection(upperBounds, unit) + "' cannot be satisfied by any type except 'Nothing'");
            }
        }
    }

    private void validateEnumeratedSupertypes(Node that, ClassOrInterface d) {
        Type superclass;
        Type type = d.getType();
        Unit unit = that.getUnit();
        if (d instanceof Class && (superclass = d.getExtendedType()) != null && superclass.isAnything() && !type.isObject() && !type.isNull()) {
            that.addError("not a subtype of any case of root type: '" + d.getName(unit) + "' directly inherits 'Anything'");
        }
        for (Type supertype : type.getSupertypes()) {
            TypeDeclaration std;
            List<Type> cts;
            if (type.isExactly(supertype) || (cts = (std = supertype.getDeclaration()).getCaseTypes()) == null || cts.isEmpty() || cts.size() == 1 && cts.get(0).getDeclaration().isSelfType()) continue;
            ArrayList<Type> types = new ArrayList<Type>(cts.size());
            for (Type ct : cts) {
                TypeDeclaration ctd = ct.resolveAliases().getDeclaration();
                Type cst = type.getSupertype(ctd);
                if (cst == null) continue;
                types.add(cst);
            }
            if (types.isEmpty()) {
                that.addError("type is not a subtype of any case of enumerated supertype: '" + d.getName(unit) + "' inherits '" + std.getName(unit) + "'");
                continue;
            }
            if (types.size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            for (Type pt : types) {
                sb.append("'").append(pt.asString(unit)).append("' and ");
            }
            sb.setLength(sb.length() - 5);
            that.addError("type is a subtype of multiple cases of enumerated supertype '" + std.getName(unit) + "': '" + d.getName(unit) + "' inherits " + sb);
        }
    }

    private void validateEnumeratedSupertypeArguments(Node that, ClassOrInterface classOrInterface) {
        Type type = classOrInterface.getType();
        block0: for (Type supertype : type.getSupertypes()) {
            List<Type> cts;
            if (type.isExactly(supertype) || (cts = supertype.getDeclaration().getCaseTypes()) == null) continue;
            for (Type ct : cts) {
                if (!ct.getDeclaration().equals(classOrInterface)) continue;
                this.validateEnumeratedSupertypeArguments(that, classOrInterface, supertype);
                continue block0;
            }
        }
    }

    private void validateEnumeratedSupertypeArguments(Node that, TypeDeclaration type, Type supertype) {
        List<TypeParameter> params = supertype.getDeclaration().getTypeParameters();
        Map<TypeParameter, Type> typeArguments = supertype.getTypeArguments();
        for (TypeParameter param : params) {
            Type arg = typeArguments.get(param);
            if (arg == null) continue;
            this.validateEnumeratedSupertypeArgument(that, type, supertype, param, arg);
        }
    }

    private void validateEnumeratedSupertypeArgument(Node that, TypeDeclaration type, Type supertype, TypeParameter tp, Type arg) {
        Unit unit = that.getUnit();
        if (arg.isTypeParameter()) {
            TypeParameter atp = (TypeParameter)arg.getDeclaration();
            if (atp.getDeclaration().equals(type)) {
                if (tp.isCovariant() && !atp.isCovariant()) {
                    that.addError("argument to covariant type parameter of enumerated supertype must be covariant: " + AnalyzerUtil.typeDescription(tp, unit));
                }
                if (tp.isContravariant() && !atp.isContravariant()) {
                    that.addError("argument to contravariant type parameter of enumerated supertype must be contravariant: " + AnalyzerUtil.typeDescription(tp, unit));
                }
            } else {
                that.addError("argument to type parameter of enumerated supertype must be a type parameter of '" + type.getName() + "': " + AnalyzerUtil.typeDescription(tp, unit));
            }
        } else if (tp.isCovariant()) {
            if (!arg.isNothing()) {
                that.addError("argument to covariant type parameter of enumerated supertype must be a type parameter or 'Nothing': " + AnalyzerUtil.typeDescription(tp, unit));
            }
        } else if (tp.isContravariant()) {
            List<Type> sts = tp.getSatisfiedTypes();
            Type ub = ModelUtil.intersectionOfSupertypes(tp);
            if (!arg.isExactly(ub)) {
                that.addError("argument to contravariant type parameter of enumerated supertype must be a type parameter or '" + AnalyzerUtil.typeNamesAsIntersection(sts, unit) + "': " + AnalyzerUtil.typeDescription(tp, unit));
            }
        } else {
            that.addError("argument to type parameter of enumerated supertype must be a type parameter: " + AnalyzerUtil.typeDescription(tp, unit));
        }
    }

    @Override
    public void visit(Tree.ExtendedType that) {
        Tree.SimpleType et;
        super.visit(that);
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        if (!td.isAlias() && (et = that.getType()) != null) {
            Tree.InvocationExpression ie = that.getInvocationExpression();
            Class clazz = (Class)td;
            boolean hasConstructors = clazz.hasConstructors() || clazz.hasEnumerated();
            boolean anonymous = clazz.isAnonymous();
            if (ie == null) {
                if (!hasConstructors || anonymous) {
                    et.addError("missing instantiation arguments");
                }
            } else if (hasConstructors && !anonymous) {
                et.addError("unnecessary instantiation arguments");
            }
            Unit unit = that.getUnit();
            Type type = et.getTypeModel();
            if (type != null) {
                this.checkSelfTypes(et, td, type);
                this.checkExtensionOfMemberType(et, td, type);
                Type ext = td.getExtendedType();
                TypeDeclaration etd = ext == null ? null : ext.getDeclaration();
                TypeDeclaration aetd = type.getDeclaration();
                if (aetd instanceof Constructor && aetd.isAbstract()) {
                    et.addError("extends a partial constructor: '" + aetd.getName(unit) + "' is declared abstract");
                }
                while (etd != null && etd.isAlias()) {
                    Type etdet = etd.getExtendedType();
                    etd = etdet == null ? null : etdet.getDeclaration();
                }
                if (etd != null) {
                    if (etd.isFinal()) {
                        et.addError("extends a final class: '" + etd.getName(unit) + "' is declared final");
                    }
                    if (etd.isSealed() && !AnalyzerUtil.inSameModule(etd, unit)) {
                        String moduleName = etd.getUnit().getPackage().getModule().getNameAsString();
                        et.addError("extends a sealed class in a different module: '" + etd.getName(unit) + "' in '" + moduleName + "' is sealed");
                    }
                }
            }
            this.checkSupertypeVarianceAnnotations(et);
        }
    }

    @Override
    public void visit(Tree.SatisfiedTypes that) {
        super.visit(that);
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        if (td.isAlias()) {
            return;
        }
        HashSet<TypeDeclaration> set = new HashSet<TypeDeclaration>();
        if (td.getSatisfiedTypes().isEmpty()) {
            return;
        }
        Unit unit = that.getUnit();
        for (Tree.StaticType t : that.getTypes()) {
            Type type = t.getTypeModel();
            if (!ModelUtil.isTypeUnknown(type) && type.isClassOrInterface()) {
                TypeDeclaration std;
                type = type.resolveAliases();
                TypeDeclaration dec = type.getDeclaration();
                if (td instanceof ClassOrInterface && !unit.getPackage().getModule().isLanguageModule()) {
                    TypeDeclaration cad;
                    if (unit.isCallableType(type)) {
                        t.addError("satisfies 'Callable'");
                    }
                    if (dec.equals(cad = unit.getConstrainedAnnotationDeclaration())) {
                        t.addError("directly satisfies 'ConstrainedAnnotation'");
                    }
                }
                if (!set.add(dec)) {
                    t.addError("duplicate satisfied type: '" + dec.getName(unit) + "' of '" + td.getName() + "'");
                }
                if (td instanceof ClassOrInterface && (std = dec).isSealed() && !AnalyzerUtil.inSameModule(std, unit)) {
                    String moduleName = std.getUnit().getPackage().getModule().getNameAsString();
                    t.addError("satisfies a sealed interface in a different module: '" + std.getName(unit) + "' in '" + moduleName + "'");
                }
                this.checkSelfTypes(t, td, type);
                this.checkExtensionOfMemberType(t, td, type);
            }
            if (!(t instanceof Tree.SimpleType)) continue;
            Tree.SimpleType st = (Tree.SimpleType)t;
            this.checkSupertypeVarianceAnnotations(st);
        }
    }

    @Override
    public void visit(Tree.CaseTypes that) {
        super.visit(that);
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        List<Type> cases = td.getCaseTypes();
        td.setCaseTypes(null);
        if (td instanceof TypeParameter) {
            for (Tree.StaticType t : that.getTypes()) {
                for (Tree.StaticType ot : that.getTypes()) {
                    if (t == ot) break;
                    AnalyzerUtil.checkCasesDisjoint(t.getTypeModel(), ot.getTypeModel(), ot);
                }
            }
        } else {
            this.collectCaseTypes(that, td);
            this.collectCaseValues(that, td);
        }
        td.setCaseTypes(cases);
    }

    void collectCaseValues(Tree.CaseTypes that, TypeDeclaration td) {
        Unit unit = that.getUnit();
        HashSet<TypedDeclaration> valueSet = new HashSet<TypedDeclaration>();
        for (Tree.BaseMemberExpression bme : that.getBaseMemberExpressions()) {
            Type type;
            TypedDeclaration value = AnalyzerUtil.getTypedDeclaration(bme.getScope(), TreeUtil.name(bme.getIdentifier()), null, false, unit);
            if (value == null) continue;
            if (value != null && !valueSet.add(value)) {
                bme.addError("duplicate case: '" + value.getName(unit) + "' of '" + td.getName() + "'");
            }
            if ((type = value.getType()) == null) continue;
            TypeDeclaration caseDec = type.getDeclaration();
            if (caseDec instanceof Constructor) {
                Scope scope = caseDec.getContainer();
                if (scope instanceof Class) {
                    Constructor cons = (Constructor)caseDec;
                    Class c = (Class)scope;
                    if (!c.isToplevel()) {
                        bme.addError("case must be a value constructor of a toplevel class: '" + c.getName(unit) + "' is not toplevel");
                    } else if (!cons.getParameterLists().isEmpty()) {
                        bme.addError("case must be a value constructor of a toplevel class: '" + cons.getName(unit) + "' is not a value constructor");
                    }
                }
            } else if (!caseDec.isObjectClass()) {
                bme.addError("case must be a toplevel or static anonymous class: '" + value.getName(unit) + "' is not an anonymous class");
            } else if (!value.isToplevel() && !value.isStatic()) {
                bme.addError("case must be a toplevel or static anonymous class: '" + value.getName(unit) + "' is neither static nor toplevel");
            }
            if (!InheritanceVisitor.checkDirectSubtype(td, bme, type)) continue;
            AnalyzerUtil.checkAssignable(type, td.getType(), bme, this.getCaseTypeExplanation(td, type));
        }
    }

    void collectCaseTypes(Tree.CaseTypes that, TypeDeclaration td) {
        HashSet<TypeDeclaration> typeSet = new HashSet<TypeDeclaration>();
        for (Tree.StaticType ct : that.getTypes()) {
            Type type = ct.getTypeModel();
            if (ModelUtil.isTypeUnknown(type)) continue;
            TypeDeclaration ctd = (type = type.resolveAliases()).getDeclaration();
            if (!typeSet.add(ctd)) {
                Unit unit = that.getUnit();
                ct.addError("duplicate case type: '" + ctd.getName(unit) + "' of '" + td.getName() + "'");
            }
            if (!(ctd instanceof TypeParameter) && InheritanceVisitor.checkDirectSubtype(td, ct, type)) {
                AnalyzerUtil.checkAssignable(type, td.getType(), ct, this.getCaseTypeExplanation(td, type));
            }
            this.checkCaseType(td, ct, ctd);
        }
    }

    void checkCaseType(TypeDeclaration type, Tree.StaticType ct, TypeDeclaration caseTypeDec) {
        if (caseTypeDec instanceof ClassOrInterface && ct instanceof Tree.SimpleType && AnalyzerUtil.isGeneric(caseTypeDec)) {
            Tree.SimpleType t = (Tree.SimpleType)ct;
            Tree.TypeArgumentList tal = t.getTypeArgumentList();
            List<Object> args = tal == null ? Collections.emptyList() : tal.getTypes();
            List<TypeParameter> typeParameters = caseTypeDec.getTypeParameters();
            HashSet<TypeParameter> used = new HashSet<TypeParameter>();
            for (int i = 0; i < typeParameters.size(); ++i) {
                String typeArg;
                Node node;
                Type argType;
                TypeParameter typeParameter = typeParameters.get(i);
                if (i < args.size()) {
                    Tree.Type arg = (Tree.Type)args.get(i);
                    argType = arg.getTypeModel();
                    node = arg;
                    typeArg = "type argument";
                } else {
                    argType = typeParameter.getDefaultTypeArgument();
                    node = tal;
                    typeArg = "default type argument '" + argType.asString(node.getUnit()) + "' of '" + typeParameter.getName() + "' ";
                }
                if (argType == null) continue;
                TypeDeclaration argTypeDec = argType.getDeclaration();
                if (argType.isTypeParameter()) {
                    TypeParameter tp = (TypeParameter)argTypeDec;
                    if (!tp.getDeclaration().equals(type)) {
                        node.addError(typeArg + "is not a type parameter of the enumerated type: '" + tp.getName() + "' is not a type parameter of '" + type.getName() + "'");
                        continue;
                    }
                    if (used.add(tp)) continue;
                    node.addError("type parameter of the enumerated type is used twice as a type argument: '" + argTypeDec.getName());
                    continue;
                }
                if (typeParameter.isCovariant()) {
                    AnalyzerUtil.checkAssignable(typeParameter.getType(), argType, node, typeArg + " is not an upper bound of the type parameter '" + typeParameter.getName() + "' ");
                    continue;
                }
                if (typeParameter.isContravariant()) {
                    AnalyzerUtil.checkAssignable(argType, typeParameter.getType(), node, typeArg + " is not a lower bound of the type parameter '" + typeParameter.getName() + "' ");
                    continue;
                }
                node.addError(typeArg + "is not a type parameter of the enumerated type: '" + argTypeDec.getName() + "'");
            }
        }
    }

    @Override
    public void visit(Tree.DelegatedConstructor that) {
        Class containingClass;
        Type et;
        super.visit(that);
        TypeDeclaration constructor = (TypeDeclaration)that.getScope();
        Scope container = constructor.getContainer();
        Tree.SimpleType type = that.getType();
        if (type != null && constructor instanceof Constructor && container instanceof Class && (et = (containingClass = (Class)container).getExtendedType()) != null) {
            Unit unit = that.getUnit();
            Type extendedType = containingClass.getExtendedType();
            Type constructedType = type.getTypeModel();
            TypeDeclaration delegate = type.getDeclarationModel();
            TypeDeclaration superclass = et.getDeclaration();
            if (superclass instanceof Constructor) {
                superclass = superclass.getExtendedType().getDeclaration();
            }
            if (delegate instanceof Constructor) {
                Type delegatedType;
                TypeDeclaration delegated;
                Constructor c = (Constructor)delegate;
                if (c.equals(constructor)) {
                    type.addError("constructor delegates to itself: '" + c.getName() + "'");
                }
                TypeDeclaration typeDeclaration = delegated = (delegatedType = c.getExtendedType()) == null ? null : delegatedType.getDeclaration();
                if (superclass.equals(delegated)) {
                    AnalyzerUtil.checkIsExactly(constructedType.getExtendedType(), extendedType, type, "type arguments must match type arguments in extended class expression");
                } else if (containingClass.equals(delegated)) {
                    if (type instanceof Tree.QualifiedType) {
                        Tree.QualifiedType qt = (Tree.QualifiedType)type;
                        AnalyzerUtil.checkIsExactly(constructedType.getQualifyingType(), containingClass.getType(), qt.getOuterType(), "type arguments must be the type parameters of this class");
                    }
                } else {
                    type.addError("not a constructor of the immediate superclass: '" + delegate.getName(unit) + "' is not a constructor of '" + superclass.getName(unit) + "'");
                }
            } else if (delegate instanceof Class) {
                if (superclass.equals(delegate)) {
                    AnalyzerUtil.checkIsExactly(constructedType, extendedType, type, "type arguments must match type arguments in extended class expression");
                } else if (containingClass.equals(delegate)) {
                    AnalyzerUtil.checkIsExactly(constructedType, containingClass.getType(), type, "type arguments must be the type parameters of this class");
                } else {
                    type.addError("does not instantiate the immediate superclass: '" + delegate.getName(unit) + "' is not '" + superclass.getName(unit) + "'");
                }
            }
        }
    }

    private static boolean checkDirectSubtype(TypeDeclaration td, Node node, Type type) {
        Type et;
        boolean found = false;
        TypeDeclaration ctd = type.getDeclaration();
        if (td instanceof Interface) {
            for (Type st : ctd.getSatisfiedTypes()) {
                if (st == null || !st.resolveAliases().getDeclaration().equals(td)) continue;
                found = true;
            }
        } else if (td instanceof Class && (et = ctd.getExtendedType()) != null && et.resolveAliases().getDeclaration().equals(td)) {
            found = true;
        }
        if (!found) {
            node.addError("case type is not a direct subtype of enumerated type: " + ctd.getName(node.getUnit()));
        }
        return found;
    }

    private String getCaseTypeExplanation(TypeDeclaration td, Type type) {
        String message = "case type must be a subtype of enumerated type";
        if (!td.getTypeParameters().isEmpty() && type.getDeclaration().inherits(td)) {
            message = message + " for every type argument of the generic enumerated type";
        }
        return message;
    }

    private void checkExtensionOfMemberType(Node that, TypeDeclaration td, Type type) {
        Type qt = type.getQualifyingType();
        if (qt != null && td instanceof ClassOrInterface) {
            Unit unit = that.getUnit();
            TypeDeclaration d = type.getDeclaration();
            if (d.isStatic() || d instanceof Constructor) {
                this.checkExtensionOfMemberType(that, td, qt);
            } else {
                Scope s = td;
                while (s != null) {
                    Scope otd;
                    if (!((s = s.getContainer()) instanceof TypeDeclaration) || !((TypeDeclaration)(otd = s)).getType().isSubtypeOf(qt)) continue;
                    return;
                }
                that.addError("qualifying type '" + qt.asString(unit) + "' of supertype '" + type.asString(unit) + "' is not an outer type or supertype of any outer type of '" + td.getName(unit) + "'");
            }
        }
    }

    private void checkSelfTypes(Tree.StaticType that, TypeDeclaration td, Type type) {
        if (!(td instanceof TypeParameter)) {
            List<TypeParameter> params = type.getDeclaration().getTypeParameters();
            List<Type> args = type.getTypeArgumentList();
            Unit unit = that.getUnit();
            for (int i = 0; i < params.size(); ++i) {
                Type st;
                TypeDeclaration mtd;
                Type at;
                TypeParameter param = params.get(i);
                if (!param.isSelfType() || args.isEmpty()) continue;
                Type arg = args.get(i);
                if (arg == null) {
                    arg = unit.getUnknownType();
                }
                TypeDeclaration std = param.getSelfTypedDeclaration();
                if (param.getContainer().equals(std)) {
                    at = td.getType();
                    mtd = td;
                } else {
                    mtd = (TypeDeclaration)td.getMember(std.getName(), null, false);
                    Type type2 = at = mtd == null ? null : mtd.getType();
                }
                if (at == null || at.isSubtypeOf(arg) || (st = mtd.getSelfType()) != null && st.isExactly(arg)) continue;
                String help = "";
                TypeDeclaration atd = at.getDeclaration();
                TypeDeclaration ad = arg.getDeclaration();
                if (ad instanceof TypeParameter) {
                    TypeParameter tp = (TypeParameter)ad;
                    if (tp.getDeclaration().equals(td)) {
                        help = " (try making '" + ad.getName() + "' a self type of '" + td.getName() + "')";
                    }
                } else if (ad instanceof Interface) {
                    help = " (try making " + AnalyzerUtil.message(atd) + " satisfy '" + ad.getName() + "')";
                } else if (ad instanceof Class && td instanceof Class) {
                    help = " (try making " + AnalyzerUtil.message(atd) + " extend '" + ad.getName() + "')";
                }
                that.addError("type argument does not satisfy self type constraint on type parameter '" + param.getName() + "' of '" + type.getDeclaration().getName(unit) + "': '" + arg.asString(unit) + "' is not a supertype or self type of " + AnalyzerUtil.message(atd) + help);
            }
        }
    }

    private void checkSupertypeVarianceAnnotations(Tree.SimpleType et) {
        Tree.TypeArgumentList tal = et.getTypeArgumentList();
        if (tal != null) {
            for (Tree.Type t : tal.getTypes()) {
                Tree.StaticType st;
                Tree.TypeVariance variance;
                if (!(t instanceof Tree.StaticType) || (variance = (st = (Tree.StaticType)t).getTypeVariance()) == null) continue;
                variance.addError("supertype expression may not specify variance");
            }
        }
    }

    @Override
    public void visit(Tree.Enumerated that) {
        Class cl;
        List<TypedDeclaration> caseValues;
        super.visit(that);
        Value v = that.getDeclarationModel();
        Scope container = v.getContainer();
        if (container instanceof Class && (caseValues = (cl = (Class)container).getCaseValues()) != null && !caseValues.contains(v) && !cl.isAbstract()) {
            that.addError("value constructor is not a case of enumerated class: '" + v.getName() + "' is not listed in the 'of' clause of '" + cl.getName() + "'");
        }
    }

    @Override
    public void visit(Tree.Constructor that) {
        Class cl;
        List<TypedDeclaration> caseValues;
        super.visit(that);
        Constructor c = that.getConstructor();
        Scope container = c.getContainer();
        if (container instanceof Class && (caseValues = (cl = (Class)container).getCaseValues()) != null && !c.isAbstract() && !cl.isAbstract()) {
            that.addError("concrete enumerated class may not have non-partial callable constructor: enumerated class '" + cl.getName() + "' is not abstract and constructor '" + c.getName() + "' is not partial");
        }
    }
}

