/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;

public class LiteralVisitor
extends Visitor {
    private static final String GENERATED_PREFIX = "$pattern$param$";
    private int indent;
    static final Pattern DOC_LINK_PATTERN = Pattern.compile("\\[\\[(([^\"`|\\[\\]]*\\|)?((module )|(package )|(class )|(interface )|(function )|(value )|(alias ))?(((\\w|\\.)+)::)?(\\w*)(\\.(\\w*))*(\\(\\))?)\\]\\]");
    private static Pattern CHARACTER_ESCAPE_PATTERN = Pattern.compile("\\\\(\\{#([^}]*)\\}|\\{([^#]([^}]*))\\}|(.?))");
    static final String digits = "\\d+";
    static final String groups = "\\d{1,3}(_\\d{3})+";
    static final String fractionalGroups = "(\\d{3}_)+\\d{1,3}";
    static final String magnitude = "k|M|G|T|P";
    static final String fractionalMagnitude = "m|u|n|p|f";
    static final String exponent = "(e|E)(\\+|-)?\\d+";
    static final String hexDigits = "(\\d|[a-f]|[A-F])+";
    static final String hexGroups = "(\\d|[a-f]|[A-F]){1,4}(_(\\d|[a-f]|[A-F]){4})+|(\\d|[a-f]|[A-F]){1,2}(_(\\d|[a-f]|[A-F]){2})+";
    static final String binDigits = "(0|1)+";
    static final String binGroups = "(0|1){1,4}(_(0|1){4})+";
    private Tree.Identifier switchId;

    @Override
    public void visit(Tree.CompilationUnit that) {
        if (!that.getLiteralsProcessed()) {
            super.visit(that);
            that.setLiteralsProcessed(true);
        }
    }

    @Override
    public void visit(Tree.StringLiteral that) {
        StringBuilder result;
        boolean allTrimmed;
        if (that.getToken() == null) {
            return;
        }
        int type = that.getToken().getType();
        String text = that.getText();
        if (type == 14 || type == 13) {
            Matcher m = DOC_LINK_PATTERN.matcher(text);
            while (m.find()) {
                int charInLine;
                String group = m.group(1);
                int start = that.getStartIndex() + m.start(1);
                int end = that.getStartIndex() + m.end(1);
                String[] linesUpTo = text.substring(0, m.start(1)).split("\n");
                CommonToken token = new CommonToken(13, group);
                token.setStartIndex(start);
                token.setStopIndex(end - 1);
                token.setTokenIndex(that.getToken().getTokenIndex());
                int line = that.getToken().getLine() + linesUpTo.length - 1;
                int n = charInLine = linesUpTo.length == 0 ? 0 : linesUpTo[linesUpTo.length - 1].length();
                if (linesUpTo.length == 1) {
                    charInLine += that.getToken().getCharPositionInLine();
                }
                token.setLine(line);
                token.setCharPositionInLine(charInLine);
                that.addDocLink(new Tree.DocLink(token));
            }
        }
        if (type != 113 && type != 111) {
            this.indent = this.getIndentPosition(that);
        }
        if (!(allTrimmed = LiteralVisitor.stripIndent(text = type == 130 || type == 14 ? text.substring(3, text.length() - (text.endsWith("\"\"\"") ? 3 : 0)) : (type == 113 ? text.substring(2, text.length() - 2) : (type == 111 ? text.substring(2, text.length() - (text.endsWith("\"") ? 1 : 0)) : (type == 114 ? text.substring(1, text.length() - 2) : text.substring(1, text.length() - (text.endsWith("\"") ? 1 : 0))))), this.indent, result = new StringBuilder()))) {
            that.addError("multiline string content should align with start of string: string begins at character position " + this.indent, 6000);
        }
        if (type != 130 && type != 14) {
            LiteralVisitor.interpolateEscapes(result, that);
        }
        that.setText(result.toString());
        if (type != 113 && type != 114) {
            this.indent = 0;
        }
    }

    @Override
    public void visit(Tree.StringTemplate that) {
        int oi = this.indent;
        this.indent = 0;
        super.visit(that);
        this.indent = oi;
    }

    @Override
    public void visit(Tree.QuotedLiteral that) {
        StringBuilder result = new StringBuilder();
        LiteralVisitor.stripIndent(that.getText(), this.getIndentPosition(that), result);
        that.setText(result.toString());
    }

    private int getIndentPosition(Tree.Literal that) {
        Token token = that.getToken();
        return token == null ? 0 : token.getCharPositionInLine() + this.getQuoteLength(token);
    }

    private int getQuoteLength(Token token) {
        int type = token.getType();
        return type == 130 || type == 14 ? 3 : 1;
    }

    @Override
    public void visit(Tree.CharLiteral that) {
        StringBuilder result = new StringBuilder(that.getText());
        LiteralVisitor.interpolateEscapes(result, that);
        that.setText(result.toString());
    }

    @Override
    public void visit(Tree.NaturalLiteral that) {
        super.visit(that);
        String text = that.getToken().getText();
        if (!(text.matches("^(\\d+|\\d{1,3}(_\\d{3})+)(k|M|G|T|P)?$") || text.matches("#((\\d|[a-f]|[A-F])+|(\\d|[a-f]|[A-F]){1,4}(_(\\d|[a-f]|[A-F]){4})+|(\\d|[a-f]|[A-F]){1,2}(_(\\d|[a-f]|[A-F]){2})+)") || text.matches("\\$((0|1)+|(0|1){1,4}(_(0|1){4})+)"))) {
            that.addError("illegal integer literal format");
        }
        that.setText(that.getText().replace("_", "").replace("k", "000").replace("M", "000000").replace("G", "000000000").replace("T", "000000000000").replace("P", "000000000000000"));
    }

    @Override
    public void visit(Tree.FloatLiteral that) {
        super.visit(that);
        String text = that.getToken().getText();
        if (!text.matches("^(\\d+|\\d{1,3}(_\\d{3})+)(\\.(\\d+|(\\d{3}_)+\\d{1,3})(k|M|G|T|P|m|u|n|p|f|(e|E)(\\+|-)?\\d+)?|m|u|n|p|f)$")) {
            that.addError("illegal floating literal format");
        }
        that.setText(that.getText().replace("_", "").replace("k", "e+3").replace("M", "e+6").replace("G", "e+9").replace("T", "e+12").replace("P", "e+15").replace("m", "e-3").replace("u", "e-6").replace("n", "e-9").replace("p", "e-12").replace("f", "e-15"));
    }

    private static boolean stripIndent(String text, int indentation, StringBuilder result) {
        boolean correctlyIndented = true;
        int num = 0;
        for (String line : text.split("\n|\r\n?")) {
            if (num++ == 0) {
                result.append(line);
            } else {
                for (int i = 0; i < line.length(); ++i) {
                    if (i < indentation) {
                        if (Character.isWhitespace(line.charAt(i))) continue;
                        correctlyIndented = false;
                        result.append(line.substring(i));
                        break;
                    }
                    result.append(line.substring(indentation));
                    break;
                }
            }
            result.append("\n");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return correctlyIndented;
    }

    private static void interpolateEscapes(StringBuilder result, Node node) {
        Matcher matcher;
        int start = 0;
        while ((matcher = CHARACTER_ESCAPE_PATTERN.matcher(result)).find(start)) {
            int to;
            String hex = matcher.group(2);
            String name = matcher.group(3);
            int from = matcher.start();
            int next = to = matcher.end();
            if (name != null) {
                String emoji;
                boolean found = false;
                for (int codePoint = 0; codePoint <= 917999; ++codePoint) {
                    String cn = Character.getName(codePoint);
                    if (cn == null || !cn.equals(name)) continue;
                    String unicodeChar = new String(Character.toChars(codePoint));
                    result.replace(from, to, unicodeChar);
                    next = from + unicodeChar.length();
                    found = true;
                    break;
                }
                if (!found && (emoji = LiteralVisitor.getEmoji(node, name)) != null) {
                    result.replace(from, to, emoji);
                    next = from + emoji.length();
                }
            } else if (hex != null) {
                if (hex.length() != 2 && hex.length() != 4 && hex.length() != 6 && hex.length() != 8) {
                    node.addError("illegal unicode escape sequence: must consist of 2, 4, or 6 digits");
                } else {
                    String unicodeChar = LiteralVisitor.getUnicodeCharacter(node, hex);
                    if (unicodeChar != null) {
                        result.replace(from, to, unicodeChar);
                        next = from + unicodeChar.length();
                    }
                }
            } else {
                String legacyEscape = matcher.group(5);
                if (legacyEscape.isEmpty()) {
                    result.delete(from, to + 1);
                    next = from;
                } else {
                    String legacyEscapeChar = LiteralVisitor.getLegacyEscape(node, legacyEscape);
                    if (legacyEscapeChar != null) {
                        result.replace(from, to, legacyEscapeChar);
                        next = from + legacyEscapeChar.length();
                    }
                }
            }
            start = next;
        }
    }

    private static String getLegacyEscape(Node node, String legacyEscape) {
        char ch;
        char escape = legacyEscape.charAt(0);
        switch (escape) {
            case 'b': {
                ch = '\b';
                break;
            }
            case 't': {
                ch = '\t';
                break;
            }
            case 'n': {
                ch = '\n';
                break;
            }
            case 'f': {
                ch = '\f';
                break;
            }
            case 'r': {
                ch = '\r';
                break;
            }
            case 'e': {
                ch = '\u001b';
                break;
            }
            case '0': {
                ch = '\u0000';
                break;
            }
            case '\"': 
            case '\'': 
            case '\\': 
            case '`': {
                ch = escape;
                break;
            }
            default: {
                node.addError("illegal escape sequence: '\\" + escape + "' is not a recognized escape sequence");
                return null;
            }
        }
        return Character.toString(ch);
    }

    private static String getUnicodeCharacter(Node node, String hex) {
        char[] chars;
        int codePoint;
        try {
            codePoint = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException nfe) {
            node.addError("illegal unicode escape sequence: '" + hex + "' is not a hexadecimal number");
            return null;
        }
        try {
            chars = Character.toChars(codePoint);
        }
        catch (IllegalArgumentException iae) {
            node.addError("illegal unicode escape sequence: '" + hex + "' is not a valid Unicode code point");
            return null;
        }
        return new String(chars);
    }

    private static String getEmoji(Node node, String name) {
        int emoji = -1;
        switch (name) {
            case ":)": 
            case ":-)": 
            case "=)": {
                emoji = 128515;
                break;
            }
            case "O:)": 
            case "O:-)": 
            case "O=)": {
                emoji = 128519;
                break;
            }
            case "}:)": 
            case "}:-)": 
            case "}=)": {
                emoji = 128520;
                break;
            }
            case ":-(": 
            case ":(": 
            case "=(": {
                emoji = 128542;
                break;
            }
            case ":-|": 
            case ":|": 
            case "=|": {
                emoji = 128528;
                break;
            }
            case ";-)": 
            case ";)": {
                emoji = 128521;
                break;
            }
            case "B-)": 
            case "B)": {
                emoji = 128526;
                break;
            }
            case ":-D": 
            case ":D": {
                emoji = 128512;
                break;
            }
            case "=D": {
                emoji = 128516;
                break;
            }
            case "-_-": {
                emoji = 128529;
                break;
            }
            case "o_o": {
                emoji = 128531;
                break;
            }
            case "u_u": {
                emoji = 128532;
                break;
            }
            case ">_<": {
                emoji = 128547;
                break;
            }
            case "^_^": {
                emoji = 128513;
                break;
            }
            case "^_^;;": {
                emoji = 128517;
                break;
            }
            case "<3": {
                emoji = 128156;
                break;
            }
            case "<\\3": 
            case "</3": {
                emoji = 128148;
                break;
            }
            case "~@~": {
                emoji = 128169;
                break;
            }
            case "(]:{": {
                emoji = 128115;
                break;
            }
            case "-<@%": {
                emoji = 128029;
                break;
            }
            case ":(|)": {
                emoji = 128053;
                break;
            }
            case ":(:)": {
                emoji = 128055;
                break;
            }
            case ":*": 
            case ":-*": {
                emoji = 128535;
                break;
            }
            case ";*": 
            case ";-*": {
                emoji = 128536;
                break;
            }
            case ":\\": 
            case ":-\\": 
            case "=\\": 
            case ":/": 
            case ":-/": 
            case "=/": {
                emoji = 128533;
                break;
            }
            case ":S": 
            case ":-S": 
            case ":s": 
            case ":-s": {
                emoji = 128534;
                break;
            }
            case ":P": 
            case ":-P": 
            case "=P": 
            case ":p": 
            case ":-p": 
            case "=p": {
                emoji = 128539;
                break;
            }
            case ";P": 
            case ";-P": 
            case ";p": 
            case ";-p": {
                emoji = 128540;
                break;
            }
            case ">.<": 
            case ">:(": 
            case ">:-(": 
            case ">=(": {
                emoji = 128545;
                break;
            }
            case "T_T": 
            case ":'(": 
            case ";_;": 
            case "='(": {
                emoji = 128546;
                break;
            }
            case "D:": {
                emoji = 128550;
                break;
            }
            case "o.o": 
            case ":o": 
            case ":-o": 
            case "=o": {
                emoji = 128558;
                break;
            }
            case "O.O": 
            case ":O": 
            case ":-O": 
            case "=O": {
                emoji = 128562;
                break;
            }
            case "x_x": 
            case "X-O": 
            case "x-o": 
            case "X(": 
            case "X-(": {
                emoji = 128565;
                break;
            }
            case ":X)": 
            case ":3": 
            case "(=^..^=)": 
            case "(=^.^=)": 
            case "=^_^=": {
                emoji = 128568;
                break;
            }
            default: {
                node.addError("illegal unicode escape sequence: " + name + " is not a Unicode character name");
            }
        }
        if (emoji < 0) {
            return null;
        }
        return new String(Character.toChars(emoji));
    }

    @Override
    public void visit(Tree.Identifier that) {
        super.visit(that);
        if (!that.isMissingToken()) {
            int cp;
            String text = that.getText();
            if (text.startsWith(GENERATED_PREFIX)) {
                return;
            }
            for (int index = 0; index < text.length(); index += Character.charCount(cp)) {
                boolean us;
                cp = text.codePointAt(index);
                int type = Character.getType(cp);
                boolean num = type == 10 || type == 9 || type == 11;
                boolean letter = type == 2 || type == 1 || type == 3 || type == 5 || type == 4;
                boolean bl = us = cp == 95;
                if (index != 0 || !num) continue;
                that.addError("identifier may not begin with a digit");
                break;
            }
        }
    }

    Tree.Type asType(Tree.Pattern pattern) {
        if (pattern instanceof Tree.VariablePattern) {
            Tree.VariablePattern vp = (Tree.VariablePattern)pattern;
            Tree.Variable variable = vp.getVariable();
            Tree.Type type = variable.getType();
            if (!(type instanceof Tree.StaticType) && !(type instanceof Tree.SequencedType)) {
                return null;
            }
            return type;
        }
        if (pattern instanceof Tree.KeyValuePattern) {
            Tree.KeyValuePattern ep = (Tree.KeyValuePattern)pattern;
            Tree.Type keyType = this.asType(ep.getKey());
            Tree.Type valueType = this.asType(ep.getValue());
            if (!(keyType instanceof Tree.StaticType) || !(valueType instanceof Tree.StaticType)) {
                return null;
            }
            Tree.EntryType et = new Tree.EntryType(null);
            et.setKeyType((Tree.StaticType)keyType);
            et.setValueType((Tree.StaticType)valueType);
            return et;
        }
        if (pattern instanceof Tree.TuplePattern) {
            Tree.TuplePattern tp = (Tree.TuplePattern)pattern;
            Tree.TupleType tt = new Tree.TupleType(null);
            for (Tree.Pattern p : tp.getPatterns()) {
                Tree.Type type = this.asType(p);
                if (!(type instanceof Tree.StaticType) && !(type instanceof Tree.SequencedType)) {
                    return null;
                }
                tt.getElementTypes().add(type);
            }
            return tt;
        }
        return null;
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        Tree.Identifier oid = this.switchId;
        this.createSwitchVariable(that.getSwitchClause(), that.getSwitchCaseList());
        super.visit(that);
        this.switchId = oid;
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        Tree.Identifier oid = this.switchId;
        this.createSwitchVariable(that.getSwitchClause(), that.getSwitchCaseList());
        super.visit(that);
        this.switchId = oid;
    }

    private void createSwitchVariable(Tree.SwitchClause switchClause, Tree.SwitchCaseList switchCaseList) {
        Tree.Switched switched;
        this.switchId = null;
        if (switchClause != null && switchCaseList != null && (switched = switchClause.getSwitched()) != null) {
            Tree.Variable variable = switched.getVariable();
            Tree.Expression expression = switched.getExpression();
            if (variable != null) {
                this.switchId = variable.getIdentifier();
            } else if (expression != null) {
                Tree.Term term = expression.getTerm();
                if (term instanceof Tree.BaseMemberExpression) {
                    Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
                    this.switchId = bme.getIdentifier();
                } else {
                    for (Tree.CaseClause cc : switchCaseList.getCaseClauses()) {
                        Tree.CaseItem item = cc.getCaseItem();
                        if (item instanceof Tree.IsCase) {
                            return;
                        }
                        if (!(item instanceof Tree.PatternCase)) continue;
                        Tree.Identifier id = new Tree.Identifier(null);
                        id.setText("_");
                        this.switchId = id;
                        switched.setVariable(this.createVariable(id, expression));
                        switched.setExpression(null);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void visit(Tree.CaseClause that) {
        Tree.CaseItem item = that.getCaseItem();
        if (item instanceof Tree.PatternCase) {
            Tree.PatternCase pc = (Tree.PatternCase)item;
            Tree.Pattern pattern = pc.getPattern();
            Tree.Type type = this.asType(pattern);
            if (type == null) {
                type = new Tree.ValueModifier(null);
                pattern.addError("missing type in pattern case: (pattern case must specify explicit types for every variable)");
            }
            Tree.Identifier id = new Tree.Identifier(null);
            id.setText(this.switchId == null ? "_" : this.switchId.getText());
            that.setCaseItem(this.createIsCase(type, id, pc));
            Tree.Destructure destructure = this.destructure(pattern, id);
            destructure.setPatternCase(true);
            Tree.Expression e = that.getExpression();
            Tree.Block b = that.getBlock();
            if (e != null) {
                Tree.LetClause letClause = new Tree.LetClause(null);
                letClause.getVariables().add(destructure);
                letClause.setExpression(e);
                that.setExpression(this.createLetExpression(letClause));
            }
            if (b != null) {
                b.getStatements().add(0, destructure);
            }
        }
        super.visit(that);
    }

    private Tree.IsCase createIsCase(Tree.Type type, Tree.Identifier id, Tree.PatternCase item) {
        CustomTree.IsCase ic = new CustomTree.IsCase(item.getToken());
        ic.setEndToken(item.getEndToken());
        ic.setType(type);
        ((Tree.IsCase)ic).setVariable(this.createVariable(id));
        return ic;
    }

    private Tree.Variable createVariable(Tree.Identifier id, Tree.Expression e) {
        Tree.SpecifierExpression se = new Tree.SpecifierExpression(null);
        se.setExpression(e);
        Tree.Variable var = new Tree.Variable(null);
        var.setType(new Tree.SyntheticVariable(null));
        var.setIdentifier(id);
        var.setSpecifierExpression(se);
        return var;
    }

    private Tree.Variable createVariable(Tree.Identifier id) {
        Tree.Variable var = new Tree.Variable(null);
        var.setType(new Tree.SyntheticVariable(null));
        var.setIdentifier(id);
        var.setSpecifierExpression(this.createReference(id));
        return var;
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        List<Tree.ParameterList> parameterLists = that.getParameterLists();
        Tree.Block funBody = that.getBlock();
        Tree.ParExpression funExpression = new Tree.ParExpression(null);
        funExpression.setTerm(that.getExpression());
        Tree.LetClause letClause = new Tree.LetClause(null);
        int k = 0;
        for (int i = 0; i < parameterLists.size(); ++i) {
            Tree.ParameterList list = parameterLists.get(i);
            List<Tree.Parameter> parameters = list.getParameters();
            for (int j = 0; j < parameters.size(); ++j) {
                Tree.Parameter p = parameters.get(j);
                if (!(p instanceof Tree.PatternParameter)) continue;
                Tree.PatternParameter pp = (Tree.PatternParameter)p;
                Tree.Pattern pattern = pp.getPattern();
                Tree.Identifier id = new Tree.Identifier(null);
                id.setText(GENERATED_PREFIX + k);
                Tree.Parameter param = this.createParameter(id, this.asType(pattern));
                parameters.set(j, param);
                Tree.Destructure destructure = this.destructure(pattern, id);
                if (funBody == null) {
                    letClause.getVariables().add(destructure);
                } else {
                    funBody.getStatements().add(k, destructure);
                }
                ++k;
            }
        }
        if (k > 0 && funBody == null) {
            letClause.setExpression(funExpression);
            that.setExpression(this.createLetExpression(letClause));
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.PatternParameter that) {
        super.visit(that);
        that.addError("parameter may not be a pattern (parameter destructuring is allowed for anonymous functions)");
    }

    private Tree.Expression createLetExpression(Tree.LetClause letClause) {
        Tree.LetExpression let = new Tree.LetExpression(null);
        let.setLetClause(letClause);
        Tree.Expression expression = new Tree.Expression(null);
        expression.setTerm(let);
        return expression;
    }

    private Tree.Parameter createParameter(Tree.Identifier id, Tree.Type type) {
        if (type != null) {
            Tree.AttributeDeclaration model = new Tree.AttributeDeclaration(null);
            model.setIdentifier(id);
            model.setType(type);
            Tree.AnnotationList al = new Tree.AnnotationList(null);
            model.setAnnotationList(al);
            Tree.ValueParameterDeclaration vpd = new Tree.ValueParameterDeclaration(null);
            vpd.setTypedDeclaration(model);
            return vpd;
        }
        Tree.InitializerParameter ip = new Tree.InitializerParameter(null);
        ip.setIdentifier(id);
        return ip;
    }

    private Tree.Destructure destructure(Tree.Pattern pattern, Tree.Identifier id) {
        Tree.Destructure destructure = new Tree.Destructure(null);
        destructure.setType(new Tree.ValueModifier(null));
        destructure.setSpecifierExpression(this.createReference(id));
        destructure.setPattern(pattern);
        return destructure;
    }

    private Tree.SpecifierExpression createReference(Tree.Identifier id) {
        Tree.BaseMemberExpression bme = new Tree.BaseMemberExpression(null);
        bme.setIdentifier(id);
        Tree.InferredTypeArguments typeArgs = new Tree.InferredTypeArguments(null);
        bme.setTypeArguments(typeArgs);
        Tree.Expression destExpression = new Tree.Expression(null);
        destExpression.setTerm(bme);
        Tree.SpecifierExpression spec = new Tree.SpecifierExpression(null);
        spec.setExpression(destExpression);
        return spec;
    }
}

