/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.tree;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.typechecker.tree.ErrorCode;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import org.antlr.runtime.Token;

public class AnalysisMessage
implements Message {
    private final Node treeNode;
    private final String message;
    private final int code;
    private final Backend backend;

    @Override
    public boolean isWarning() {
        return false;
    }

    public AnalysisMessage(Node treeNode, String message) {
        this(treeNode, message, 0);
    }

    public AnalysisMessage(Node treeNode, String message, Backend backend) {
        this(treeNode, message, 0, backend);
    }

    public AnalysisMessage(Node treeNode, String message, int code) {
        this(treeNode, message, code, null);
    }

    public AnalysisMessage(Node treeNode, String message, ErrorCode errorCode) {
        this(treeNode, message, errorCode, null);
    }

    public AnalysisMessage(Node treeNode, String message, ErrorCode errorCode, Backend backend) {
        this(treeNode, message, errorCode == null ? ErrorCode.UNKNOWN.code : errorCode.code, null);
    }

    public AnalysisMessage(Node treeNode, String message, int code, Backend backend) {
        this.treeNode = treeNode;
        this.message = message;
        this.code = code;
        this.backend = backend;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Node getTreeNode() {
        return this.treeNode;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Backend getBackend() {
        return this.backend;
    }

    @Override
    public int getLine() {
        Token token = this.treeNode.getToken();
        return token == null ? -1 : token.getLine();
    }

    public String toString() {
        return this.message;
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.getErrorCode(this.code);
    }
}

