/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.tree;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalysisError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UnsupportedError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.parser.LexError;
import com.redhat.ceylon.compiler.typechecker.parser.ParseError;
import com.redhat.ceylon.compiler.typechecker.tree.ErrorCode;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.MissingToken;
import com.redhat.ceylon.compiler.typechecker.tree.UnexpectedError;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.PrintVisitor;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;

public abstract class Node {
    private String text;
    private Token token;
    private Token endToken;
    private Token firstChildToken;
    private Token lastChildToken;
    private Scope scope;
    private Unit unit;
    private List<Message> errors = null;

    protected Node(Token token) {
        this.token = token;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.token == null) {
            return "";
        }
        if (this.endToken == null) {
            return this.token.getText();
        }
        return this.token.getText() + this.endToken.getText();
    }

    public void setText(String text) {
        this.text = text;
    }

    public Token getToken() {
        return this.getFirstChildToken();
    }

    public Token getMainToken() {
        return this.token;
    }

    public Token getMainEndToken() {
        return this.endToken;
    }

    public String getLocation() {
        Token token = this.getToken();
        Token endToken = this.getEndToken();
        if (token == null) {
            return "unknown location";
        }
        if (endToken == null) {
            return Node.toLocation(token);
        }
        return Node.toLocation(token) + "-" + Node.toEndLocation(endToken);
    }

    public Integer getStartIndex() {
        Token token = this.getToken();
        if (token == null) {
            return null;
        }
        CommonToken ct = (CommonToken)token;
        return ct.getStartIndex();
    }

    public Integer getStopIndex() {
        Token token = this.getEndToken();
        if (token == null) {
            token = this.getToken();
        }
        if (token == null) {
            return null;
        }
        CommonToken ct = (CommonToken)token;
        return ct.getStopIndex();
    }

    public Integer getEndIndex() {
        Token token = this.getEndToken();
        if (token == null) {
            token = this.getToken();
        }
        if (token == null) {
            return null;
        }
        CommonToken ct = (CommonToken)token;
        return ct.getStopIndex() + 1;
    }

    public Integer getDistance() {
        Integer start = this.getStartIndex();
        Integer end = this.getEndIndex();
        if (start != null && end != null) {
            return end - start;
        }
        return null;
    }

    private static String toLocation(Token token) {
        return token.getLine() + ":" + token.getCharPositionInLine();
    }

    private static String toEndLocation(Token token) {
        return token.getLine() + ":" + (token.getCharPositionInLine() + token.getText().length() - 1);
    }

    private static boolean isMissingToken(Token t) {
        return t instanceof MissingToken;
    }

    public boolean isMissingToken() {
        return Node.isMissingToken(this.token);
    }

    private Token getFirstChildToken() {
        Token token;
        Token token2 = token = this.token == null || Node.isMissingToken(this.token) ? null : this.token;
        if (this.firstChildToken != null && (token == null || this.firstChildToken.getTokenIndex() < token.getTokenIndex())) {
            token = this.firstChildToken;
        }
        return token;
    }

    private Token getLastChildToken() {
        Token token;
        Token token2 = token = this.endToken == null || Node.isMissingToken(this.endToken) ? this.token : this.endToken;
        if (this.lastChildToken != null && (token == null || this.lastChildToken.getTokenIndex() > token.getTokenIndex())) {
            token = this.lastChildToken;
        }
        return token;
    }

    public Token getEndToken() {
        return this.getLastChildToken();
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setEndToken(Token endToken) {
        if (endToken == null || !Node.isMissingToken(endToken)) {
            this.endToken = endToken;
        }
    }

    public List<Message> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public void addError(Message error) {
        if (this.errors == null) {
            this.errors = new ArrayList<Message>(2);
        }
        this.errors.add(error);
    }

    public void addError(String message) {
        this.addError(new AnalysisError(this, message));
    }

    public void addError(String message, Backend backend) {
        this.addError(new AnalysisError(this, message, backend));
    }

    public void addError(String message, int code) {
        this.addError(new AnalysisError(this, message, code));
    }

    public void addError(String message, int code, Backend backend) {
        this.addError(new AnalysisError(this, message, code, backend));
    }

    public void addError(String message, ErrorCode errorCode) {
        this.addError(new AnalysisError(this, message, errorCode));
    }

    public void addError(String message, ErrorCode errorCode, Backend backend) {
        this.addError(new AnalysisError(this, message, errorCode, backend));
    }

    public void addUnexpectedError(String message) {
        this.addError(new UnexpectedError(this, message));
    }

    public void addUnexpectedError(String message, Backend backend) {
        this.addError(new UnexpectedError(this, message, backend));
    }

    public void addUnsupportedError(String message) {
        this.addError(new UnsupportedError(this, message));
    }

    public void addUnsupportedError(String message, Backend backend) {
        this.addError(new UnsupportedError(this, message, backend));
    }

    public <E extends Enum<E>> void addUsageWarning(E warningName, String message) {
        this.addError(new UsageWarning(this, message, warningName.toString()));
    }

    public <E extends Enum<E>> void addUsageWarning(E warningName, String message, Backend backend) {
        this.addError(new UsageWarning(this, message, warningName.toString(), backend));
    }

    public void addParseError(ParseError error) {
        this.addError(error);
    }

    public void addLexError(LexError error) {
        this.addError(error);
    }

    public abstract void visit(Visitor var1);

    public abstract void visitChildren(Visitor var1);

    public String toString() {
        StringWriter w = new StringWriter();
        PrintVisitor pv = new PrintVisitor(w);
        pv.visitAny(this);
        return w.toString();
    }

    public String getNodeType() {
        return this.getClass().getSimpleName();
    }

    public void handleException(Exception e, Visitor visitor) {
        this.addUnexpectedError(this.getMessage(e, visitor));
    }

    public String getMessage(Exception e, Visitor visitor) {
        return "the '" + visitor.getClass().getSimpleName() + "' caused an exception visiting a '" + this.getNodeType() + "' node: '\"" + e + "\"'" + this.getLocationInfo(e);
    }

    private String getLocationInfo(Exception e) {
        return e.getStackTrace().length == 0 ? "" : " at '" + e.getStackTrace()[0].toString() + "'";
    }

    public void connect(Node child) {
        if (child != null) {
            Token childLastChildToken;
            Token childFirstChildToken = child.getFirstChildToken();
            if (childFirstChildToken != null && (this.firstChildToken == null || childFirstChildToken.getTokenIndex() < this.firstChildToken.getTokenIndex())) {
                this.firstChildToken = childFirstChildToken;
            }
            if ((childLastChildToken = child.getLastChildToken()) != null && (this.lastChildToken == null || childLastChildToken.getTokenIndex() > this.lastChildToken.getTokenIndex())) {
                this.lastChildToken = childLastChildToken;
            }
        }
    }
}

