/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.treegen;

import java.io.PrintStream;

public class Util {
    public static PrintStream out = System.out;

    public static String className(String nodeName) {
        return Util.toJavaIdentifier(nodeName, true);
    }

    public static String fieldName(String nodeName) {
        return Util.toJavaIdentifier(nodeName, false);
    }

    public static String toJavaIdentifier(String nodeName, boolean boundary) {
        StringBuilder result = new StringBuilder();
        for (char c : nodeName.toCharArray()) {
            if (c == '_') {
                boundary = true;
                continue;
            }
            if (boundary) {
                result.append(c);
                boundary = false;
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static String initialUpper(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String description(String nodeName) {
        return nodeName.toLowerCase().replace('_', ' ');
    }

    public static void print(String text) {
        out.print(text);
    }

    public static void println(String text) {
        out.println(text);
    }
}

