/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

public class Levenshtein {
    public static void main(String[] args) {
        Levenshtein l = new Levenshtein();
        System.out.println(l.distance("My string", "My $tring"));
        System.out.println(l.distance("My string", "M string2"));
        System.out.println(l.distance("My string", "My $tring"));
    }

    public double distance(String s1, String s2) {
        int i;
        if (s1.equals(s2)) {
            return 0.0;
        }
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int[] v0 = new int[s2.length() + 1];
        int[] v1 = new int[s2.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s1.length(); ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < s2.length(); ++j) {
                int cost = s1.charAt(i) == s2.charAt(j) ? 0 : 1;
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + cost));
            }
            int[] vtemp = v0;
            v0 = v1;
            v1 = vtemp;
        }
        return v0[s2.length()];
    }
}

