/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.antlr.runtime.ANTLRStringStream;

public class NewlineFixingStringStream
extends ANTLRStringStream {
    private static final int DEFAULT_INIT_BUF_SIZE = 1024;

    public NewlineFixingStringStream() {
    }

    public NewlineFixingStringStream(char[] data, int numberOfActualCharsInArray) {
        super(data, numberOfActualCharsInArray);
    }

    public NewlineFixingStringStream(String input) {
        super(input);
    }

    public static NewlineFixingStringStream fromStream(InputStream input, String encoding) throws IOException {
        return NewlineFixingStringStream.fromStream(input, encoding, 1024);
    }

    public static NewlineFixingStringStream fromStream(InputStream input, String encoding, int bufSize) throws IOException {
        return NewlineFixingStringStream.fromReader(new InputStreamReader((InputStream)new BufferedInputStream(input), encoding), bufSize);
    }

    public static NewlineFixingStringStream fromReader(Reader reader) throws IOException {
        return NewlineFixingStringStream.fromReader(reader, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NewlineFixingStringStream fromReader(Reader reader, int bufSize) throws IOException {
        try {
            char[] data = new char[bufSize];
            int read = reader.read(data);
            int n = 0;
            while (read != -1) {
                if ((n += read) == data.length) {
                    char[] newdata = new char[data.length * 2];
                    System.arraycopy(data, 0, newdata, 0, n);
                    data = newdata;
                }
                read = reader.read(data, n, data.length - n);
            }
            NewlineFixingStringStream newlineFixingStringStream = new NewlineFixingStringStream(data, n);
            return newlineFixingStringStream;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void consume() {
        if (this.p < this.n) {
            ++this.charPositionInLine;
            if (this.data[this.p] == '\n') {
                ++this.line;
                this.charPositionInLine = 0;
            } else if (this.data[this.p] == '\r' && (this.p + 1 == this.n || this.data[this.p + 1] != '\n')) {
                ++this.line;
                this.charPositionInLine = 0;
            }
            ++this.p;
        }
    }
}

