/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.file;

import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.file.BaseFileObject;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import com.redhat.ceylon.langtools.tools.javac.file.RelativePath;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JImageZipFile
implements JavacFileManager.Archive {
    private FileSystem fileSystem;
    private JavacFileManager fileManager;
    private Map<String, Entry> roots = new HashMap<String, Entry>();
    Map<String, Entry> absoluteEntries = new HashMap<String, Entry>();

    public JImageZipFile(JavacFileManager fm, File fileName) {
        this.fileManager = fm;
        this.fileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
        try {
            this.loadModules();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadModules() throws IOException {
        for (Path module : Files.newDirectoryStream(this.fileSystem.getPath("/modules", new String[0]))) {
            for (Path root : Files.newDirectoryStream(module)) {
                this.scan(root, null, "", module.getFileName().toString());
            }
        }
    }

    public void scan(Path path, Entry container, String parentPath, String module) throws IOException {
        Entry entry;
        String name = path.getFileName().toString();
        String thisPath = parentPath + name;
        boolean newEntry = false;
        if (Files.isDirectory(path, new LinkOption[0])) {
            thisPath = thisPath + "/";
            entry = container != null ? container.getEntry(name) : this.roots.get(name);
            if (entry == null) {
                entry = new Entry(container, name, true, module);
                newEntry = true;
            }
            for (Path child : Files.newDirectoryStream(path)) {
                this.scan(child, entry, thisPath, module);
            }
        } else {
            entry = new Entry(container, path.getFileName().toString(), false, module);
            newEntry = true;
        }
        if (newEntry) {
            this.absoluteEntries.put(thisPath, entry);
            if (container != null) {
                container.addEntry(entry);
            } else {
                this.roots.put(entry.name, entry);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean contains(RelativePath name) {
        return this.absoluteEntries.containsKey(name.getPath());
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory subdirectory, String file) {
        Entry entry = this.absoluteEntries.get(subdirectory.getPath() + file);
        if (entry != null && !entry.isFolder) {
            String path = entry.getFullPathWithModule();
            return new JImageFileObject(this.fileSystem.getPath(path, new String[0]));
        }
        return null;
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory subdirectory) {
        Entry entry = this.absoluteEntries.get(subdirectory.getPath());
        if (entry != null && entry.isFolder) {
            ListBuffer<String> ret = new ListBuffer<String>();
            for (String child : entry.entries.keySet()) {
                ret.add(child);
            }
            return ret.toList();
        }
        return List.nil();
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        HashSet<RelativePath.RelativeDirectory> ret = new HashSet<RelativePath.RelativeDirectory>();
        for (Entry entry : this.absoluteEntries.values()) {
            if (!entry.isFolder) continue;
            ret.add(new RelativePath.RelativeDirectory(entry.getAbsolutePath()));
        }
        return ret;
    }

    private static class Entry {
        Map<String, Entry> entries = new HashMap<String, Entry>();
        boolean isFolder;
        String name;
        Entry parent;
        String module;

        Entry(Entry parent, String name, boolean isFolder, String module) {
            this.module = module;
            this.parent = parent;
            this.name = name;
            this.isFolder = isFolder;
        }

        public void addEntry(Entry entry) {
            this.entries.put(entry.name, entry);
        }

        public Entry getEntry(String name) {
            return this.entries.get(name);
        }

        public String getAbsolutePath() {
            return this.parent != null ? this.parent.getAbsolutePath() + "/" + this.name : "/" + this.name;
        }

        public String getFullPathWithModule() {
            return "/modules/" + this.module + this.getAbsolutePath();
        }
    }

    public class JImageFileObject
    extends BaseFileObject {
        private Path path;

        public JImageFileObject(Path path) {
            super(JImageZipFile.this.fileManager);
            this.path = path;
        }

        @Override
        public URI toUri() {
            return this.path.toUri();
        }

        @Override
        public String getName() {
            return this.path.toString();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.getKind(this.getName());
        }

        @Override
        public boolean isNameCompatible(String cn, JavaFileObject.Kind k) {
            cn.getClass();
            if (k == JavaFileObject.Kind.OTHER && this.getKind() != k) {
                return false;
            }
            return this.getName().equals(cn + k.extension);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb = this.fileManager.getCachedContent(this);
            if (cb == null) {
                try (InputStream in = this.openInputStream();){
                    ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                    JavaFileObject prev = this.fileManager.log.useSource(this);
                    try {
                        cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                    }
                    finally {
                        this.fileManager.log.useSource(prev);
                    }
                    this.fileManager.recycleByteBuffer(bb);
                    if (!ignoreEncodingErrors) {
                        this.fileManager.cache(this, cb);
                    }
                }
            }
            return cb;
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            try {
                return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getShortName() {
            return this.path.toString();
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> path) {
            String entryName = this.getName();
            return JImageFileObject.removeExtension(entryName).replace('/', '.');
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof JImageFileObject)) {
                return false;
            }
            return this.path.equals(((JImageFileObject)other).path);
        }

        @Override
        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

