/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.util;

import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class List<A>
extends AbstractCollection<A>
implements java.util.List<A> {
    public A head;
    public List<A> tail;
    private static final List<?> EMPTY_LIST = new List<Object>(null, null){

        @Override
        public List<Object> setTail(List<Object> tail) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private static final Iterator<?> EMPTYITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    List(A head, List<A> tail) {
        this.tail = tail;
        this.head = head;
    }

    public static <A> List<A> nil() {
        return EMPTY_LIST;
    }

    public static <A> List<A> filter(List<A> l, A elem) {
        Assert.checkNonNull(elem);
        List<A> res = List.nil();
        for (A a : l) {
            if (a == null || a.equals(elem)) continue;
            res = res.prepend(a);
        }
        return res.reverse();
    }

    public List<A> intersect(List<A> that) {
        ListBuffer<A> buf = new ListBuffer<A>();
        for (A el : this) {
            if (!that.contains(el)) continue;
            buf.append(el);
        }
        return buf.toList();
    }

    public List<A> diff(List<A> that) {
        ListBuffer<A> buf = new ListBuffer<A>();
        for (A el : this) {
            if (that.contains(el)) continue;
            buf.append(el);
        }
        return buf.toList();
    }

    public List<A> take(int n) {
        ListBuffer<A> buf = new ListBuffer<A>();
        int count = 0;
        for (A el : this) {
            if (count++ == n) break;
            buf.append(el);
        }
        return buf.toList();
    }

    public static <A> List<A> of(A x1) {
        return new List<A>(x1, List.nil());
    }

    public static <A> List<A> of(A x1, A x2) {
        return new List<A>(x1, List.of(x2));
    }

    public static <A> List<A> of(A x1, A x2, A x3) {
        return new List<A>(x1, List.of(x2, x3));
    }

    public static <A> List<A> of(A x1, A x2, A x3, A ... rest) {
        return new List<A>(x1, new List<A>(x2, new List<A>(x3, List.from(rest))));
    }

    public static <A> List<A> from(A[] array) {
        List<A> xs = List.nil();
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                xs = new List<A>(array[i], xs);
            }
        }
        return xs;
    }

    public static <A> List<A> from(Iterable<? extends A> coll) {
        ListBuffer<A> xs = new ListBuffer<A>();
        for (A a : coll) {
            xs.append(a);
        }
        return xs.toList();
    }

    @Deprecated
    public static <A> List<A> fill(int len, A init) {
        List<A> l = List.nil();
        for (int i = 0; i < len; ++i) {
            l = new List<A>(init, l);
        }
        return l;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == null;
    }

    public boolean nonEmpty() {
        return this.tail != null;
    }

    public int length() {
        List<A> l = this;
        int len = 0;
        while (l.tail != null) {
            l = l.tail;
            ++len;
        }
        return len;
    }

    @Override
    public int size() {
        return this.length();
    }

    public List<A> setTail(List<A> tail) {
        this.tail = tail;
        return tail;
    }

    public List<A> prepend(A x) {
        return new List<A>(x, this);
    }

    public List<A> prependList(List<A> xs) {
        if (this.isEmpty()) {
            return xs;
        }
        if (xs.isEmpty()) {
            return this;
        }
        if (xs.tail.isEmpty()) {
            return this.prepend(xs.head);
        }
        List<A> result = this;
        List<A> rev = xs.reverse();
        Assert.check(rev != xs);
        while (rev.nonEmpty()) {
            List<A> h = rev;
            rev = rev.tail;
            h.setTail(result);
            result = h;
        }
        return result;
    }

    public List<A> reverse() {
        if (this.isEmpty() || this.tail.isEmpty()) {
            return this;
        }
        List<A> rev = List.nil();
        List<A> l = this;
        while (l.nonEmpty()) {
            rev = new List<A>(l.head, rev);
            l = l.tail;
        }
        return rev;
    }

    public List<A> append(A x) {
        return List.of(x).prependList(this);
    }

    public List<A> appendList(List<A> x) {
        return x.prependList(this);
    }

    public List<A> appendList(ListBuffer<A> x) {
        return this.appendList(x.toList());
    }

    @Override
    public <T> T[] toArray(T[] vec) {
        int i;
        List<A> l = this;
        T[] dest = vec;
        for (i = 0; l.nonEmpty() && i < vec.length; ++i) {
            dest[i] = l.head;
            l = l.tail;
        }
        if (l.isEmpty()) {
            if (i < vec.length) {
                vec[i] = null;
            }
            return vec;
        }
        vec = (Object[])Array.newInstance(vec.getClass().getComponentType(), this.size());
        return this.toArray(vec);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public String toString(String sep) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.head);
        List<A> l = this.tail;
        while (l.nonEmpty()) {
            buf.append(sep);
            buf.append(l.head);
            l = l.tail;
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(",");
    }

    @Override
    public int hashCode() {
        List<A> l = this;
        int h = 1;
        while (l.tail != null) {
            h = h * 31 + (l.head == null ? 0 : l.head.hashCode());
            l = l.tail;
        }
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof List) {
            return List.equals(this, (List)other);
        }
        if (other instanceof java.util.List) {
            List<A> t = this;
            Iterator oIter = ((java.util.List)other).iterator();
            while (t.tail != null && oIter.hasNext()) {
                Object o = oIter.next();
                if (!(t.head != null ? t.head.equals(o) : o == null)) {
                    return false;
                }
                t = t.tail;
            }
            return t.isEmpty() && !oIter.hasNext();
        }
        return false;
    }

    public static boolean equals(List<?> xs, List<?> ys) {
        while (xs.tail != null && ys.tail != null) {
            if (xs.head == null ? ys.head != null : !xs.head.equals(ys.head)) {
                return false;
            }
            xs = xs.tail;
            ys = ys.tail;
        }
        return xs.tail == null && ys.tail == null;
    }

    @Override
    public boolean contains(Object x) {
        List<A> l = this;
        while (l.tail != null) {
            if (x == null ? l.head == null : l.head.equals(x)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public A last() {
        A last = null;
        List<A> t = this;
        while (t.tail != null) {
            last = t.head;
            t = t.tail;
        }
        return last;
    }

    public static <T> List<T> convert(Class<T> klass, List<?> list) {
        if (list == null) {
            return null;
        }
        for (Object o : list) {
            klass.cast(o);
        }
        return list;
    }

    private static <A> Iterator<A> emptyIterator() {
        return EMPTYITERATOR;
    }

    @Override
    public Iterator<A> iterator() {
        if (this.tail == null) {
            return List.emptyIterator();
        }
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = List.this;
            }

            @Override
            public boolean hasNext() {
                return this.elems.tail != null;
            }

            @Override
            public A next() {
                if (this.elems.tail == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.elems.head;
                this.elems = this.elems.tail;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public A get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        List<A> l = this;
        int i = index;
        while (i-- > 0 && !l.isEmpty()) {
            l = l.tail;
        }
        if (l.isEmpty()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", " + "Size: " + this.size());
        }
        return l.head;
    }

    @Override
    public boolean addAll(int index, Collection<? extends A> c) {
        if (c.isEmpty()) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public A set(int index, A element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, A element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public A remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        List<A> l = this;
        while (l.tail != null) {
            if (l.head == null ? o == null : l.head.equals(o)) {
                return i;
            }
            l = l.tail;
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int last = -1;
        int i = 0;
        List<A> l = this;
        while (l.tail != null) {
            if (l.head == null ? o == null : l.head.equals(o)) {
                last = i;
            }
            l = l.tail;
            ++i;
        }
        return last;
    }

    @Override
    public ListIterator<A> listIterator() {
        return Collections.unmodifiableList(new ArrayList(this)).listIterator();
    }

    @Override
    public ListIterator<A> listIterator(int index) {
        return Collections.unmodifiableList(new ArrayList(this)).listIterator(index);
    }

    @Override
    public java.util.List<A> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        ArrayList<A> a = new ArrayList<A>(toIndex - fromIndex);
        List<A> l = this;
        for (int i = 0; l.tail != null && i != toIndex; ++i) {
            if (i >= fromIndex) {
                a.add(l.head);
            }
            l = l.tail;
        }
        return Collections.unmodifiableList(a);
    }
}

