/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.launcher;

import com.redhat.ceylon.launcher.LauncherUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;

public class CeylonClassLoader
extends URLClassLoader {
    private String signature;

    public static CeylonClassLoader newInstance() throws URISyntaxException, MalformedURLException, FileNotFoundException {
        return new CeylonClassLoader(CeylonClassLoader.getClassPath());
    }

    public static CeylonClassLoader newInstance(List<File> classPath) throws URISyntaxException, MalformedURLException, FileNotFoundException {
        return new CeylonClassLoader(classPath);
    }

    private CeylonClassLoader(List<File> classPath) throws URISyntaxException, MalformedURLException, FileNotFoundException {
        super(CeylonClassLoader.toUrls(classPath));
        this.signature = CeylonClassLoader.toString(classPath);
    }

    private CeylonClassLoader(List<File> classPath, ClassLoader parentLoader) throws URISyntaxException, MalformedURLException, FileNotFoundException {
        super(CeylonClassLoader.toUrls(classPath), parentLoader);
        this.signature = CeylonClassLoader.toString(classPath);
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean hasSignature(String signature) {
        return signature != null && this.signature.equals(signature);
    }

    private static URL[] toUrls(List<File> cp) throws MalformedURLException {
        URL[] urls = new URL[cp.size()];
        int i = 0;
        for (File f : cp) {
            urls[i++] = f.toURI().toURL();
        }
        return urls;
    }

    private static String toString(List<File> cp) {
        StringBuilder classPath = new StringBuilder();
        for (File f : cp) {
            if (classPath.length() > 0) {
                classPath.append(File.pathSeparatorChar);
            }
            classPath.append(f.getAbsolutePath());
        }
        return classPath.toString();
    }

    public static String getClassPathAsString() throws URISyntaxException, FileNotFoundException {
        return CeylonClassLoader.toString(CeylonClassLoader.getClassPath());
    }

    public static String getClassPathSignature(List<File> cp) {
        return CeylonClassLoader.toString(cp);
    }

    public static List<File> getClassPath() throws URISyntaxException, FileNotFoundException {
        File ceylonHome = LauncherUtil.determineHome();
        File ceylonRepo = LauncherUtil.determineRepo(ceylonHome);
        boolean includeSlf4j = LauncherUtil.isIncludeSlf4j();
        CeylonClassLoader.checkFolders(ceylonHome, ceylonRepo);
        LinkedList<File> archives = new LinkedList<File>();
        String version2 = LauncherUtil.determineSystemVersion();
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.compiler.java", version2));
        archives.add(CeylonClassLoader.getRepoCar(ceylonRepo, "ceylon.language", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "ceylon.runtime", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.compiler.js", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.typechecker", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.common", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.cli", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.model", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.module-loader", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.module-resolver", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.module-resolver-aether", version2));
        if (includeSlf4j) {
            archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.module-resolver-webdav", version2));
        }
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.module-resolver-javascript", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.langtools.classfile", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.tool.provider", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.redhat.ceylon.tools", version2));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.jboss.modules", "1.4.4.Final"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.jboss.logmanager", "2.0.3.Final"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.eclipse.aether.api", "1.1.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.eclipse.aether.spi", "1.1.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.eclipse.aether.util", "1.1.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.eclipse.aether.impl", "1.1.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.eclipse.aether.connector.basic", "1.1.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.eclipse.aether.transport.file", "1.1.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.eclipse.aether.transport.http", "1.1.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.google.guava", "18.0"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.commons.lang3", "3.4"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-artifact", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-model", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-model-builder", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-repository-metadata", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-builder-support", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-settings", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-settings-builder", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.maven.maven-aether-provider", "3.3.9"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.codehaus.plexus.plexus-interpolation", "1.22"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.codehaus.plexus.plexus-utils", "3.0.22"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.antlr.runtime", "3.4"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "net.minidev.json-smart", "1.1.1"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.tautua.markdownpapers.core", "1.2.7"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.github.rjeschke.txtmark", "0.13"));
        if (includeSlf4j) {
            archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "com.github.lookfirst.sardine", "5.1"));
            archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.slf4j.api", "1.6.1"));
            archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.slf4j.simple", "1.6.1"));
        }
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.httpcomponents.httpclient", "4.3.2"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.httpcomponents.httpcore", "4.3.2"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.commons.logging", "1.1.1"));
        archives.add(CeylonClassLoader.getRepoJar(ceylonRepo, "org.apache.commons.codec", "1.8"));
        return archives;
    }

    private static File getRepoJar(File repo, String moduleName, String version2) {
        return CeylonClassLoader.getRepoUrl(repo, moduleName, version2, "jar");
    }

    private static File getRepoCar(File repo, String moduleName, String version2) {
        return CeylonClassLoader.getRepoUrl(repo, moduleName, version2, "car");
    }

    private static File getRepoUrl(File repo, String moduleName, String version2, String extension) {
        return new File(repo, moduleName.replace('.', '/') + "/" + version2 + "/" + moduleName + "-" + version2 + "." + extension);
    }

    public static File getRepoJar(String moduleName, String version2) throws FileNotFoundException, URISyntaxException {
        return CeylonClassLoader.getRepoUrl(moduleName, version2, "jar");
    }

    public static File getRepoCar(String moduleName, String version2) throws FileNotFoundException, URISyntaxException {
        return CeylonClassLoader.getRepoUrl(moduleName, version2, "car");
    }

    public static File getRepoUrl(String moduleName, String version2, String extension) throws URISyntaxException, FileNotFoundException {
        File ceylonHome = LauncherUtil.determineHome();
        File ceylonRepo = LauncherUtil.determineRepo(ceylonHome);
        CeylonClassLoader.checkFolders(ceylonHome, ceylonRepo);
        return new File(ceylonRepo, moduleName.replace('.', '/') + "/" + version2 + "/" + moduleName + "-" + version2 + "." + extension);
    }

    private static void checkFolders(File ceylonHome, File ceylonRepo) throws FileNotFoundException {
        if (!ceylonHome.isDirectory()) {
            throw new FileNotFoundException("Could not determine the Ceylon home directory (" + ceylonHome + ")");
        }
        if (!ceylonRepo.isDirectory()) {
            throw new FileNotFoundException("The Ceylon system repository could not be found (" + ceylonRepo + ")");
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> localUrls = this.findResources(name);
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null) {
            parentUrls = this.getParent().getResources(name);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return Collections.enumeration(urls);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url != null) {
            try {
                URLConnection con = url.openConnection();
                con.setUseCaches(false);
                return con.getInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void clearCacheButNotWithThisNameToKeepSpringBootHappy() {
        try {
            Class<URLClassLoader> klass = URLClassLoader.class;
            Field ucp = klass.getDeclaredField("ucp");
            ucp.setAccessible(true);
            Object sunMiscURLClassPath = ucp.get(this);
            Field loaders = sunMiscURLClassPath.getClass().getDeclaredField("loaders");
            loaders.setAccessible(true);
            Object collection = loaders.get(sunMiscURLClassPath);
            for (Object sunMiscURLClassPathJarLoader : ((Collection)collection).toArray()) {
                try {
                    Field loader = sunMiscURLClassPathJarLoader.getClass().getDeclaredField("jar");
                    loader.setAccessible(true);
                    Object jarFile = loader.get(sunMiscURLClassPathJarLoader);
                    ((JarFile)jarFile).close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

