/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.MainClass_attribute;
import com.redhat.ceylon.langtools.classfile.Module_attribute;
import com.redhat.ceylon.langtools.classfile.Version_attribute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Java9ModuleReader {
    public static List<String> getExportedPackages(File jar) {
        Java9Module module = Java9ModuleReader.getJava9Module(jar);
        if (module != null) {
            ArrayList<String> ret = new ArrayList<String>(module.exports.size());
            ret.addAll(module.exports);
            return ret;
        }
        return null;
    }

    public static Java9Module getJava9Module(ZipFile zipFile, ZipEntry entry) {
        ClassFile classFile = Java9ModuleReader.getClassFile(zipFile, entry);
        if (classFile == null) {
            return null;
        }
        Module_attribute moduleAttribute = (Module_attribute)classFile.getAttribute("Module");
        if (moduleAttribute != null) {
            return new Java9Module(moduleAttribute, classFile);
        }
        return null;
    }

    public static Java9Module getJava9Module(File jar) {
        ClassFile classFile = Java9ModuleReader.getClassFile(jar);
        if (classFile == null) {
            return null;
        }
        Module_attribute moduleAttribute = (Module_attribute)classFile.getAttribute("Module");
        if (moduleAttribute != null) {
            return new Java9Module(moduleAttribute, classFile);
        }
        return null;
    }

    public static Java9Module getJava9Module(InputStream is) {
        ClassFile classFile = Java9ModuleReader.getClassFile(is);
        if (classFile == null) {
            return null;
        }
        Module_attribute moduleAttribute = (Module_attribute)classFile.getAttribute("Module");
        if (moduleAttribute != null) {
            return new Java9Module(moduleAttribute, classFile);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassFile getClassFile(File jar) {
        try {
            if (ModuleUtil.isMavenJarlessModule(jar)) {
                return null;
            }
            try (ZipFile zipFile = new ZipFile(jar);){
                ZipEntry entry = zipFile.getEntry("module-info.class");
                if (entry == null) return null;
                ClassFile classFile = Java9ModuleReader.getClassFile(zipFile, entry);
                return classFile;
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassFile getClassFile(ZipFile zipFile, ZipEntry entry) {
        try (InputStream in = zipFile.getInputStream(entry);){
            ClassFile classFile = Java9ModuleReader.getClassFile(in);
            return classFile;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private static ClassFile getClassFile(InputStream in) {
        try {
            return ClassFile.read(in);
        }
        catch (ConstantPoolException | IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static class Java9ModuleDependency {
        public final String module;
        public final boolean shared;

        public Java9ModuleDependency(String module, boolean shared) {
            this.module = module;
            this.shared = shared;
        }
    }

    public static class Java9Module {
        public final String name;
        public final String version;
        public final String mainClass;
        public final Set<String> exports = new HashSet<String>();
        public final List<Java9ModuleDependency> dependencies = new ArrayList<Java9ModuleDependency>();

        public Java9Module(Module_attribute moduleAttribute, ClassFile classFile) {
            try {
                String nameAttr = classFile.getName();
                if (nameAttr.endsWith("/module-info")) {
                    nameAttr = nameAttr.substring(0, nameAttr.length() - 12);
                }
                this.name = nameAttr.replace('/', '.');
                for (Module_attribute.ExportsEntry export : moduleAttribute.exports) {
                    if (export.exports_to_count != 0) continue;
                    String ex = classFile.constant_pool.getUTF8Value(export.exports_index).replace('/', '.');
                    this.exports.add(ex);
                }
                for (Module_attribute.RequiresEntry requires : moduleAttribute.requires) {
                    this.dependencies.add(new Java9ModuleDependency(requires.getRequires(-1, classFile.constant_pool), (requires.requires_flags & 0x20) != 0));
                }
                Version_attribute versionAttribute = (Version_attribute)classFile.getAttribute("Version");
                this.version = versionAttribute != null ? classFile.constant_pool.getUTF8Value(versionAttribute.version_index) : null;
                MainClass_attribute mainAttribute = (MainClass_attribute)classFile.getAttribute("MainClass");
                this.mainClass = mainAttribute != null ? mainAttribute.getMainClassName(classFile.constant_pool).replace('/', '.') : null;
            }
            catch (ConstantPoolException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

