/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.model.FieldValue;
import com.redhat.ceylon.model.loader.model.JavaBeanValue;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;

public class NamingBase {
    public static final String OLD_MODULE_DESCRIPTOR_CLASS_NAME = "module_";
    public static final String MODULE_DESCRIPTOR_CLASS_NAME = "$module_";
    public static final String PACKAGE_DESCRIPTOR_CLASS_NAME = "$package_";

    public static String prefixName(Prefix prefix, String s) {
        return prefix.toString() + s;
    }

    public static String prefixName(Prefix prefix, String ... rest) {
        if (rest.length == 0) {
            throw new RuntimeException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        for (String s : rest) {
            sb.append(s).append('$');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String suffixName(Suffix suffix, String s) {
        return s + suffix.toString();
    }

    public static String getAliasInstantiatorMethodName(Class model) {
        String name = NamingBase.suffixName(Suffix.$aliased$, model.getName());
        if (!model.isShared()) {
            name = NamingBase.suffixName(Suffix.$priv$, name);
        }
        return name;
    }

    public static String stripLeadingDollar(String str) {
        return !str.isEmpty() && str.charAt(0) == '$' ? str.substring(1) : str;
    }

    public static String capitalize(String str) {
        return new StringBuilder().appendCodePoint(Character.toUpperCase(str.codePointAt(0))).append(str.substring(Character.isSurrogate(str.charAt(0)) ? 2 : 1)).toString();
    }

    public static String getDisambigAnnoCtorName(Interface iface, OutputElement target) {
        return NamingBase.getJavaBeanName(iface.getName()) + "__" + (Object)((Object)target);
    }

    public static String getJavaBeanName(String name) {
        int c;
        int[] newName = new int[name.codePointCount(0, name.length())];
        int codePointIndex = 0;
        for (int charIndex = 0; charIndex < name.length(); charIndex += Character.charCount(c)) {
            c = name.codePointAt(charIndex);
            newName[codePointIndex++] = c;
        }
        if (NamingBase.is_CONSTANT_CASE(newName)) {
            return NamingBase.constant_case_toCamelCase(newName);
        }
        for (int i = 0; i < newName.length; ++i) {
            int codepoint = newName[i];
            if (Character.isLowerCase(codepoint) || codepoint == 95) {
                if (i <= 1) break;
                newName[i - 1] = Character.toUpperCase(newName[i - 1]);
                break;
            }
            newName[i] = Character.toLowerCase(codepoint);
        }
        return new String(newName, 0, newName.length);
    }

    private static String constant_case_toCamelCase(int[] newName) {
        int j = 0;
        boolean capitaliseNext = false;
        for (int i = 0; i < newName.length; ++i) {
            int codepoint = newName[i];
            if (codepoint == 95) {
                capitaliseNext = true;
                continue;
            }
            if (capitaliseNext) {
                newName[j++] = codepoint;
                capitaliseNext = false;
                continue;
            }
            newName[j++] = Character.toLowerCase(codepoint);
        }
        return new String(newName, 0, j);
    }

    private static boolean is_CONSTANT_CASE(int[] newName) {
        if (newName.length <= 1) {
            return false;
        }
        boolean hasOneUnderscore = false;
        for (int i = 0; i < newName.length; ++i) {
            int codepoint = newName[i];
            if (Character.isLowerCase(codepoint) && codepoint != 95) {
                return false;
            }
            if (codepoint != 95) continue;
            hasOneUnderscore = true;
        }
        return hasOneUnderscore;
    }

    public static String getReverseJavaBeanName(String name) {
        for (int i = 0; i < name.length(); i += Character.isSurrogate(name.charAt(i)) ? 2 : 1) {
            if (!Character.isUpperCase(name.codePointAt(i))) continue;
            return name.substring(0, i).toUpperCase() + name.substring(i);
        }
        return name.toUpperCase();
    }

    public static String getGetterName(Declaration decl) {
        return NamingBase.getGetterName(decl, false);
    }

    public static String getGetterName(Declaration decl, boolean indirect) {
        boolean enumeratedConstructor;
        if ((decl = decl.getRefinedDeclaration()) instanceof FieldValue) {
            return ((FieldValue)decl).getRealName();
        }
        if (decl instanceof JavaBeanValue && !indirect) {
            return ((JavaBeanValue)decl).getGetterName();
        }
        boolean bl = enumeratedConstructor = decl instanceof Value && ((Value)decl).getType() != null && ((Value)decl).getType().getDeclaration() instanceof Constructor;
        if (ModelUtil.withinClassOrInterface(decl) && (!ModelUtil.isLocalToInitializer(decl) || enumeratedConstructor || decl.isStatic()) && !indirect) {
            if (enumeratedConstructor) {
                Class constructedClass = ModelUtil.getConstructedClass(decl);
                if (constructedClass.isToplevel() || constructedClass.isClassMember()) {
                    return NamingBase.getGetterName(((Class)decl.getContainer()).getName() + "$" + decl.getName());
                }
                return NamingBase.name(Unfix.ref);
            }
            return NamingBase.getErasedGetterName(decl);
        }
        if (decl instanceof TypedDeclaration && JvmBackendUtil.isBoxedVariable((TypedDeclaration)decl)) {
            return NamingBase.name(Unfix.ref);
        }
        return NamingBase.name(Unfix.get_);
    }

    public static String getSetterName(Declaration decl) {
        Declaration refinedDecl = decl.getRefinedDeclaration();
        if (JvmBackendUtil.isValue(decl) && JvmBackendUtil.isValue(refinedDecl)) {
            Value v = (Value)decl;
            Value rv = (Value)refinedDecl;
            if (!v.isVariable() || rv.isVariable()) {
                decl = refinedDecl;
            }
        } else {
            decl = refinedDecl;
        }
        if (decl instanceof FieldValue) {
            return ((FieldValue)decl).getRealName();
        }
        if (decl instanceof JavaBeanValue && ((JavaBeanValue)decl).getSetterName() != null) {
            return ((JavaBeanValue)decl).getSetterName();
        }
        if (ModelUtil.withinClassOrInterface(decl) && !ModelUtil.isLocalToInitializer(decl) || decl.isStatic()) {
            String setterName = NamingBase.getSetterName(decl.getName());
            if (decl.isMember() && !decl.isShared()) {
                setterName = NamingBase.suffixName(Suffix.$priv$, setterName);
            }
            return setterName;
        }
        if (decl instanceof TypedDeclaration && JvmBackendUtil.isBoxedVariable((TypedDeclaration)decl)) {
            return NamingBase.name(Unfix.ref);
        }
        return NamingBase.name(Unfix.set_);
    }

    private static String getErasedGetterName(Declaration decl) {
        String property = decl.getName();
        if (!(decl instanceof Value) || ((Value)decl).isShared()) {
            if ("hash".equals(property)) {
                return "hashCode";
            }
            if ("string".equals(property)) {
                return "toString";
            }
        }
        String getterName = NamingBase.getGetterName(property);
        if (decl.isMember() && !decl.isShared()) {
            getterName = NamingBase.suffixName(Suffix.$priv$, getterName);
        }
        return getterName;
    }

    public static String getGetterName(String property) {
        String result = "get" + NamingBase.capitalize(NamingBase.stripLeadingDollar(property));
        if ("getClass".equals(result)) {
            result = "getClass$";
        }
        return result;
    }

    public static String getSetterName(String property) {
        return "set" + NamingBase.capitalize(NamingBase.stripLeadingDollar(property));
    }

    public static String name(Unfix unfix) {
        return unfix.toString();
    }

    public static String getJavaAttributeName(String getterName) {
        if (getterName.startsWith("get") || getterName.startsWith("set")) {
            return NamingBase.getJavaBeanName(getterName.substring(3));
        }
        if (getterName.startsWith("is")) {
            return NamingBase.getJavaBeanName(getterName.substring(2));
        }
        if (getterName.equals("hashCode")) {
            return "hash";
        }
        if (getterName.equals("toString")) {
            return "string";
        }
        throw new RuntimeException("Illegal java getter/setter name " + getterName);
    }

    public static String getValueConstructorFieldNameAsString(Value singletonModel) {
        Class clz = (Class)singletonModel.getContainer();
        if (clz.isToplevel()) {
            return JVMModuleUtil.quoteIfJavaKeyword(singletonModel.getName());
        }
        if (clz.isClassMember()) {
            return NamingBase.prefixName(Prefix.$instance$, clz.getName(), singletonModel.getName());
        }
        return NamingBase.prefixName(Prefix.$instance$, clz.getName(), singletonModel.getName());
    }

    public static enum Prefix implements Affix
    {
        $next$,
        $arg$,
        $ceylontmp$,
        $default$,
        $init$,
        $iterator$,
        $reified$,
        $superarg$,
        $pattern$,
        $instance$,
        $array$;

    }

    public static enum Suffix implements Affix
    {
        $delegation$,
        $aliased$,
        $annotation$,
        $annotations$,
        $arg$,
        $args$,
        $argthis$,
        $callable$,
        $canonical$,
        $element$,
        $exhausted$,
        $getter$,
        $impl,
        $iterable$,
        $iteration$,
        $iterator$,
        $new$,
        $param$,
        $priv$,
        $qual$,
        $reified$,
        $sb$,
        $setter$,
        $specifier$,
        $this$,
        $variadic$;

    }

    public static enum Unfix implements Affix
    {
        ref,
        set_,
        get_,
        value,
        $name$,
        $annotationSequence$,
        $array$,
        $call$,
        $callvariadic$,
        $calltyped$,
        $element$,
        $evaluate$,
        $get$,
        $getArray$,
        $getFirst$,
        $getLength$,
        $getType$,
        $getIterables$,
        $index$,
        $initException$,
        $instance$,
        $invoke$,
        $lookup$,
        $refine$,
        $return$,
        $sb$,
        $spreadVarargs$,
        $TypeDescriptor$,
        $apply$,
        apply,
        $serialize$,
        deconstructor,
        $references$,
        $set$,
        reference,
        instance,
        $isMember$,
        $object$;

    }

    static interface Affix {
    }
}

