/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class Timer {
    private long programStart;
    private String currentTask;
    private long currentTaskStart;
    protected boolean verbose;
    private final Map<String, IgnoredCategory> ignoredCategories;
    protected PrintWriter out;

    protected Timer() {
        this.ignoredCategories = new HashMap<String, IgnoredCategory>();
    }

    private Timer(PrintWriter out, long programStart, boolean verbose, Map<String, IgnoredCategory> ignoredCategories) {
        this.programStart = programStart;
        this.verbose = verbose;
        this.ignoredCategories = ignoredCategories;
        this.out = out;
    }

    public Timer(boolean verbose) {
        this.ignoredCategories = new HashMap<String, IgnoredCategory>();
        this.setup(verbose);
    }

    private void setup(boolean verbose) {
    }

    public void init() {
        this.programStart = System.nanoTime();
        if (this.verbose) {
            this.log("Program start", this.programStart);
        }
    }

    public void end() {
        if (!this.verbose) {
            return;
        }
        this.log("Program end");
    }

    public void startTask(String name) {
        if (!this.verbose) {
            return;
        }
        if (this.currentTask != null) {
            this.endTask();
        }
        this.currentTask = name;
        this.currentTaskStart = System.nanoTime();
        this.log("Task " + this.currentTask + " start");
    }

    public void log(String string) {
        if (!this.verbose) {
            return;
        }
        this.log(string, System.nanoTime());
    }

    private void log(String string, long now) {
        long delta = (now - this.programStart) / 1000000L;
        String msg = "[" + delta + "ms] " + string;
        if (this.out != null) {
            this.out.println(msg);
        } else {
            System.err.println(msg);
        }
    }

    public void print(String string) {
        if (!this.verbose) {
            return;
        }
        if (this.out != null) {
            this.out.println(string);
        } else {
            System.err.println(string);
        }
    }

    public void endTask() {
        if (!this.verbose) {
            return;
        }
        long time = System.nanoTime();
        long delta = (time - this.currentTaskStart) / 1000000L;
        this.log("Task " + this.currentTask + " end: " + delta + "ms");
        this.printIgnoredCategories();
        this.currentTask = null;
    }

    public void startIgnore(String category) {
        if (!this.verbose) {
            return;
        }
        IgnoredCategory ignoredCategory = this.ignoredCategories.get(category);
        if (ignoredCategory == null) {
            ignoredCategory = new IgnoredCategory(category);
            this.ignoredCategories.put(category, ignoredCategory);
        }
        ignoredCategory.start();
    }

    public void stopIgnore(String category) {
        if (!this.verbose) {
            return;
        }
        IgnoredCategory ignoredCategory = this.ignoredCategories.get(category);
        if (ignoredCategory != null) {
            ignoredCategory.stop();
        }
    }

    private void printIgnoredCategories() {
        for (IgnoredCategory category : this.ignoredCategories.values()) {
            if (category.total != 0L) {
                this.print(" Including " + category.name + " for " + category.total + "ms");
            }
            category.reset();
        }
    }

    public Timer nestedTimer() {
        return new Timer(this.out, this.programStart, this.verbose, this.ignoredCategories);
    }

    private final class IgnoredCategory {
        String name;
        long start;
        long total;
        int count;

        public IgnoredCategory(String category) {
            this.name = category;
        }

        public void start() {
            if (this.count++ == 0) {
                this.start = System.nanoTime();
            }
        }

        public void stop() {
            if (--this.count == 0) {
                long end = System.nanoTime();
                long delta = (end - this.start) / 1000000L;
                this.total += delta;
            }
        }

        public void reset() {
            if (this.count != 0) {
                Timer.this.print("Ignored category " + this.name + " count is " + this.count + " during reset: timings will be wrong");
            }
            this.count = 0;
            this.total = 0L;
        }
    }
}

