/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ContentAwareArtifactResult;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class LazyModule
extends Module {
    private boolean isJava = false;
    protected Set<String> jarPackages = new HashSet<String>();
    private PackagePathsProvider packagePathsProvider;
    private List<String> exportedJavaPackages;

    @Override
    public Package getDirectPackage(String name) {
        return this.findPackageInModule(this, name);
    }

    @Override
    public Package getPackage(String name) {
        Module languageModule;
        Package pkg = null;
        boolean defaultModule = this.isDefaultModule();
        if (!defaultModule && (pkg = this.findPackageInModule(this, name)) != null) {
            return this.loadPackage(pkg);
        }
        HashSet<Module> visited = new HashSet<Module>();
        for (ModuleImport dependency : this.getImports()) {
            pkg = this.findPackageInImport(name, dependency, visited);
            if (pkg == null) continue;
            return this.loadPackage(pkg);
        }
        AbstractModelLoader modelLoader = this.getModelLoader();
        JdkProvider jdkProvider = modelLoader.getJdkProvider();
        if (jdkProvider.isJDKModule(this.getNameAsString()) && (languageModule = this.getModelLoader().getLanguageModule()) instanceof LazyModule && (pkg = this.findPackageInModule((LazyModule)languageModule, name)) != null) {
            return this.loadPackage(pkg);
        }
        if (jdkProvider.isJDKPackage(name)) {
            return null;
        }
        if (defaultModule) {
            pkg = modelLoader.findExistingPackage(this, name);
        }
        return pkg;
    }

    private Package loadPackage(Package pkg) {
        if (pkg instanceof LazyPackage) {
            return this.getModelLoader().loadPackage((LazyPackage)pkg);
        }
        return pkg;
    }

    private Package findPackageInImport(String name, ModuleImport dependency, Set<Module> visited) {
        Module module = dependency.getModule();
        if (!visited.add(module)) {
            return null;
        }
        if (module instanceof LazyModule) {
            Package pkg = this.findPackageInModule((LazyModule)dependency.getModule(), name);
            if (pkg != null) {
                return pkg;
            }
            for (ModuleImport dep : module.getImports()) {
                if (!dep.isExport() || (pkg = this.findPackageInImport(name, dep, visited)) == null) continue;
                return pkg;
            }
            return null;
        }
        return module.getPackage(name);
    }

    private Package findPackageInModule(final LazyModule module, final String name) {
        if (module.containsPackage(name)) {
            AbstractModelLoader modelLoader = this.getModelLoader();
            return modelLoader.synchronizedCall(new Callable<Package>(){

                @Override
                public Package call() throws Exception {
                    for (Package pkg : module.getPackages()) {
                        if (!pkg.getNameAsString().equals(name)) continue;
                        return pkg;
                    }
                    return LazyModule.this.getModelLoader().findExistingPackage(module, name);
                }
            });
        }
        return null;
    }

    public Package findPackageNoLazyLoading(String name) {
        for (Package pkg : super.getPackages()) {
            if (!pkg.getNameAsString().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    protected abstract AbstractModelLoader getModelLoader();

    @Override
    public boolean isJava() {
        return this.isJava;
    }

    public void setJava(boolean isJava) {
        this.isJava = isJava;
    }

    public void loadPackageList(ArtifactResult artifact) {
        if (artifact instanceof ContentAwareArtifactResult) {
            for (String entry : ((ContentAwareArtifactResult)artifact).getPackages()) {
                String pkg = entry.replace('.', '/');
                pkg = pkg.replace("$", "");
                String pathQuery = entry.isEmpty() ? pkg : pkg + "/";
                if (artifact.filter() != null && !artifact.filter().accept(pathQuery)) continue;
                this.jarPackages.add(entry);
            }
        } else {
            File file = artifact.artifact();
            if (file != null) {
                try {
                    this.jarPackages.addAll(JvmBackendUtil.listPackages(file, artifact.filter()));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error accessing artifact: " + artifact.artifact(), e);
                }
            }
        }
    }

    public boolean containsPackage(String pkgName) {
        if (!this.isJava) {
            List<Package> superPackages = super.getPackages();
            int l = superPackages.size();
            for (int i = 0; i < l; ++i) {
                if (!superPackages.get(i).getNameAsString().equals(pkgName)) continue;
                return true;
            }
            if (this.isLanguageModule()) {
                return JvmBackendUtil.isSubPackage(this.getNameAsString(), pkgName) || pkgName.startsWith("com.redhat.ceylon.compiler.java.runtime") || pkgName.startsWith("com.redhat.ceylon.compiler.java.language") || pkgName.startsWith("com.redhat.ceylon.compiler.java.metadata");
            }
            return this.getJarPackages().contains(pkgName);
        }
        if (this.isJdkPackage(this.getNameAsString(), pkgName)) {
            return true;
        }
        JdkProvider jdkProvider = this.getModelLoader().getJdkProvider();
        if (jdkProvider.getJdkContainerModule() == this && jdkProvider.isJDKPackage(pkgName)) {
            return false;
        }
        return this.getJarPackages().contains(pkgName);
    }

    @Override
    protected boolean isJdkModule(String moduleName) {
        return this.getModelLoader().getJdkProvider().isJDKModule(moduleName);
    }

    @Override
    protected boolean isJdkPackage(String moduleName, String packageName) {
        return this.getModelLoader().getJdkProvider().isJDKPackage(moduleName, packageName);
    }

    public void addPackage(Package pkg) {
        super.getPackages().add(pkg);
    }

    public boolean isExportedJavaPackage(String name) {
        return this.exportedJavaPackages != null ? this.exportedJavaPackages.contains(name) : true;
    }

    public void setExportedJavaPackages(List<String> exportedPackages) {
        this.exportedJavaPackages = exportedPackages;
    }

    private void loadPackageListFromPackagePaths(Set<String> packagePaths) {
        for (String pkg : packagePaths) {
            pkg = pkg.replace("$", "");
            pkg = pkg.replace('/', '.');
            this.jarPackages.add(pkg);
        }
    }

    protected Set<String> getJarPackages() {
        if (this.packagePathsProvider != null) {
            this.loadPackageListFromPackagePaths(this.packagePathsProvider.getPackagePaths());
            this.packagePathsProvider = null;
        }
        return this.jarPackages;
    }

    public void setPackagePathsProvider(PackagePathsProvider packagePathsProvider) {
        this.packagePathsProvider = packagePathsProvider;
    }

    @Override
    public Module getLanguageModule() {
        Module ret = super.getLanguageModule();
        if (!ret.isAvailable()) {
            this.getModelLoader().lazyLoadModule(ret);
        }
        return ret;
    }

    @Override
    public void setLanguageModule(Module languageModule) {
        super.setLanguageModule(languageModule);
    }

    public static interface PackagePathsProvider {
        public Set<String> getPackagePaths();
    }
}

