/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.Arrays;
import java.util.List;

public abstract class LazyModuleManager
extends ModuleManager {
    protected void setupIfJDKModule(LazyModule module) {
        String nameAsString = module.getNameAsString();
        String version2 = module.getVersion();
        if (version2 != null && (JDKUtils.isJDKModule(nameAsString) || JDKUtils.isOracleJDKModule(nameAsString)) && JDKUtils.jdk.providesVersion(version2)) {
            module.setAvailable(true);
            module.setJava(true);
            module.setNativeBackends(Backend.Java.asSet());
        }
    }

    public boolean shouldLoadTransitiveDependencies() {
        return false;
    }

    @Override
    protected abstract Module createModule(List<String> var1, String var2);

    public abstract AbstractModelLoader getModelLoader();

    public boolean isModuleLoadedFromSource(String moduleName) {
        return false;
    }

    @Override
    public Iterable<String> getSearchedArtifactExtensions() {
        return Arrays.asList("car", "jar");
    }

    @Override
    public Backends getSupportedBackends() {
        return Backend.Java.asSet();
    }

    @Override
    public void addImplicitImports() {
        Module languageModule = this.modules.getLanguageModule();
        for (Module m : this.modules.getListOfModules()) {
            ModuleImport moduleImport;
            if (m instanceof LazyModule && ((LazyModule)m).isJava() || m.equals(languageModule) || (moduleImport = this.findImport(m, languageModule)) != null) continue;
            moduleImport = new ModuleImport(null, languageModule, false, true);
            m.addImport(moduleImport);
        }
    }

    @Override
    protected boolean compareVersions(Module current, String version2, String currentVersion) {
        String name = current.getNameAsString();
        if ((JDKUtils.isJDKModule(name) || JDKUtils.isOracleJDKModule(name)) && JDKUtils.jdk.providesVersion(version2) && JDKUtils.jdk.providesVersion(currentVersion)) {
            return true;
        }
        return currentVersion == null || version2 == null || currentVersion.equals(version2);
    }
}

