/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.LanguageModuleCache;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class LazyPackage
extends Package {
    private AbstractModelLoader modelLoader;
    private List<Declaration> compiledDeclarations = new ArrayList<Declaration>(3);
    private Set<Unit> lazyUnits = new HashSet<Unit>();
    private Map<String, Declaration> cache = new HashMap<String, Declaration>();
    private boolean descriptorLoaded;

    public LazyPackage(AbstractModelLoader modelLoader) {
        this.modelLoader = modelLoader;
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean ellipsis) {
        NothingType nothingDeclaration;
        LanguageModuleCache languageModuleCache;
        if (signature == null && name.equals("Nothing") && this.isLanguagePackage() && (languageModuleCache = this.getModule().getLanguageModuleCache()) != null && (nothingDeclaration = languageModuleCache.getNothingDeclaration()) != null) {
            return nothingDeclaration;
        }
        return this.getDirectMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean ellipsis) {
        return this.getDirectMember(name, signature, ellipsis, true);
    }

    private Declaration getDirectMember(String name, List<Type> signature, boolean ellipsis, boolean tryAlternates) {
        Declaration cachedDeclaration;
        boolean canCache;
        boolean bl = canCache = signature == null && !ellipsis;
        if (canCache && this.cache.containsKey(name) && !this.modelLoader.searchAgain(cachedDeclaration = this.cache.get(name), this, name)) {
            return cachedDeclaration;
        }
        Declaration ret = this.getDirectMemberMemoised(name, signature, ellipsis, Backends.ANY, tryAlternates);
        if (canCache) {
            this.cache.put(name, ret);
        }
        return ret;
    }

    @Override
    public Declaration getDirectMemberForBackend(String name, Backends backends) {
        return this.getDirectMemberMemoised(name, null, false, backends, true);
    }

    private Declaration getDirectMemberMemoised(final String name, final List<Type> signature, final boolean ellipsis, final Backends backends, final boolean tryAlternates) {
        return this.modelLoader.synchronizedCall(new Callable<Declaration>(){

            @Override
            public Declaration call() throws Exception {
                Declaration d;
                String pkgName = LazyPackage.this.getQualifiedNameString();
                Module module = LazyPackage.this.getModule();
                LazyPackage.this.modelLoader.loadPackage(module, pkgName, false);
                Declaration declaration = d = !backends.none() ? ModelUtil.lookupMemberForBackend(LazyPackage.this.compiledDeclarations, name, backends) : ModelUtil.lookupMember(LazyPackage.this.compiledDeclarations, name, signature, ellipsis);
                if (d != null) {
                    return d;
                }
                String className = LazyPackage.this.getQualifiedName(pkgName, name);
                ClassMirror classSymbol = LazyPackage.this.modelLoader.lookupClassMirror(module, className);
                if (classSymbol != null && (!classSymbol.isLoadedFromSource() || classSymbol.isJavaSource())) {
                    Class c;
                    d = LazyPackage.this.modelLoader.convertToDeclaration(module, className, ModelLoader.DeclarationType.VALUE);
                    if (d instanceof Class && (c = (Class)d).isAbstraction() && signature != null) {
                        ArrayList<Declaration> list = new ArrayList<Declaration>(c.getOverloads());
                        list.add(c);
                        return !backends.none() ? ModelUtil.lookupMemberForBackend(list, name, backends) : ModelUtil.lookupMember(list, name, signature, ellipsis);
                    }
                    if (d != null && LazyPackage.this.isForBackend(d, backends)) {
                        return d;
                    }
                }
                if ((d = LazyPackage.this.getDirectMemberFromSource(name, backends)) == null && tryAlternates && !name.isEmpty() && Character.isLowerCase(name.codePointAt(0)) && Character.isUpperCase(Character.toUpperCase(name.codePointAt(0)))) {
                    for (String annotationName : Arrays.asList(NamingBase.capitalize(name), NamingBase.getReverseJavaBeanName(name), NamingBase.capitalize(name).replaceFirst("__(CONSTRUCTOR|TYPE|PACKAGE|FIELD|METHOD|ANNOTATION_TYPE|LOCAL_VARIABLE|PARAMETER|SETTER|GETTER)$", ""))) {
                        Declaration possibleAnnotationType = LazyPackage.this.getDirectMember(annotationName, signature, ellipsis, false);
                        if (possibleAnnotationType == null || !(possibleAnnotationType instanceof LazyInterface) || !((LazyInterface)possibleAnnotationType).isAnnotationType()) continue;
                        d = !backends.none() ? ModelUtil.lookupMemberForBackend(LazyPackage.this.compiledDeclarations, name, backends) : ModelUtil.lookupMember(LazyPackage.this.compiledDeclarations, name, signature, ellipsis);
                    }
                }
                if (d == null && tryAlternates && !name.isEmpty() && Character.isUpperCase(name.codePointAt(0)) && Character.isLowerCase(Character.toLowerCase(name.codePointAt(0)))) {
                    for (String typeName : Arrays.asList(NamingBase.getJavaBeanName(name))) {
                        Declaration possibleLowercaseType = LazyPackage.this.getDirectMember(typeName, signature, ellipsis, false);
                        if (possibleLowercaseType == null || !(possibleLowercaseType instanceof LazyInterface) && !(possibleLowercaseType instanceof LazyClass)) continue;
                        d = !backends.none() ? ModelUtil.lookupMemberForBackend(LazyPackage.this.compiledDeclarations, name, backends) : ModelUtil.lookupMember(LazyPackage.this.compiledDeclarations, name, signature, ellipsis);
                    }
                }
                return d;
            }
        });
    }

    private boolean isForBackend(@NonNull Declaration d, @NonNull Backends backends) {
        return backends.none() || d.getNativeBackends().none() || backends.supports(d.getNativeBackends());
    }

    public Declaration getDirectMemberFromSource(String name, Backends backends) {
        for (Declaration d : super.getMembers()) {
            if (!ModelUtil.isResolvable(d) || !ModelUtil.isNamed(name, d) || !this.isForBackend(d, backends)) continue;
            return d;
        }
        return null;
    }

    public String getQualifiedName(String pkgName, String name) {
        String className = pkgName.isEmpty() ? name : JVMModuleUtil.quoteJavaKeywords(pkgName) + "." + name;
        return className;
    }

    @Override
    public List<Declaration> getMembers() {
        return this.modelLoader.synchronizedCall(new Callable<List<Declaration>>(){

            @Override
            public List<Declaration> call() throws Exception {
                LazyPackage.this.modelLoader.loadPackage(LazyPackage.this.getModule(), LazyPackage.this.getQualifiedNameString(), true);
                List sourceDeclarations = LazyPackage.super.getMembers();
                LinkedList<Declaration> ret = new LinkedList<Declaration>();
                ret.addAll(sourceDeclarations);
                ret.addAll(LazyPackage.this.compiledDeclarations);
                return ret;
            }
        });
    }

    @Override
    public void addMember(Declaration declaration) {
        super.addMember(declaration);
        this.flushCache(declaration);
    }

    private void flushCache(Declaration declaration) {
        this.cache.remove(declaration.getName());
    }

    public void addCompiledMember(final Declaration d) {
        this.modelLoader.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                LazyPackage.this.flushCache(d);
                LazyPackage.this.compiledDeclarations.add(d);
                if (d instanceof LazyInterface && !((LazyInterface)d).isCeylon() && ((LazyInterface)d).isAnnotationType()) {
                    LazyPackage.this.compiledDeclarations.addAll(LazyPackage.this.modelLoader.makeInteropAnnotation((LazyInterface)d, LazyPackage.this));
                }
                if ((d instanceof LazyClass || d instanceof LazyInterface) && d.getUnit().getFilename() != null) {
                    LazyPackage.this.lazyUnits.add(d.getUnit());
                }
            }
        });
    }

    @Override
    public Iterable<Unit> getUnits() {
        return this.modelLoader.synchronizedCall(new Callable<Iterable<Unit>>(){

            @Override
            public Iterable<Unit> call() throws Exception {
                Iterable sourceUnits = LazyPackage.super.getUnits();
                LinkedList<Unit> ret = new LinkedList<Unit>();
                for (Unit unit : sourceUnits) {
                    ret.add(unit);
                }
                ret.addAll(LazyPackage.this.lazyUnits);
                return ret;
            }
        });
    }

    @Override
    public void removeUnit(final Unit unit) {
        this.modelLoader.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                for (Declaration d : unit.getDeclarations()) {
                    LazyPackage.this.flushCache(d);
                    if (!(d instanceof TypeDeclaration)) continue;
                    ((TypeDeclaration)d).clearProducedTypeCache();
                }
                if (unit.getFilename().endsWith(".class") || unit.getFilename().endsWith(".java")) {
                    LazyPackage.this.lazyUnits.remove(unit);
                    for (Declaration d : unit.getDeclarations()) {
                        LazyPackage.this.compiledDeclarations.remove(d);
                    }
                    LazyPackage.this.modelLoader.removeDeclarations(unit.getDeclarations());
                } else {
                    LazyPackage.super.removeUnit(unit);
                }
            }
        });
    }

    public void addLazyUnit(final Unit unit) {
        this.modelLoader.synchronizedRun(new Runnable(){

            @Override
            public void run() {
                LazyPackage.this.lazyUnits.add(unit);
            }
        });
    }

    public void setDescriptorLoaded(boolean loaded) {
        this.descriptorLoaded = loaded;
    }

    public boolean isDescriptorLoaded() {
        return this.descriptorLoaded;
    }
}

