/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.ImportScope;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Scoped;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Element
implements Scoped,
ImportScope {
    private Scope container;
    private Scope scope;
    protected Unit unit;
    private List<Import> imports = null;

    Element() {
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public void addImport(Import imp) {
        if (this.imports == null) {
            this.imports = new ArrayList<Import>(3);
        }
        this.imports.add(imp);
    }

    @Override
    public void removeImport(Import imp) {
        if (this.imports != null) {
            this.imports.remove(imp);
        }
    }

    @Override
    public Import getImport(String name) {
        List<Import> imports = this.getImports();
        if (imports != null) {
            for (Import i : imports) {
                if (i.isAmbiguous() || i.getTypeDeclaration() != null || !i.getAlias().equals(name)) continue;
                return i;
            }
        }
        return null;
    }

    @Override
    public List<Declaration> getMembers() {
        return Collections.emptyList();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit compilationUnit) {
        this.unit = compilationUnit;
    }

    @Override
    public Scope getContainer() {
        return this.container;
    }

    public void setContainer(Scope scope) {
        this.container = scope;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @Override
    public String getQualifiedNameString() {
        return this.getContainer().getQualifiedNameString();
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean variadic) {
        return this.getDirectMember(name, signature, variadic, false);
    }

    public Declaration getDirectMember(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return ModelUtil.lookupMember(this.getMembers(), name, signature, variadic, onlyExactMatches);
    }

    @Override
    public Declaration getDirectMemberForBackend(String name, Backends backends) {
        return ModelUtil.lookupMemberForBackend(this.getMembers(), name, backends);
    }

    public Declaration getMember(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return this.getDirectMember(name, signature, variadic, onlyExactMatches);
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean variadic) {
        return this.getMember(name, signature, variadic, false);
    }

    @Override
    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean variadic) {
        return this.getMemberOrParameter(unit, name, signature, variadic, false);
    }

    private Declaration getImportedDeclaration(String name, List<Type> signature, boolean ellipsis) {
        List<Import> imports = this.getImports();
        if (imports != null) {
            for (Import i : imports) {
                Declaration d;
                if (i.isAmbiguous() || !i.getAlias().equals(name) || !Unit.isToplevelImport(i, d = i.getDeclaration())) continue;
                return d.getContainer().getMember(d.getName(), signature, ellipsis);
            }
        }
        return null;
    }

    public Declaration getImportedDeclaration(TypeDeclaration td, String name, List<Type> signature, boolean ellipsis) {
        List<Import> imports = this.getImports();
        if (imports != null) {
            for (Import i : imports) {
                TypeDeclaration itd = i.getTypeDeclaration();
                if (itd == null || !td.inherits(itd) || i.isAmbiguous() || !i.getAlias().equals(name)) continue;
                Declaration d = i.getDeclaration();
                return d.getContainer().getMember(d.getName(), signature, ellipsis);
            }
        }
        return null;
    }

    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        Declaration d = this.getImportedDeclaration(name, signature, variadic);
        if (d != null) {
            return d;
        }
        d = this.getMemberOrParameter(name, signature, variadic);
        if (d != null) {
            return d;
        }
        if (this.getScope() != null) {
            return this.getScope().getMemberOrParameter(unit, name, signature, variadic);
        }
        return null;
    }

    protected Declaration getMemberOrParameter(String name, List<Type> signature, boolean variadic) {
        return this.getMemberOrParameter(name, signature, variadic, false);
    }

    protected Declaration getMemberOrParameter(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return this.getDirectMember(name, signature, variadic, onlyExactMatches);
    }

    @Override
    public boolean isInherited(Declaration d) {
        if (d.getContainer() == this) {
            return false;
        }
        if (this.getContainer() != null) {
            return this.getContainer().isInherited(d);
        }
        return false;
    }

    @Override
    public TypeDeclaration getInheritingDeclaration(Declaration d) {
        if (d.getContainer() == this) {
            return null;
        }
        if (this.getContainer() != null) {
            return this.getContainer().getInheritingDeclaration(d);
        }
        return null;
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        if (d.isMember()) {
            return this.getContainer().getDeclaringType(d);
        }
        return null;
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        Map<String, DeclarationWithProximity> result = this.getScope().getMatchingDeclarations(unit, startingWith, proximity + 1, canceller);
        for (Declaration d : this.getMembers()) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            if (!ModelUtil.isResolvable(d) || ModelUtil.isOverloadedVersion(d)) continue;
            if (ModelUtil.isNameMatching(startingWith, d)) {
                result.put(d.getName(unit), new DeclarationWithProximity(d, proximity));
            }
            for (String alias : d.getAliases()) {
                if (!ModelUtil.isNameMatching(startingWith, alias)) continue;
                result.put(alias, new DeclarationWithProximity(alias, d, proximity));
            }
        }
        return result;
    }

    @Override
    public Backends getScopedBackends() {
        return this.getScope().getScopedBackends();
    }
}

