/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Function
extends FunctionOrValue
implements Generic,
Scope,
Functional {
    private List<TypeParameter> typeParameters = Collections.emptyList();
    private List<ParameterList> parameterLists = new ArrayList<ParameterList>(1);
    private Object annotationConstructor;
    private Function realFunction;

    public Object getAnnotationConstructor() {
        return this.annotationConstructor;
    }

    public void setAnnotationConstructor(Object annotationInstantiation) {
        this.annotationConstructor = annotationInstantiation;
    }

    @Override
    public boolean isParameterized() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public ParameterList getFirstParameterList() {
        List<ParameterList> lists = this.getParameterLists();
        if (lists.isEmpty()) {
            return null;
        }
        return lists.get(0);
    }

    @Override
    public List<ParameterList> getParameterLists() {
        return this.parameterLists;
    }

    @Override
    public void addParameterList(ParameterList pl) {
        this.parameterLists.add(pl);
    }

    @Override
    public boolean isDeclaredVoid() {
        return (this.flags & 0x4000000L) != 0L;
    }

    public void setDeclaredVoid(boolean declaredVoid) {
        this.flags = declaredVoid ? (this.flags |= 0x4000000L) : (this.flags &= 0xFFFFFFFFFBFFFFFFL);
    }

    public boolean isDeferred() {
        return (this.flags & 0x8000000L) != 0L;
    }

    public void setDeferred(boolean deferred) {
        this.flags = deferred ? (this.flags |= 0x8000000L) : (this.flags &= 0xFFFFFFFFF7FFFFFFL);
    }

    @Override
    public Parameter getParameter(String name) {
        for (Declaration d : this.getMembers()) {
            if (!d.isParameter() || !ModelUtil.isNamed(name, d)) continue;
            FunctionOrValue mod = (FunctionOrValue)d;
            return mod.getInitializerParameter();
        }
        return null;
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    public void setAnonymous(boolean anonymous) {
        this.flags = anonymous ? (this.flags |= 0x10000000L) : (this.flags &= 0xFFFFFFFFEFFFFFFFL);
    }

    @Override
    public boolean isAnonymous() {
        return (this.flags & 0x10000000L) != 0L;
    }

    @Override
    public boolean isNamed() {
        return (this.flags & 0x10000000L) == 0L;
    }

    @Override
    public String toString() {
        StringBuilder params = new StringBuilder();
        for (ParameterList pl : this.getParameterLists()) {
            params.append("(");
            boolean first = true;
            for (Parameter p : pl.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    params.append(", ");
                }
                FunctionOrValue model = p.getModel();
                if (model != null && model.getType() != null) {
                    if (model.isFunctional()) {
                        params.append(model.getTypedReference().getFullType().asString());
                    } else {
                        params.append(model.getType().asString());
                    }
                    params.append(" ");
                }
                params.append(p.getName());
            }
            params.append(")");
        }
        Type type = this.getType();
        return "function " + this.toStringName() + params + (type == null ? "" : " => " + type.asString());
    }

    public Function getRealFunction() {
        return this.realFunction;
    }

    public void setRealFunction(Function realFunction) {
        this.realFunction = realFunction;
    }
}

