/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TypeAlias
extends TypeDeclaration {
    private List<Declaration> members = new ArrayList<Declaration>(3);
    private List<Annotation> annotations = new ArrayList<Annotation>(4);
    private List<TypeParameter> typeParameters = Collections.emptyList();
    private boolean anonymous;

    @Override
    void collectSupertypeDeclarations(List<TypeDeclaration> results) {
        Type et = this.getExtendedType();
        if (et != null) {
            et.getDeclaration().collectSupertypeDeclarations(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inherits(TypeDeclaration dec) {
        Type et = this.getExtendedType();
        if (et != null) {
            Type.checkDepth();
            Type.incDepth();
            try {
                boolean bl = et.getDeclaration().inherits(dec);
                return bl;
            }
            finally {
                Type.decDepth();
            }
        }
        return false;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Declaration> getMembers() {
        return this.members;
    }

    @Override
    public void addMember(Declaration declaration) {
        this.members.add(declaration);
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        return DeclarationKind.TYPE;
    }

    @Override
    public boolean isAlias() {
        return true;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isNamed() {
        return !this.anonymous;
    }

    @Override
    public boolean isParameterized() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public boolean isMember() {
        return this.getContainer() instanceof ClassOrInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyType() {
        Type et = this.getExtendedType();
        if (et != null) {
            Type.checkDepth();
            Type.incDepth();
            try {
                boolean bl = et.getDeclaration().isEmptyType();
                return bl;
            }
            finally {
                Type.decDepth();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTupleType() {
        Type et = this.getExtendedType();
        if (et != null) {
            Type.checkDepth();
            Type.incDepth();
            try {
                boolean bl = et.getDeclaration().isTupleType();
                return bl;
            }
            finally {
                Type.decDepth();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSequentialType() {
        Type et = this.getExtendedType();
        if (et != null) {
            Type.checkDepth();
            Type.incDepth();
            try {
                boolean bl = et.getDeclaration().isSequentialType();
                return bl;
            }
            finally {
                Type.decDepth();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSequenceType() {
        Type et = this.getExtendedType();
        if (et != null) {
            Type.checkDepth();
            Type.incDepth();
            try {
                boolean bl = et.getDeclaration().isSequenceType();
                return bl;
            }
            finally {
                Type.decDepth();
            }
        }
        return false;
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        ret = ModelUtil.addHashForModule(ret, this);
        if (this.isToplevel()) {
            ret = 37 * ret + this.getQualifiedNameString().hashCode();
        } else {
            ret = 37 * ret + this.getContainer().hashCode();
            ret = 37 * ret + Objects.hashCode(this.getName());
        }
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        if (o == null || !(o instanceof ClassOrInterface)) {
            return false;
        }
        ClassOrInterface b = (ClassOrInterface)o;
        if (!ModelUtil.sameModule(this, b)) {
            return false;
        }
        if (this.isToplevel()) {
            if (!b.isToplevel()) {
                return false;
            }
            return this.getQualifiedNameString().equals(b.getQualifiedNameString());
        }
        if (b.isToplevel()) {
            return false;
        }
        return this.getContainer().equals(b.getContainer()) && Objects.equals(this.getName(), b.getName());
    }

    @Override
    public void clearProducedTypeCache() {
        ModelUtil.clearProducedTypeCache(this);
    }

    @Override
    public String toString() {
        return "alias " + this.toStringName();
    }
}

