/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.bootstrap;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.launcher.LauncherUtil;
import com.redhat.ceylon.tools.bootstrap.CeylonBootstrapMessages;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;

@Summary(value="Generates a Ceylon bootstrap script in the current directory")
@Description(value="This tool generates a `ceylonb` bootstrap shell script (and a `ceylonb.bat` batch file for Windows) that functions exactly like the normal `ceylon` command, except that it is not necessary to install Ceylon yourself. On first execution the scripts will check if the required Ceylon distribution is already available locally and if not they will download and install it.\n\nA bootstrap script can be used to make it very easy for authors of Ceylon projects to distribute their code to users without them having to install Ceylon. It is also useful for making sure that users use the exact same version of Ceylon the code was tested with without forcing them to install that exact same version themselves.\n\nThe `distribution` argument determines which distribution the bootstrap script will install. It can either be a version string, which will then be combined with the URL to the official Ceylon download site, or it can be a URL pointing directly to the desired Ceylon distribution download. If this option is not specified the current version will be used (default: 1.3.2)")
public class CeylonBootstrapTool
extends CeylonBaseTool {
    private URI distribution;
    private File installation;
    private String shaSum;
    private boolean force;
    private static final String FILE_CEYLON_SCRIPT = "ceylon";
    private static final String FILE_CEYLONB_SCRIPT = "ceylonb";

    @Argument(argumentName="distribution", multiplicity="?")
    public void setDistribution(URI distribution) {
        this.distribution = distribution;
    }

    @OptionArgument(argumentName="path")
    @Description(value="Determines where the bootstrap script will install the distribution. This can either be a path that starts with `~` or `${user.home}` to indicate a location in the user's home directory or it can start with `${ceylon.user.dir}` to indicate a location in the user's Ceylon directory. (default: ${ceylon.user.dir}/dists/)")
    public void setInstallation(File installation) {
        this.installation = installation;
    }

    @OptionArgument(argumentName="sum")
    @Description(value="The SHA-256 sum to be included for the bootstrap script (default: no sum)")
    public void setShaSum(String shaSum) {
        this.shaSum = shaSum;
    }

    @Option
    @Description(value="Create the bootstrap files even if they already exist")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        if (!this.force) {
            File sourceDir = this.applyCwd(new File("source"));
            File configDir = this.applyCwd(new File(".ceylon"));
            if (!sourceDir.isDirectory() && !configDir.isDirectory()) {
                throw new IllegalStateException(CeylonBootstrapMessages.msg("error.not.project", new Object[0]));
            }
            File scriptFile = this.applyCwd(new File(FILE_CEYLONB_SCRIPT));
            File batFile = this.applyCwd(new File("ceylonb.bat"));
            File bootstrapDir = new File(this.applyCwd(new File(".ceylon")), "bootstrap");
            File propsFile = new File(bootstrapDir, "ceylon-bootstrap.properties");
            File jarFile = new File(bootstrapDir, "ceylon-bootstrap.jar");
            if (scriptFile.exists() || batFile.exists() || propsFile.exists() || jarFile.exists()) {
                throw new IllegalStateException(CeylonBootstrapMessages.msg("error.bootstrap.exists", new Object[0]));
            }
        }
        if (this.installation != null && this.installation.isAbsolute()) {
            throw new IllegalArgumentException(CeylonBootstrapMessages.msg("error.path.not.absolute", new Object[0]));
        }
        if (this.shaSum != null && this.shaSum.length() != 64) {
            throw new IllegalArgumentException(CeylonBootstrapMessages.msg("error.shasum.length", new Object[0]));
        }
    }

    @Override
    public void run() throws Exception {
        CeylonBootstrapTool.setupBootstrap(this.validCwd().getAbsoluteFile(), this.distribution, this.installation, this.shaSum);
    }

    public static void setupBootstrap(File targetDir, URI distribution, File installation, String shaSum) throws Exception {
        File srcJar = new File(LauncherUtil.determineLibs(LauncherUtil.determineHome()), "ceylon-bootstrap.jar");
        File srcScripts = new File(LauncherUtil.determineHome(), "bin");
        CeylonBootstrapTool.setupBootstrap(targetDir, srcJar, srcScripts, distribution, installation, shaSum);
    }

    public static void setupBootstrap(File targetDir, File srcJar, File srcScripts, URI distribution, File installation, String shaSum) throws Exception {
        File bootstrapDir = new File(new File(targetDir, ".ceylon"), "bootstrap");
        FileUtil.mkdirs(bootstrapDir);
        Properties props = new Properties();
        props.setProperty("distribution", CeylonBootstrapTool.getDistributionUri(distribution).toString());
        if (installation != null) {
            props.setProperty("installation", installation.getPath());
        }
        if (shaSum != null) {
            props.setProperty("sha256sum", shaSum);
        }
        File propsFile = new File(bootstrapDir, "ceylon-bootstrap.properties");
        try (FileOutputStream out = new FileOutputStream(propsFile);){
            props.store(out, CeylonBootstrapMessages.msg("info.generated.by", new Object[0]));
        }
        File destJar = new File(bootstrapDir, "ceylon-bootstrap.jar");
        Files.copy(srcJar.toPath(), destJar.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        File srcScript = new File(srcScripts, FILE_CEYLON_SCRIPT);
        File destScript = new File(targetDir, FILE_CEYLONB_SCRIPT);
        Files.copy(srcScript.toPath(), destScript.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        destScript.setExecutable(true, false);
        File srcBat = new File(srcScripts, "ceylon.bat");
        File destBat = new File(targetDir, "ceylonb.bat");
        Files.copy(srcBat.toPath(), destBat.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    private static URI getDistributionUri(URI distribution) throws URISyntaxException {
        if (distribution == null || distribution.getScheme() == null) {
            String version2 = distribution != null ? distribution.getPath() : "1.3.2";
            return new URI("https://ceylon-lang.org/download/dist/" + version2.replace('.', '_'));
        }
        return distribution;
    }
}

