/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.jigsaw;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.tools.jigsaw.CeylonJigsawMessages;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

@Summary(value="Tools to interop with Java 9 (Jigsaw) modules")
@Description(value="There is currently one mode of action:\n\n- `create-mlib`: Generates an mlib folder suitable for Java 9 tools to run a given Ceylon module\n\nThe list of modules specified can have their versions set, but if missing we will try to find the\nversion from the current source path. If the list of modules is omitted, we will use the list of\nmodules found in the current source path.")
public class CeylonJigsawTool
extends ModuleLoadingTool {
    private List<ModuleSpec> modules;
    private boolean force;
    private boolean staticMetamodel;
    private Mode mode;
    private File out = new File("mlib");
    private final List<String> excludedModules = new ArrayList<String>();

    @Argument(order=0, argumentName="mode", multiplicity="1")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Argument(order=1, argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Description(value="Folder in which to place the resulting jars (defaults to `mlib`).")
    @OptionArgument(shortName=111, argumentName="dir")
    public void setOut(File out) {
        this.out = out;
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=120)
    @Description(value="Excludes modules from the resulting folder. Can be a module name or a file containing module names. Can be specified multiple times. Note that this excludes the module from the resulting folder, but if your modules require that module to be present at runtime it will still be required and may cause your application to fail to start if it is not provided at runtime.")
    public void setExcludeModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.excludedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonJigsawMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.excludedModules.add(each);
        }
    }

    @Option(longName="force")
    @Description(value="Force generation of mlib folder with multiple versions of the same module.")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Option(longName="static-metamodel")
    @Description(value="Generate a static metamodel descriptor (default: `false`).")
    public void setStaticMetamodel(boolean staticMetamodel) {
        this.staticMetamodel = staticMetamodel;
    }

    @Override
    public void run() throws Exception {
        for (ModuleSpec module : this.modules) {
            String moduleName = module.getName();
            String version2 = this.checkModuleVersionsOrShowSuggestions(moduleName, module.isVersioned() ? module.getVersion() : null, ModuleQuery.Type.JVM, 8, 1, null, null, null);
            if (version2 == null) {
                return;
            }
            this.loadModule(null, moduleName, version2);
            if (this.force) continue;
            this.errorOnConflictingModule(moduleName, version2);
        }
        this.loader.resolve();
        if (!this.out.exists() && !this.out.mkdirs()) {
            throw new ToolUsageError(Messages.msg(this.bundle, "jigsaw.folder.error", this.out));
        }
        final ArrayList<ArtifactResult> staticMetamodelEntries = new ArrayList<ArtifactResult>();
        this.loader.visitModules(new ModuleGraph.Visitor(){

            @Override
            public void visit(ModuleGraph.Module module) {
                if (module.artifact != null) {
                    File file = module.artifact.artifact();
                    try {
                        if (file != null) {
                            CeylonJigsawTool.this.append(file.getAbsolutePath());
                            CeylonJigsawTool.this.newline();
                            staticMetamodelEntries.add(module.artifact);
                            String name = file.getName();
                            if (name.endsWith(".car")) {
                                name = name.substring(0, name.length() - 4) + ".jar";
                            }
                            Files.copy(file.toPath(), new File(CeylonJigsawTool.this.out, name).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException x) {
                        throw new RuntimeException(x);
                    }
                }
            }
        });
        if (this.staticMetamodel) {
            JvmBackendUtil.writeStaticMetamodel(this.out, staticMetamodelEntries, this.jdkProvider);
        }
        this.flush();
    }

    @Override
    protected boolean shouldExclude(String moduleName, String version2) {
        return super.shouldExclude(moduleName, version2) || this.excludedModules.contains(moduleName);
    }

    public static enum Mode {
        create_mlib;

    }
}

