/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.new_;

import com.redhat.ceylon.compiler.typechecker.parser.ParseUtil;
import com.redhat.ceylon.tools.new_.ChoiceVariable;
import com.redhat.ceylon.tools.new_.Environment;
import com.redhat.ceylon.tools.new_.Messages;
import com.redhat.ceylon.tools.new_.PathValidator;
import com.redhat.ceylon.tools.new_.PatternValidator;
import com.redhat.ceylon.tools.new_.PromptedValue;
import com.redhat.ceylon.tools.new_.VariableValidator;
import com.redhat.ceylon.tools.new_.VariableValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Variable {
    protected final String key;
    protected final VariableValidator validator;
    protected VariableValue variableValue;
    public static PatternValidator moduleNameValidator = new PatternValidator("[a-zA-Z0-9.]+");
    public static PatternValidator moduleVersionValidator = new PatternValidator("[\\S]+");

    protected Variable(String key, VariableValidator validator, VariableValue variableValue) {
        this.key = key;
        this.variableValue = variableValue;
        this.validator = validator;
    }

    public String getKey() {
        return this.key;
    }

    public VariableValue getVariableValue() {
        return this.variableValue;
    }

    public void setVariableValue(VariableValue varValue) {
        this.variableValue = varValue;
    }

    public VariableValidator getValidator() {
        return this.validator;
    }

    public List<Variable> initialize(String projectName, Environment env) {
        String value = this.getVariableValue().getValue(projectName, env);
        if (!this.isValid(value)) {
            throw new RuntimeException(Messages.msg("value.invalid", value));
        }
        env.put(this.getKey(), value);
        List<Variable> subvars = this.subvars(value);
        return subvars != null ? subvars : Collections.emptyList();
    }

    private boolean isValid(String value) {
        VariableValidator validator = this.getValidator();
        return validator == null || validator.isValid(value);
    }

    protected List<Variable> subvars(String value) {
        return null;
    }

    public static Variable directory(String key, String defaultValue) {
        PathValidator validator = new PathValidator();
        return new Variable(key, validator, new PromptedValue(key, validator, defaultValue));
    }

    public static Variable moduleName(String key, String defaultValue) {
        return new Variable(key, moduleNameValidator, new PromptedValue(key, moduleNameValidator, defaultValue));
    }

    public static Variable moduleDir(String key, final String moduleNameKey) {
        return new Variable(key, null, new VariableValue(){

            @Override
            public String getValue(String projectName, Environment env) {
                return env.get(moduleNameKey).replace('.', '/');
            }
        });
    }

    public static Variable moduleQuotedName(String key, final String moduleNameKey) {
        return new Variable(key, null, new VariableValue(){

            @Override
            public String getValue(String projectName, Environment env) {
                return ParseUtil.quoteCeylonKeywords(env.get(moduleNameKey));
            }
        });
    }

    public static Variable moduleVersion(String key, String defaultValue) {
        return new Variable(key, moduleVersionValidator, new PromptedValue(key, moduleVersionValidator, defaultValue));
    }

    public static ChoiceVariable booleanVariable(String key, List<Variable> yesVars, List<Variable> noVars, String dv) {
        String non;
        PatternValidator validator = new PatternValidator("true|false");
        HashMap<String, List<Variable>> choices = new HashMap<String, List<Variable>>();
        final String oui = Messages.msg("mnemonic.yes", new Object[0]);
        if (oui.equals(non = Messages.msg("mnemonic.no", new Object[0]))) {
            throw new RuntimeException();
        }
        choices.put("true", yesVars);
        choices.put("false", noVars);
        PromptedValue prompt = new PromptedValue(key, dv){

            @Override
            protected String parseValue(String readLine) {
                return oui.equals(readLine) || non.equals(readLine) ? Boolean.toString(readLine.trim().equals(oui)) : null;
            }
        };
        return new ChoiceVariable(key, validator, prompt, choices);
    }

    public static ChoiceVariable yesNo(String key, Variable ... yesVars) {
        return Variable.booleanVariable(key, Arrays.asList(yesVars), null, null);
    }

    public static ChoiceVariable yesNo(String key, String dv, Variable ... yesVars) {
        return Variable.booleanVariable(key, Arrays.asList(yesVars), null, dv);
    }
}

