/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.p2;

import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.tools.p2.Category;
import com.redhat.ceylon.tools.p2.CeylonP2Tool;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Feature {
    final String name;
    final String version;
    final long manifestSize;
    final long jarSize;
    private String label;
    private String provider;
    private String description;
    private List<ModuleSpec> dependencies = new LinkedList<ModuleSpec>();
    private String copyright;
    private String license;
    private Category category;

    public Feature(String name, String version2, long manifestSize, long jarSize, Element root) {
        this.name = name;
        this.version = version2;
        this.manifestSize = manifestSize;
        this.jarSize = jarSize;
        this.parseXml(root);
    }

    private void parseXml(Element root) {
        this.label = root.getAttribute("label");
        this.provider = root.getAttribute("provider-name");
        this.description = CeylonP2Tool.getContent(root, "description");
        this.license = CeylonP2Tool.getContent(root, "license");
        this.copyright = CeylonP2Tool.getContent(root, "copyright");
        NodeList nodes = root.getElementsByTagName("plugin");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element plugin = (Element)nodes.item(i);
            this.dependencies.add(new ModuleSpec(null, plugin.getAttribute("id"), plugin.getAttribute("version")));
        }
    }

    public SortedMap<String, String> getProperties() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        ret.put("org.eclipse.equinox.p2.name", this.label);
        ret.put("org.eclipse.equinox.p2.description", this.description);
        ret.put("org.eclipse.equinox.p2.provider", this.provider);
        return ret;
    }

    public List<ModuleSpec> getImportedModules() {
        return this.dependencies;
    }

    public String getLicense() {
        return this.license;
    }

    public String getCopyright() {
        return this.copyright;
    }
}

