/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.p2;

import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.tools.p2.CeylonP2Tool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ModuleInfo {
    private static final String[] PropertyNames = new String[]{"Bundle-Name", "Bundle-Vendor", "Bundle-Description", "Bundle-DocUrl"};
    final String name;
    final String version;
    final File jar;
    Attributes osgiAttributes;
    String osgiVersion;
    private CeylonP2Tool tool;
    static Pattern quotingPattern = Pattern.compile("(([^\"']+)|(\"[^\"]*\")|('[^']*'))");

    public ModuleInfo(CeylonP2Tool tool, String name, String version2, File jar) throws IOException {
        this.tool = tool;
        this.name = name;
        this.version = version2;
        this.jar = jar;
        this.loadOsgiVersion();
    }

    private void loadOsgiVersion() throws IOException {
        JarFile jarFile = new JarFile(this.jar);
        Manifest manifest = jarFile.getManifest();
        this.osgiVersion = this.version;
        if (manifest != null) {
            String tmp;
            this.osgiAttributes = manifest.getMainAttributes();
            if (this.osgiAttributes != null && (tmp = this.osgiAttributes.getValue("Bundle-Version")) != null) {
                this.osgiVersion = tmp;
            }
        }
        jarFile.close();
        this.osgiVersion = CeylonP2Tool.fixOsgiVersion(this.osgiVersion);
    }

    public List<ModuleSpec> getExportedPackages() {
        String value = this.osgiAttributes.getValue("Export-Package");
        LinkedList<ModuleSpec> ret = new LinkedList<ModuleSpec>();
        if (value != null) {
            for (String pkg : ModuleInfo.split(value, ",")) {
                String[] details = ModuleInfo.split(pkg, ";");
                String name = details[0];
                String version2 = "";
                for (int i = 1; i < details.length; ++i) {
                    if (!details[i].startsWith("version=")) continue;
                    version2 = this.unquote(details[i].substring(8));
                    break;
                }
                ret.add(new ModuleSpec(null, name, version2));
            }
        }
        return ret;
    }

    private String unquote(String quotedVersion) {
        if (quotedVersion == null || quotedVersion.isEmpty()) {
            return quotedVersion;
        }
        char first = quotedVersion.charAt(0);
        char last = quotedVersion.charAt(quotedVersion.length() - 1);
        if (first == '\"' && last == '\"') {
            return quotedVersion.substring(1, quotedVersion.length() - 1);
        }
        if (first == '\'' && last == '\'') {
            return quotedVersion.substring(1, quotedVersion.length() - 1);
        }
        return quotedVersion;
    }

    public static String[] split(String string, String separator) {
        String quoteTag = "$$$$quote$$$$";
        Matcher matcher = quotingPattern.matcher(string);
        ArrayList<String> matchList = new ArrayList<String>();
        int start = 0;
        String stringWithReplacedQuotes = "";
        while (matcher.find(start)) {
            String match = matcher.group(0);
            char matchFirstChar = match.charAt(0);
            char matchLastChar = match.charAt(match.length() - 1);
            if (matchFirstChar == '\'' && matchLastChar == '\'' || matchFirstChar == '\"' && matchLastChar == '\"') {
                matchList.add(match);
                stringWithReplacedQuotes = stringWithReplacedQuotes + quoteTag;
            } else {
                stringWithReplacedQuotes = stringWithReplacedQuotes + match;
            }
            start = matcher.end();
        }
        String[] splittedStringWithReplacedQuotes = stringWithReplacedQuotes.split(separator);
        int quoteIndex = 0;
        for (int i = 0; i < splittedStringWithReplacedQuotes.length; ++i) {
            String part = splittedStringWithReplacedQuotes[i];
            while (part.contains(quoteTag)) {
                part = part.replaceFirst(Pattern.quote(quoteTag), (String)matchList.get(quoteIndex++));
            }
            splittedStringWithReplacedQuotes[i] = part;
        }
        return splittedStringWithReplacedQuotes;
    }

    public List<Dependency> getImportedPackages() {
        String value = this.osgiAttributes.getValue("Import-Package");
        LinkedList<Dependency> ret = new LinkedList<Dependency>();
        if (value != null) {
            for (String pkg : ModuleInfo.split(value, ",")) {
                String[] details = ModuleInfo.split(pkg, ";");
                String name = details[0];
                String version2 = "";
                boolean optional = false;
                for (int i = 1; i < details.length; ++i) {
                    String resolution;
                    if (details[i].startsWith("version=")) {
                        version2 = this.unquote(details[i].substring(8));
                    }
                    if (!details[i].startsWith("resolution:=") || !"optional".equals(resolution = this.unquote(details[i].substring(12)))) continue;
                    optional = true;
                }
                ret.add(new Dependency(name, version2, optional));
            }
        }
        return ret;
    }

    public List<Dependency> getImportedModules() {
        String value = this.osgiAttributes.getValue("Require-Bundle");
        LinkedList<Dependency> ret = new LinkedList<Dependency>();
        if (value != null && !value.isEmpty()) {
            for (String pkg : ModuleInfo.split(value, ",")) {
                String[] details = ModuleInfo.split(pkg, ";");
                String name = details[0];
                boolean optional = false;
                if (this.tool.skipModule(name)) continue;
                String version2 = "";
                for (int i = 1; i < details.length; ++i) {
                    String resolution;
                    if (details[i].startsWith("bundle-version=")) {
                        version2 = this.unquote(details[i].substring(15));
                    }
                    if (!details[i].startsWith("resolution:=") || !"optional".equals(resolution = this.unquote(details[i].substring(12)))) continue;
                    optional = true;
                }
                ret.add(new Dependency(name, version2, optional));
            }
        }
        return ret;
    }

    public String getAttribute(String name) {
        return this.osgiAttributes.getValue(name);
    }

    public SortedMap<String, String> getOsgiProperties() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (String name : PropertyNames) {
            String attribute = this.getAttribute(name);
            if (attribute == null) continue;
            ret.put(name, attribute);
        }
        return ret;
    }

    public static class Dependency
    extends ModuleSpec {
        private boolean optional;

        public Dependency(String name, String version2) {
            this(name, version2, false);
        }

        public Dependency(String name, String version2, boolean optional) {
            super(null, name, version2);
            this.optional = optional;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

