/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.src;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.RepoUsingTool;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.tools.src.CeylonSrcMessages;
import java.io.File;
import java.io.IOException;
import java.util.List;

@Summary(value="Fetches source archives from a repository and extracts their contents into a source directory")
@Description(value="Fetches any sources, resources, documentation and scripts that can be found for given `module` from the first configured repository to contain the module and extracts the them into their respective output directories. Multiple modules can be given.\n\nThis tool is especially useful for working with example projects.")
@RemainingSections(value="## Examples\n\nA typical workflow might be:\n\n    mkdir my-project\n    cd my-project\n    ceylon src org.example.foo\n    ceylon compile org.example.foo\n    ceylon run org.example.foo\n")
public class CeylonSrcTool
extends RepoUsingTool {
    private File src = DefaultToolOptions.getCompilerSourceDirs().get(0);
    private File resource = DefaultToolOptions.getCompilerResourceDirs().get(0);
    private File doc = DefaultToolOptions.getCompilerDocDirs().get(0);
    private File script = DefaultToolOptions.getCompilerScriptDirs().get(0);
    private String resourceRoot = DefaultToolOptions.getCompilerResourceRootName();
    private List<ModuleSpec> modules;

    public CeylonSrcTool() {
        super(CeylonSrcMessages.RESOURCE_BUNDLE);
    }

    @OptionArgument(shortName=115, longName="src", argumentName="dir")
    @Description(value="The output source directory (default: `./source`)")
    public void setSrc(File directory) {
        this.src = directory;
    }

    @OptionArgument(longName="source", argumentName="dir")
    @Description(value="An alias for `--src` (default: `./source`)")
    public void setSource(File source) {
        this.setSrc(source);
    }

    @OptionArgument(shortName=114, longName="resource", argumentName="dir")
    @Description(value="The output resource directory (default: `./resource`)")
    public void setResource(File resource) {
        this.resource = resource;
    }

    @OptionArgument(longName="doc", argumentName="dirs")
    @Description(value="The output doc directory (default: `./doc`)")
    public void setDocFolders(File doc) {
        this.doc = doc;
    }

    @OptionArgument(shortName=120, longName="script", argumentName="dir")
    @Description(value="The output script directory (default: `./script`)")
    public void setScriptFolders(File script) {
        this.script = script;
    }

    @OptionArgument(shortName=82, argumentName="folder-name")
    @Description(value="Sets the special resource folder name whose files will end up in the root of the resulting module CAR file (default: ROOT).")
    public void setResourceRoot(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @Argument(argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Override
    protected boolean needsSystemRepo() {
        return false;
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        super.initialize(mainTool);
    }

    @Override
    public void run() throws Exception {
        for (ModuleSpec module : this.modules) {
            if (module == ModuleSpec.DEFAULT_MODULE || module.isVersioned() || this.checkModuleVersionsOrShowSuggestions(module.getName(), null, ModuleQuery.Type.SRC, null, null, null, null) != null) continue;
            return;
        }
        for (ModuleSpec module : this.modules) {
            String version2 = module.getVersion();
            if (module != ModuleSpec.DEFAULT_MODULE && !module.isVersioned()) {
                version2 = this.checkModuleVersionsOrShowSuggestions(module.getName(), null, ModuleQuery.Type.SRC, null, null, null, null);
            }
            this.msg("retrieving.module", module).newline();
            ArtifactContext allArtifacts = new ArtifactContext(null, module.getName(), version2, ".src", "module-resources", "module-doc", ".scripts.zip");
            List<ArtifactResult> results = this.getRepositoryManager().getArtifactResults(allArtifacts);
            if (results == null) {
                String err = this.getModuleNotFoundErrorMessage(this.getRepositoryManager(), module.getName(), module.getVersion());
                this.errorAppend(err);
                this.errorNewline();
                continue;
            }
            String modFolder = module.getName().replace('.', File.separatorChar);
            boolean hasSources = false;
            for (ArtifactResult result : results) {
                String suffix = ArtifactContext.getSuffixFromFilename(result.artifact().getName());
                if (".src".equals(suffix)) {
                    this.append("    ").msg("extracting.sources", new Object[0]).newline();
                    this.extractArchive(result, this.applyCwd(this.src), "source");
                    hasSources = true;
                    continue;
                }
                if (".scripts.zip".equals(suffix)) {
                    this.append("    ").msg("extracting.scripts", new Object[0]).newline();
                    this.extractArchive(result, new File(this.applyCwd(this.script), modFolder), "script");
                    continue;
                }
                if ("module-resources".equals(suffix)) {
                    this.append("    ").msg("extracting.resources", new Object[0]).newline();
                    this.copyResources(result, this.applyCwd(this.resource));
                    continue;
                }
                if (!"module-doc".equals(suffix)) continue;
                this.append("    ").msg("extracting.docs", new Object[0]).newline();
                this.copyFiles(result, "doc", new File(this.applyCwd(this.doc), modFolder), "doc", false);
            }
            if (hasSources) continue;
            this.msg("no.sources.found", module).newline();
        }
    }

    private void extractArchive(ArtifactResult result, File dir, String name) throws IOException {
        try {
            IOUtils.extractArchive(result.artifact(), dir);
        }
        catch (IOUtils.UnzipException x) {
            switch (x.failure) {
                case CannotCreateDestination: {
                    throw new RuntimeException(CeylonSrcMessages.msg("unable.create.output.dir", name, x.dir));
                }
                case CopyError: {
                    throw new RuntimeException(CeylonSrcMessages.msg("unable.extract.entry", x.entryName, result.artifact().getAbsolutePath()), x.getCause());
                }
                case DestinationNotDirectory: {
                    throw new RuntimeException(CeylonSrcMessages.msg("not.dir.output.dir", name, x.dir));
                }
            }
            throw x;
        }
    }

    private void copyFiles(ArtifactResult result, String fromSubDir, File destDir, String name, boolean strict) {
        File fromDir = result.artifact();
        if (fromSubDir != null) {
            fromDir = new File(fromDir, fromSubDir);
        }
        if (!fromDir.isDirectory()) {
            if (!strict) {
                return;
            }
            throw new RuntimeException(CeylonSrcMessages.msg("not.dir.input.dir", name, destDir));
        }
        if (!destDir.exists() && !FileUtil.mkdirs(destDir)) {
            throw new RuntimeException(CeylonSrcMessages.msg("unable.create.output.dir", name, destDir));
        }
        if (!destDir.isDirectory()) {
            throw new RuntimeException(CeylonSrcMessages.msg("not.dir.output.dir", name, destDir));
        }
        try {
            FileUtil.copyAll(fromDir, destDir);
        }
        catch (IOException ex) {
            throw new RuntimeException(CeylonSrcMessages.msg("unable.copy", name, fromDir), ex);
        }
    }

    private void copyResources(ArtifactResult result, File destDir) {
        String[] parts = result.name().split("\\.");
        this.copyFiles(result, parts[0], new File(destDir, parts[0]), "resource", true);
        String modFolder = result.name().replace('.', File.separatorChar);
        File destRoot = new File(new File(destDir, modFolder), this.resourceRoot);
        for (File f : result.artifact().listFiles()) {
            if (f.getName().equals(parts[0])) continue;
            try {
                FileUtil.copyAll(f, destRoot);
            }
            catch (IOException ex) {
                throw new RuntimeException(CeylonSrcMessages.msg("unable.copy", "resource", f), ex);
            }
        }
    }
}

