/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class InFieldInitCriterion
implements Criterion {
    public final String varName;
    public final Criterion varCriterion;

    public InFieldInitCriterion(String varName) {
        this.varName = varName;
        this.varCriterion = Criteria.is(Tree.Kind.VARIABLE, varName);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        assert (path == null || path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        while (path != null) {
            if (CommonScanner.isFieldInit(path)) {
                return this.varCriterion.isSatisfiedBy(path);
            }
            path = path.getParentPath();
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_FIELD_INIT;
    }

    public String toString() {
        return "In field initializer for field '" + this.varName + "'";
    }
}

