/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plume.UtilMDE;

public class IsSigMethodCriterion
implements Criterion {
    private static final Map<CompilationUnitTree, Context> contextCache = new HashMap<CompilationUnitTree, Context>();
    private final String fullMethodName;
    private final String simpleMethodName;
    private final List<String> fullyQualifiedParams;
    private final String returnType;

    public IsSigMethodCriterion(String methodName) {
        this.fullMethodName = methodName.substring(0, methodName.indexOf(")") + 1);
        this.simpleMethodName = methodName.substring(0, methodName.indexOf("("));
        this.fullyQualifiedParams = new ArrayList<String>();
        try {
            this.parseParams(methodName.substring(methodName.indexOf("(") + 1, methodName.indexOf(")")));
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while parsing method: " + methodName, e);
        }
        String returnTypeJvml = methodName.substring(methodName.indexOf(")") + 1);
        this.returnType = returnTypeJvml.equals("V") ? "void" : UtilMDE.fieldDescriptorToBinaryName(returnTypeJvml);
    }

    private void parseParams(String params) {
        while (params.length() != 0) {
            String nextParam = this.readNext(params);
            params = params.substring(nextParam.length());
            this.fullyQualifiedParams.add(UtilMDE.fieldDescriptorToBinaryName(nextParam));
        }
    }

    private String readNext(String restOfParams) {
        String firstChar = restOfParams.substring(0, 1);
        if (this.isPrimitiveLetter(firstChar)) {
            return firstChar;
        }
        if (firstChar.equals("[")) {
            return "[" + this.readNext(restOfParams.substring(1));
        }
        if (firstChar.equals("L")) {
            return "L" + restOfParams.substring(1, restOfParams.indexOf(";") + 1);
        }
        throw new RuntimeException("Unknown method params: " + this.fullMethodName + " with remainder: " + restOfParams);
    }

    private static Context initImports(TreePath path) {
        CompilationUnitTree topLevel = path.getCompilationUnit();
        Context result = contextCache.get(topLevel);
        if (result != null) {
            return result;
        }
        ExpressionTree packageTree = topLevel.getPackageName();
        String packageName = packageTree == null ? "" : packageTree.toString();
        ArrayList<String> imports = new ArrayList<String>();
        for (ImportTree importTree : topLevel.getImports()) {
            String imported = importTree.getQualifiedIdentifier().toString();
            imports.add(imported);
        }
        result = new Context(packageName, imports);
        contextCache.put(topLevel, result);
        return result;
    }

    private boolean matchTypeParam(String goalType, Tree type, Map<String, String> typeToClassMap, Context context) {
        String simpleType = type.toString();
        boolean haveMatch = this.matchSimpleType(goalType, simpleType, context);
        if (!haveMatch && !typeToClassMap.isEmpty()) {
            for (Map.Entry<String, String> p : typeToClassMap.entrySet()) {
                haveMatch = this.matchSimpleType(goalType, simpleType = simpleType.replaceAll("\\b" + p.getKey() + "\\b", p.getValue()), context);
                if (haveMatch) continue;
                Criteria.dbug.debug("matchTypeParams() => false:%n", new Object[0]);
                Criteria.dbug.debug("  type = %s%n", type);
                Criteria.dbug.debug("  simpleType = %s%n", simpleType);
                Criteria.dbug.debug("  goalType = %s%n", goalType);
            }
        }
        return haveMatch;
    }

    private boolean matchTypeParams(List<? extends VariableTree> sourceParams, Map<String, String> typeToClassMap, Context context) {
        assert (sourceParams.size() == this.fullyQualifiedParams.size());
        for (int i = 0; i < sourceParams.size(); ++i) {
            VariableTree vt;
            Tree vtType;
            String fullType = this.fullyQualifiedParams.get(i);
            if (this.matchTypeParam(fullType, vtType = (vt = sourceParams.get(i)).getType(), typeToClassMap, context)) continue;
            Criteria.dbug.debug("matchTypeParam() => false:%n  i=%d vt = %s%n  fullType = %s%n", i, vt, fullType);
            return false;
        }
        return true;
    }

    private boolean matchSimpleType(String fullType, String simpleType, Context context) {
        Criteria.dbug.debug("matchSimpleType(%s, %s, %s)%n", fullType, simpleType, context);
        while (simpleType.contains("<")) {
            int bracketIndex = simpleType.lastIndexOf("<");
            String beforeBracket = simpleType.substring(0, bracketIndex);
            String afterBracket = simpleType.substring(simpleType.indexOf(">", bracketIndex) + 1);
            simpleType = beforeBracket + afterBracket;
        }
        boolean matchable = false;
        if (!matchable) {
            String packagePrefix = context.packageName;
            if (packagePrefix.length() > 0) {
                packagePrefix = packagePrefix + ".";
            }
            if (this.matchWithPrefix(fullType, simpleType, packagePrefix)) {
                matchable = true;
            }
        }
        if (!matchable && this.matchWithPrefix(fullType, simpleType, "java.lang.")) {
            matchable = true;
        }
        if (!matchable && this.matchWithPrefix(fullType, simpleType, "")) {
            matchable = true;
        }
        if (!matchable) {
            for (String someImport : context.imports) {
                String importPrefix = null;
                if (someImport.contains("*")) {
                    importPrefix = someImport.substring(0, someImport.indexOf("*"));
                } else {
                    String importSimpleType = someImport.substring(someImport.lastIndexOf(".") + 1);
                    int arrayBracket = simpleType.indexOf(91);
                    String simpleBaseType = simpleType;
                    if (arrayBracket > -1) {
                        simpleBaseType = simpleType.substring(0, arrayBracket);
                    }
                    if (!simpleBaseType.equals(importSimpleType) && !simpleBaseType.startsWith(importSimpleType + ".")) continue;
                    importPrefix = someImport.substring(0, someImport.lastIndexOf(".") + 1);
                }
                if (!this.matchWithPrefix(fullType, simpleType, importPrefix)) continue;
                matchable = true;
                break;
            }
        }
        return matchable;
    }

    private boolean matchWithPrefix(String fullType, String simpleType, String prefix) {
        return this.matchWithPrefixOneWay(fullType, simpleType, prefix) || this.matchWithPrefixOneWay(simpleType, fullType, prefix);
    }

    private boolean matchWithPrefixOneWay(String fullType, String simpleType, String prefix) {
        String simpleType2 = simpleType.replace("/", ".");
        String fullType2 = fullType.replace("$", ".");
        boolean b = fullType2.equals(prefix + simpleType2) || fullType.startsWith(prefix) && (fullType.endsWith("$" + simpleType2) || fullType2.endsWith("." + simpleType2));
        Criteria.dbug.debug("matchWithPrefix(%s, %s, %s) => %b)%n", fullType2, simpleType, prefix, b);
        return b;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        assert (path == null || path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSatisfiedBy(TreePath path) {
        void var8_10;
        if (path == null) {
            return false;
        }
        Context context = IsSigMethodCriterion.initImports(path);
        Tree leaf = path.getLeaf();
        if (leaf.getKind() != Tree.Kind.METHOD) {
            Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy(%s) => false: not a METHOD tree%n", Main.pathToString(path));
            return false;
        }
        MethodTree mt = (MethodTree)leaf;
        if (!this.simpleMethodName.equals(mt.getName().toString())) {
            Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy => false: Names don't match%n", new Object[0]);
            return false;
        }
        List<? extends VariableTree> sourceParams = mt.getParameters();
        if (this.fullyQualifiedParams.size() != sourceParams.size()) {
            Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy => false: Number of parameters don't match%n", new Object[0]);
            return false;
        }
        HashMap<String, String> typeToClassMap = new HashMap<String, String>();
        for (TypeParameterTree typeParameterTree : mt.getTypeParameters()) {
            void var10_13;
            String paramName = typeParameterTree.getName().toString();
            String string = "Object";
            List<? extends Tree> paramBounds = typeParameterTree.getBounds();
            if (paramBounds != null && paramBounds.size() >= 1) {
                Tree boundZero = paramBounds.get(0);
                if (boundZero.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                    boundZero = ((AnnotatedTypeTree)boundZero).getUnderlyingType();
                }
                String string2 = boundZero.toString();
            }
            typeToClassMap.put(paramName, (String)var10_13);
        }
        TreePath classpath = path;
        ClassTree classTree = IsSigMethodCriterion.enclosingClass(classpath);
        while (var8_10 != null) {
            for (TypeParameterTree typeParameterTree : var8_10.getTypeParameters()) {
                String paramName = typeParameterTree.getName().toString();
                String paramClass = "Object";
                List<? extends Tree> paramBounds = typeParameterTree.getBounds();
                if (paramBounds != null && paramBounds.size() >= 1) {
                    Tree pb = paramBounds.get(0);
                    if (pb.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                        pb = ((AnnotatedTypeTree)pb).getUnderlyingType();
                    }
                    paramClass = pb.toString();
                }
                typeToClassMap.put(paramName, paramClass);
            }
            classpath = classpath.getParentPath();
            ClassTree classTree2 = IsSigMethodCriterion.enclosingClass(classpath);
        }
        if (!this.matchTypeParams(sourceParams, typeToClassMap, context)) {
            Criteria.dbug.debug("IsSigMethodCriterion => false: Parameter types don't match%n", new Object[0]);
            return false;
        }
        if (mt.getReturnType() != null && !this.matchTypeParam(this.returnType, mt.getReturnType(), typeToClassMap, context)) {
            Criteria.dbug.debug("IsSigMethodCriterion => false: Return types don't match%n", new Object[0]);
            return false;
        }
        Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy => true%n", new Object[0]);
        return true;
    }

    private static ClassTree enclosingClass(TreePath path) {
        EnumSet<Tree.Kind> kinds = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Tree leaf = p.getLeaf();
            assert (leaf != null);
            if (!kinds.contains((Object)leaf.getKind())) continue;
            return (ClassTree)leaf;
        }
        return null;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.SIG_METHOD;
    }

    private boolean isPrimitiveLetter(String s2) {
        return s2.equals("Z") || s2.equals("B") || s2.equals("C") || s2.equals("D") || s2.equals("F") || s2.equals("I") || s2.equals("J") || s2.equals("S");
    }

    public String toString() {
        return "IsSigMethodCriterion: " + this.fullMethodName;
    }

    private static class Context {
        public final String packageName;
        public final List<String> imports;

        public Context(String packageName, List<String> imports) {
            this.packageName = packageName;
            this.imports = imports;
        }
    }
}

