/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class UpperBoundVisitor
extends BaseTypeVisitor<UpperBoundAnnotatedTypeFactory> {
    private static final String UPPER_BOUND = "array.access.unsafe.high";
    private static final String UPPER_BOUND_CONST = "array.access.unsafe.high.constant";
    private static final String UPPER_BOUND_RANGE = "array.access.unsafe.high.range";

    public UpperBoundVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Void type) {
        ExpressionTree indexTree = tree.getIndex();
        ExpressionTree arrTree = tree.getExpression();
        this.visitAccess(indexTree, arrTree);
        return super.visitArrayAccess(tree, type);
    }

    private void visitAccess(ExpressionTree indexTree, ExpressionTree arrTree) {
        AnnotatedTypeMirror indexType = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(indexTree);
        String arrName = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, arrTree).toString();
        UBQualifier qualifier = UBQualifier.createUBQualifier(indexType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        if (qualifier.isLessThanLengthOf(arrName)) {
            return;
        }
        Long valMax = IndexUtil.getMaxValue(indexTree, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory());
        AnnotationMirror sameLenAnno = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).sameLenAnnotationFromTree(arrTree);
        if (sameLenAnno != null && AnnotationUtils.areSameByClass(sameLenAnno, SameLen.class) && AnnotationUtils.hasElementValue(sameLenAnno, "value")) {
            List<String> slNames = AnnotationUtils.getElementValueArray(sameLenAnno, "value", String.class, true);
            if (qualifier.isLessThanLengthOfAny(slNames)) {
                return;
            }
            for (String slName : slNames) {
                int minlenSL = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory().getMinLenFromString(slName, arrTree, this.getCurrentPath());
                if (valMax == null || valMax >= (long)minlenSL) continue;
                return;
            }
        }
        Integer minLen = IndexUtil.getMinLen(arrTree, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory());
        if (valMax != null && minLen != null && valMax < (long)minLen.intValue()) {
            return;
        }
        if (IndexUtil.getExactValue(indexTree, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory()) != null) {
            this.checker.report(Result.failure(UPPER_BOUND_CONST, valMax, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory().getAnnotatedType(arrTree).toString(), valMax + 1L, valMax + 1L), indexTree);
        } else if (valMax != null && qualifier.isUnknown()) {
            this.checker.report(Result.failure(UPPER_BOUND_RANGE, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory().getAnnotatedType(indexTree).toString(), ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory().getAnnotatedType(arrTree).toString(), arrName, arrName, valMax + 1L), indexTree);
        } else {
            this.checker.report(Result.failure(UPPER_BOUND, indexType.toString(), arrName, arrName, arrName), indexTree);
        }
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        if (!this.relaxedCommonAssignment(varType, valueExp)) {
            super.commonAssignmentCheck(varType, valueExp, errorKey);
        }
    }

    private boolean relaxedCommonAssignment(AnnotatedTypeMirror varType, ExpressionTree valueExp) {
        if (valueExp.getKind() == Tree.Kind.NEW_ARRAY && varType.getKind() == TypeKind.ARRAY) {
            List<? extends ExpressionTree> expressions = ((NewArrayTree)valueExp).getInitializers();
            if (expressions == null || expressions.isEmpty()) {
                return false;
            }
            AnnotatedTypeMirror componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)varType).getComponentType();
            UBQualifier qualifier = UBQualifier.createUBQualifier(componentType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
            if (!qualifier.isLessThanLengthQualifier()) {
                return false;
            }
            for (ExpressionTree expressionTree : expressions) {
                if (this.relaxedCommonAssignmentCheck((UBQualifier.LessThanLengthOf)qualifier, expressionTree)) continue;
                return false;
            }
            return true;
        }
        UBQualifier qualifier = UBQualifier.createUBQualifier(varType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        return qualifier.isLessThanLengthQualifier() && this.relaxedCommonAssignmentCheck((UBQualifier.LessThanLengthOf)qualifier, valueExp);
    }

    private boolean relaxedCommonAssignmentCheck(UBQualifier.LessThanLengthOf varLtlQual, ExpressionTree valueExp) {
        AnnotatedTypeMirror expType = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(valueExp);
        UBQualifier expQual = UBQualifier.createUBQualifier(expType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        Long value = IndexUtil.getMaxValue(valueExp, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory());
        if (value == null && !expQual.isLessThanLengthQualifier()) {
            return false;
        }
        SameLenAnnotatedTypeFactory sameLenFactory = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getSameLenAnnotatedTypeFactory();
        ValueAnnotatedTypeFactory valueAnnotatedTypeFactory = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory();
        block0: for (String string : varLtlQual.getArrays()) {
            int minlen;
            List<String> sameLenArrays = sameLenFactory.getSameLensFromString(string, valueExp, this.getCurrentPath());
            if (this.testSameLen(expQual, varLtlQual, sameLenArrays, string) || this.testMinLen(value, minlen = valueAnnotatedTypeFactory.getMinLenFromString(string, valueExp, this.getCurrentPath()), string, varLtlQual)) continue;
            for (String array : sameLenArrays) {
                int minlenSL = valueAnnotatedTypeFactory.getMinLenFromString(array, valueExp, this.getCurrentPath());
                if (!this.testMinLen(value, minlenSL, string, varLtlQual)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean testSameLen(UBQualifier expQual, UBQualifier.LessThanLengthOf varQual, List<String> sameLenArrays, String arrayName) {
        if (!expQual.isLessThanLengthQualifier()) {
            return false;
        }
        for (String sameLenArrayName : sameLenArrays) {
            if (!varQual.isValidReplacement(arrayName, sameLenArrayName, (UBQualifier.LessThanLengthOf)expQual)) continue;
            return true;
        }
        return false;
    }

    private boolean testMinLen(Long value, int minLen, String arrayName, UBQualifier.LessThanLengthOf varQual) {
        if (value == null) {
            return false;
        }
        return varQual.isValuePlusOffsetLessThanMinLen(arrayName, value.intValue(), minLen);
    }
}

