/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.value.RangeOrListOfValues;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueCheckerUtils;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.common.value.util.NumberMath;
import org.checkerframework.common.value.util.NumberUtils;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.dataflow.util.NodeUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TypesUtils;

public class ValueTransfer
extends CFTransfer {
    ValueAnnotatedTypeFactory atypefactory;
    private static final List<Boolean> ALL_BOOLEANS = Arrays.asList(Boolean.TRUE, Boolean.FALSE);

    public ValueTransfer(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        super(analysis);
        this.atypefactory = (ValueAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    private Range getIntRangeStringLengthRange(Node subNode, TransferInput<CFValue, CFStore> p) {
        Range valueRange = this.getIntRange(subNode, p);
        int fromLength = Long.toString(valueRange.from).length();
        int toLength = Long.toString(valueRange.to).length();
        int lowerLength = Math.min(fromLength, toLength);
        if (valueRange.contains(0L)) {
            lowerLength = 1;
        }
        int upperLength = Math.max(fromLength, toLength);
        return new Range(lowerLength, upperLength);
    }

    private Range getStringLengthRange(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror arrayLenRangeAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), ArrayLenRange.class);
        if (arrayLenRangeAnno != null) {
            return ValueAnnotatedTypeFactory.getRange(arrayLenRangeAnno);
        }
        if (AnnotationUtils.containsSameByClass(value.getAnnotations(), BottomVal.class)) {
            return Range.NOTHING;
        }
        TypeKind subNodeTypeKind = subNode.getType().getKind();
        if (subNode instanceof StringConversionNode) {
            return this.getStringLengthRange(((StringConversionNode)subNode).getOperand(), p);
        }
        if (this.isIntRange(subNode, p)) {
            return this.getIntRangeStringLengthRange(subNode, p);
        }
        if (subNodeTypeKind == TypeKind.INT) {
            return new Range(1L, 11L);
        }
        if (subNodeTypeKind == TypeKind.LONG) {
            return new Range(1L, 20L);
        }
        return new Range(0L, Integer.MAX_VALUE);
    }

    private List<Integer> getStringLengths(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror arrayLenAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), ArrayLen.class);
        if (arrayLenAnno != null) {
            return ValueAnnotatedTypeFactory.getArrayLength(arrayLenAnno);
        }
        if (AnnotationUtils.containsSameByClass(value.getAnnotations(), BottomVal.class)) {
            return new ArrayList<Integer>();
        }
        TypeKind subNodeTypeKind = subNode.getType().getKind();
        if (subNode instanceof StringConversionNode) {
            return this.getStringLengths(((StringConversionNode)subNode).getOperand(), p);
        }
        if (subNodeTypeKind == TypeKind.CHAR) {
            return Collections.singletonList(1);
        }
        if (this.isIntRange(subNode, p)) {
            Range lengthRange = this.getIntRangeStringLengthRange(subNode, p);
            return ValueCheckerUtils.getValuesFromRange(lengthRange, Integer.class);
        }
        if (subNodeTypeKind == TypeKind.BYTE) {
            return ValueCheckerUtils.getValuesFromRange(new Range(1L, 4L), Integer.class);
        }
        if (subNodeTypeKind == TypeKind.SHORT) {
            return ValueCheckerUtils.getValuesFromRange(new Range(1L, 6L), Integer.class);
        }
        return null;
    }

    private List<String> getStringValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        List<Serializable> values;
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror stringAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), StringVal.class);
        if (stringAnno != null) {
            return ValueAnnotatedTypeFactory.getStringValues(stringAnno);
        }
        AnnotationMirror topAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), UnknownVal.class);
        if (topAnno != null) {
            return null;
        }
        AnnotationMirror bottomAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), BottomVal.class);
        if (bottomAnno != null) {
            return new ArrayList<String>();
        }
        AnnotationMirror numberAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), BoolVal.class);
        if (numberAnno != null) {
            values = this.getBooleanValues(subNode, p);
        } else if (subNode.getType().getKind() == TypeKind.CHAR) {
            values = this.getCharValues(subNode, p);
        } else {
            if (subNode instanceof StringConversionNode) {
                return this.getStringValues(((StringConversionNode)subNode).getOperand(), p);
            }
            if (this.isIntRange(subNode, p)) {
                Range range = this.getIntRange(subNode, p);
                List<Long> longValues = ValueCheckerUtils.getValuesFromRange(range, Long.class);
                values = NumberUtils.castNumbers(subNode.getType(), longValues);
            } else {
                values = this.getNumericalValues(subNode, p);
            }
        }
        if (values == null) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Comparable<Boolean> comparable : values) {
            stringValues.add(comparable.toString());
        }
        return stringValues.isEmpty() ? Collections.singletonList("null") : stringValues;
    }

    private List<Boolean> getBooleanValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror intAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), BoolVal.class);
        return ValueAnnotatedTypeFactory.getBooleanValues(intAnno);
    }

    private List<Character> getCharValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror intAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), IntVal.class);
        if (intAnno != null) {
            return ValueAnnotatedTypeFactory.getCharValues(intAnno);
        }
        if (this.atypefactory.isIntRange(value.getAnnotations())) {
            intAnno = this.atypefactory.getQualifierHierarchy().findAnnotationInHierarchy(value.getAnnotations(), this.atypefactory.UNKNOWNVAL);
            Range range = ValueAnnotatedTypeFactory.getRange(intAnno);
            return ValueCheckerUtils.getValuesFromRange(range, Character.class);
        }
        return new ArrayList<Character>();
    }

    private AnnotationMirror getValueAnnotation(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        return this.getValueAnnotation(value);
    }

    private AnnotationMirror getValueAnnotation(CFValue cfValue) {
        return this.atypefactory.getQualifierHierarchy().findAnnotationInHierarchy(cfValue.getAnnotations(), this.atypefactory.UNKNOWNVAL);
    }

    private List<? extends Number> getNumericalValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        AnnotationMirror valueAnno = this.getValueAnnotation(subNode, p);
        return this.getNumericalValues(subNode, valueAnno);
    }

    private List<? extends Number> getNumericalValues(Node subNode, AnnotationMirror valueAnno) {
        List<Number> values;
        if (valueAnno == null || AnnotationUtils.areSameByClass(valueAnno, UnknownVal.class)) {
            return null;
        }
        if (AnnotationUtils.areSameByClass(valueAnno, BottomVal.class)) {
            return new ArrayList();
        }
        if (AnnotationUtils.areSameByClass(valueAnno, IntVal.class)) {
            values = ValueAnnotatedTypeFactory.getIntValues(valueAnno);
        } else if (AnnotationUtils.areSameByClass(valueAnno, DoubleVal.class)) {
            values = ValueAnnotatedTypeFactory.getDoubleValues(valueAnno);
        } else {
            return null;
        }
        return NumberUtils.castNumbers(subNode.getType(), values);
    }

    private Range getIntRange(Node subNode, TransferInput<CFValue, CFStore> p) {
        AnnotationMirror val = this.getValueAnnotation(subNode, p);
        return this.getIntRangeFromAnnotation(subNode, val);
    }

    private Range getIntRangeFromAnnotation(Node node, AnnotationMirror val) {
        Range range;
        if (val == null || AnnotationUtils.areSameByClass(val, UnknownVal.class)) {
            range = Range.EVERYTHING;
        } else if (this.atypefactory.isIntRange(val)) {
            range = ValueAnnotatedTypeFactory.getRange(val);
        } else if (AnnotationUtils.areSameByClass(val, IntVal.class)) {
            List<Long> values = ValueAnnotatedTypeFactory.getIntValues(val);
            range = ValueCheckerUtils.getRangeFromValues(values);
        } else if (AnnotationUtils.areSameByClass(val, DoubleVal.class)) {
            List<Double> values = ValueAnnotatedTypeFactory.getDoubleValues(val);
            range = ValueCheckerUtils.getRangeFromValues(values);
        } else {
            if (AnnotationUtils.areSameByClass(val, BottomVal.class)) {
                return Range.NOTHING;
            }
            range = Range.EVERYTHING;
        }
        return NumberUtils.castRange(node.getType(), range);
    }

    private boolean isIntRange(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        return this.atypefactory.isIntRange(value.getAnnotations());
    }

    private boolean isIntegralUnknownVal(Node node, AnnotationMirror anno) {
        return AnnotationUtils.areSameByClass(anno, UnknownVal.class) && TypesUtils.isIntegral(node.getType());
    }

    private TransferResult<CFValue, CFStore> createNewResult(TransferResult<CFValue, CFStore> result, AnnotationMirror resultAnno) {
        CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(resultAnno, result.getResultValue().getUnderlyingType());
        return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
    }

    private TransferResult<CFValue, CFStore> createNewResultBoolean(CFStore thenStore, CFStore elseStore, List<Boolean> resultValues, TypeMirror underlyingType) {
        AnnotationMirror boolVal = this.atypefactory.createBooleanAnnotation(resultValues);
        CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(boolVal, underlyingType);
        if (elseStore != null) {
            return new ConditionalTransferResult<CFValue, CFStore>(newResultValue, thenStore, elseStore);
        }
        return new RegularTransferResult<CFValue, CFStore>(newResultValue, thenStore);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFieldAccess(FieldAccessNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult<CFValue, CFStore> result = super.visitFieldAccess(node, in);
        this.refineArrayAtLengthAccess(node, result.getRegularStore());
        return result;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(n, p);
        this.refineStringAtLengthInvocation(n, result.getRegularStore());
        return result;
    }

    private void refineArrayAtLengthAccess(FieldAccessNode arrayLengthNode, CFStore store) {
        if (!NodeUtils.isArrayLengthFieldAccess(arrayLengthNode)) {
            return;
        }
        this.refineAtLengthAccess(arrayLengthNode, arrayLengthNode.getReceiver(), store);
    }

    private void refineStringAtLengthInvocation(MethodInvocationNode stringLengthNode, CFStore store) {
        MethodAccessNode methodAccessNode = stringLengthNode.getTarget();
        if (this.atypefactory.isStringLengthMethod(methodAccessNode.getMethod())) {
            this.refineAtLengthAccess(stringLengthNode, methodAccessNode.getReceiver(), store);
        }
    }

    private AnnotationMirror getArrayOrStringAnnotation(Node arrayOrStringNode) {
        AnnotationMirror arrayOrStringAnno = this.atypefactory.getAnnotationMirror(arrayOrStringNode.getTree(), StringVal.class);
        if (arrayOrStringAnno == null) {
            arrayOrStringAnno = this.atypefactory.getAnnotationMirror(arrayOrStringNode.getTree(), ArrayLen.class);
        }
        if (arrayOrStringAnno == null) {
            arrayOrStringAnno = this.atypefactory.getAnnotationMirror(arrayOrStringNode.getTree(), ArrayLenRange.class);
        }
        return arrayOrStringAnno;
    }

    private void refineAtLengthAccess(Node lengthNode, Node receiverNode, CFStore store) {
        RangeOrListOfValues rolv;
        FlowExpressions.Receiver lengthRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), lengthNode);
        if (lengthRec instanceof FlowExpressions.Unknown) {
            return;
        }
        CFValue value = (CFValue)store.getValue(lengthRec);
        if (value == null) {
            return;
        }
        AnnotationMirror lengthAnno = this.getValueAnnotation(value);
        if (lengthAnno == null) {
            return;
        }
        if (AnnotationUtils.areSameByClass(lengthAnno, BottomVal.class)) {
            FlowExpressions.Receiver receiver = FlowExpressions.internalReprOf((AnnotationProvider)this.atypefactory, receiverNode);
            store.insertValue(receiver, lengthAnno);
            return;
        }
        if (this.atypefactory.isIntRange(lengthAnno)) {
            rolv = new RangeOrListOfValues(ValueAnnotatedTypeFactory.getRange(lengthAnno));
        } else if (AnnotationUtils.areSameByClass(lengthAnno, IntVal.class)) {
            List<Long> lengthValues = ValueAnnotatedTypeFactory.getIntValues(lengthAnno);
            rolv = new RangeOrListOfValues(RangeOrListOfValues.convertLongsToInts(lengthValues));
        } else {
            return;
        }
        AnnotationMirror newRecAnno = rolv.createAnnotation(this.atypefactory);
        AnnotationMirror oldRecAnno = this.getArrayOrStringAnnotation(receiverNode);
        AnnotationMirror combinedRecAnno = oldRecAnno == null ? newRecAnno : this.atypefactory.getQualifierHierarchy().greatestLowerBound(oldRecAnno, newRecAnno);
        FlowExpressions.Receiver receiver = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), receiverNode);
        store.insertValue(receiver, combinedRecAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitStringConcatenateAssignment(StringConcatenateAssignmentNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<CFValue, CFStore> result = super.visitStringConcatenateAssignment(n, p);
        return this.stringConcatenation(n.getLeftOperand(), n.getRightOperand(), p, result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitStringConcatenate(StringConcatenateNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult result = (TransferResult)super.visitStringConcatenate(n, p);
        return this.stringConcatenation(n.getLeftOperand(), n.getRightOperand(), p, result);
    }

    private List<Integer> calculateLengthAddition(List<Integer> leftLengths, List<Integer> rightLengths) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int left : leftLengths) {
            for (int right : rightLengths) {
                long resultLength = left + right;
                if (resultLength > Integer.MAX_VALUE) continue;
                result.add((int)resultLength);
            }
        }
        return result;
    }

    private Range calculateLengthRangeAddition(Range leftLengths, Range rightLengths) {
        return leftLengths.plus(rightLengths).intersect(Range.INT_EVERYTHING);
    }

    private AnnotationMirror createAnnotationForStringConcatenation(Node leftOperand, Node rightOperand, TransferInput<CFValue, CFStore> p) {
        Range rightLengthRange;
        List<Integer> rightLengths;
        List<String> leftValues = this.getStringValues(leftOperand, p);
        List<String> rightValues = this.getStringValues(rightOperand, p);
        if (leftValues != null && rightValues != null) {
            ArrayList<String> concatValues = new ArrayList<String>();
            if (leftValues.isEmpty()) {
                leftValues = Collections.singletonList("null");
            }
            if (rightValues.isEmpty()) {
                rightValues = Collections.singletonList("null");
            }
            for (String left : leftValues) {
                for (String right : rightValues) {
                    concatValues.add(left + right);
                }
            }
            return this.atypefactory.createStringAnnotation(concatValues);
        }
        List<Integer> leftLengths = leftValues != null ? ValueCheckerUtils.getLengthsForStringValues(leftValues) : this.getStringLengths(leftOperand, p);
        List<Integer> list = rightLengths = rightValues != null ? ValueCheckerUtils.getLengthsForStringValues(rightValues) : this.getStringLengths(rightOperand, p);
        if (leftLengths != null && rightLengths != null) {
            List<Integer> concatLengths = this.calculateLengthAddition(leftLengths, rightLengths);
            return this.atypefactory.createArrayLenAnnotation(concatLengths);
        }
        Range leftLengthRange = leftLengths != null ? ValueCheckerUtils.getRangeFromValues(leftLengths) : this.getStringLengthRange(leftOperand, p);
        Range range = rightLengthRange = rightLengths != null ? ValueCheckerUtils.getRangeFromValues(rightLengths) : this.getStringLengthRange(rightOperand, p);
        if (leftLengthRange != null && rightLengthRange != null) {
            Range concatLengthRange = this.calculateLengthRangeAddition(leftLengthRange, rightLengthRange);
            return this.atypefactory.createArrayLenRangeAnnotation(concatLengthRange);
        }
        return this.atypefactory.UNKNOWNVAL;
    }

    public TransferResult<CFValue, CFStore> stringConcatenation(Node leftOperand, Node rightOperand, TransferInput<CFValue, CFStore> p, TransferResult<CFValue, CFStore> result) {
        AnnotationMirror resultAnno = this.createAnnotationForStringConcatenation(leftOperand, rightOperand, p);
        TypeMirror underlyingType = result.getResultValue().getUnderlyingType();
        CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(resultAnno, underlyingType);
        return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
    }

    private AnnotationMirror calculateNumericalBinaryOp(Node leftNode, Node rightNode, NumericalBinaryOps op, TransferInput<CFValue, CFStore> p) {
        if (!this.isIntRange(leftNode, p) && !this.isIntRange(rightNode, p)) {
            List<Number> resultValues = this.calculateValuesBinaryOp(leftNode, rightNode, op, p);
            return this.atypefactory.createNumberAnnotationMirror(resultValues);
        }
        Range resultRange = this.calculateRangeBinaryOp(leftNode, rightNode, op, p);
        return this.atypefactory.createIntRangeAnnotation(resultRange);
    }

    private Range calculateRangeBinaryOp(Node leftNode, Node rightNode, NumericalBinaryOps op, TransferInput<CFValue, CFStore> p) {
        if (TypesUtils.isIntegral(leftNode.getType()) && TypesUtils.isIntegral(rightNode.getType())) {
            Range resultRange;
            Range leftRange = this.getIntRange(leftNode, p);
            Range rightRange = this.getIntRange(rightNode, p);
            switch (op) {
                case ADDITION: {
                    resultRange = leftRange.plus(rightRange);
                    break;
                }
                case SUBTRACTION: {
                    resultRange = leftRange.minus(rightRange);
                    break;
                }
                case MULTIPLICATION: {
                    resultRange = leftRange.times(rightRange);
                    break;
                }
                case DIVISION: {
                    resultRange = leftRange.divide(rightRange);
                    break;
                }
                case REMAINDER: {
                    resultRange = leftRange.remainder(rightRange);
                    break;
                }
                case SHIFT_LEFT: {
                    resultRange = leftRange.shiftLeft(rightRange);
                    break;
                }
                case SIGNED_SHIFT_RIGHT: {
                    resultRange = leftRange.signedShiftRight(rightRange);
                    break;
                }
                case UNSIGNED_SHIFT_RIGHT: {
                    resultRange = leftRange.unsignedShiftRight(rightRange);
                    break;
                }
                case BITWISE_AND: {
                    resultRange = leftRange.bitwiseAnd(rightRange);
                    break;
                }
                case BITWISE_OR: {
                    resultRange = leftRange.bitwiseOr(rightRange);
                    break;
                }
                case BITWISE_XOR: {
                    resultRange = leftRange.bitwiseXor(rightRange);
                    break;
                }
                default: {
                    ErrorReporter.errorAbort("ValueTransfer: unsupported operation: " + (Object)((Object)op));
                    throw new RuntimeException("this can't happen");
                }
            }
            return leftNode.getType().getKind() == TypeKind.LONG || rightNode.getType().getKind() == TypeKind.LONG ? resultRange : resultRange.intRange();
        }
        return Range.EVERYTHING;
    }

    private List<Number> calculateValuesBinaryOp(Node leftNode, Node rightNode, NumericalBinaryOps op, TransferInput<CFValue, CFStore> p) {
        List<? extends Number> lefts = this.getNumericalValues(leftNode, p);
        List<? extends Number> rights = this.getNumericalValues(rightNode, p);
        if (lefts == null || rights == null) {
            return null;
        }
        ArrayList<Number> resultValues = new ArrayList<Number>();
        for (Number number : lefts) {
            NumberMath<?> nmLeft = NumberMath.getNumberMath(number);
            block14: for (Number number2 : rights) {
                switch (op) {
                    case ADDITION: {
                        resultValues.add(nmLeft.plus(number2));
                        continue block14;
                    }
                    case DIVISION: {
                        Number result = nmLeft.divide(number2);
                        if (result == null) continue block14;
                        resultValues.add(result);
                        continue block14;
                    }
                    case MULTIPLICATION: {
                        resultValues.add(nmLeft.times(number2));
                        continue block14;
                    }
                    case REMAINDER: {
                        Number resultR = nmLeft.remainder(number2);
                        if (resultR == null) continue block14;
                        resultValues.add(resultR);
                        continue block14;
                    }
                    case SUBTRACTION: {
                        resultValues.add(nmLeft.minus(number2));
                        continue block14;
                    }
                    case SHIFT_LEFT: {
                        resultValues.add(nmLeft.shiftLeft(number2));
                        continue block14;
                    }
                    case SIGNED_SHIFT_RIGHT: {
                        resultValues.add(nmLeft.signedShiftRight(number2));
                        continue block14;
                    }
                    case UNSIGNED_SHIFT_RIGHT: {
                        resultValues.add(nmLeft.unsignedShiftRight(number2));
                        continue block14;
                    }
                    case BITWISE_AND: {
                        resultValues.add(nmLeft.bitwiseAnd(number2));
                        continue block14;
                    }
                    case BITWISE_OR: {
                        resultValues.add(nmLeft.bitwiseOr(number2));
                        continue block14;
                    }
                    case BITWISE_XOR: {
                        resultValues.add(nmLeft.bitwiseXor(number2));
                        continue block14;
                    }
                }
                ErrorReporter.errorAbort("ValueTransfer: unsupported operation: " + (Object)((Object)op));
            }
        }
        return resultValues;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalAddition(NumericalAdditionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalAddition(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.ADDITION, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalSubtraction(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.SUBTRACTION, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalMultiplication(NumericalMultiplicationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalMultiplication(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.MULTIPLICATION, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerDivision(IntegerDivisionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitIntegerDivision(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.DIVISION, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFloatingDivision(FloatingDivisionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitFloatingDivision(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.DIVISION, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerRemainder(IntegerRemainderNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitIntegerRemainder(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.REMAINDER, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFloatingRemainder(FloatingRemainderNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitFloatingRemainder(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.REMAINDER, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLeftShift(LeftShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitLeftShift(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.SHIFT_LEFT, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitSignedRightShift(SignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitSignedRightShift(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.SIGNED_SHIFT_RIGHT, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitUnsignedRightShift(UnsignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitUnsignedRightShift(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.UNSIGNED_SHIFT_RIGHT, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseAnd(BitwiseAndNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseAnd(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.BITWISE_AND, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseOr(BitwiseOrNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseOr(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.BITWISE_OR, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseXor(BitwiseXorNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseXor(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumericalBinaryOps.BITWISE_XOR, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    private AnnotationMirror calculateNumericalUnaryOp(Node operand, NumericalUnaryOps op, TransferInput<CFValue, CFStore> p) {
        if (!this.isIntRange(operand, p)) {
            List<Number> resultValues = this.calculateValuesUnaryOp(operand, op, p);
            return this.atypefactory.createNumberAnnotationMirror(resultValues);
        }
        Range resultRange = this.calculateRangeUnaryOp(operand, op, p);
        return this.atypefactory.createIntRangeAnnotation(resultRange);
    }

    private Range calculateRangeUnaryOp(Node operand, NumericalUnaryOps op, TransferInput<CFValue, CFStore> p) {
        if (TypesUtils.isIntegral(operand.getType())) {
            Range resultRange;
            Range range = this.getIntRange(operand, p);
            switch (op) {
                case PLUS: {
                    resultRange = range.unaryPlus();
                    break;
                }
                case MINUS: {
                    resultRange = range.unaryMinus();
                    break;
                }
                case BITWISE_COMPLEMENT: {
                    resultRange = range.bitwiseComplement();
                    break;
                }
                default: {
                    ErrorReporter.errorAbort("ValueTransfer: unsupported operation: " + (Object)((Object)op));
                    throw new RuntimeException("this can't happen");
                }
            }
            return operand.getType().getKind() == TypeKind.LONG ? resultRange : resultRange.intRange();
        }
        return Range.EVERYTHING;
    }

    private List<Number> calculateValuesUnaryOp(Node operand, NumericalUnaryOps op, TransferInput<CFValue, CFStore> p) {
        List<? extends Number> lefts = this.getNumericalValues(operand, p);
        if (lefts == null) {
            return null;
        }
        ArrayList<Number> resultValues = new ArrayList<Number>();
        block5: for (Number number : lefts) {
            NumberMath<?> nmLeft = NumberMath.getNumberMath(number);
            switch (op) {
                case PLUS: {
                    resultValues.add(nmLeft.unaryPlus());
                    continue block5;
                }
                case MINUS: {
                    resultValues.add(nmLeft.unaryMinus());
                    continue block5;
                }
                case BITWISE_COMPLEMENT: {
                    resultValues.add(nmLeft.bitwiseComplement());
                    continue block5;
                }
            }
            ErrorReporter.errorAbort("ValueTransfer: unsupported operation: " + (Object)((Object)op));
        }
        return resultValues;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalMinus(NumericalMinusNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalMinus(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalUnaryOp(n.getOperand(), NumericalUnaryOps.MINUS, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalPlus(NumericalPlusNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalPlus(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalUnaryOp(n.getOperand(), NumericalUnaryOps.PLUS, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseComplement(BitwiseComplementNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseComplement(n, p);
        AnnotationMirror resultAnno = this.calculateNumericalUnaryOp(n.getOperand(), NumericalUnaryOps.BITWISE_COMPLEMENT, p);
        return this.createNewResult(transferResult, resultAnno);
    }

    private List<Boolean> calculateBinaryComparison(Node leftNode, CFValue leftValue, Node rightNode, CFValue rightValue, ComparisonOperators op, CFStore thenStore, CFStore elseStore) {
        AnnotationMirror leftAnno = this.getValueAnnotation(leftValue);
        AnnotationMirror rightAnno = this.getValueAnnotation(rightValue);
        if (this.atypefactory.isIntRange(leftAnno) || this.atypefactory.isIntRange(rightAnno) || this.isIntegralUnknownVal(rightNode, rightAnno) || this.isIntegralUnknownVal(leftNode, leftAnno)) {
            return this.refineIntRanges(leftNode, leftAnno, rightNode, rightAnno, op, thenStore, elseStore);
        }
        ArrayList<Boolean> resultValues = new ArrayList<Boolean>();
        List<? extends Number> lefts = this.getNumericalValues(leftNode, leftAnno);
        List<? extends Number> rights = this.getNumericalValues(rightNode, rightAnno);
        if (lefts == null || rights == null) {
            if (AnnotationUtils.areSame(leftAnno, this.atypefactory.BOTTOMVAL) || AnnotationUtils.areSame(rightAnno, this.atypefactory.BOTTOMVAL)) {
                return new ArrayList<Boolean>();
            }
            return null;
        }
        ArrayList<Number> thenLeftVals = new ArrayList<Number>();
        ArrayList<Number> elseLeftVals = new ArrayList<Number>();
        ArrayList<Number> thenRightVals = new ArrayList<Number>();
        ArrayList<Number> elseRightVals = new ArrayList<Number>();
        for (Number number : lefts) {
            NumberMath<?> nmLeft = NumberMath.getNumberMath(number);
            for (Number number2 : rights) {
                Boolean result;
                switch (op) {
                    case EQUAL: {
                        result = nmLeft.equalTo(number2);
                        break;
                    }
                    case GREATER_THAN: {
                        result = nmLeft.greaterThan(number2);
                        break;
                    }
                    case GREATER_THAN_EQ: {
                        result = nmLeft.greaterThanEq(number2);
                        break;
                    }
                    case LESS_THAN: {
                        result = nmLeft.lessThan(number2);
                        break;
                    }
                    case LESS_THAN_EQ: {
                        result = nmLeft.lessThanEq(number2);
                        break;
                    }
                    case NOT_EQUAL: {
                        result = nmLeft.notEqualTo(number2);
                        break;
                    }
                    default: {
                        ErrorReporter.errorAbort("ValueTransfer: unsupported operation: " + (Object)((Object)op));
                        throw new RuntimeException("this can't happen");
                    }
                }
                resultValues.add(result);
                if (result.booleanValue()) {
                    thenLeftVals.add(number);
                    thenRightVals.add(number2);
                    continue;
                }
                elseLeftVals.add(number);
                elseRightVals.add(number2);
            }
        }
        this.createAnnotationFromResultsAndAddToStore(thenStore, thenLeftVals, leftNode);
        this.createAnnotationFromResultsAndAddToStore(elseStore, elseLeftVals, leftNode);
        this.createAnnotationFromResultsAndAddToStore(thenStore, thenRightVals, rightNode);
        this.createAnnotationFromResultsAndAddToStore(elseStore, elseRightVals, rightNode);
        return resultValues;
    }

    private List<Boolean> refineIntRanges(Node leftNode, AnnotationMirror leftAnno, Node rightNode, AnnotationMirror rightAnno, ComparisonOperators op, CFStore thenStore, CFStore elseStore) {
        Range elseLeftRange;
        Range elseRightRange;
        Range thenLeftRange;
        Range thenRightRange;
        Range leftRange = this.getIntRangeFromAnnotation(leftNode, leftAnno);
        Range rightRange = this.getIntRangeFromAnnotation(rightNode, rightAnno);
        switch (op) {
            case EQUAL: {
                thenLeftRange = thenRightRange = rightRange.refineEqualTo(leftRange);
                elseRightRange = rightRange.refineNotEqualTo(leftRange);
                elseLeftRange = leftRange.refineNotEqualTo(rightRange);
                break;
            }
            case GREATER_THAN: {
                thenLeftRange = leftRange.refineGreaterThan(rightRange);
                thenRightRange = rightRange.refineLessThan(leftRange);
                elseRightRange = rightRange.refineGreaterThanEq(leftRange);
                elseLeftRange = leftRange.refineLessThanEq(rightRange);
                break;
            }
            case GREATER_THAN_EQ: {
                thenRightRange = rightRange.refineLessThanEq(leftRange);
                thenLeftRange = leftRange.refineGreaterThanEq(rightRange);
                elseLeftRange = leftRange.refineLessThan(rightRange);
                elseRightRange = rightRange.refineGreaterThan(leftRange);
                break;
            }
            case LESS_THAN: {
                thenLeftRange = leftRange.refineLessThan(rightRange);
                thenRightRange = rightRange.refineGreaterThan(leftRange);
                elseRightRange = rightRange.refineLessThanEq(leftRange);
                elseLeftRange = leftRange.refineGreaterThanEq(rightRange);
                break;
            }
            case LESS_THAN_EQ: {
                thenRightRange = rightRange.refineGreaterThanEq(leftRange);
                thenLeftRange = leftRange.refineLessThanEq(rightRange);
                elseLeftRange = leftRange.refineGreaterThan(rightRange);
                elseRightRange = rightRange.refineLessThan(leftRange);
                break;
            }
            case NOT_EQUAL: {
                thenRightRange = rightRange.refineNotEqualTo(leftRange);
                thenLeftRange = leftRange.refineNotEqualTo(rightRange);
                elseLeftRange = elseRightRange = rightRange.refineEqualTo(leftRange);
                break;
            }
            default: {
                ErrorReporter.errorAbort("ValueTransfer: unsupported operation: " + (Object)((Object)op));
                throw new RuntimeException("this is impossible, but javac issues a warning");
            }
        }
        this.createAnnotationFromRangeAndAddToStore(thenStore, thenRightRange, rightNode);
        this.createAnnotationFromRangeAndAddToStore(thenStore, thenLeftRange, leftNode);
        this.createAnnotationFromRangeAndAddToStore(elseStore, elseRightRange, rightNode);
        this.createAnnotationFromRangeAndAddToStore(elseStore, elseLeftRange, leftNode);
        return null;
    }

    private void createAnnotationFromResultsAndAddToStore(CFStore store, List<?> results, Node node) {
        AnnotationMirror anno = this.atypefactory.createResultingAnnotation(node.getType(), results);
        this.addAnnotationToStore(store, anno, node);
    }

    private void createAnnotationFromRangeAndAddToStore(CFStore store, Range range, Node node) {
        AnnotationMirror anno = this.atypefactory.createIntRangeAnnotation(range);
        this.addAnnotationToStore(store, anno, node);
    }

    private void addAnnotationToStore(CFStore store, AnnotationMirror anno, Node node) {
        for (Node internal : this.splitAssignments(node)) {
            AnnotationMirror currentAnno = this.atypefactory.getAnnotatedType(internal.getTree()).getAnnotationInHierarchy(this.atypefactory.BOTTOMVAL);
            FlowExpressions.Receiver rec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), internal);
            store.insertValue(rec, this.atypefactory.getQualifierHierarchy().greatestLowerBound(anno, currentAnno));
            if (node instanceof FieldAccessNode) {
                this.refineArrayAtLengthAccess((FieldAccessNode)internal, store);
                continue;
            }
            if (!(node instanceof MethodInvocationNode)) continue;
            this.refineStringAtLengthInvocation((MethodInvocationNode)internal, store);
        }
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThan(LessThanNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitLessThan(n, p);
        CFStore thenStore = (CFStore)transferResult.getThenStore();
        CFStore elseStore = (CFStore)transferResult.getElseStore();
        List<Boolean> resultValues = this.calculateBinaryComparison(n.getLeftOperand(), p.getValueOfSubNode(n.getLeftOperand()), n.getRightOperand(), p.getValueOfSubNode(n.getRightOperand()), ComparisonOperators.LESS_THAN, thenStore, elseStore);
        TypeMirror underlyingType = ((CFValue)transferResult.getResultValue()).getUnderlyingType();
        return this.createNewResultBoolean(thenStore, elseStore, resultValues, underlyingType);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThanOrEqual(LessThanOrEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitLessThanOrEqual(n, p);
        CFStore thenStore = (CFStore)transferResult.getThenStore();
        CFStore elseStore = (CFStore)transferResult.getElseStore();
        List<Boolean> resultValues = this.calculateBinaryComparison(n.getLeftOperand(), p.getValueOfSubNode(n.getLeftOperand()), n.getRightOperand(), p.getValueOfSubNode(n.getRightOperand()), ComparisonOperators.LESS_THAN_EQ, thenStore, elseStore);
        TypeMirror underlyingType = ((CFValue)transferResult.getResultValue()).getUnderlyingType();
        return this.createNewResultBoolean(thenStore, elseStore, resultValues, underlyingType);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThan(GreaterThanNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitGreaterThan(n, p);
        CFStore thenStore = (CFStore)transferResult.getThenStore();
        CFStore elseStore = (CFStore)transferResult.getElseStore();
        List<Boolean> resultValues = this.calculateBinaryComparison(n.getLeftOperand(), p.getValueOfSubNode(n.getLeftOperand()), n.getRightOperand(), p.getValueOfSubNode(n.getRightOperand()), ComparisonOperators.GREATER_THAN, thenStore, elseStore);
        TypeMirror underlyingType = ((CFValue)transferResult.getResultValue()).getUnderlyingType();
        return this.createNewResultBoolean(thenStore, elseStore, resultValues, underlyingType);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThanOrEqual(GreaterThanOrEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitGreaterThanOrEqual(n, p);
        CFStore thenStore = (CFStore)transferResult.getThenStore();
        CFStore elseStore = (CFStore)transferResult.getElseStore();
        List<Boolean> resultValues = this.calculateBinaryComparison(n.getLeftOperand(), p.getValueOfSubNode(n.getLeftOperand()), n.getRightOperand(), p.getValueOfSubNode(n.getRightOperand()), ComparisonOperators.GREATER_THAN_EQ, thenStore, elseStore);
        TypeMirror underlyingType = ((CFValue)transferResult.getResultValue()).getUnderlyingType();
        return this.createNewResultBoolean(thenStore, elseStore, resultValues, underlyingType);
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> transferResult, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        if (firstValue == null) {
            return transferResult;
        }
        if (TypesUtils.isNumeric(firstNode.getType()) || TypesUtils.isNumeric(secondNode.getType())) {
            CFStore thenStore = transferResult.getThenStore();
            CFStore elseStore = transferResult.getElseStore();
            List<Boolean> resultValues = this.calculateBinaryComparison(firstNode, firstValue, secondNode, secondValue, notEqualTo ? ComparisonOperators.NOT_EQUAL : ComparisonOperators.EQUAL, thenStore, elseStore);
            if (transferResult.getResultValue() == null) {
                return transferResult;
            }
            TypeMirror underlyingType = transferResult.getResultValue().getUnderlyingType();
            return this.createNewResultBoolean(thenStore, elseStore, resultValues, underlyingType);
        }
        return super.strengthenAnnotationOfEqualTo(transferResult, firstNode, secondNode, firstValue, secondValue, notEqualTo);
    }

    private List<Boolean> calculateConditionalOperator(Node leftNode, Node rightNode, ConditionalOperators op, TransferInput<CFValue, CFStore> p) {
        List<Boolean> lefts = this.getBooleanValues(leftNode, p);
        if (lefts == null) {
            lefts = ALL_BOOLEANS;
        }
        ArrayList<Boolean> resultValues = new ArrayList<Boolean>();
        List<Boolean> rights = null;
        if (rightNode != null && (rights = this.getBooleanValues(rightNode, p)) == null) {
            rights = ALL_BOOLEANS;
        }
        switch (op) {
            case NOT: {
                for (Boolean left : lefts) {
                    resultValues.add(left == false);
                }
                return resultValues;
            }
            case OR: {
                for (Boolean left : lefts) {
                    for (Boolean right : rights) {
                        resultValues.add(left != false || right != false);
                    }
                }
                return resultValues;
            }
            case AND: {
                for (Boolean left : lefts) {
                    for (Boolean right : rights) {
                        resultValues.add(left != false && right != false);
                    }
                }
                return resultValues;
            }
        }
        ErrorReporter.errorAbort("ValueTransfer: unsupported operation: " + (Object)((Object)op));
        throw new RuntimeException("this can't happen");
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalNot(ConditionalNotNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<CFValue, CFStore> transferResult = super.visitConditionalNot(n, p);
        List<Boolean> resultValues = this.calculateConditionalOperator(n.getOperand(), null, ConditionalOperators.NOT, p);
        return this.createNewResultBoolean(transferResult.getThenStore(), transferResult.getElseStore(), resultValues, transferResult.getResultValue().getUnderlyingType());
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalAnd(ConditionalAndNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitConditionalAnd(n, p);
        List<Boolean> resultValues = this.calculateConditionalOperator(n.getLeftOperand(), n.getRightOperand(), ConditionalOperators.AND, p);
        return this.createNewResultBoolean((CFStore)transferResult.getThenStore(), (CFStore)transferResult.getElseStore(), resultValues, ((CFValue)transferResult.getResultValue()).getUnderlyingType());
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalOr(ConditionalOrNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitConditionalOr(n, p);
        List<Boolean> resultValues = this.calculateConditionalOperator(n.getLeftOperand(), n.getRightOperand(), ConditionalOperators.OR, p);
        return this.createNewResultBoolean((CFStore)transferResult.getThenStore(), (CFStore)transferResult.getElseStore(), resultValues, ((CFValue)transferResult.getResultValue()).getUnderlyingType());
    }

    static enum ConditionalOperators {
        NOT,
        OR,
        AND;

    }

    static enum ComparisonOperators {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_THAN_EQ,
        LESS_THAN,
        LESS_THAN_EQ;

    }

    static enum NumericalUnaryOps {
        PLUS,
        MINUS,
        BITWISE_COMPLEMENT;

    }

    static enum NumericalBinaryOps {
        ADDITION,
        SUBTRACTION,
        DIVISION,
        REMAINDER,
        MULTIPLICATION,
        SHIFT_LEFT,
        SIGNED_SHIFT_RIGHT,
        UNSIGNED_SHIFT_RIGHT,
        BITWISE_AND,
        BITWISE_OR,
        BITWISE_XOR;

    }
}

