/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.wholeprograminference;

import annotations.Annotation;
import annotations.el.AnnotationDef;
import annotations.field.AnnotationFieldType;
import annotations.field.ArrayAFT;
import annotations.field.BasicAFT;
import annotations.field.ScalarAFT;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;

public class AnnotationConverter {
    protected static Annotation annotationMirrorToAnnotation(AnnotationMirror am) {
        AnnotationDef def = new AnnotationDef(AnnotationUtils.annotationName(am));
        HashMap<String, Object> fieldTypes = new HashMap<String, Object>();
        for (ExecutableElement executableElement : am.getElementValues().keySet()) {
            AnnotationFieldType aft = AnnotationConverter.getAnnotationFieldType(executableElement, am.getElementValues().get(executableElement).getValue());
            if (aft == null) {
                return null;
            }
            fieldTypes.put(executableElement.getSimpleName().toString(), aft);
        }
        def.setFieldTypes(fieldTypes);
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = am.getElementValues();
        HashMap hashMap = new HashMap();
        for (ExecutableElement executableElement : values.keySet()) {
            ArrayList<Object> value = values.get(executableElement).getValue();
            if (value instanceof List) {
                List valueList = value;
                ArrayList<Object> newList = new ArrayList<Object>();
                for (Object o : valueList) {
                    newList.add(((AnnotationValue)o).getValue());
                }
                value = newList;
            }
            hashMap.put(executableElement.getSimpleName().toString(), value);
        }
        Annotation out = new Annotation(def, hashMap);
        return out;
    }

    protected static AnnotationMirror annotationToAnnotationMirror(Annotation anno, ProcessingEnvironment processingEnv) {
        AnnotationBuilder builder = new AnnotationBuilder(processingEnv, anno.def().name);
        for (String fieldKey : anno.fieldValues.keySet()) {
            AnnotationConverter.addFieldToAnnotationBuilder(fieldKey, anno.fieldValues.get(fieldKey), builder);
        }
        return builder.build();
    }

    protected static AnnotationFieldType getAnnotationFieldType(ExecutableElement ee, Object value) {
        if (value instanceof List) {
            AnnotationValue defaultValue = ee.getDefaultValue();
            if (defaultValue == null || (Type.ArrayType)((Attribute.Array)defaultValue).type == null) {
                ScalarAFT scalarAFT;
                List listV = (List)value;
                if (!listV.isEmpty() && (scalarAFT = (ScalarAFT)AnnotationConverter.getAnnotationFieldType(ee, ((AnnotationValue)listV.get(0)).getValue())) != null) {
                    return new ArrayAFT(scalarAFT);
                }
                return null;
            }
            Type elemType = ((Type.ArrayType)((Attribute.Array)defaultValue).type).elemtype;
            try {
                return new ArrayAFT(BasicAFT.forType(Class.forName(elemType.toString())));
            }
            catch (ClassNotFoundException e) {
                ErrorReporter.errorAbort(e.getMessage());
            }
        } else {
            if (value instanceof Boolean) {
                return BasicAFT.forType(Boolean.TYPE);
            }
            if (value instanceof Character) {
                return BasicAFT.forType(Character.TYPE);
            }
            if (value instanceof Double) {
                return BasicAFT.forType(Double.TYPE);
            }
            if (value instanceof Float) {
                return BasicAFT.forType(Float.TYPE);
            }
            if (value instanceof Integer) {
                return BasicAFT.forType(Integer.TYPE);
            }
            if (value instanceof Long) {
                return BasicAFT.forType(Long.TYPE);
            }
            if (value instanceof Short) {
                return BasicAFT.forType(Short.TYPE);
            }
            if (value instanceof String) {
                return BasicAFT.forType(String.class);
            }
        }
        return null;
    }

    protected static void addFieldToAnnotationBuilder(String fieldKey, Object obj, AnnotationBuilder builder) {
        if (obj instanceof List) {
            builder.setValue((CharSequence)fieldKey, (List)obj);
        } else if (obj instanceof String) {
            builder.setValue((CharSequence)fieldKey, (String)obj);
        } else if (obj instanceof Integer) {
            builder.setValue((CharSequence)fieldKey, (Integer)obj);
        } else if (obj instanceof Float) {
            builder.setValue((CharSequence)fieldKey, (Float)obj);
        } else if (obj instanceof Long) {
            builder.setValue((CharSequence)fieldKey, (Long)obj);
        } else if (obj instanceof Boolean) {
            builder.setValue((CharSequence)fieldKey, (Boolean)obj);
        } else if (obj instanceof Character) {
            builder.setValue((CharSequence)fieldKey, (Character)obj);
        } else if (obj instanceof Class) {
            builder.setValue((CharSequence)fieldKey, (Class)obj);
        } else if (obj instanceof Double) {
            builder.setValue((CharSequence)fieldKey, (Double)obj);
        } else if (obj instanceof Float) {
            builder.setValue((CharSequence)fieldKey, (Float)obj);
        } else if (obj instanceof Enum) {
            builder.setValue((CharSequence)fieldKey, (Enum)obj);
        } else if (obj instanceof Enum[]) {
            builder.setValue((CharSequence)fieldKey, (Enum[])obj);
        } else if (obj instanceof AnnotationMirror) {
            builder.setValue((CharSequence)fieldKey, (AnnotationMirror)obj);
        } else if (obj instanceof Object[]) {
            builder.setValue((CharSequence)fieldKey, (Object[])obj);
        } else if (obj instanceof TypeMirror) {
            builder.setValue((CharSequence)fieldKey, (TypeMirror)obj);
        } else if (obj instanceof Short) {
            builder.setValue((CharSequence)fieldKey, (Short)obj);
        } else if (obj instanceof VariableElement) {
            builder.setValue((CharSequence)fieldKey, (VariableElement)obj);
        } else if (obj instanceof VariableElement[]) {
            builder.setValue((CharSequence)fieldKey, (VariableElement[])obj);
        } else {
            ErrorReporter.errorAbort("Unrecognized type: " + obj.getClass());
        }
    }
}

