/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AsSuperVisitor;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.SyntheticArrays;
import org.checkerframework.framework.util.AtmLubVisitor;
import org.checkerframework.framework.util.QualifierPolymorphism;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TypesUtils;

public class AnnotatedTypes {
    private static AsSuperVisitor asSuperVisitor;
    private static Map<TypeElement, Boolean> isTypeAnnotationCache;
    private static String annotationClassName;

    private AnnotatedTypes() {
        throw new AssertionError((Object)"Class AnnotatedTypes cannot be instantiated.");
    }

    @Deprecated
    public static AnnotatedTypeMirror asSuper(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror type, AnnotatedTypeMirror superType) {
        return AnnotatedTypes.asSuper(atypeFactory, type, superType);
    }

    public static <T extends AnnotatedTypeMirror> T asSuper(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror type, T superType) {
        if (asSuperVisitor == null || !asSuperVisitor.sameAnnotatedTypeFactory(atypeFactory)) {
            asSuperVisitor = new AsSuperVisitor(atypeFactory);
        }
        return asSuperVisitor.asSuper(type, superType);
    }

    public static boolean hasNoExplicitBound(AnnotatedTypeMirror wildcard) {
        return ((Type.WildcardType)wildcard.getUnderlyingType()).isUnbound();
    }

    public static boolean hasExplicitSuperBound(AnnotatedTypeMirror wildcard) {
        Type.WildcardType wildcardType = (Type.WildcardType)wildcard.getUnderlyingType();
        return wildcardType.isSuperBound() && !((Type.WildcardType)wildcard.getUnderlyingType()).isUnbound();
    }

    public static boolean hasExplicitExtendsBound(AnnotatedTypeMirror wildcard) {
        Type.WildcardType wildcardType = (Type.WildcardType)wildcard.getUnderlyingType();
        return wildcardType.isExtendsBound() && !((Type.WildcardType)wildcard.getUnderlyingType()).isUnbound();
    }

    private static AnnotatedTypeMirror asOuterSuper(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror type, AnnotatedTypeMirror superType) {
        if (type.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType dt;
            AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType;
            TypeMirror superTypeMirror = types.erasure(superType.getUnderlyingType());
            for (enclosingType = dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)type; enclosingType != null; enclosingType = enclosingType.getEnclosingType()) {
                TypeMirror enclosingTypeMirror = types.erasure(enclosingType.getUnderlyingType());
                if (!types.isSubtype(enclosingTypeMirror, superTypeMirror)) continue;
                dt = enclosingType;
                break;
            }
            if (enclosingType == null) {
                return superType;
            }
            return AnnotatedTypes.asSuper(atypeFactory, dt, superType);
        }
        return AnnotatedTypes.asSuper(atypeFactory, type, superType);
    }

    public static AnnotatedTypeMirror.AnnotatedExecutableType asMemberOf(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, ExecutableElement elem) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)AnnotatedTypes.asMemberOf(types, atypeFactory, t, (Element)elem);
    }

    public static AnnotatedTypeMirror asMemberOf(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, Element elem) {
        switch (elem.getKind()) {
            case PACKAGE: 
            case INSTANCE_INIT: 
            case OTHER: 
            case STATIC_INIT: 
            case TYPE_PARAMETER: {
                return atypeFactory.fromElement(elem);
            }
        }
        AnnotatedTypeMirror type = AnnotatedTypes.asMemberOfImpl(types, atypeFactory, t, elem);
        if (!ElementUtils.isStatic(elem)) {
            atypeFactory.postAsMemberOf(type, t, elem);
        }
        return type;
    }

    private static AnnotatedTypeMirror asMemberOfImpl(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror of, Element member) {
        AnnotatedTypeMirror memberType = atypeFactory.getAnnotatedType(member);
        if (ElementUtils.isStatic(member)) {
            return memberType;
        }
        switch (of.getKind()) {
            case ARRAY: {
                if (SyntheticArrays.isArrayClone(of, member)) {
                    return SyntheticArrays.replaceReturnType(member, (AnnotatedTypeMirror.AnnotatedArrayType)of);
                }
                return memberType;
            }
            case TYPEVAR: {
                return AnnotatedTypes.asMemberOf(types, atypeFactory, ((AnnotatedTypeMirror.AnnotatedTypeVariable)of).getUpperBound(), member);
            }
            case WILDCARD: {
                return AnnotatedTypes.asMemberOf(types, atypeFactory, ((AnnotatedTypeMirror.AnnotatedWildcardType)of).getExtendsBound().deepCopy(), member);
            }
            case INTERSECTION: 
            case UNION: 
            case DECLARED: {
                return AnnotatedTypes.substituteTypeVariables(types, atypeFactory, of, member, memberType);
            }
        }
        ErrorReporter.errorAbort("asMemberOf called on unexpected type.\nt: " + of);
        return memberType;
    }

    private static AnnotatedTypeMirror substituteTypeVariables(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror of, Element member, AnnotatedTypeMirror memberType) {
        TypeElement enclosingClassOfMember = ElementUtils.enclosingClass(member);
        HashMap<TypeVariable, AnnotatedTypeMirror> mappings = new HashMap<TypeVariable, AnnotatedTypeMirror>();
        while (enclosingClassOfMember != null) {
            AnnotatedTypes.addTypeVarMappings(types, atypeFactory, of, enclosingClassOfMember, mappings);
            enclosingClassOfMember = ElementUtils.enclosingClass(enclosingClassOfMember.getEnclosingElement());
        }
        if (!mappings.isEmpty()) {
            memberType = atypeFactory.getTypeVarSubstitutor().substitute(mappings, memberType);
        }
        return memberType;
    }

    private static void addTypeVarMappings(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, TypeElement enclosingClassOfElem, Map<TypeVariable, AnnotatedTypeMirror> mappings) {
        if (enclosingClassOfElem.getTypeParameters().isEmpty()) {
            return;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType = atypeFactory.getAnnotatedType(enclosingClassOfElem);
        AnnotatedTypeMirror.AnnotatedDeclaredType base = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asOuterSuper(types, atypeFactory, t, enclosingType);
        ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable> ownerParams = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>(enclosingType.getTypeArguments().size());
        for (AnnotatedTypeMirror typeParam : enclosingType.getTypeArguments()) {
            if (typeParam.getKind() != TypeKind.TYPEVAR) {
                ErrorReporter.errorAbort("Type arguments of a declaration should be type variables\nenclosingClassOfElem=" + enclosingClassOfElem + "\nenclosingType=" + enclosingType + "\ntypeMirror=" + t);
            }
            ownerParams.add((AnnotatedTypeMirror.AnnotatedTypeVariable)typeParam);
        }
        java.util.List<AnnotatedTypeMirror> baseParams = base.getTypeArguments();
        if (ownerParams.size() != baseParams.size() && !base.wasRaw()) {
            ErrorReporter.errorAbort("Unexpected number of parameters.\nenclosingType=" + enclosingType + "\nbaseType=" + base);
        }
        if (!ownerParams.isEmpty() && baseParams.isEmpty() && base.wasRaw()) {
            ArrayList<AnnotatedTypeMirror> newBaseParams = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror.AnnotatedTypeVariable arg : ownerParams) {
                newBaseParams.add(arg.getErased());
            }
            baseParams = newBaseParams;
        }
        for (int i = 0; i < ownerParams.size(); ++i) {
            mappings.put(((AnnotatedTypeMirror.AnnotatedTypeVariable)ownerParams.get(i)).getUnderlyingType(), baseParams.get(i));
        }
    }

    public static AnnotatedTypeMirror getIteratedType(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror iterableType) {
        if (iterableType.getKind() == TypeKind.ARRAY) {
            return ((AnnotatedTypeMirror.AnnotatedArrayType)iterableType).getComponentType();
        }
        if (iterableType.getKind() == TypeKind.WILDCARD) {
            return AnnotatedTypes.getIteratedType(processingEnv, atypeFactory, ((AnnotatedTypeMirror.AnnotatedWildcardType)iterableType).getExtendsBound().deepCopy());
        }
        if (iterableType.getKind() == TypeKind.TYPEVAR) {
            return AnnotatedTypes.getIteratedType(processingEnv, atypeFactory, ((AnnotatedTypeMirror.AnnotatedTypeVariable)iterableType).getUpperBound());
        }
        if (iterableType.getKind() != TypeKind.DECLARED) {
            ErrorReporter.errorAbort("AnnotatedTypes.getIteratedType: not iterable type: " + iterableType);
            return null;
        }
        TypeElement iterableElement = processingEnv.getElementUtils().getTypeElement("java.lang.Iterable");
        AnnotatedTypeMirror.AnnotatedDeclaredType iterableElmType = atypeFactory.getAnnotatedType(iterableElement);
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = AnnotatedTypes.asSuper(atypeFactory, iterableType, iterableElmType);
        if (dt.getTypeArguments().isEmpty()) {
            TypeElement e = processingEnv.getElementUtils().getTypeElement("java.lang.Object");
            AnnotatedTypeMirror.AnnotatedDeclaredType t = atypeFactory.getAnnotatedType(e);
            return t;
        }
        return dt.getTypeArguments().get(0);
    }

    public static Set<AnnotatedTypeMirror.AnnotatedDeclaredType> getSuperTypes(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        LinkedHashSet<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = new LinkedHashSet<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        if (type == null) {
            return supertypes;
        }
        ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType> stack = new ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        stack.push(type);
        while (!stack.isEmpty()) {
            AnnotatedTypeMirror.AnnotatedDeclaredType current = (AnnotatedTypeMirror.AnnotatedDeclaredType)stack.pop();
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : current.directSuperTypes()) {
                if (supertypes.contains(supertype)) continue;
                stack.push(supertype);
                supertypes.add(supertype);
            }
        }
        return Collections.unmodifiableSet(supertypes);
    }

    public static Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(Elements elements, AnnotatedTypeFactory atypeFactory, ExecutableElement method) {
        TypeElement elem = (TypeElement)method.getEnclosingElement();
        AnnotatedTypeMirror.AnnotatedDeclaredType type = atypeFactory.getAnnotatedType(elem);
        Set<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = AnnotatedTypes.getSuperTypes(type);
        return AnnotatedTypes.overriddenMethods(elements, method, supertypes);
    }

    public static Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(Elements elements, ExecutableElement method, Collection<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes) {
        LinkedHashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overrides = new LinkedHashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement>();
        block0: for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : supertypes) {
            @Nullable TypeElement superElement = (TypeElement)supertype.getUnderlyingType().asElement();
            assert (superElement != null);
            for (ExecutableElement supermethod : ElementFilter.methodsIn(superElement.getEnclosedElements())) {
                if (!elements.overrides(method, supermethod, superElement)) continue;
                overrides.put(supertype, supermethod);
                continue block0;
            }
        }
        return Collections.unmodifiableMap(overrides);
    }

    public static Map<TypeVariable, AnnotatedTypeMirror> findTypeArguments(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, ExpressionTree expr, ExecutableElement elt, AnnotatedTypeMirror.AnnotatedExecutableType preType) {
        java.util.List<? extends Tree> targs;
        if (elt.getTypeParameters().isEmpty()) {
            return Collections.emptyMap();
        }
        if (expr instanceof MethodInvocationTree) {
            targs = ((MethodInvocationTree)expr).getTypeArguments();
        } else if (expr instanceof NewClassTree) {
            targs = ((NewClassTree)expr).getTypeArguments();
        } else if (expr instanceof MemberReferenceTree) {
            targs = ((MemberReferenceTree)expr).getTypeArguments();
            if (targs == null) {
                return new HashMap<TypeVariable, AnnotatedTypeMirror>();
            }
        } else {
            ErrorReporter.errorAbort("AnnotatedTypes.findTypeArguments: unexpected tree: " + expr);
            return null;
        }
        if (!targs.isEmpty()) {
            java.util.List<AnnotatedTypeMirror.AnnotatedTypeVariable> tvars = preType.getTypeVariables();
            HashMap<TypeVariable, AnnotatedTypeMirror> typeArguments = new HashMap<TypeVariable, AnnotatedTypeMirror>();
            for (int i = 0; i < elt.getTypeParameters().size(); ++i) {
                AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = tvars.get(i);
                AnnotatedTypeMirror typeArg = atypeFactory.getAnnotatedTypeFromTypeTree(targs.get(i));
                typeArguments.put(typeVar.getUnderlyingType(), typeArg);
            }
            return typeArguments;
        }
        return atypeFactory.getTypeArgumentInference().inferTypeArgs(atypeFactory, expr, elt, preType);
    }

    @Deprecated
    public static AnnotatedTypeMirror leastUpperBound(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        return AnnotatedTypes.leastUpperBound(atypeFactory, type1, type2);
    }

    public static AnnotatedTypeMirror leastUpperBound(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        TypeMirror lub = InternalUtils.leastUpperBound(atypeFactory.getProcessingEnv(), type1.getUnderlyingType(), type2.getUnderlyingType());
        return AnnotatedTypes.leastUpperBound(atypeFactory, type1, type2, lub);
    }

    public static AnnotatedTypeMirror leastUpperBound(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, TypeMirror lubTypeMirror) {
        return new AtmLubVisitor(atypeFactory).lub(type1, type2, lubTypeMirror);
    }

    public static java.util.List<AnnotatedTypeMirror> expandVarArgs(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror.AnnotatedExecutableType method, java.util.List<? extends ExpressionTree> args) {
        AnnotatedTypeMirror lastArg;
        java.util.List<AnnotatedTypeMirror> parameters = method.getParameterTypes();
        if (!method.getElement().isVarArgs()) {
            return parameters;
        }
        AnnotatedTypeMirror.AnnotatedArrayType varargs = (AnnotatedTypeMirror.AnnotatedArrayType)parameters.get(parameters.size() - 1);
        if (parameters.size() == args.size() && (lastArg = atypeFactory.getAnnotatedType(args.get(args.size() - 1))).getKind() == TypeKind.ARRAY && AnnotatedTypes.getArrayDepth(varargs) == AnnotatedTypes.getArrayDepth((AnnotatedTypeMirror.AnnotatedArrayType)lastArg)) {
            return parameters;
        }
        parameters = new ArrayList<AnnotatedTypeMirror>(parameters.subList(0, parameters.size() - 1));
        for (int i = args.size() - parameters.size(); i > 0; --i) {
            parameters.add(varargs.getComponentType());
        }
        return parameters;
    }

    public static java.util.List<AnnotatedTypeMirror> expandVarArgsFromTypes(AnnotatedTypeMirror.AnnotatedExecutableType method, java.util.List<AnnotatedTypeMirror> args) {
        AnnotatedTypeMirror lastArg;
        java.util.List<AnnotatedTypeMirror> parameters = method.getParameterTypes();
        if (!method.getElement().isVarArgs()) {
            return parameters;
        }
        AnnotatedTypeMirror.AnnotatedArrayType varargs = (AnnotatedTypeMirror.AnnotatedArrayType)parameters.get(parameters.size() - 1);
        if (parameters.size() == args.size() && (lastArg = args.get(args.size() - 1)).getKind() == TypeKind.ARRAY && (AnnotatedTypes.getArrayDepth(varargs) == AnnotatedTypes.getArrayDepth((AnnotatedTypeMirror.AnnotatedArrayType)lastArg) || varargs.getComponentType().getKind() == TypeKind.TYPEVAR)) {
            return parameters;
        }
        parameters = new ArrayList<AnnotatedTypeMirror>(parameters.subList(0, parameters.size() - 1));
        for (int i = args.size() - parameters.size(); i > 0; --i) {
            parameters.add(varargs.getComponentType());
        }
        return parameters;
    }

    public static AnnotatedTypeMirror getAnnotatedTypeMirrorOfParameter(AnnotatedTypeMirror.AnnotatedExecutableType methodType, int index) {
        boolean parameterBeforeVarargs;
        java.util.List<AnnotatedTypeMirror> parameterTypes = methodType.getParameterTypes();
        boolean hasVarArg = methodType.getElement().isVarArgs();
        int lastIndex = parameterTypes.size() - 1;
        AnnotatedTypeMirror lastType = parameterTypes.get(lastIndex);
        boolean bl = parameterBeforeVarargs = index < lastIndex;
        if (!parameterBeforeVarargs && lastType instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)lastType;
            if (hasVarArg) {
                return arrayType.getComponentType();
            }
        }
        return parameterTypes.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.List<AnnotatedTypeMirror> getAnnotatedTypes(AnnotatedTypeFactory atypeFactory, java.util.List<AnnotatedTypeMirror> paramTypes, java.util.List<? extends ExpressionTree> trees) {
        assert (paramTypes.size() == trees.size()) : "AnnotatedTypes.getAnnotatedTypes: size mismatch! Parameter types: " + paramTypes + " Arguments: " + trees;
        ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = atypeFactory.getVisitorState().getAssignmentContext();
        try {
            for (int i = 0; i < trees.size(); ++i) {
                AnnotatedTypeMirror param = paramTypes.get(i);
                atypeFactory.getVisitorState().setAssignmentContext(Pair.of(null, param));
                ExpressionTree arg = trees.get(i);
                types.add(atypeFactory.getAnnotatedType(arg));
            }
        }
        finally {
            atypeFactory.getVisitorState().setAssignmentContext(preAssCtxt);
        }
        return types;
    }

    public static boolean areSame(AnnotatedTypeMirror t1, AnnotatedTypeMirror t2) {
        return t1.toString().equals(t2.toString());
    }

    public static int getArrayDepth(AnnotatedTypeMirror.AnnotatedArrayType array) {
        int counter = 0;
        AnnotatedTypeMirror type = array;
        while (type.getKind() == TypeKind.ARRAY) {
            ++counter;
            type = type.getComponentType();
        }
        return counter;
    }

    public static AnnotatedTypeMirror innerMostType(AnnotatedTypeMirror t) {
        AnnotatedTypeMirror inner = t;
        while (inner.getKind() == TypeKind.ARRAY) {
            inner = ((AnnotatedTypeMirror.AnnotatedArrayType)inner).getComponentType();
        }
        return inner;
    }

    public static boolean containsModifier(AnnotatedTypeMirror type, AnnotationMirror modifier) {
        return AnnotatedTypes.containsModifierImpl(type, modifier, new LinkedList<AnnotatedTypeMirror>());
    }

    private static boolean containsModifierImpl(AnnotatedTypeMirror type, AnnotationMirror modifier, java.util.List<AnnotatedTypeMirror> visited) {
        boolean found = type.hasAnnotation(modifier);
        boolean vis = visited.contains(type);
        visited.add(type);
        if (!found && !vis) {
            if (type.getKind() == TypeKind.DECLARED) {
                AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)type;
                for (AnnotatedTypeMirror typeMirror : declaredType.getTypeArguments()) {
                    if (found |= AnnotatedTypes.containsModifierImpl(typeMirror, modifier, visited)) break;
                }
            } else if (type.getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)type;
                found = AnnotatedTypes.containsModifierImpl(arrayType.getComponentType(), modifier, visited);
            } else if (type.getKind() == TypeKind.TYPEVAR) {
                AnnotatedTypeMirror.AnnotatedTypeVariable atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)type;
                if (atv.getUpperBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(atv.getUpperBound(), modifier, visited);
                }
                if (!found && atv.getLowerBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(atv.getLowerBound(), modifier, visited);
                }
            } else if (type.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType awc = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
                if (awc.getExtendsBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(awc.getExtendsBound(), modifier, visited);
                }
                if (!found && awc.getSuperBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(awc.getSuperBound(), modifier, visited);
                }
            }
        }
        return found;
    }

    public static boolean isTypeAnnotation(AnnotationMirror anno, Class<?> cls) {
        TypeElement elem = (TypeElement)anno.getAnnotationType().asElement();
        if (isTypeAnnotationCache.containsKey(elem)) {
            return isTypeAnnotationCache.get(elem);
        }
        boolean result = AnnotatedTypes.hasTypeQualifierElementTypes(elem.getAnnotation(Target.class).value(), cls);
        isTypeAnnotationCache.put(elem, result);
        return result;
    }

    public static boolean hasTypeQualifierElementTypes(ElementType[] elements, Class<?> cls) {
        boolean hasTypeUse = false;
        ElementType otherElementType = null;
        for (ElementType element : elements) {
            if (element.equals((Object)ElementType.TYPE_USE)) {
                hasTypeUse = true;
            } else if (!element.equals((Object)ElementType.TYPE_PARAMETER)) {
                otherElementType = element;
            }
            if (!hasTypeUse || otherElementType == null) continue;
            ErrorReporter.errorAbort("@Target meta-annotation should not contain both TYPE_USE and " + (Object)((Object)otherElementType) + ", for annotation " + cls.getName());
        }
        return hasTypeUse;
    }

    public static boolean isValidType(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror type) {
        boolean res = AnnotatedTypes.isValidType(qualifierHierarchy, type, Collections.emptySet());
        return res;
    }

    private static boolean isValidType(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror type, Set<AnnotatedTypeMirror> v) {
        boolean canHaveEmptyAnnotationSet;
        if (type == null) {
            return false;
        }
        HashSet<AnnotatedTypeMirror> visited = new HashSet<AnnotatedTypeMirror>(v);
        if (visited.contains(type)) {
            return true;
        }
        visited.add(type);
        Set<AnnotationMirror> annotations = type.getAnnotations();
        Set<AnnotationMirror> seenTops = AnnotationUtils.createAnnotationSet();
        int n = 0;
        for (AnnotationMirror anno : annotations) {
            if (QualifierPolymorphism.isPolyAll(anno)) continue;
            ++n;
            AnnotationMirror top = qualifierHierarchy.getTopAnnotation(anno);
            if (AnnotationUtils.containsSame(seenTops, top)) {
                return false;
            }
            seenTops.add(top);
        }
        int expectedN = qualifierHierarchy.getWidth();
        if (n > expectedN) {
            return false;
        }
        boolean hasPolyAll = type.hasAnnotation(PolyAll.class);
        boolean bl = canHaveEmptyAnnotationSet = QualifierHierarchy.canHaveEmptyAnnotationSet(type) || hasPolyAll;
        if (!canHaveEmptyAnnotationSet && n != expectedN) {
            return false;
        }
        if (type instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            AnnotatedTypeMirror.AnnotatedArrayType at = (AnnotatedTypeMirror.AnnotatedArrayType)type;
            if (!AnnotatedTypes.isValidType(qualifierHierarchy, at.getComponentType(), visited)) {
                return false;
            }
        } else if (type instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            AnnotatedTypeMirror.AnnotatedTypeVariable at = (AnnotatedTypeMirror.AnnotatedTypeVariable)type;
            AnnotatedTypeMirror lowerBound = at.getLowerBound();
            AnnotatedTypeMirror upperBound = at.getUpperBound();
            if (lowerBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, lowerBound, visited)) {
                return false;
            }
            if (upperBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, upperBound, visited)) {
                return false;
            }
        } else if (type instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
            AnnotatedTypeMirror.AnnotatedWildcardType at = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
            AnnotatedTypeMirror extendsBound = at.getExtendsBound();
            AnnotatedTypeMirror superBound = at.getSuperBound();
            if (extendsBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, extendsBound, visited)) {
                return false;
            }
            if (superBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, superBound, visited)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJavaLangAnnotation(AnnotatedTypeMirror atm) {
        return TypesUtils.isDeclaredOfName(atm.getUnderlyingType(), annotationClassName);
    }

    public static boolean implementsAnnotation(AnnotatedTypeMirror atm) {
        if (atm.getKind() != TypeKind.DECLARED) {
            return false;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)atm;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)declaredType.getUnderlyingType().asElement();
        for (Type iface : classSymbol.getInterfaces()) {
            if (!TypesUtils.isDeclaredOfName(iface, annotationClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnum(AnnotatedTypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adt = (AnnotatedTypeMirror.AnnotatedDeclaredType)typeMirror;
            return TypesUtils.isDeclaredOfName(adt.getUnderlyingType(), Enum.class.getName());
        }
        return false;
    }

    public static boolean isDeclarationOfJavaLangEnum(Types types, Elements elements, AnnotatedTypeMirror typeMirror) {
        if (AnnotatedTypes.isEnum(typeMirror)) {
            return elements.getTypeElement("java.lang.Enum").equals(((AnnotatedTypeMirror.AnnotatedDeclaredType)typeMirror).getUnderlyingType().asElement());
        }
        return false;
    }

    public static boolean haveSameDeclaration(Types types, AnnotatedTypeMirror.AnnotatedTypeVariable typeVar1, AnnotatedTypeMirror.AnnotatedTypeVariable typeVar2) {
        return types.isSameType(typeVar1.getUnderlyingType(), typeVar2.getUnderlyingType());
    }

    public static boolean areCorrespondingTypeVariables(Elements elements, AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2) {
        TypeParameterElement type1ParamElem = (TypeParameterElement)type1.getUnderlyingType().asElement();
        TypeParameterElement type2ParamElem = (TypeParameterElement)type2.getUnderlyingType().asElement();
        if (type1ParamElem.getGenericElement() instanceof ExecutableElement && type2ParamElem.getGenericElement() instanceof ExecutableElement) {
            boolean methodIsOverriden;
            ExecutableElement type1Executable = (ExecutableElement)type1ParamElem.getGenericElement();
            ExecutableElement type2Executable = (ExecutableElement)type2ParamElem.getGenericElement();
            TypeElement type1Class = (TypeElement)type1Executable.getEnclosingElement();
            TypeElement type2Class = (TypeElement)type2Executable.getEnclosingElement();
            boolean bl = methodIsOverriden = elements.overrides(type1Executable, type2Executable, type1Class) || elements.overrides(type2Executable, type1Executable, type2Class);
            if (methodIsOverriden) {
                boolean haveSameIndex = type1Executable.getTypeParameters().indexOf(type1ParamElem) == type2Executable.getTypeParameters().indexOf(type2ParamElem);
                return haveSameIndex;
            }
        }
        return false;
    }

    public static AnnotationMirror findEffectiveAnnotationInHierarchy(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch, AnnotationMirror top) {
        return AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, toSearch, top, false);
    }

    public static AnnotationMirror findEffectiveAnnotationInHierarchy(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch, AnnotationMirror top, boolean canBeEmpty) {
        AnnotatedTypeMirror source = toSearch;
        block5: while (source.getAnnotationInHierarchy(top) == null) {
            switch (source.getKind()) {
                case TYPEVAR: {
                    source = ((AnnotatedTypeMirror.AnnotatedTypeVariable)source).getUpperBound();
                    continue block5;
                }
                case WILDCARD: {
                    source = ((AnnotatedTypeMirror.AnnotatedWildcardType)source).getExtendsBound();
                    continue block5;
                }
                case INTERSECTION: {
                    AnnotationMirror glb = AnnotatedTypes.glbOfBoundsInHierarchy((AnnotatedTypeMirror.AnnotatedIntersectionType)source, top, qualifierHierarchy);
                    if (glb == null) {
                        ErrorReporter.errorAbort("AnnotatedIntersectionType has no annotation in hierarchy on any of its supertypes!\nintersectionType=" + source);
                    }
                    return glb;
                }
            }
            if (canBeEmpty) {
                return null;
            }
            ErrorReporter.errorAbort("Unexpected AnnotatedTypeMirror with no primary annotation!\ntoSearch=" + toSearch + "\ntop=" + top + "\nsource=" + source);
            return null;
        }
        return source.getAnnotationInHierarchy(top);
    }

    public static Set<AnnotationMirror> findEffectiveLowerBoundAnnotations(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch) {
        AnnotatedTypeMirror source = toSearch;
        TypeKind kind = source.getKind();
        while (kind == TypeKind.TYPEVAR || kind == TypeKind.WILDCARD || kind == TypeKind.INTERSECTION) {
            switch (source.getKind()) {
                case TYPEVAR: {
                    source = ((AnnotatedTypeMirror.AnnotatedTypeVariable)source).getLowerBound();
                    break;
                }
                case WILDCARD: {
                    source = ((AnnotatedTypeMirror.AnnotatedWildcardType)source).getSuperBound();
                    break;
                }
                case INTERSECTION: {
                    Set<AnnotationMirror> glb = AnnotatedTypes.glbOfBounds((AnnotatedTypeMirror.AnnotatedIntersectionType)source, qualifierHierarchy);
                    return glb;
                }
                default: {
                    ErrorReporter.errorAbort("Unexpected AnnotatedTypeMirror with no primary annotation!toSearch=" + toSearch + "source=" + source);
                }
            }
            kind = source.getKind();
        }
        return source.getAnnotations();
    }

    public static Set<AnnotationMirror> findEffectiveAnnotations(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror toSearch) {
        AnnotatedTypeMirror source = toSearch;
        TypeKind kind = source.getKind();
        while (kind == TypeKind.TYPEVAR || kind == TypeKind.WILDCARD || kind == TypeKind.INTERSECTION) {
            switch (source.getKind()) {
                case TYPEVAR: {
                    source = ((AnnotatedTypeMirror.AnnotatedTypeVariable)source).getUpperBound();
                    break;
                }
                case WILDCARD: {
                    source = ((AnnotatedTypeMirror.AnnotatedWildcardType)source).getExtendsBound();
                    break;
                }
                case INTERSECTION: {
                    Set<AnnotationMirror> glb = AnnotatedTypes.glbOfBounds((AnnotatedTypeMirror.AnnotatedIntersectionType)source, qualifierHierarchy);
                    return glb;
                }
                default: {
                    ErrorReporter.errorAbort("Unexpected AnnotatedTypeMirror with no primary annotation!toSearch=" + toSearch + "source=" + source);
                }
            }
            kind = source.getKind();
        }
        return source.getAnnotations();
    }

    private static AnnotationMirror glbOfBoundsInHierarchy(AnnotatedTypeMirror.AnnotatedIntersectionType isect, AnnotationMirror top, QualifierHierarchy qualifierHierarchy) {
        AnnotationMirror anno = isect.getAnnotationInHierarchy(top);
        for (AnnotatedTypeMirror annotatedTypeMirror : isect.directSuperTypes()) {
            AnnotationMirror superAnno = annotatedTypeMirror.getAnnotationInHierarchy(top);
            if (superAnno == null || anno != null && !qualifierHierarchy.isSubtype(superAnno, anno)) continue;
            anno = superAnno;
        }
        return anno;
    }

    public static Set<AnnotationMirror> glbOfBounds(AnnotatedTypeMirror.AnnotatedIntersectionType isect, QualifierHierarchy qualifierHierarchy) {
        Set<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
            AnnotationMirror glbAnno = AnnotatedTypes.glbOfBoundsInHierarchy(isect, annotationMirror, qualifierHierarchy);
            if (glbAnno == null) continue;
            result.add(glbAnno);
        }
        return result;
    }

    public static boolean isExplicitlySuperBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isSuperBound() && !((Type.WildcardType)wildcardType.getUnderlyingType()).isUnbound();
    }

    public static boolean isExplicitlyExtendsBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isExtendsBound() && !((Type.WildcardType)wildcardType.getUnderlyingType()).isUnbound();
    }

    public static boolean isUnboundedOrSuperBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isSuperBound();
    }

    public static boolean isUnboundedOrExtendsBounded(AnnotatedTypeMirror.AnnotatedWildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType.getUnderlyingType()).isExtendsBound();
    }

    public static void copyOnlyExplicitConstructorAnnotations(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror.AnnotatedDeclaredType returnType, AnnotatedTypeMirror.AnnotatedExecutableType constructor) {
        List<Attribute.TypeCompound> decall = ((Symbol)((Object)constructor.getElement())).getRawTypeAttributes();
        Set<AnnotationMirror> decret = AnnotationUtils.createAnnotationSet();
        for (Attribute.TypeCompound da : decall) {
            if (da.position.type != TargetType.METHOD_RETURN) continue;
            decret.add(da);
        }
        Set<AnnotationMirror> polys = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror anno : returnType.getAnnotations()) {
            if (!QualifierPolymorphism.isPolymorphicQualified(anno)) continue;
            polys.add(anno);
        }
        block2: for (AnnotationMirror cta : constructor.getReturnType().getAnnotations()) {
            AnnotationMirror ctatop = atypeFactory.getQualifierHierarchy().getTopAnnotation(cta);
            if (atypeFactory.isSupportedQualifier(cta) && !returnType.isAnnotatedInHierarchy(cta)) {
                for (AnnotationMirror fromDecl : decret) {
                    if (!atypeFactory.isSupportedQualifier(fromDecl) || !AnnotationUtils.areSame(ctatop, atypeFactory.getQualifierHierarchy().getTopAnnotation(fromDecl))) continue;
                    returnType.addAnnotation(cta);
                    break;
                }
            }
            for (AnnotationMirror pa : polys) {
                if (!AnnotationUtils.areSame(ctatop, atypeFactory.getQualifierHierarchy().getTopAnnotation(pa))) continue;
                returnType.replaceAnnotation(cta);
                continue block2;
            }
        }
    }

    static {
        isTypeAnnotationCache = new IdentityHashMap<TypeElement, Boolean>();
        annotationClassName = Annotation.class.getCanonicalName();
    }
}

