/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;

public class GraphQualifierHierarchy
extends MultiGraphQualifierHierarchy {
    public GraphQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, AnnotationMirror bottom) {
        super(f, bottom);
    }

    @Override
    protected void finish(QualifierHierarchy qualHierarchy, Map<AnnotationMirror, Set<AnnotationMirror>> fullMap, Map<AnnotationMirror, AnnotationMirror> polyQualifiers, Set<AnnotationMirror> tops, Set<AnnotationMirror> bottoms, Object ... args) {
        if (args != null && args[0] != null) {
            AnnotationMirror thebottom = (AnnotationMirror)args[0];
            Set<AnnotationMirror> allQuals = AnnotationUtils.createAnnotationSet();
            allQuals.addAll(fullMap.keySet());
            allQuals.remove(thebottom);
            AnnotationUtils.updateMappingToImmutableSet(fullMap, thebottom, allQuals);
            tops.remove(thebottom);
            bottoms.clear();
            bottoms.add(thebottom);
        }
    }

    @Override
    public Set<? extends AnnotationMirror> getTopAnnotations() {
        if (this.tops.size() != 1) {
            ErrorReporter.errorAbort("Expected 1 possible top qualifier, found " + this.tops.size() + " (does the checker know about all type qualifiers?): " + this.tops);
        }
        return this.tops;
    }

    @Override
    public Set<? extends AnnotationMirror> getBottomAnnotations() {
        return this.bottoms;
    }

    @Override
    public boolean isSubtype(Collection<? extends AnnotationMirror> rhs, Collection<? extends AnnotationMirror> lhs) {
        rhs = this.replacePolyAll(rhs);
        if ((lhs = this.replacePolyAll(lhs)).isEmpty() || rhs.isEmpty()) {
            ErrorReporter.errorAbort("GraphQualifierHierarchy: Empty annotations in lhs: " + lhs + " or rhs: " + rhs);
        }
        if (lhs.size() > 1) {
            ErrorReporter.errorAbort("GraphQualifierHierarchy: Type with more than one annotation found: " + lhs);
        }
        if (rhs.size() > 1) {
            ErrorReporter.errorAbort("GraphQualifierHierarchy: Type with more than one annotation found: " + rhs);
        }
        for (AnnotationMirror annotationMirror : lhs) {
            for (AnnotationMirror annotationMirror2 : rhs) {
                if (!this.isSubtype(annotationMirror2, annotationMirror)) continue;
                return true;
            }
        }
        return false;
    }
}

