/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.TargetType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.framework.util.element.IndexedElementAnnotationApplier;
import org.checkerframework.javacutil.ErrorReporter;

abstract class TypeParamElementAnnotationApplier
extends IndexedElementAnnotationApplier {
    protected final AnnotatedTypeMirror.AnnotatedTypeVariable typeParam;
    protected final AnnotatedTypeFactory typeFactory;

    public static boolean accepts(AnnotatedTypeMirror typeMirror, Element element) {
        return element.getKind() == ElementKind.TYPE_PARAMETER;
    }

    protected abstract TargetType lowerBoundTarget();

    protected abstract TargetType upperBoundTarget();

    TypeParamElementAnnotationApplier(AnnotatedTypeMirror.AnnotatedTypeVariable type, Element element, AnnotatedTypeFactory typeFactory) {
        super(type, element);
        this.typeParam = type;
        this.typeFactory = typeFactory;
    }

    @Override
    protected TargetType[] annotatedTargets() {
        return new TargetType[]{this.lowerBoundTarget(), this.upperBoundTarget()};
    }

    @Override
    public int getTypeCompoundIndex(Attribute.TypeCompound anno) {
        return anno.getPosition().parameter_index;
    }

    @Override
    protected void handleTargeted(List<Attribute.TypeCompound> targeted) {
        int paramIndex = this.getElementIndex();
        ArrayList<Attribute.TypeCompound> upperBoundAnnos = new ArrayList<Attribute.TypeCompound>();
        ArrayList<Attribute.TypeCompound> lowerBoundAnnos = new ArrayList<Attribute.TypeCompound>();
        for (Attribute.TypeCompound anno : targeted) {
            AnnotationMirror canonicalAnno;
            AnnotationMirror aliasedAnno = this.typeFactory.aliasedAnnotation(anno);
            AnnotationMirror annotationMirror = canonicalAnno = aliasedAnno != null ? aliasedAnno : anno;
            if (anno.position.parameter_index != paramIndex || !this.typeFactory.isSupportedQualifier(canonicalAnno)) continue;
            if (ElementAnnotationUtil.isOnComponentType(anno)) {
                this.applyComponentAnnotation(anno);
                continue;
            }
            if (anno.position.type == this.upperBoundTarget()) {
                upperBoundAnnos.add(anno);
                continue;
            }
            lowerBoundAnnos.add(anno);
        }
        this.applyLowerBounds(lowerBoundAnnos);
        this.applyUpperBounds(upperBoundAnnos);
    }

    private void applyUpperBounds(List<Attribute.TypeCompound> upperBounds) {
        if (!upperBounds.isEmpty()) {
            AnnotatedTypeMirror upperBoundType = this.typeParam.getUpperBound();
            if (upperBoundType.getKind() == TypeKind.INTERSECTION) {
                List<? extends AnnotatedTypeMirror> intersectionTypes = upperBoundType.directSuperTypes();
                int boundIndexOffset = ElementAnnotationUtil.getBoundIndexOffset(intersectionTypes);
                for (Attribute.TypeCompound anno : upperBounds) {
                    int boundIndex = anno.position.bound_index + boundIndexOffset;
                    if (boundIndex < 0 || boundIndex > intersectionTypes.size()) {
                        ErrorReporter.errorAbort("Invalid bound index on element annotation ( " + anno + " ) for type ( " + this.typeParam + " ) with upper bound ( " + this.typeParam.getUpperBound() + " ) and boundIndex( " + boundIndex + " ) ");
                    }
                    intersectionTypes.get(boundIndex).replaceAnnotation(anno);
                }
            } else {
                upperBoundType.addAnnotations(upperBounds);
            }
        }
    }

    private void applyLowerBounds(List<? extends AnnotationMirror> annos) {
        if (!annos.isEmpty()) {
            AnnotatedTypeMirror lowerBound = this.typeParam.getLowerBound();
            for (AnnotationMirror annotationMirror : annos) {
                lowerBound.addAnnotation(annotationMirror);
            }
        }
    }

    private void addAnnotationToMap(AnnotatedTypeMirror type, Attribute.TypeCompound anno, Map<AnnotatedTypeMirror, List<Attribute.TypeCompound>> typeToAnnos) {
        List<Attribute.TypeCompound> annoList = typeToAnnos.get(type);
        if (annoList == null) {
            annoList = new ArrayList<Attribute.TypeCompound>();
            typeToAnnos.put(type, annoList);
        }
        annoList.add(anno);
    }

    private void applyComponentAnnotation(Attribute.TypeCompound anno) {
        AnnotatedTypeMirror upperBoundType = this.typeParam.getUpperBound();
        HashMap<AnnotatedTypeMirror, List<Attribute.TypeCompound>> typeToAnnotations = new HashMap<AnnotatedTypeMirror, List<Attribute.TypeCompound>>();
        if (anno.position.type == this.upperBoundTarget()) {
            if (upperBoundType.getKind() == TypeKind.INTERSECTION) {
                List<? extends AnnotatedTypeMirror> intersectionTypes = upperBoundType.directSuperTypes();
                int boundIndex = anno.position.bound_index + ElementAnnotationUtil.getBoundIndexOffset(intersectionTypes);
                if (boundIndex < 0 || boundIndex > intersectionTypes.size()) {
                    ErrorReporter.errorAbort("Invalid bound index on element annotation ( " + anno + " ) for type ( " + this.typeParam + " ) with upper bound ( " + this.typeParam.getUpperBound() + " )");
                }
                this.addAnnotationToMap(intersectionTypes.get(boundIndex), anno, typeToAnnotations);
            } else {
                this.addAnnotationToMap(upperBoundType, anno, typeToAnnotations);
            }
        } else {
            this.addAnnotationToMap(this.typeParam.getLowerBound(), anno, typeToAnnotations);
        }
        for (Map.Entry typeToAnno : typeToAnnotations.entrySet()) {
            ElementAnnotationUtil.annotateViaTypeAnnoPosition((AnnotatedTypeMirror)typeToAnno.getKey(), (Collection)typeToAnno.getValue());
        }
    }
}

