/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.stubparser.ast.visitor;

import java.util.Iterator;
import java.util.List;
import org.checkerframework.stubparser.ast.BlockComment;
import org.checkerframework.stubparser.ast.CompilationUnit;
import org.checkerframework.stubparser.ast.ImportDeclaration;
import org.checkerframework.stubparser.ast.IndexUnit;
import org.checkerframework.stubparser.ast.LineComment;
import org.checkerframework.stubparser.ast.Node;
import org.checkerframework.stubparser.ast.PackageDeclaration;
import org.checkerframework.stubparser.ast.TypeParameter;
import org.checkerframework.stubparser.ast.body.AnnotationDeclaration;
import org.checkerframework.stubparser.ast.body.AnnotationMemberDeclaration;
import org.checkerframework.stubparser.ast.body.BodyDeclaration;
import org.checkerframework.stubparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.stubparser.ast.body.ConstructorDeclaration;
import org.checkerframework.stubparser.ast.body.EmptyMemberDeclaration;
import org.checkerframework.stubparser.ast.body.EmptyTypeDeclaration;
import org.checkerframework.stubparser.ast.body.EnumConstantDeclaration;
import org.checkerframework.stubparser.ast.body.EnumDeclaration;
import org.checkerframework.stubparser.ast.body.FieldDeclaration;
import org.checkerframework.stubparser.ast.body.InitializerDeclaration;
import org.checkerframework.stubparser.ast.body.JavadocComment;
import org.checkerframework.stubparser.ast.body.MethodDeclaration;
import org.checkerframework.stubparser.ast.body.ModifierSet;
import org.checkerframework.stubparser.ast.body.Parameter;
import org.checkerframework.stubparser.ast.body.TypeDeclaration;
import org.checkerframework.stubparser.ast.body.VariableDeclarator;
import org.checkerframework.stubparser.ast.body.VariableDeclaratorId;
import org.checkerframework.stubparser.ast.expr.AnnotationExpr;
import org.checkerframework.stubparser.ast.expr.ArrayAccessExpr;
import org.checkerframework.stubparser.ast.expr.ArrayCreationExpr;
import org.checkerframework.stubparser.ast.expr.ArrayInitializerExpr;
import org.checkerframework.stubparser.ast.expr.AssignExpr;
import org.checkerframework.stubparser.ast.expr.BinaryExpr;
import org.checkerframework.stubparser.ast.expr.BooleanLiteralExpr;
import org.checkerframework.stubparser.ast.expr.CastExpr;
import org.checkerframework.stubparser.ast.expr.CharLiteralExpr;
import org.checkerframework.stubparser.ast.expr.ClassExpr;
import org.checkerframework.stubparser.ast.expr.ConditionalExpr;
import org.checkerframework.stubparser.ast.expr.DoubleLiteralExpr;
import org.checkerframework.stubparser.ast.expr.EnclosedExpr;
import org.checkerframework.stubparser.ast.expr.Expression;
import org.checkerframework.stubparser.ast.expr.FieldAccessExpr;
import org.checkerframework.stubparser.ast.expr.InstanceOfExpr;
import org.checkerframework.stubparser.ast.expr.IntegerLiteralExpr;
import org.checkerframework.stubparser.ast.expr.IntegerLiteralMinValueExpr;
import org.checkerframework.stubparser.ast.expr.LongLiteralExpr;
import org.checkerframework.stubparser.ast.expr.LongLiteralMinValueExpr;
import org.checkerframework.stubparser.ast.expr.MarkerAnnotationExpr;
import org.checkerframework.stubparser.ast.expr.MemberValuePair;
import org.checkerframework.stubparser.ast.expr.MethodCallExpr;
import org.checkerframework.stubparser.ast.expr.NameExpr;
import org.checkerframework.stubparser.ast.expr.NormalAnnotationExpr;
import org.checkerframework.stubparser.ast.expr.NullLiteralExpr;
import org.checkerframework.stubparser.ast.expr.ObjectCreationExpr;
import org.checkerframework.stubparser.ast.expr.QualifiedNameExpr;
import org.checkerframework.stubparser.ast.expr.SingleMemberAnnotationExpr;
import org.checkerframework.stubparser.ast.expr.StringLiteralExpr;
import org.checkerframework.stubparser.ast.expr.SuperExpr;
import org.checkerframework.stubparser.ast.expr.ThisExpr;
import org.checkerframework.stubparser.ast.expr.UnaryExpr;
import org.checkerframework.stubparser.ast.expr.VariableDeclarationExpr;
import org.checkerframework.stubparser.ast.stmt.AssertStmt;
import org.checkerframework.stubparser.ast.stmt.BlockStmt;
import org.checkerframework.stubparser.ast.stmt.BreakStmt;
import org.checkerframework.stubparser.ast.stmt.CatchClause;
import org.checkerframework.stubparser.ast.stmt.ContinueStmt;
import org.checkerframework.stubparser.ast.stmt.DoStmt;
import org.checkerframework.stubparser.ast.stmt.EmptyStmt;
import org.checkerframework.stubparser.ast.stmt.ExplicitConstructorInvocationStmt;
import org.checkerframework.stubparser.ast.stmt.ExpressionStmt;
import org.checkerframework.stubparser.ast.stmt.ForStmt;
import org.checkerframework.stubparser.ast.stmt.ForeachStmt;
import org.checkerframework.stubparser.ast.stmt.IfStmt;
import org.checkerframework.stubparser.ast.stmt.LabeledStmt;
import org.checkerframework.stubparser.ast.stmt.ReturnStmt;
import org.checkerframework.stubparser.ast.stmt.Statement;
import org.checkerframework.stubparser.ast.stmt.SwitchEntryStmt;
import org.checkerframework.stubparser.ast.stmt.SwitchStmt;
import org.checkerframework.stubparser.ast.stmt.SynchronizedStmt;
import org.checkerframework.stubparser.ast.stmt.ThrowStmt;
import org.checkerframework.stubparser.ast.stmt.TryStmt;
import org.checkerframework.stubparser.ast.stmt.TypeDeclarationStmt;
import org.checkerframework.stubparser.ast.stmt.WhileStmt;
import org.checkerframework.stubparser.ast.type.ClassOrInterfaceType;
import org.checkerframework.stubparser.ast.type.PrimitiveType;
import org.checkerframework.stubparser.ast.type.ReferenceType;
import org.checkerframework.stubparser.ast.type.Type;
import org.checkerframework.stubparser.ast.type.VoidType;
import org.checkerframework.stubparser.ast.type.WildcardType;
import org.checkerframework.stubparser.ast.visitor.VoidVisitor;

public final class DumpVisitor
implements VoidVisitor<Object> {
    private final SourcePrinter printer = new SourcePrinter();

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(int n) {
        if (ModifierSet.isPrivate(n)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isProtected(n)) {
            this.printer.print("protected ");
        }
        if (ModifierSet.isPublic(n)) {
            this.printer.print("public ");
        }
        if (ModifierSet.isAbstract(n)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(n)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(n)) {
            this.printer.print("final ");
        }
        if (ModifierSet.isNative(n)) {
            this.printer.print("native ");
        }
        if (ModifierSet.isStrictfp(n)) {
            this.printer.print("strictfp ");
        }
        if (ModifierSet.isSynchronized(n)) {
            this.printer.print("synchronized ");
        }
        if (ModifierSet.isTransient(n)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(n)) {
            this.printer.print("volatile ");
        }
    }

    private void printMembers(List<BodyDeclaration> list, Object object) {
        for (BodyDeclaration bodyDeclaration : list) {
            this.printer.printLn();
            bodyDeclaration.accept(this, object);
            this.printer.printLn();
        }
    }

    private void printMemberAnnotations(List<AnnotationExpr> list, Object object) {
        if (list != null) {
            for (AnnotationExpr annotationExpr : list) {
                annotationExpr.accept(this, object);
                this.printer.printLn();
            }
        }
    }

    private void printAnnotations(List<AnnotationExpr> list, Object object) {
        this.printAnnotations(list, object, false);
    }

    private void printAnnotations(List<AnnotationExpr> list, Object object, boolean bl) {
        Iterator<AnnotationExpr> iterator;
        if (list != null && (iterator = list.iterator()).hasNext()) {
            AnnotationExpr annotationExpr = iterator.next();
            if (bl) {
                this.printer.print(" ");
            }
            annotationExpr.accept(this, object);
            while (iterator.hasNext()) {
                this.printer.print(" ");
                annotationExpr = iterator.next();
                annotationExpr.accept(this, object);
            }
            if (!bl) {
                this.printer.print(" ");
            }
        }
    }

    private void printTypeArgs(List<Type> list, Object object) {
        if (list != null) {
            this.printer.print("<");
            Iterator<Type> iterator = list.iterator();
            while (iterator.hasNext()) {
                Type type = iterator.next();
                type.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(List<TypeParameter> list, Object object) {
        if (list != null) {
            this.printer.print("<");
            Iterator<TypeParameter> iterator = list.iterator();
            while (iterator.hasNext()) {
                TypeParameter typeParameter = iterator.next();
                typeParameter.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printArguments(List<Expression> list, Object object) {
        this.printer.print("(");
        if (list != null) {
            Iterator<Expression> iterator = list.iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                expression.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    private void printJavadoc(JavadocComment javadocComment, Object object) {
        if (javadocComment != null) {
            javadocComment.accept(this, object);
        }
    }

    @Override
    public void visit(IndexUnit indexUnit, Object object) {
        for (CompilationUnit compilationUnit : indexUnit.getCompilationUnits()) {
            this.visit(compilationUnit, object);
            this.printer.printLn();
            this.printer.printLn();
        }
    }

    @Override
    public void visit(CompilationUnit compilationUnit, Object object) {
        if (compilationUnit.getPackage() != null) {
            compilationUnit.getPackage().accept(this, object);
        }
        if (compilationUnit.getImports() != null) {
            for (ImportDeclaration importDeclaration : compilationUnit.getImports()) {
                importDeclaration.accept(this, object);
            }
            this.printer.printLn();
        }
        if (compilationUnit.getTypes() != null) {
            Iterator<Node> iterator = compilationUnit.getTypes().iterator();
            while (iterator.hasNext()) {
                ((TypeDeclaration)iterator.next()).accept(this, object);
                this.printer.printLn();
                if (!iterator.hasNext()) continue;
                this.printer.printLn();
            }
        }
    }

    @Override
    public void visit(PackageDeclaration packageDeclaration, Object object) {
        this.printMemberAnnotations(packageDeclaration.getAnnotations(), object);
        this.printer.print("package ");
        packageDeclaration.getName().accept(this, object);
        this.printer.printLn(";");
        this.printer.printLn();
    }

    @Override
    public void visit(NameExpr nameExpr, Object object) {
        this.printer.print(nameExpr.getName());
    }

    @Override
    public void visit(QualifiedNameExpr qualifiedNameExpr, Object object) {
        qualifiedNameExpr.getQualifier().accept(this, object);
        this.printer.print(".");
        this.printer.print(qualifiedNameExpr.getName());
    }

    @Override
    public void visit(ImportDeclaration importDeclaration, Object object) {
        this.printer.print("import ");
        if (importDeclaration.isStatic()) {
            this.printer.print("static ");
        }
        importDeclaration.getName().accept(this, object);
        if (importDeclaration.isAsterisk()) {
            this.printer.print(".*");
        }
        this.printer.printLn(";");
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, Object object) {
        ClassOrInterfaceType classOrInterfaceType;
        Iterator<ClassOrInterfaceType> iterator;
        this.printJavadoc(classOrInterfaceDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(classOrInterfaceDeclaration.getAnnotations(), object);
        this.printModifiers(classOrInterfaceDeclaration.getModifiers());
        if (classOrInterfaceDeclaration.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        this.printer.print(classOrInterfaceDeclaration.getName());
        this.printTypeParameters(classOrInterfaceDeclaration.getTypeParameters(), object);
        if (classOrInterfaceDeclaration.getExtends() != null) {
            this.printer.print(" extends ");
            iterator = classOrInterfaceDeclaration.getExtends().iterator();
            while (iterator.hasNext()) {
                classOrInterfaceType = iterator.next();
                classOrInterfaceType.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (classOrInterfaceDeclaration.getImplements() != null) {
            this.printer.print(" implements ");
            iterator = classOrInterfaceDeclaration.getImplements().iterator();
            while (iterator.hasNext()) {
                classOrInterfaceType = iterator.next();
                classOrInterfaceType.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (classOrInterfaceDeclaration.getMembers() != null) {
            this.printMembers(classOrInterfaceDeclaration.getMembers(), object);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EmptyTypeDeclaration emptyTypeDeclaration, Object object) {
        this.printJavadoc(emptyTypeDeclaration.getJavaDoc(), object);
        this.printer.print(";");
    }

    @Override
    public void visit(JavadocComment javadocComment, Object object) {
        this.printer.print("/**");
        this.printer.print(javadocComment.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType classOrInterfaceType, Object object) {
        this.printAnnotations(classOrInterfaceType.getAnnotations(), object);
        if (classOrInterfaceType.getScope() != null) {
            classOrInterfaceType.getScope().accept(this, object);
            this.printer.print(".");
        }
        this.printer.print(classOrInterfaceType.getName());
        this.printTypeArgs(classOrInterfaceType.getTypeArgs(), object);
    }

    @Override
    public void visit(TypeParameter typeParameter, Object object) {
        this.printAnnotations(typeParameter.getAnnotations(), object);
        this.printer.print(typeParameter.getName());
        if (typeParameter.getTypeBound() != null) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> iterator = typeParameter.getTypeBound().iterator();
            while (iterator.hasNext()) {
                ClassOrInterfaceType classOrInterfaceType = iterator.next();
                classOrInterfaceType.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
    }

    @Override
    public void visit(PrimitiveType primitiveType, Object object) {
        this.printAnnotations(primitiveType.getAnnotations(), object);
        switch (primitiveType.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
    }

    @Override
    public void visit(ReferenceType referenceType, Object object) {
        this.printAnnotations(referenceType.getAnnotations(), object);
        referenceType.getType().accept(this, object);
        for (int i = 0; i < referenceType.getArrayCount(); ++i) {
            if (!referenceType.getAnnotationsAtLevel(i).isEmpty()) {
                this.printer.print(" ");
                this.printAnnotations(referenceType.getAnnotationsAtLevel(i), object);
            }
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(WildcardType wildcardType, Object object) {
        this.printAnnotations(wildcardType.getAnnotations(), object);
        this.printer.print("?");
        if (wildcardType.getExtends() != null) {
            this.printer.print(" extends ");
            wildcardType.getExtends().accept(this, object);
        }
        if (wildcardType.getSuper() != null) {
            this.printer.print(" super ");
            wildcardType.getSuper().accept(this, object);
        }
    }

    @Override
    public void visit(FieldDeclaration fieldDeclaration, Object object) {
        this.printJavadoc(fieldDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(fieldDeclaration.getAnnotations(), object);
        this.printModifiers(fieldDeclaration.getModifiers());
        fieldDeclaration.getType().accept(this, object);
        this.printer.print(" ");
        Iterator<VariableDeclarator> iterator = fieldDeclaration.getVariables().iterator();
        while (iterator.hasNext()) {
            VariableDeclarator variableDeclarator = iterator.next();
            variableDeclarator.accept(this, object);
            if (!iterator.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarator variableDeclarator, Object object) {
        variableDeclarator.getId().accept(this, object);
        if (variableDeclarator.getInit() != null) {
            this.printer.print(" = ");
            variableDeclarator.getInit().accept(this, object);
        }
    }

    @Override
    public void visit(VariableDeclaratorId variableDeclaratorId, Object object) {
        this.printer.print(variableDeclaratorId.getName());
        for (int i = 0; i < variableDeclaratorId.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(ArrayInitializerExpr arrayInitializerExpr, Object object) {
        this.printer.print("{");
        if (arrayInitializerExpr.getValues() != null) {
            this.printer.print(" ");
            Iterator<Expression> iterator = arrayInitializerExpr.getValues().iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                expression.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        }
        this.printer.print("}");
    }

    @Override
    public void visit(VoidType voidType, Object object) {
        this.printer.print("void");
    }

    @Override
    public void visit(ArrayAccessExpr arrayAccessExpr, Object object) {
        arrayAccessExpr.getName().accept(this, object);
        this.printer.print("[");
        arrayAccessExpr.getIndex().accept(this, object);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr arrayCreationExpr, Object object) {
        this.printer.print("new ");
        arrayCreationExpr.getType().accept(this, object);
        if (arrayCreationExpr.getDimensions() != null) {
            for (Expression expression : arrayCreationExpr.getDimensions()) {
                this.printer.print("[");
                expression.accept(this, object);
                this.printer.print("]");
            }
            for (int i = 0; i < arrayCreationExpr.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
        } else {
            for (int i = 0; i < arrayCreationExpr.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
            this.printer.print(" ");
            arrayCreationExpr.getInitializer().accept(this, object);
        }
    }

    @Override
    public void visit(AssignExpr assignExpr, Object object) {
        assignExpr.getTarget().accept(this, object);
        this.printer.print(" ");
        switch (assignExpr.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("&=");
                break;
            }
            case or: {
                this.printer.print("|=");
                break;
            }
            case xor: {
                this.printer.print("^=");
                break;
            }
            case plus: {
                this.printer.print("+=");
                break;
            }
            case minus: {
                this.printer.print("-=");
                break;
            }
            case rem: {
                this.printer.print("%=");
                break;
            }
            case slash: {
                this.printer.print("/=");
                break;
            }
            case star: {
                this.printer.print("*=");
                break;
            }
            case lShift: {
                this.printer.print("<<=");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>=");
            }
        }
        this.printer.print(" ");
        assignExpr.getValue().accept(this, object);
    }

    @Override
    public void visit(BinaryExpr binaryExpr, Object object) {
        binaryExpr.getLeft().accept(this, object);
        this.printer.print(" ");
        switch (binaryExpr.getOperator()) {
            case or: {
                this.printer.print("||");
                break;
            }
            case and: {
                this.printer.print("&&");
                break;
            }
            case binOr: {
                this.printer.print("|");
                break;
            }
            case binAnd: {
                this.printer.print("&");
                break;
            }
            case xor: {
                this.printer.print("^");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("!=");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print("<<");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>");
                break;
            }
            case plus: {
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("%");
            }
        }
        this.printer.print(" ");
        binaryExpr.getRight().accept(this, object);
    }

    @Override
    public void visit(CastExpr castExpr, Object object) {
        this.printer.print("(");
        castExpr.getType().accept(this, object);
        this.printer.print(") ");
        castExpr.getExpr().accept(this, object);
    }

    @Override
    public void visit(ClassExpr classExpr, Object object) {
        classExpr.getType().accept(this, object);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr conditionalExpr, Object object) {
        conditionalExpr.getCondition().accept(this, object);
        this.printer.print(" ? ");
        conditionalExpr.getThenExpr().accept(this, object);
        this.printer.print(" : ");
        conditionalExpr.getElseExpr().accept(this, object);
    }

    @Override
    public void visit(EnclosedExpr enclosedExpr, Object object) {
        this.printer.print("(");
        enclosedExpr.getInner().accept(this, object);
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr fieldAccessExpr, Object object) {
        fieldAccessExpr.getScope().accept(this, object);
        this.printer.print(".");
        this.printer.print(fieldAccessExpr.getField());
    }

    @Override
    public void visit(InstanceOfExpr instanceOfExpr, Object object) {
        instanceOfExpr.getExpr().accept(this, object);
        this.printer.print(" instanceof ");
        instanceOfExpr.getType().accept(this, object);
    }

    @Override
    public void visit(CharLiteralExpr charLiteralExpr, Object object) {
        this.printer.print("'");
        this.printer.print(charLiteralExpr.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr doubleLiteralExpr, Object object) {
        this.printer.print(doubleLiteralExpr.getValue());
    }

    @Override
    public void visit(IntegerLiteralExpr integerLiteralExpr, Object object) {
        this.printer.print(integerLiteralExpr.getValue());
    }

    @Override
    public void visit(LongLiteralExpr longLiteralExpr, Object object) {
        this.printer.print(longLiteralExpr.getValue());
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr integerLiteralMinValueExpr, Object object) {
        this.printer.print(integerLiteralMinValueExpr.getValue());
    }

    @Override
    public void visit(LongLiteralMinValueExpr longLiteralMinValueExpr, Object object) {
        this.printer.print(longLiteralMinValueExpr.getValue());
    }

    @Override
    public void visit(StringLiteralExpr stringLiteralExpr, Object object) {
        this.printer.print("\"");
        this.printer.print(stringLiteralExpr.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr booleanLiteralExpr, Object object) {
        this.printer.print(String.valueOf(booleanLiteralExpr.getValue()));
    }

    @Override
    public void visit(NullLiteralExpr nullLiteralExpr, Object object) {
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr thisExpr, Object object) {
        if (thisExpr.getClassExpr() != null) {
            thisExpr.getClassExpr().accept(this, object);
            this.printer.print(".");
        }
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr superExpr, Object object) {
        if (superExpr.getClassExpr() != null) {
            superExpr.getClassExpr().accept(this, object);
            this.printer.print(".");
        }
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr methodCallExpr, Object object) {
        if (methodCallExpr.getScope() != null) {
            methodCallExpr.getScope().accept(this, object);
            this.printer.print(".");
        }
        this.printTypeArgs(methodCallExpr.getTypeArgs(), object);
        this.printer.print(methodCallExpr.getName());
        this.printArguments(methodCallExpr.getArgs(), object);
    }

    @Override
    public void visit(ObjectCreationExpr objectCreationExpr, Object object) {
        if (objectCreationExpr.getScope() != null) {
            objectCreationExpr.getScope().accept(this, object);
            this.printer.print(".");
        }
        this.printer.print("new ");
        this.printTypeArgs(objectCreationExpr.getTypeArgs(), object);
        objectCreationExpr.getType().accept(this, object);
        this.printArguments(objectCreationExpr.getArgs(), object);
        if (objectCreationExpr.getAnonymousClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(objectCreationExpr.getAnonymousClassBody(), object);
            this.printer.unindent();
            this.printer.print("}");
        }
    }

    @Override
    public void visit(UnaryExpr unaryExpr, Object object) {
        switch (unaryExpr.getOperator()) {
            case positive: {
                this.printer.print("+");
                break;
            }
            case negative: {
                this.printer.print("-");
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("!");
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
                break;
            }
        }
        unaryExpr.getExpr().accept(this, object);
        switch (unaryExpr.getOperator()) {
            case posIncrement: {
                this.printer.print("++");
                break;
            }
            case posDecrement: {
                this.printer.print("--");
                break;
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration constructorDeclaration, Object object) {
        Node node;
        Iterator<Node> iterator;
        this.printJavadoc(constructorDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(constructorDeclaration.getAnnotations(), object);
        this.printModifiers(constructorDeclaration.getModifiers());
        if (constructorDeclaration.getTypeParameters() != null) {
            this.printTypeParameters(constructorDeclaration.getTypeParameters(), object);
            this.printer.print(" ");
        }
        this.printer.print(constructorDeclaration.getName());
        this.printer.print("(");
        if (constructorDeclaration.getParameters() != null) {
            iterator = constructorDeclaration.getParameters().iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                ((Parameter)node).accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        this.printAnnotations(constructorDeclaration.getReceiverAnnotations(), object, true);
        if (constructorDeclaration.getThrows() != null) {
            this.printer.print(" throws ");
            iterator = constructorDeclaration.getThrows().iterator();
            while (iterator.hasNext()) {
                node = (NameExpr)iterator.next();
                ((NameExpr)node).accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (constructorDeclaration.getBlock() == null) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            constructorDeclaration.getBlock().accept(this, object);
        }
    }

    @Override
    public void visit(MethodDeclaration methodDeclaration, Object object) {
        Node node;
        this.printJavadoc(methodDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(methodDeclaration.getAnnotations(), object);
        this.printModifiers(methodDeclaration.getModifiers());
        this.printTypeParameters(methodDeclaration.getTypeParameters(), object);
        if (methodDeclaration.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        methodDeclaration.getType().accept(this, object);
        this.printer.print(" ");
        this.printer.print(methodDeclaration.getName());
        this.printer.print("(");
        if (methodDeclaration.getParameters() != null) {
            Iterator<Parameter> iterator = methodDeclaration.getParameters().iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                ((Parameter)node).accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        for (int i = 0; i < methodDeclaration.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
        this.printAnnotations(methodDeclaration.getReceiverAnnotations(), object, true);
        if (methodDeclaration.getThrows() != null) {
            this.printer.print(" throws ");
            Iterator<NameExpr> iterator = methodDeclaration.getThrows().iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                ((NameExpr)node).accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (methodDeclaration.getBody() == null) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            methodDeclaration.getBody().accept(this, object);
        }
    }

    @Override
    public void visit(Parameter parameter, Object object) {
        this.printAnnotations(parameter.getAnnotations(), object);
        this.printModifiers(parameter.getModifiers());
        parameter.getType().accept(this, object);
        if (parameter.isVarArgs()) {
            this.printer.print("...");
        }
        this.printer.print(" ");
        parameter.getId().accept(this, object);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, Object object) {
        if (explicitConstructorInvocationStmt.isThis()) {
            this.printTypeArgs(explicitConstructorInvocationStmt.getTypeArgs(), object);
            this.printer.print("this");
        } else {
            if (explicitConstructorInvocationStmt.getExpr() != null) {
                explicitConstructorInvocationStmt.getExpr().accept(this, object);
                this.printer.print(".");
            }
            this.printTypeArgs(explicitConstructorInvocationStmt.getTypeArgs(), object);
            this.printer.print("super");
        }
        this.printArguments(explicitConstructorInvocationStmt.getArgs(), object);
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarationExpr variableDeclarationExpr, Object object) {
        this.printMemberAnnotations(variableDeclarationExpr.getAnnotations(), object);
        this.printModifiers(variableDeclarationExpr.getModifiers());
        variableDeclarationExpr.getType().accept(this, object);
        this.printer.print(" ");
        Iterator<VariableDeclarator> iterator = variableDeclarationExpr.getVars().iterator();
        while (iterator.hasNext()) {
            VariableDeclarator variableDeclarator = iterator.next();
            variableDeclarator.accept(this, object);
            if (!iterator.hasNext()) continue;
            this.printer.print(", ");
        }
    }

    @Override
    public void visit(TypeDeclarationStmt typeDeclarationStmt, Object object) {
        typeDeclarationStmt.getTypeDeclaration().accept(this, object);
    }

    @Override
    public void visit(AssertStmt assertStmt, Object object) {
        this.printer.print("assert ");
        assertStmt.getCheck().accept(this, object);
        if (assertStmt.getMessage() != null) {
            this.printer.print(" : ");
            assertStmt.getMessage().accept(this, object);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(BlockStmt blockStmt, Object object) {
        this.printer.printLn("{");
        if (blockStmt.getStmts() != null) {
            this.printer.indent();
            for (Statement statement : blockStmt.getStmts()) {
                statement.accept(this, object);
                this.printer.printLn();
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(LabeledStmt labeledStmt, Object object) {
        this.printer.print(labeledStmt.getLabel());
        this.printer.print(": ");
        labeledStmt.getStmt().accept(this, object);
    }

    @Override
    public void visit(EmptyStmt emptyStmt, Object object) {
        this.printer.print(";");
    }

    @Override
    public void visit(ExpressionStmt expressionStmt, Object object) {
        expressionStmt.getExpression().accept(this, object);
        this.printer.print(";");
    }

    @Override
    public void visit(SwitchStmt switchStmt, Object object) {
        this.printer.print("switch(");
        switchStmt.getSelector().accept(this, object);
        this.printer.printLn(") {");
        if (switchStmt.getEntries() != null) {
            this.printer.indent();
            for (SwitchEntryStmt switchEntryStmt : switchStmt.getEntries()) {
                switchEntryStmt.accept(this, object);
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(SwitchEntryStmt switchEntryStmt, Object object) {
        if (switchEntryStmt.getLabel() != null) {
            this.printer.print("case ");
            switchEntryStmt.getLabel().accept(this, object);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.printLn();
        this.printer.indent();
        if (switchEntryStmt.getStmts() != null) {
            for (Statement statement : switchEntryStmt.getStmts()) {
                statement.accept(this, object);
                this.printer.printLn();
            }
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt breakStmt, Object object) {
        this.printer.print("break");
        if (breakStmt.getId() != null) {
            this.printer.print(" ");
            this.printer.print(breakStmt.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(ReturnStmt returnStmt, Object object) {
        this.printer.print("return");
        if (returnStmt.getExpr() != null) {
            this.printer.print(" ");
            returnStmt.getExpr().accept(this, object);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(EnumDeclaration enumDeclaration, Object object) {
        Node node;
        Iterator<Node> iterator;
        this.printJavadoc(enumDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(enumDeclaration.getAnnotations(), object);
        this.printModifiers(enumDeclaration.getModifiers());
        this.printer.print("enum ");
        this.printer.print(enumDeclaration.getName());
        if (enumDeclaration.getImplements() != null) {
            this.printer.print(" implements ");
            iterator = enumDeclaration.getImplements().iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                ((ClassOrInterfaceType)node).accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (enumDeclaration.getEntries() != null) {
            this.printer.printLn();
            iterator = enumDeclaration.getEntries().iterator();
            while (iterator.hasNext()) {
                node = (EnumConstantDeclaration)iterator.next();
                ((EnumConstantDeclaration)node).accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (enumDeclaration.getMembers() != null) {
            this.printer.printLn(";");
            this.printMembers(enumDeclaration.getMembers(), object);
        } else if (enumDeclaration.getEntries() != null) {
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EnumConstantDeclaration enumConstantDeclaration, Object object) {
        this.printJavadoc(enumConstantDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(enumConstantDeclaration.getAnnotations(), object);
        this.printer.print(enumConstantDeclaration.getName());
        if (enumConstantDeclaration.getArgs() != null) {
            this.printArguments(enumConstantDeclaration.getArgs(), object);
        }
        if (enumConstantDeclaration.getClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(enumConstantDeclaration.getClassBody(), object);
            this.printer.unindent();
            this.printer.printLn("}");
        }
    }

    @Override
    public void visit(EmptyMemberDeclaration emptyMemberDeclaration, Object object) {
        this.printJavadoc(emptyMemberDeclaration.getJavaDoc(), object);
        this.printer.print(";");
    }

    @Override
    public void visit(InitializerDeclaration initializerDeclaration, Object object) {
        this.printJavadoc(initializerDeclaration.getJavaDoc(), object);
        if (initializerDeclaration.isStatic()) {
            this.printer.print("static ");
        }
        initializerDeclaration.getBlock().accept(this, object);
    }

    @Override
    public void visit(IfStmt ifStmt, Object object) {
        this.printer.print("if (");
        ifStmt.getCondition().accept(this, object);
        this.printer.print(") ");
        ifStmt.getThenStmt().accept(this, object);
        if (ifStmt.getElseStmt() != null) {
            this.printer.print(" else ");
            ifStmt.getElseStmt().accept(this, object);
        }
    }

    @Override
    public void visit(WhileStmt whileStmt, Object object) {
        this.printer.print("while (");
        whileStmt.getCondition().accept(this, object);
        this.printer.print(") ");
        whileStmt.getBody().accept(this, object);
    }

    @Override
    public void visit(ContinueStmt continueStmt, Object object) {
        this.printer.print("continue");
        if (continueStmt.getId() != null) {
            this.printer.print(" ");
            this.printer.print(continueStmt.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(DoStmt doStmt, Object object) {
        this.printer.print("do ");
        doStmt.getBody().accept(this, object);
        this.printer.print(" while (");
        doStmt.getCondition().accept(this, object);
        this.printer.print(");");
    }

    @Override
    public void visit(ForeachStmt foreachStmt, Object object) {
        this.printer.print("for (");
        foreachStmt.getVariable().accept(this, object);
        this.printer.print(" : ");
        foreachStmt.getIterable().accept(this, object);
        this.printer.print(") ");
        foreachStmt.getBody().accept(this, object);
    }

    @Override
    public void visit(ForStmt forStmt, Object object) {
        Expression expression;
        Iterator<Expression> iterator;
        this.printer.print("for (");
        if (forStmt.getInit() != null) {
            iterator = forStmt.getInit().iterator();
            while (iterator.hasNext()) {
                expression = iterator.next();
                expression.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print("; ");
        if (forStmt.getCompare() != null) {
            forStmt.getCompare().accept(this, object);
        }
        this.printer.print("; ");
        if (forStmt.getUpdate() != null) {
            iterator = forStmt.getUpdate().iterator();
            while (iterator.hasNext()) {
                expression = iterator.next();
                expression.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(") ");
        forStmt.getBody().accept(this, object);
    }

    @Override
    public void visit(ThrowStmt throwStmt, Object object) {
        this.printer.print("throw ");
        throwStmt.getExpr().accept(this, object);
        this.printer.print(";");
    }

    @Override
    public void visit(SynchronizedStmt synchronizedStmt, Object object) {
        this.printer.print("synchronized (");
        synchronizedStmt.getExpr().accept(this, object);
        this.printer.print(") ");
        synchronizedStmt.getBlock().accept(this, object);
    }

    @Override
    public void visit(TryStmt tryStmt, Object object) {
        this.printer.print("try ");
        tryStmt.getTryBlock().accept(this, object);
        if (tryStmt.getCatchs() != null) {
            for (CatchClause catchClause : tryStmt.getCatchs()) {
                catchClause.accept(this, object);
            }
        }
        if (tryStmt.getFinallyBlock() != null) {
            this.printer.print(" finally ");
            tryStmt.getFinallyBlock().accept(this, object);
        }
    }

    @Override
    public void visit(CatchClause catchClause, Object object) {
        this.printer.print(" catch (");
        catchClause.getExcept().accept(this, object);
        this.printer.print(") ");
        catchClause.getCatchBlock().accept(this, object);
    }

    @Override
    public void visit(AnnotationDeclaration annotationDeclaration, Object object) {
        this.printJavadoc(annotationDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(annotationDeclaration.getAnnotations(), object);
        this.printModifiers(annotationDeclaration.getModifiers());
        this.printer.print("@interface ");
        this.printer.print(annotationDeclaration.getName());
        this.printer.printLn(" {");
        this.printer.indent();
        if (annotationDeclaration.getMembers() != null) {
            this.printMembers(annotationDeclaration.getMembers(), object);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(AnnotationMemberDeclaration annotationMemberDeclaration, Object object) {
        this.printJavadoc(annotationMemberDeclaration.getJavaDoc(), object);
        this.printMemberAnnotations(annotationMemberDeclaration.getAnnotations(), object);
        this.printModifiers(annotationMemberDeclaration.getModifiers());
        annotationMemberDeclaration.getType().accept(this, object);
        this.printer.print(" ");
        this.printer.print(annotationMemberDeclaration.getName());
        this.printer.print("()");
        if (annotationMemberDeclaration.getDefaultValue() != null) {
            this.printer.print(" default ");
            annotationMemberDeclaration.getDefaultValue().accept(this, object);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(MarkerAnnotationExpr markerAnnotationExpr, Object object) {
        this.printer.print("@");
        markerAnnotationExpr.getName().accept(this, object);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr singleMemberAnnotationExpr, Object object) {
        this.printer.print("@");
        singleMemberAnnotationExpr.getName().accept(this, object);
        this.printer.print("(");
        singleMemberAnnotationExpr.getMemberValue().accept(this, object);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr normalAnnotationExpr, Object object) {
        this.printer.print("@");
        normalAnnotationExpr.getName().accept(this, object);
        this.printer.print("(");
        if (normalAnnotationExpr.getPairs() != null) {
            Iterator<MemberValuePair> iterator = normalAnnotationExpr.getPairs().iterator();
            while (iterator.hasNext()) {
                MemberValuePair memberValuePair = iterator.next();
                memberValuePair.accept(this, object);
                if (!iterator.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair memberValuePair, Object object) {
        this.printer.print(memberValuePair.getName());
        this.printer.print(" = ");
        memberValuePair.getValue().accept(this, object);
    }

    @Override
    public void visit(LineComment lineComment, Object object) {
        this.printer.print("//");
        this.printer.printLn(lineComment.getContent());
    }

    @Override
    public void visit(BlockComment blockComment, Object object) {
        this.printer.print("/*");
        this.printer.print(blockComment.getContent());
        this.printer.printLn("*/");
    }

    private static class SourcePrinter {
        private int level = 0;
        private boolean indented = false;
        private final StringBuilder buf = new StringBuilder();

        private SourcePrinter() {
        }

        public void indent() {
            ++this.level;
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append("    ");
            }
        }

        public void print(String string) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.buf.append(string);
        }

        public void printLn(String string) {
            this.print(string);
            this.printLn();
        }

        public void printLn() {
            this.buf.append("\n");
            this.indented = false;
        }

        public String getSource() {
            return this.buf.toString();
        }

        public String toString() {
            return this.getSource();
        }
    }
}

