/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class CountingPrintWriter
extends PrintWriter {
    private int writtenBytes = 0;
    private int printedBytes = 0;
    private int writtenChars = 0;
    private int printedChars = 0;
    private static final String lineSep = System.getProperty("line.separator");

    public CountingPrintWriter(OutputStream out) {
        super(out);
    }

    public CountingPrintWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public CountingPrintWriter(Writer out) {
        super(out);
    }

    public CountingPrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public int countBytes(String s2) {
        if (s2 == null) {
            return -1;
        }
        int numchars = s2.length();
        int numbytes = 0;
        for (int i = 0; i < numchars; ++i) {
            char c = s2.charAt(i);
            numbytes += this.countBytes(c);
        }
        return numbytes;
    }

    public int countBytes(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c > '\u07ff') {
            return 3;
        }
        return 2;
    }

    public int getNumberOfPrintedBytes() {
        return this.printedBytes;
    }

    public int getNumberOfWrittenBytes() {
        return this.writtenBytes;
    }

    public int getNumberOfPrintedChars() {
        return this.printedChars;
    }

    @Override
    public void print(String s2) {
        if (s2 == null) {
            this.printedBytes += this.countBytes("null");
            this.printedChars += 4;
        } else {
            this.printedBytes += this.countBytes(s2);
            this.printedChars += s2.length();
        }
        super.print(s2);
    }

    @Override
    public void print(boolean b) {
        String s2 = String.valueOf(b);
        this.printedBytes += this.countBytes(s2);
        this.printedChars += s2.length();
        super.print(b);
    }

    @Override
    public void print(char c) {
        this.printedBytes += this.countBytes(c);
        ++this.printedChars;
    }

    @Override
    public void print(char[] s2) {
        for (int i = 0; i < s2.length; ++i) {
            this.printedBytes += this.countBytes(s2[i]);
        }
        this.printedChars += s2.length;
        super.print(s2);
    }

    @Override
    public void print(double d) {
        String s2 = String.valueOf(d);
        this.printedBytes += this.countBytes(s2);
        this.printedChars += s2.length();
        super.print(d);
    }

    @Override
    public void print(float f) {
        String s2 = String.valueOf(f);
        this.printedBytes += this.countBytes(s2);
        this.printedChars += s2.length();
        super.print(f);
    }

    @Override
    public void print(int i) {
        String s2 = String.valueOf(i);
        this.printedBytes += this.countBytes(s2);
        this.printedChars += s2.length();
        super.print(i);
    }

    public void resetAll() {
        this.resetPrintedByteCounter();
        this.resetPrintedCharCounter();
        this.resetWrittenByteCounter();
        this.resetWrittenCharCounter();
    }

    public void resetPrintedByteCounter() {
        this.printedBytes = 0;
    }

    public void resetPrintedCharCounter() {
        this.printedChars = 0;
    }

    public void resetWrittenByteCounter() {
        this.writtenBytes = 0;
    }

    public void resetWrittenCharCounter() {
        this.writtenChars = 0;
    }

    @Override
    public void print(long l) {
        String s2 = String.valueOf(l);
        this.printedBytes += this.countBytes(s2);
        this.printedChars += s2.length();
        super.print(l);
    }

    @Override
    public void print(Object obj) {
        String s2 = String.valueOf(obj);
        this.printedBytes += this.countBytes(s2);
        this.printedChars += s2.length();
        super.print(obj);
    }

    @Override
    public void println() {
        this.printedBytes += this.countBytes(lineSep);
        this.printedChars += lineSep.length();
        super.println();
    }

    @Override
    public void println(String s2) {
        this.print(s2);
        this.println();
    }

    @Override
    public void write(char[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            this.writtenBytes += this.countBytes(buf[i]);
        }
        this.writtenChars += buf.length;
        super.write(buf);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.writtenBytes += this.countBytes(buf[i]);
        }
        this.writtenChars += len;
        super.write(buf, off, len);
    }

    @Override
    public void write(String s2) {
        this.writtenBytes += this.countBytes(s2);
        this.writtenChars += s2.length();
        super.write(s2);
    }

    @Override
    public void write(String s2, int off, int len) {
        this.writtenBytes += this.countBytes(s2.substring(off, off + len));
        this.writtenChars += len;
        super.write(s2, off, len);
    }
}

