/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GraphMDE {
    private GraphMDE() {
        throw new Error("do not instantiate");
    }

    public static <T> Map<T, List<T>> dominators(Map<T, List<T>> predecessors) {
        HashMap dom = new HashMap();
        Map<T, List<T>> preds = predecessors;
        ArrayList<T> nodes = new ArrayList<T>(preds.keySet());
        ArrayList<T> roots = new ArrayList<T>();
        ArrayList<T> non_roots = new ArrayList<T>();
        for (T node : preds.keySet()) {
            if (preds.get(node).isEmpty()) {
                Set<T> set = Collections.singleton(node);
                dom.put(node, new ArrayList<T>(set));
                roots.add(node);
                continue;
            }
            dom.put(node, new ArrayList<T>(nodes));
            non_roots.add(node);
        }
        assert (roots.size() + non_roots.size() == nodes.size());
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Object node : non_roots) {
                ArrayList<Object> new_doms = null;
                assert (preds.containsKey(node));
                for (T pred : preds.get(node)) {
                    assert (dom.containsKey(pred));
                    List dom_of_pred = (List)dom.get(pred);
                    if (new_doms == null) {
                        new_doms = new ArrayList<Object>(dom_of_pred);
                        continue;
                    }
                    new_doms.retainAll(dom_of_pred);
                }
                assert (new_doms != null) : "@AssumeAssertion(nullness): the loop was entered at least once because this is a non-root, which has at least one predecessor";
                new_doms.add(node);
                assert (dom.containsKey(node));
                if (((List)dom.get(node)).equals(new_doms)) continue;
                dom.put(node, new_doms);
                changed = true;
            }
        }
        for (Object node : preds.keySet()) {
            assert (dom.containsKey(node) && ((List)dom.get(node)).contains(node));
        }
        return dom;
    }

    public static <T> void print(Map<T, List<T>> graph, PrintStream ps, int indent) {
        String indentString = "";
        for (int i = 0; i < indent; ++i) {
            indentString = indentString + " ";
        }
        for (T node : graph.keySet()) {
            ps.printf("%s%s%n", indentString, node);
            for (T child : graph.get(node)) {
                ps.printf("  %s%s%n", indentString, child);
            }
        }
    }
}

