/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.Serializable;
import java.util.List;
import plume.ArraysMDE;

public class LimitedSizeSet<T>
implements Serializable,
Cloneable {
    static final long serialVersionUID = 20031021L;
    protected T[] values;
    int num_values;

    public LimitedSizeSet(int max_values) {
        assert (max_values > 0);
        Object[] new_values_array = new Object[max_values];
        this.values = new_values_array;
        this.num_values = 0;
    }

    public void add(T elt) {
        if (this.repNulled()) {
            return;
        }
        if (this.contains(elt)) {
            return;
        }
        if (this.num_values == this.values.length) {
            this.nullRep();
            return;
        }
        this.values[this.num_values] = elt;
        ++this.num_values;
    }

    public void addAll(LimitedSizeSet<? extends T> s2) {
        boolean sameObject;
        boolean bl = sameObject = this == s2;
        if (sameObject) {
            return;
        }
        if (this.repNulled()) {
            return;
        }
        if (s2.repNulled()) {
            if (s2.size() > this.values.length) {
                this.nullRep();
                return;
            }
            throw new Error("Arg is rep-nulled, so we don't know its values and can't add them to this.");
        }
        T[] svalues = s2.values;
        for (int i = 0; i < s2.size(); ++i) {
            assert (svalues[i] != null) : "@AssumeAssertion(nullness): used portion of array";
            this.add(svalues[i]);
            if (!this.repNulled()) continue;
            return;
        }
    }

    public boolean contains(T elt) {
        if (this.repNulled()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.num_values; ++i) {
            T value = this.values[i];
            if (value != elt && (value == null || !value.equals(elt))) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.num_values;
    }

    public int max_size() {
        if (this.repNulled()) {
            return this.num_values;
        }
        return this.values.length + 1;
    }

    public boolean repNulled() {
        return this.values == null;
    }

    private void nullRep() {
        if (this.repNulled()) {
            return;
        }
        this.num_values = this.values.length + 1;
        this.values = null;
    }

    public LimitedSizeSet<T> clone() {
        LimitedSizeSet result;
        try {
            LimitedSizeSet result_as_lss;
            result = result_as_lss = (LimitedSizeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.values != null) {
            result.values = (Object[])this.values.clone();
        }
        return result;
    }

    public static <T> LimitedSizeSet<T> merge(int max_values, List<LimitedSizeSet<? extends T>> slist) {
        LimitedSizeSet<T> result = new LimitedSizeSet<T>(max_values);
        for (LimitedSizeSet<T> limitedSizeSet : slist) {
            result.addAll(limitedSizeSet);
        }
        return result;
    }

    public String toString() {
        return "[size=" + this.size() + "; " + (this.repNulled() ? "null" : ArraysMDE.toString(this.values)) + "]";
    }
}

