/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class StrTok {
    Reader reader;
    public StreamTokenizer stok;
    ErrorHandler errorHandler;

    public StrTok(String s2) {
        this(s2, new ErrorHandler());
    }

    public StrTok(String s2, ErrorHandler e) {
        this.reader = new StringReader(s2);
        this.stok = new StreamTokenizer(this.reader);
        this.stok.wordChars(95, 95);
        this.set_error_handler(e);
    }

    public String nextToken() {
        try {
            this.stok.nextToken();
        }
        catch (Exception e) {
            throw new RuntimeException("StreamTokenizer exception: ", e);
        }
        return this.token();
    }

    public void pushBack() {
        this.stok.pushBack();
    }

    public String token() {
        int ttype = this.stok.ttype;
        if (ttype == -1) {
            return null;
        }
        if (ttype == 10) {
            return "";
        }
        if (this.stok.sval != null) {
            if (ttype > 0) {
                String s2 = (char)ttype + this.stok.sval + (char)ttype;
                return s2.intern();
            }
            return this.stok.sval.intern();
        }
        if (ttype > 0) {
            String s3 = "" + (char)ttype;
            return s3.intern();
        }
        throw new RuntimeException("Unexpected return " + ttype + " from StreamTokenizer");
    }

    public void commentChar(int ch) {
        this.stok.commentChar(ch);
    }

    public void quoteChar(int ch) {
        this.stok.quoteChar(ch);
    }

    public int ttype() {
        return this.stok.ttype;
    }

    public boolean isWord() {
        return this.stok.ttype == -3;
    }

    public boolean isQString() {
        return this.stok.sval != null && this.stok.ttype > 0;
    }

    public void set_error_handler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void need(String tok) {
        String t = this.nextToken();
        if (tok.equals(t)) {
            return;
        }
        this.errorHandler.tok_error(String.format("Token %s found where %s expected", t, tok));
    }

    public String need_word() {
        String t = this.nextToken();
        if (!this.isWord()) {
            this.errorHandler.tok_error(String.format("'%s' found where identifier expected", t));
        }
        assert (t != null) : "@AssumeAssertion(nullness): dependent: because of isWord check";
        return t;
    }

    public static class ErrorHandler {
        public void tok_error(String s2) {
            throw new RuntimeException("StrTok error: " + s2);
        }
    }
}

