/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import plume.Hasher;

public final class WeakHasherMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Hasher hasher = null;
    private Map<WeakKey, V> hash;
    private ReferenceQueue<? super K> queue = new ReferenceQueue();
    private Set<Map.Entry<K, V>> entrySet = null;

    private boolean keyEquals(Object k1, Object k2) {
        return this.hasher == null ? k1.equals(k2) : this.hasher.equals(k1, k2);
    }

    private int keyHashCode(Object k1) {
        return this.hasher == null ? k1.hashCode() : this.hasher.hashCode(k1);
    }

    private WeakKey WeakKeyCreate(K k) {
        if (k == null) {
            return null;
        }
        return new WeakKey((Object)k);
    }

    private WeakKey WeakKeyCreate(K k, ReferenceQueue<? super K> q) {
        if (k == null) {
            return null;
        }
        return new WeakKey(k, q);
    }

    private void processQueue() {
        WeakKey wk;
        while ((wk = (WeakKey)this.queue.poll()) != null) {
            this.hash.remove(wk);
        }
    }

    public WeakHasherMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<WeakKey, V>(initialCapacity, loadFactor);
    }

    public WeakHasherMap(int initialCapacity) {
        this.hash = new HashMap<WeakKey, V>(initialCapacity);
    }

    public WeakHasherMap() {
        this.hash = new HashMap<WeakKey, V>();
    }

    public WeakHasherMap(Hasher h2) {
        this.hash = new HashMap<WeakKey, V>();
        this.hasher = h2;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Object kkey = key;
        return this.hash.containsKey(this.WeakKeyCreate(kkey));
    }

    @Override
    public V get(Object key) {
        Object kkey = key;
        return this.hash.get(this.WeakKeyCreate(kkey));
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        return this.hash.put(this.WeakKeyCreate(key, this.queue), value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        Object kkey = key;
        return this.hash.remove(this.WeakKeyCreate(kkey));
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<WeakKey, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = WeakHasherMap.this.hash.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<WeakKey, V>> hashIterator;
                Map.Entry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        WeakKey wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object t = wk.get();
                            k = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            WeakHasherMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            WeakKey wk = WeakHasherMap.this.WeakKeyCreate(e.getKey());
            Object hv = WeakHasherMap.this.hash.get(wk);
            if (hv == null ? ev == null && WeakHasherMap.this.hash.containsKey(wk) : hv.equals(ev)) {
                WeakHasherMap.this.hash.remove(wk);
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int h2 = 0;
            for (Map.Entry ent : this.hashEntrySet) {
                Object v;
                WeakKey wk = ent.getKey();
                if (wk == null) continue;
                h2 += wk.hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h2;
        }
    }

    private final class Entry<K, V>
    implements Map.Entry<K, V> {
        private Map.Entry<WeakKey, V> ent;
        private K key;

        Entry(Map.Entry<WeakKey, V> ent, K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private boolean keyvalEquals(K o1, K o2) {
            return o1 == null ? o2 == null : WeakHasherMap.this.keyEquals(o1, o2);
        }

        private boolean valEquals(V o1, V o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public boolean equals(Map.Entry<K, V> e) {
            return this.keyvalEquals(this.key, e.getKey()) && this.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : WeakHasherMap.this.keyHashCode(this.key)) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private final class WeakKey
    extends WeakReference<K> {
        private int hash;

        private WeakKey(K k) {
            super(k);
            this.hash = WeakHasherMap.this.keyHashCode(k);
        }

        private WeakKey create(K k) {
            if (k == null) {
                return null;
            }
            return new WeakKey(k);
        }

        private WeakKey(K k, ReferenceQueue<? super K> q) {
            super(k, q);
            this.hash = WeakHasherMap.this.keyHashCode(k);
        }

        private WeakKey create(K k, ReferenceQueue<? super K> q) {
            if (k == null) {
                return null;
            }
            return new WeakKey(k, q);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!o.getClass().equals(WeakKey.class)) {
                return false;
            }
            Object t = this.get();
            Object u = ((WeakKey)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return WeakHasherMap.this.keyEquals(t, u);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

