/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private volatile transient Set<K> our_keySet = null;
    volatile transient Collection<V> our_values = null;

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        Entry[] tmpTable = new Entry[capacity];
        this.table = tmpTable;
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        Entry[] tmpTable = new Entry[16];
        this.table = tmpTable;
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(t);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private static <K> K unmaskNull(K key) {
        return key == NULL_KEY ? null : (K)key;
    }

    static boolean eq(Object x, Object y) {
        return x == y;
    }

    static int hasher(Object x) {
        return System.identityHashCode(x);
    }

    static int indexFor(int h2, int length) {
        return h2 & length - 1;
    }

    private void expungeStaleEntries() {
        Entry e;
        block0: while ((e = (Entry)this.queue.poll()) != null) {
            Entry prev;
            int h2 = e.hash;
            int i = WeakIdentityHashMap.indexFor(h2, this.table.length);
            Entry p = prev = this.table[i];
            while (p != null) {
                Entry next = p.next;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    e.value = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object key) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h2 = WeakIdentityHashMap.hasher(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == h2 && WeakIdentityHashMap.eq(k, e.get())) {
                return (V)e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry<K, V> getEntry(Object key) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h2 = WeakIdentityHashMap.hasher(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry e = tab[index];
        while (!(e == null || e.hash == h2 && WeakIdentityHashMap.eq(k, e.get()))) {
            e = e.next;
        }
        return e;
    }

    @Override
    public V put(K key, V value) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h2 = System.identityHashCode(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry<K, V> e = tab[i];
        while (e != null) {
            if (h2 == ((Entry)e).hash && WeakIdentityHashMap.eq(k, e.get())) {
                Object oldValue = ((Entry)e).value;
                if (value != oldValue) {
                    ((Entry)e).value = value;
                }
                return (V)oldValue;
            }
            e = ((Entry)e).next;
        }
        ++this.modCount;
        e = tab[i];
        tab[i] = new Entry<Object, V>(k, value, this.queue, h2, e);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<K, V>[] src, Entry<K, V>[] dest) {
        for (int j = 0; j < src.length; ++j) {
            Entry e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    int i = WeakIdentityHashMap.indexFor(e.hash, dest.length);
                    e.next = (Entry)dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        int numKeysToBeAdded = m3.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m3.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry prev;
        Object k = WeakIdentityHashMap.maskNull(key);
        int h2 = WeakIdentityHashMap.hasher(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h2 == e.hash && WeakIdentityHashMap.eq(k, e.get())) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return (V)e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    Entry<K, V> removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Entry<K, V>[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = WeakIdentityHashMap.maskNull(entry.getKey());
        int h2 = WeakIdentityHashMap.hasher(k);
        int i = WeakIdentityHashMap.indexFor(h2, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h2 == e.hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.our_keySet;
        return ks != null ? ks : (this.our_keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.our_values;
        return vs != null ? vs : (this.our_values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    static class OurSimpleEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        public OurSimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public OurSimpleEntry(Map.Entry<K, V> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakIdentityHashMap.eq(this.key, e.getKey()) && OurSimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Entry candidate = WeakIdentityHashMap.this.getEntry(k);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakIdentityHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new OurSimpleEntry(i.next()));
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new OurSimpleEntry(i.next()));
            }
            return c.toArray(a);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (WeakIdentityHashMap.this.containsKey(o)) {
                WeakIdentityHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        int index;
        Entry<K, V> entry = null;
        Entry<K, V> lastReturned = null;
        int expectedModCount = WeakIdentityHashMap.access$400(WeakIdentityHashMap.this);
        Object nextKey = null;
        Object currentKey = null;

        HashIterator() {
            this.index = WeakIdentityHashMap.this.size() != 0 ? WeakIdentityHashMap.this.table.length : 0;
        }

        @Override
        public boolean hasNext() {
            Entry[] t = WeakIdentityHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakIdentityHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private static class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        private V value;
        private final int hash;
        private Entry<K, V> next;

        Entry(K key, V value, ReferenceQueue<K> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)WeakIdentityHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return WeakIdentityHashMap.eq(k1, k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : WeakIdentityHashMap.hasher(k)) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

