/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.node;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.errorprone.javacutil.TypesUtils;

public class InstanceOfNode
extends Node {
    protected final Node operand;
    protected final TypeMirror refType;
    protected final InstanceOfTree tree;
    protected final Types types;

    public InstanceOfNode(Tree tree, Node operand, TypeMirror refType, Types types) {
        super(types.getPrimitiveType(TypeKind.BOOLEAN));
        assert (tree.getKind() == Tree.Kind.INSTANCE_OF);
        this.tree = (InstanceOfTree)tree;
        this.operand = operand;
        this.refType = refType;
        this.types = types;
    }

    public Node getOperand() {
        return this.operand;
    }

    public TypeMirror getRefType() {
        return this.refType;
    }

    @Override
    public InstanceOfTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitInstanceOf(this, p);
    }

    public String toString() {
        return "(" + this.getOperand() + " instanceof " + TypesUtils.simpleTypeName(this.getRefType()) + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof InstanceOfNode)) {
            return false;
        }
        InstanceOfNode other = (InstanceOfNode)obj;
        return this.getOperand().equals(other.getOperand()) && this.types.isSameType(this.getRefType(), other.getRefType());
    }

    public int hashCode() {
        return Objects.hash(InstanceOfNode.class, this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

